

c
c
      subroutine glmeva (ip, irank, isx, jsend, m, nout, ntype,
     +                   a, b, se,
     +                   link, mean, offset,
     +                   abort, ready)
c
c action: evaluate y = f(x), i.e. mu = g^{-1}(eta) for GLIM models
c author: w.g.bardsley, university of manchester, u.k., 06/05/2003
c         11/05/2003 revised
c         04/07/2015 added intents
c         25/10/2021 added E_NUMBERS and E_FORMATS
c
c         NTYPE: 1. Normal 
c                2. Binomial
c                3. Poisson
c                4. Gamma
c         JSEND: 1. Advanced GLM
c                2. Simple logistic
c                3. Binary logistic
c                4. Polynomial
c            IP: number of independent variables in the model including the intercept if present
c             M: number of independent variables    
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)  :: ip, m
      integer,             intent (in)  :: irank, isx(m), jsend, nout,
     +                                     ntype
      double precision,    intent (in)  :: a, b(ip), se(ip)
      character (len = *), intent (in)  :: link, mean, offset
      logical,             intent (in)  :: ready
      logical,             intent (out) :: abort
c
c locals
c      
      integer    i, ifail, j, k, nbinom
      integer    isend, itype, nmax
      parameter (isend = 2, itype = 1, nmax = 100)
      integer    n0, n1, n2, n3, n4, n15
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n15 = 15)
      double precision eta, rtol, t, x(n1,nmax), xtemp, y
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      double precision x02amf$, g01eaf$
      character (len = 100) line
      character (len = 13 ) d13(2), showlj
      character (len = 10 ) word10
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    curve, fixcol, fixrow, label, order, wtd
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .false., wtd = .false.)
      external   e_formats, showlj
      external   putadv, editor, getd01, table1, triml1, getjge
      external   x02amf$, g01eaf$
      intrinsic  dble, exp, abs, trim
      save       x, xtemp
      save       nbinom
      data       x, xtemp / nmax*one, one /
      data       nbinom  / 1 /
c
c set abort = .true. then test the input data
c
      abort = .true.
      if (.not.ready) then
         call putadv ('First fit the data')
         return
      endif
      if (ip.lt.n1) then
         call putadv ('No variables ... IP < 1 in call to GLMEVA')
         return
      endif
      if (ip.ne.irank) then
         call putadv ('Not allowed if rank deficient')
         return
      endif
      if (m.lt.n1) then
         call putadv ('No variables ... M < 1 in call to GLMEVA')
         return
      endif
      if (jsend.lt.n1 .or. jsend.gt.n4) then
         call putadv ('JSEND out of range in call to GLMEVA')
         return
      endif
      if (ntype.lt.n1 .or. ntype.gt.n4) then
         call putadv ('NTYPE out of range in call to GLMEVA')
         return
      endif
      if (offset.eq.'Y' .or. offset.eq.'y') then
         call putadv ('Not allowed when offsets are supplied')
         return
      endif
      do i = n1, ip
         if (se(i).le.zero) then
            call putadv ('Nonpositive standard error')
            return
         endif
      enddo
      if (mean.eq.'M' .or. mean.eq.'m') then
         if (ip.gt.m + n1) then
            call putadv ('IP > M + 1 in call to GLMEVA')
            return
         endif
         j = n1
         eta = b(n1)
      elseif (mean.eq.'Z' .or. mean.eq.'z') then
         if (ip.gt.m) then
            call putadv ('IP > M in call to GLMEVA')
            return
         endif
         j = n0
         eta = zero
      else
         call putadv ('MEAN out of range in call to GLMEVA')
         return
      endif
      e_numbers = e_formats()
c
c binomial n
c
      if (ntype.eq.n2) then
         if (jsend.eq.n2) then
            call getjge (nbinom, n1,
     +'Binomial N required (i.e. the number of trials per estimate)')
         elseif (jsend.eq.n3) then
            nbinom = n1
         else
            call putadv ('NTYPE /JSEND incompatible in call to GLMEVA')
            return
         endif
         t = dble(nbinom)
      endif
c
c ------------------------------------------------------------------
c data supplied is ok and j and eta have been initialised so proceed 
c ------------------------------------------------------------------
c
      if (jsend.eq.n4) then
c
c special action for polynomial: generate powers of x
c
        call getd01 (xtemp, 'x-value required')
        x(n1,n1) = xtemp
        if (m.gt.n1) then
           do i = n2, m
              x(n1,i) = xtemp*x(n1,i - n1)
           enddo
         endif
      else
c
c get the x-values required
c
        if (m.eq.n1) then
           line = 'x-value required'
        else
           write (line,100) m
        endif
        
        call editor (isend, itype, m, n1, n1,
     +               x,
     +               line,
     +               curve, fixcol, fixrow, label, order, wtd)
         
           
      endif
c
c calculate eta
c
      do i = n1, m
         if (isx(i).gt.n0) then
            j = j + n1
            eta = eta + b(j)*x(n1,i)
         endif
      enddo
c
c assign y
c
      if (ntype.eq.n2) then
         if (link.eq.'G' .or. link.eq.'g') then
            xtemp = exp(eta)
            y = t*xtemp/(one + xtemp)
         elseif (link.eq.'P' .or. link.eq.'p') then
            ifail = n1
            y = t*g01eaf$('L', eta, ifail)
         elseif (link.eq.'C' .or. link.eq.'c') then
            xtemp = - exp(eta)
            y = t*(one - exp(xtemp))
         else
            call putadv ('Forbidden link in call to GLMEVA')
            return
         endif
      else
         if (link.eq.'E' .or. link.eq.'e') then
            rtol = 1.0d+09*x02amf$()
            if (eta.lt.zero .or. abs(a).le.rtol) then
               call putadv ('Calculation is impossible')
               return
            else
               y = eta**(one/a)
            endif
         elseif (link.eq.'I' .or. link.eq.'i') then
            y = eta
         elseif (link.eq.'L' .or. link.eq.'l') then
            y = exp(eta)
         elseif (link.eq.'S' .or. link.eq.'s') then
            y = eta**2
         elseif (link.eq.'R' .or. link.eq.'r') then
            rtol = 1.0d+09*x02amf$()
            if (abs(eta).le.rtol) then
               call putadv ('Calculation is impossible')
               return
            else
               y = one/eta
            endif
         else
            call putadv ('Forbidden link in call to GLMEVA')
            return
         endif
      endif
c
c output results
c
      write (nout,'(a)') blank
      k = n15
      call table1 (k, 'OPEN')
      k = n0
      if (mean.eq.'M' .or. mean.eq.'m') then
         j = n1
         if (e_numbers) then
            write (line,200) n0, one, b(j), ' (the constant term)'
         else
            d13(1) = showlj(one)
            d13(2) = showlj(b(j))
            write (line,250) n0, d13(1), trim(d13(2)), 
     +                       ' (the constant term)' 
         endif  
         write (nout,'(a)') line
         call table1 (k, line)
      else
         j = n0
      endif
      do i = n1, m
         if (isx(i).gt.n0) then
            j = j + n1
            if (e_numbers) then
               write (line,200) i, x(n1,i), b(j), blank
            else
               d13(1) = showlj(x(n1,i))
               d13(2) = showlj(b(j))
               write (line,250) i, d13(1), trim(d13(2)), blank  
            endif  
            write (nout,'(a)') line
            call table1 (k, line)
         endif
      enddo
      if (ntype.eq.n2) then
c
c special action for binomial distribution: output binomial N
c
         write (word10,'(i10)') nbinom
         call triml1 (word10)
         write (line,300) word10
         write (nout,'(a)') line
         call table1 (k, line)
         if (e_numbers) then
            write (line,400) y, y/t
         else
            d13(1) = showlj(y)
            write (line,450) trim(d13(1)), y/t
         endif  
      else
         if (e_numbers) then
            write (line,500) y
         else
            d13(1) = showlj(y)
            write (line,550) trim(d13(1)) 
         endif  
      endif
      write (nout,'(a)') line
      k = 4
      call table1 (k, line)
      call table1 (k, 'CLOSE')
c
c all is well so return abort = .false.
c
      abort = .false.
c
c format statements
c      
  100 format ('Values for x(1) to x(',I3,')')
  200 format ('x(',I3,') =',1p,e13.5, ' coefficient =',e13.5,A)
  250 format ('x(',I3,') =',1x,a13,' coefficient =',1x,a,a)
  300 format ('Binomial N =',1x,a)
  400 format ('y(x) =',1p,e13.5,', Binomial probability p =',0p,f9.6)
  450 format ('y(x) =',1x,a,', Binomial probability p =',f9.6)
  500 format ('y(x) =',1p,e13.5)
  550 format ('y(x) =',1x,a)
      end
c
c
