C
C
      SUBROUTINE GLMFIT (IPRINT, ISX, JSEND, LTYPE, MAXIT, NCMAX,
     +                   NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                   AFIX, A1, A2, B, COV, EPS, SE, SFIX, T,
     +                   TOL, V, WK, WT, Y,
     +                   FNAME1, TITLE1,
     +                   OFFVEC)
C
C
C ACTION : GLIM fitting
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          24/07/2000 developed from LINEAR
C          07/02/2001 added CHOP80 and TRIM80
C          14/06/2002 introduced JSEND and changed plot offset from
C                     IRANK to IP in V matrix
C          21/11/2002 added HNPLOT
C          06/05/2003 added GLMEVA, changed TRIM80, CHOP80 TO TRIM60, CHOP60,
C                     added TTEST2 and PCVTST
C          16/04/2004 added ISXEDI, ISXTYP, and ISXVEC
C          13/04/2006 suppressed attempt to plot using NFREE = V(IP + 1,8)
C          28/12/2014 set ITEST = 9 when IFAIL = 14 to indicate divergence
C          05/07/2015 added an additional option and more output for logistic regression  
C          13/07/2015 added GLMREF to plot best-fit curves for single variable cases
C          13/01/2021 added E_NUMBERS and E_FORMATS, etc. 
C
C          IPRINT = iterations before printing intermediate output
C          ISX = variables out (0) or in (1)
C          JSEND = fitting type
C          LTYPE = link type
C          MAXIT = max. no. iterations
C          NTYPE = error type
C          AFIX = A in eta = mu^A
C          A1 = original data matrix ... this is never altered
C          A2 = the current active copy of DATA in A1 which is required
C          B = parameters
C          COV = CV matrix
C          EPS = rank factor for SVD
C          RES = deviance residuals
C          SE = std. errors
C          SFIX = S
C          T = original N for binomial errors
C          TOL = convergence factor
C          V = workspace
C          WK = workspace
C          WT = weights (active) calculated on demand
C          Y = original (active) Y-values
C          OFFVEC = offset (yes/no)
C          Each time the data set is altered a new active set is calculated
C
      IMPLICIT   NONE
      INTEGER    NCMAX, NRMAX
      INTEGER    IPRINT, ISX(NCMAX), JSEND, LTYPE, MAXIT, NCOLS, NF,
     +           NROWS, NTYPE
      INTEGER    I, IDF, IFAIL, IP, IRANK, ITEST, J, K, M, MODE, N,
     +           NCOL1, NVAR
      INTEGER    COLOUR, NPAR, NPMAX, NPTS
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N8 = 8, N9 = 9, N10 = 10, N15 = 15)
      INTEGER    NCOVAR, NGRAF, LPLOT, MPLOT, NPLOT, NXMIN
      PARAMETER (NCOVAR = 100, NGRAF = 1000, NXMIN = 1)
      INTEGER    NREF
      PARAMETER (NREF = 120)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 11,
     +           NSTART = 14, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION AFIX, A1(NRMAX,NCMAX), A2(NRMAX,NCMAX),
     +                 B(NCMAX), COV(NCMAX*(NCMAX + 1)/2), EPS,
     +                 SE(NCMAX), SFIX, T(NRMAX), TOL,
     +                 V(NRMAX,NCMAX + 8),
     +                 WK((NCMAX*NCMAX + 3*NCMAX + 22)/2), WT(NRMAX),
     +                 Y(NRMAX)
      DOUBLE PRECISION XGRAF1(NGRAF), XGRAF2(NGRAF), XGRAF3(NREF),
     +                 XGRAF4(2)
      DOUBLE PRECISION YGRAF1(NGRAF), YGRAF2(NGRAF), YGRAF3(NREF),
     +                 YGRAF4(2)
      DOUBLE PRECISION COVAR(NCOVAR,NCOVAR)
      DOUBLE PRECISION A, ASYMP, DEV, EPS1, RSS, S, TOL1, WTOL, XBIG
      DOUBLE PRECISION DF, PVAL, TEMP, TNU, TVAL, VALUE
      DOUBLE PRECISION XDELTA, XMAX, XMIN, XTEMP
      DOUBLE PRECISION XREF(NREF), YREF(NREF)
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT05, PNT1, PNT2
      PARAMETER (PNT025 = 0.025D+00, PNT05 = 0.05D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION EPOS, ENEG
      PARAMETER (EPOS = 1.0D+100, ENEG = - EPOS)
      DOUBLE PRECISION X02AJF$, G01EBF$, X02AMF$, G01FBF$
      CHARACTER (LEN = 13) D13(4), WORD13, SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER  FNAME1*(*), TITLE1*(*)
      CHARACTER  CHOP60*60, TEXT(NTEXT)*100, LINE*100, TRIM60*60
      CHARACTER  FNAME2*60, TITLE2*60
      CHARACTER  HEADER(3)*100
      CHARACTER  CIPHER*4, LABELM*5, LABELW*5
      CHARACTER (LEN = 12) WORD12
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      CHARACTER  LINK*1, MEAN*1, OFFSET*1, WEIGHT*1
      CHARACTER  PTITLE*40, XTITLE*3, YTITLE*3
      CHARACTER  PNAME*20, XNAME*9, YNAME*9
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    OFFVEC, READY, SHOWIT
      LOGICAL    ABORT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ACTION, AGAIN1, AGAIN2, FITNOW, LOGIST
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWRJ, SHOWLJ
      EXTERNAL   PUTIFA, LBOX01, PUTFAT, TABLE1, PUTADV, PUTWAR, LBOX02,
     +           GETIM1, WAITER, GKST04, REVPRO, GKS004, TRIM60, CHOP60,
     +           PUTMES, HNPLOT, GLMEVA, TTEST2, PCVTST, ISXEDI, ISXTYP,
     +           ISXVEC, GLMEV2, GLMREF
      EXTERNAL   X02AJF$, G01EBF$, X02AMF$, G01FBF$
      EXTERNAL   G02GAF$, G02GBF$, G02GCF$, G02GDF$
      INTRINSIC  ABS, DBLE, MIN, EXP
      SAVE       MEAN
      DATA       MEAN / 'M' /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Part 1: Initialise
C ==================
C
      READY = .FALSE.
      LOGIST = .FALSE.
      IF (OFFVEC) THEN
         OFFSET = 'Y'
      ELSE
         OFFSET = 'N'
      ENDIF
      IF (NTYPE.EQ.N2) THEN
         IF (LTYPE.EQ.N1) THEN
            LINK = 'G'
         ELSEIF (LTYPE.EQ.N2) THEN
            LINK = 'P'
         ELSEIF (LTYPE.EQ.N3) THEN
            LINK = 'C'
         ENDIF
      ELSE
         IF (LTYPE.EQ.N1) THEN
            LINK = 'E'
         ELSEIF (LTYPE.EQ.N2) THEN
            LINK = 'I'
         ELSEIF (LTYPE.EQ.N3) THEN
            LINK = 'L'
         ELSEIF (LTYPE.EQ.N4) THEN
            LINK = 'S'
         ELSEIF (LTYPE.EQ.N5) THEN
            LINK = 'R'
         ENDIF
      ENDIF
C
C Part 2: Check input data
C ========================
C
      IF (NTYPE.LT.N1 .OR. NTYPE.GT.N4 .OR. LTYPE.LT.N1) RETURN
      IF ((NTYPE.EQ.N2 .AND. LTYPE.GT.N3) .OR. LTYPE.GT.N5) RETURN
      IF (NCOLS.GT.NCMAX) THEN
         CALL PUTFAT ('Column dimension exceeded in call to GLMFIT')
         RETURN
      ENDIF
      IF (NTYPE.EQ.N2) THEN
         NCOL1 = N4
         NPMAX = NCMAX - N3
      ELSE
         NCOL1 = N3
         NPMAX = NCMAX - N2
      ENDIF
      IF (NCOLS.LT.NCOL1) THEN
         CALL PUTFAT ('Insufficient no. of data columns for analysis')
         RETURN
      ENDIF
      IF (NROWS.GT.NRMAX) THEN
         CALL PUTFAT ('Row dimension exceeded in call to GLMFIT')
         RETURN
      ENDIF
      IF (NROWS.LE.NCOLS - N2) THEN
         CALL PUTFAT ('Must have more y-values than variables')
         RETURN
      ENDIF
C
C Initialise then check if weights should be calculated
C
      E_NUMBERS = E_FORMATS()
      WTOL = 10.0D+00*X02AJF$()
      WEIGHT = 'U'
      I = N0
      DO WHILE (I.LT.NROWS .AND. WEIGHT.EQ.'U')
         I = I + N1
         VALUE = A1(I,NCOLS)
         IF (VALUE.GT.ZERO .AND. ABS(VALUE-ONE).GT.WTOL) WEIGHT = 'W'
      ENDDO
      IF (WEIGHT.EQ.'W') THEN
         LABELW = '(Yes)'
      ELSE
         LABELW = ' (No)'
      ENDIF
C
C Initialise elements of ISX ... M = total number of variables
C
      IF (NTYPE.EQ.N2) THEN
         M = NCOLS - N3
      ELSE
         M = NCOLS - N2
      ENDIF
      IF (M.EQ.NPMAX) THEN
         CALL PUTFAT ('Too many variables to include a constant term')
         MEAN = 'Z'
      ENDIF
      DO I = N1, NCMAX
         ISX(I) = N1
      ENDDO
C
C Suppress higher degree polynomial terms
C
      IF (JSEND.EQ.N4) THEN
         DO I = N2, N6
            ISX(I) = N0
         ENDDO
      ENDIF
C
C Part 3: Define N and assign data to array A2 then calculate the weights
C =======================================================================
C
      N = N0
      WTOL = 1.0D-20
      DO I = N1, NROWS
         VALUE = A1(I,NCOLS)
         IF (VALUE.GT.WTOL) THEN
            N = N + N1
            IF (WEIGHT.EQ.'W') THEN
               WT(N) = ONE/(VALUE**2)
            ELSE
               WT(N) = ONE
            ENDIF
            K = N0
            DO J = N1, M
               K = K + N1
               A2(N,K) = A1(I,K)
            ENDDO
            K = K + N1
            Y(N) = A1(I,K)
            IF (NTYPE.EQ.N2) THEN
               K = K + N1
               T(N) = A1(I,K)
            ENDIF
         ENDIF
      ENDDO
C
C ======================================================================
C Part 4: Main branch point for repeated analysis
C ======================================================================
C
      FNAME2 = TRIM60(FNAME1)
      TITLE2 = CHOP60(TITLE1)
      AGAIN1 = .TRUE.
      AGAIN2 = .TRUE.
      FITNOW = .FALSE.
      DO WHILE (AGAIN1)
C
C First of all define IP, NVAR and LABELM then initialise the menu
C
         NUMDEC = N1
         CALL ISXVEC (ISX, M, NVAR, NXMIN)
         IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
            IP = NVAR + N1
            LABELM = '[Yes]'
         ELSE
            IP = NVAR
            LABELM = ' [No]'
         ENDIF
         CALL ISXTYP (ISX, M, NVAR, NXMIN,
     +                LINE,
     +                SHOWIT)
         WRITE (TEXT,100) LINE, FNAME2, TITLE2, LABELW, LABELM, M, NVAR,
     +                    M - NVAR, IP
C
C Now store details of the menu
C
         HEADER(1) = TEXT(1)
         HEADER(2) = TEXT(3)
         HEADER(3) = TEXT(4)
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(5) = N1
         NUMBLD(6) = N1
         FITNOW = .FALSE.
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(5) = N0
         NUMBLD(6) = N0
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Proceed to fitting (after NUMDEC = NUMOPT section)
C
            READY = .FALSE.
            FITNOW = .TRUE.
            CONTINUE
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Change status of MEAN
C
            IF (M.EQ.NPMAX) THEN
               MEAN = 'Z'
               CALL PUTFAT (
     +        'Too many variables to include a constant term')
            ELSEIF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               MEAN = 'Z'
               CALL PUTADV (
     +        'Regression will now have eta(0) = 0')
            ELSE
               MEAN = 'M'
               CALL PUTADV (
     +        'Regression will now have eta(0) = constant')
            ENDIF
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Suppress/Restore variables
C
            CALL ISXEDI (ISX, M, NVAR, NXMIN)
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: Plot
C
             IF (READY) THEN
                IF (M.EQ.N1 .OR. JSEND.EQ.N4) THEN
                   J = N1
                ELSE
                   CALL GETIM1 (N1, J, M,
     +            'Number of x-column for plotting')
                ENDIF
                IF (ISX(J).EQ.N0 .AND. JSEND.NE.N4) THEN
                   CALL PUTFAT (
     +            'This is not in the current regression set')
                ELSE
C
C Copy the data into XGRAF1 and YGRAF1
C
                   NPTS = MIN(N, NGRAF)
                   DO I = N1, NPTS
                      XGRAF1(I) = A2(I,J)
                      YGRAF1(I) = Y(I)
                      IF (NTYPE.EQ.2) YGRAF1(I) = YGRAF1(I)/T(I)
                   ENDDO
C
C See if a best-fit curve has been calculated then assign PTITLE
C
                   IF (JSEND.EQ.N4) THEN
                      LPLOT = N1
                      MPLOT = N0
                      NPLOT = 100
                      XMIN = A2(N1,N1)
                      XMAX = A2(N,N1)
                      DO I = N1, N
                         IF (A2(I,N1).LT.XMIN) XMIN = A2(I,N1)
                         IF (A2(I,N1).GT.XMAX) XMAX = A2(I,N1)
                      ENDDO
                      XDELTA = (XMAX - XMIN)/DBLE(NPLOT - N1)
                      XGRAF2(N1) = XMIN
                      XGRAF2(NPLOT) = XMAX
                      DO I = N2, NPLOT - N1
                         XGRAF2(I) = XGRAF2(I - N1) + XDELTA
                      ENDDO
                      IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
C
C Polynomial with constant
C
                         DO I = N1, NPLOT
                            XDELTA = B(N1)
                            J = N1
                            XTEMP = ONE
                            DO K = N1, M
                               XTEMP = XTEMP*XGRAF2(I)
                               IF (ISX(K).GT.N0) THEN
                                  J = J + N1
                                  XDELTA = XDELTA + B(J)*XTEMP
                               ENDIF
                            ENDDO
                            IF (XDELTA.LT.ENEG) THEN
                               XDELTA = ENEG
                            ELSEIF (XDELTA.GT.EPOS) THEN
                               XDELTA = EPOS
                            ENDIF
                            XTEMP = EXP(XDELTA)
                            YGRAF2(I) = XTEMP/(ONE + XTEMP)
                         ENDDO
                      ELSE
C
C Polynomial with no constant
C
                         DO I = N1, NPLOT
                            XDELTA = ZERO
                            J = N0
                            XTEMP = ONE
                            DO K = N1, M
                               XTEMP = XTEMP*XGRAF2(I)
                               IF (ISX(K).GT.N0) THEN
                                  J = J + N1
                                  XDELTA = XDELTA + B(J)*XTEMP
                               ENDIF
                            ENDDO
                            IF (XDELTA.LT.ENEG) THEN
                               XDELTA = ENEG
                            ELSEIF (XDELTA.GT.EPOS) THEN
                               XDELTA = EPOS
                            ENDIF
                            XTEMP = EXP(XDELTA)
                            YGRAF2(I) = XTEMP/(ONE + XTEMP)
                         ENDDO
                      ENDIF
                      PTITLE = 'Data and Best-Fit'
                   ELSE
C                      NPLOT = NINT(V(IP + N1,N8))
C                      IF (NPLOT.GT.N2) THEN
C
C If so copy the best-fit curve into XGRAF2, YGRAF2
C
C                         NPLOT = MIN(NPLOT, NGRAF)
C                         XMIN = V(IP + N2,N8)
C                         XDELTA = V(IP + N3,N8)
C                         XGRAF2(1) = XMIN
C                         YGRAF2(1) = V(IP + N4,N8)
C                         DO I = N2, NPLOT
C                            XGRAF2(I) = XGRAF2(I - N1) + XDELTA
C                            YGRAF2(I) = V(IP + N3 + I,N8)
C                         ENDDO
C                         LPLOT = N1
C                         MPLOT = N0
C                         PTITLE = 'Data and Best-Fit'
C                      ELSE
C
C Otherwise copy the best fit points into XGRAF2 and YGRAF2
C
                         LPLOT = N0
                         MPLOT = N4
                         NPLOT = NPTS
                         PTITLE = 'Data with * = Fit'
                         DO I = N1, NPLOT
                            XGRAF2(I) = XGRAF1(I)
                            YGRAF2(I) = V(I,N2)
                            IF (NTYPE.EQ.N2) YGRAF2(I) = YGRAF2(I)/T(I)
                         ENDDO
C                      ENDIF
                   ENDIF
C
C Assign YTITLE and ASYMP
C
                   IF (NTYPE.EQ.N2) THEN
                      YTITLE = 'y/N'
                      ASYMP = ONE
                   ELSE
                      YTITLE = ' y '
                      ASYMP = - ONE
                   ENDIF
C
C Initialise the dummy arrays
C
                   DO I = N1, N2
                      XGRAF3(I) = ZERO
                      XGRAF4(I) = ZERO
                      YGRAF3(I) = ZERO
                      YGRAF4(I) = ZERO
                   ENDDO
C
C Assign XTITLE
C
                   IF (JSEND.EQ.N4) THEN
                      XTITLE = 'x'
                   ELSEIF (J.LT.N10) THEN
                      WRITE (XTITLE,'(A2,I1)') ' x', J
                   ELSE
                      WRITE (XTITLE,'(A1,I2)') 'x', J
                   ENDIF
C
C Plot the data
C
                   CALL  GLMREF (IP, JSEND, M, NCOLS, NREF, NRMAX, N,
     +                           NTYPE,
     +                           A, B, A2, XREF, YREF,
     +                           LINK, OFFSET,
     +                           ABORT)
                   IF (ABORT) THEN
                      CALL GKST04 (N0, LPLOT, N0, N0,
     +                             N5, MPLOT, N0, N0,
     +                             NPTS, NPLOT, N2, N2,
     +                             ASYMP,
     +                             XGRAF1, XGRAF2, XGRAF3, XGRAF4,
     +                             YGRAF1, YGRAF2, YGRAF3, YGRAF4,
     +                             PTITLE, XTITLE, YTITLE,
     +                             AXES, AXES)
                   ELSE
                      PTITLE = 'Data and best fit curve'
                      XTITLE = 'x'
                      CALL GKST04 (N0, N1, N0, N0,
     +                             N5, N0, N0, N0,
     +                             NPTS, NREF, N2, N2,
     +                             ASYMP,
     +                             XGRAF1, XREF, XGRAF3, XGRAF4,
     +                             YGRAF1, YREF, YGRAF3, YGRAF4,
     +                             PTITLE, XTITLE, YTITLE,
     +                             AXES, AXES)
                   ENDIF
                ENDIF
             ELSE
                CALL PUTFAT ('Not ready  ...  First fit the data')
             ENDIF
             AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
             IF (READY) THEN
C
C NUMDEC = 5: Output the residuals, etc.
C
               NUMDEC = N4
               AGAIN2 = .TRUE.
               DO WHILE (AGAIN2)
                  WRITE (TEXT,700)
                  CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, N6, NUMPOS,
     +                         TEXT)
                  IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
                     COLOUR = N15
                     CALL TABLE1 (COLOUR, 'OPEN')
                     WRITE (LINE,800)
                     COLOUR = N4
                     CALL TABLE1 (COLOUR, LINE)
                     COLOUR = N0
                     IF (E_NUMBERS) THEN
                        DO I = N1, N
                           WRITE (LINE,900) I, Y(I), V(I,2), V(I,5), 
     +                                      V(I,6)
                           CALL TABLE1 (COLOUR, LINE)
                        ENDDO
                     ELSE
                        DO I = N1, N
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6))
                           WRITE (LINE,950) I, D13(1), D13(2),
     +                                      D13(3), D13(4) 
                           CALL TABLE1 (COLOUR, LINE)
                        ENDDO

                     ENDIF  
                     CALL TABLE1 (COLOUR, 'CLOSE')
                     NUMDEC = N2
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C
                     WRITE (NF,'(A)') ' '
                     WRITE (NF,800)
                     IF (E_NUMBERS) THEN
                        DO I = N1, N
                           WRITE (NF,900) I, Y(I), V(I,2), V(I,5),
     +                                    V(I,6)
                        ENDDO
                     ELSE
                        DO I = N1, N
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6))
                           WRITE (NF,950) I, D13(1), D13(2),
     +                                    D13(3), D13(4) 
                        ENDDO  
                     ENDIF  
                     NUMDEC = N3
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot the residuals
C
                      NPTS = MIN(N, NGRAF)
                      DO I = N1, NPTS
                         XGRAF1(I) = V(I,2)
                         YGRAF1(I) = V(I,5)
                      ENDDO
                      DO I = N1, N2
                         XGRAF2(I) = ZERO
                         XGRAF3(I) = ZERO
                         XGRAF4(I) = ZERO
                         YGRAF2(I) = ZERO
                         YGRAF3(I) = ZERO
                         YGRAF4(I) = ZERO
                      ENDDO
                      IF (NTYPE.EQ.N1) THEN
                         PNAME = 'Residuals Plot'
                      ELSEIF (NTYPE.EQ.N2) THEN
                         PNAME = 'Deviance Residuals'
                      ELSEIF (NTYPE.EQ.N3) THEN
                         PNAME = 'Deviance Residuals'
                      ELSEIF (NTYPE.EQ.N4) THEN
                         PNAME = 'Anscombe Residuals'
                      ENDIF
                      XNAME = 'Best-Fit'
                      YNAME = 'Residuals'
C
C Plot the residuals
C
                      CALL GKS004 (N0, N0, N0, N0,
     +                             N4, N0, N0, N0,
     +                             NPTS, N2, N2, N2,
     +                             XGRAF1, XGRAF2, XGRAF3, XGRAF4,
     +                             YGRAF1, YGRAF2, YGRAF3, YGRAF4,
     +                             PNAME, XNAME, YNAME,
     +                             AXES, AXES)
                     NUMDEC = N4
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N4) THEN
C
C Half normal plot
C
                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        YGRAF1(I) = V(I,5)
                     ENDDO
                     IFAIL = N1
                     CALL HNPLOT (IFAIL, NPTS, YGRAF1)
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N5) THEN
C
C Full normal plot
C
                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        YGRAF1(I) = V(I,5)
                     ENDDO
                     IFAIL = N2
                     CALL HNPLOT (IFAIL, NPTS, YGRAF1)
                     AGAIN2 = .TRUE.
                  ELSE
                     AGAIN2 = .FALSE.
                  ENDIF
                  NUMDEC = N6
               ENDDO
            ELSE
               CALL PUTFAT ('Not ready  ...  First fit the data')
            ENDIF
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: Compare 2 parameters
C
            CALL TTEST2 (NF)
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C NUMDEC = 7: Compare 2 sets of parameters
C
            IF (READY) THEN
               MODE = 2
               K = N0
               DO J = N1, IP
                  DO I = N1, J
                     K = K + N1
                     COVAR(I,J) = COV(K)
                     IF (I.NE.J) COVAR(J,I) = COVAR(I,J)
                  ENDDO
               ENDDO
            ELSE
               MODE = 3
            ENDIF
            NPAR = IP
            NPTS = N
            CALL PCVTST (MODE, NF, NPAR, NPTS, NCOVAR, COVAR, B)
         ELSEIF (NUMDEC.EQ.N8) THEN
C
C NUMDEC = 8: Evaluate from terminal
C
            CALL GLMEVA (IP, IRANK, ISX, JSEND, M, NF, NTYPE,
     +                   A, B, SE,
     +                   LINK, MEAN, OFFSET,
     +                   ABORT, READY)
         ELSEIF (NUMDEC.EQ.N9) THEN
C
C NUMDEC = 9: Evaluate from a file
C
            CALL GLMEV2 (IP, IRANK, ISX, JSEND, M, NF, NTYPE,
     +                   A, B, SE,
     +                   LINK, MEAN, OFFSET,
     +                   ABORT, READY)     
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = 10: Results
C
            CALL REVPRO (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = 11: Terminate current data analysis
C
           AGAIN1 = .FALSE.
           AGAIN2 = .FALSE.
           FITNOW = .FALSE.
         ENDIF
C
C Part 5: Fitting
C ===============
C
         IF (FITNOW) THEN
            LOGIST = .FALSE.
            ACTION = .TRUE.
            CALL WAITER (ACTION)
            ACTION = .FALSE.
            IFAIL = N0
            A = AFIX
            EPS1 = EPS
            S = SFIX
            TOL1 = TOL
            IF (NTYPE.EQ.N1) THEN
               CALL G02GAF$(LINK, MEAN, OFFSET, WEIGHT, N, A2, NRMAX, M,
     +                      ISX, IP, Y, WT, S, A, RSS, IDF, B, IRANK,
     +                      SE, COV, V, NRMAX, TOL1, MAXIT, IPRINT,
     +                      EPS1, WK,
     +                      IFAIL)
               CALL WAITER (ACTION)
               CALL PUTIFA (IFAIL, NF, 'G02GAF/GLMFIT')
               ITEST = IFAIL
            ELSEIF (NTYPE.EQ.N2) THEN
               CALL G02GBF$(LINK, MEAN, OFFSET, WEIGHT, N, A2, NRMAX, M,
     +                      ISX, IP, Y, T, WT, DEV, IDF, B, IRANK, SE,
     +                      COV, V, NRMAX, TOL1, MAXIT, IPRINT, EPS1,
     +                      WK,
     +                      IFAIL)
               CALL WAITER (ACTION)
               CALL PUTIFA (IFAIL, NF, 'G02GBF/GLMFIT')
               ITEST = IFAIL - N2
               IF (IFAIL.EQ.N0 .AND.
     +            LINK.EQ.'G' .AND.
     +            OFFSET.EQ.'N') THEN
                  LOGIST = .TRUE.
               ENDIF
            ELSEIF (NTYPE.EQ.N3) THEN
               CALL G02GCF$(LINK, MEAN, OFFSET, WEIGHT, N, A2, NRMAX, M,
     +                      ISX, IP, Y, WT, A, DEV, IDF, B, IRANK, SE,
     +                      COV, V, NRMAX, TOL1, MAXIT, IPRINT, EPS1,
     +                      WK,
     +                      IFAIL)
               CALL WAITER (ACTION)
               CALL PUTIFA (IFAIL, NF, 'G02GCF/GLMFIT')
               ITEST = IFAIL - N1
            ELSEIF (NTYPE.EQ.N4) THEN
               CALL G02GDF$(LINK, MEAN, OFFSET, WEIGHT, N, A2, NRMAX, M,
     +                      ISX, IP, Y, WT, S, A, DEV, IDF, B, IRANK,
     +                      SE, COV, V, NRMAX, TOL1, MAXIT, IPRINT,
     +                      EPS1, WK,
     +                      IFAIL)
               CALL WAITER (ACTION)
               CALL PUTIFA (IFAIL, NF, 'G02GDF/GLMFIT')
               ITEST = IFAIL - N1
            ENDIF
            IF (IFAIL.EQ.N0) THEN
               READY = .TRUE.
            ELSE
               IF (IFAIL.EQ.14) ITEST = 9
               IF (ITEST.GE.4 .AND. ITEST.LE.9) THEN
                  READY = .TRUE.
                  TEXT(N1) =
     +'Note: the model fitting procedure has not converged properly'
                  TEXT(N2) = BLANK
                  TEXT(N3) =
     +'Parameter estimates and best fit model may be unreliable since'
                  IF (ITEST.EQ.4) THEN
                     TEXT(N4) =
     +'the fitted model has hit a boundary ... re-formulate the model ?'
                  ELSEIF (ITEST.EQ.5) THEN
                     TEXT(N4) =
     +'the SVD has failed to converge ... selected model may not fit.'
                  ELSEIF (ITEST.EQ.6) THEN
                     TEXT(N4) =
     +'max. iterations used without convergence ... increase MAXIT ?'
                  ELSEIF (ITEST.EQ.7) THEN
                     TEXT(N4) =
     +'rank changed during iteration ... examine the fit carefully.'
                  ELSEIF (ITEST.EQ.8) THEN
                     TEXT(N4) =
     +'NDOF = 0 ... a saturated model has been fitted.'
                  ELSEIF (ITEST.EQ.9) THEN
                     TEXT(N4) =
     +'the fitting procedure in subroutine G02GLIM diverged'                  
                  ENDIF
                  TEXT(N5) = BLANK
                  TEXT(N6) =
     +'Advice: new model, adjust data or re-configure GLM parameters.'
                  CALL PUTMES (N6, TEXT)
               ELSE
                  READY = .FALSE.
               ENDIF
            ENDIF
C
C Is the problem of full rank ?
C
            IF (READY) THEN
               IF (IRANK.LT.IP) CALL PUTWAR (
     +'Less than full rank (SVD used) ... Ignore parameters/std.errors')
C
C Output the best-fit parameters
C
               WRITE (NF,'(A)') BLANK
               IF (SHOWIT) THEN
                  DO I = N1, N3
                     WRITE (NF,'(A)') HEADER(I)
                  ENDDO
               ELSE
                  WRITE (NF,'(A)') HEADER(1)
               ENDIF   
               WRITE (NF,'(A)') BLANK
               COLOUR = N15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
               I12(1) = FORM12(IP)
               I12(2) = FORM12(IRANK)
               I12(3) = FORM12(N)
               I12(4) = FORM12(IDF)
               WRITE (LINE,200) TRIM(I12(1)), TRIM(I12(2)), 
     +                          TRIM(I12(3)), I12(4)
               WRITE (NF,200) TRIM(I12(1)), TRIM(I12(2)), 
     +                        TRIM(I12(3)), I12(4)
               CALL TABLE1 (COLOUR, LINE)
               IF (LOGIST) THEN
                  WORD12 = '   exp(B(i))'
               ELSE
                  WORD12 = BLANK
               ENDIF      
               WRITE (LINE,400) WORD12
               WRITE (NF,400) WORD12
               COLOUR = N4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = N0
C
C Calculate t values and parameter p-values
C
               IFAIL = N1
               TNU = G01FBF$(TAIL, PNT025, DBLE(IDF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01FBF/GLMFIT')
               WTOL = 1.0D+9*X02AMF$()
               XBIG = LOG(ONE/WTOL)
               DF = DBLE(IDF)
               IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
                  J = N1
                  IF (SE(J).GT.WTOL) THEN
                     TVAL = ABS(B(J)/SE(J))
                     IFAIL = N1
                     PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMFIT')
                  ELSE
                     PVAL = ONE
                  ENDIF
                  IF (PVAL.GT.PNT2) THEN
                     CIPHER = ' ***'
                  ELSEIF (PVAL.GT.PNT1) THEN
                     CIPHER = ' ** '
                  ELSEIF (PVAL.GT.PNT05) THEN
                     CIPHER = '  * '
                  ELSE
                     CIPHER = '    '
                  ENDIF
                  IF (PVAL.LT.ZERO) THEN
                     PVAL = ZERO
                  ELSEIF (PVAL.GT.ONE) THEN
                     PVAL = ONE
                  ENDIF
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,500) B(J), B(J) - TNU*SE(J),
     +                                B(J) + TNU*SE(J),
     +                                SE(J), PVAL, CIPHER
                     WRITE (NF,500) B(J), B(J) - TNU*SE(J),
     +                              B(J) + TNU*SE(J),
     +                              SE(J), PVAL, CIPHER
                  ELSE
                     D13(1) = SHOWRJ(B(J))
                     TEMP = B(J) - TNU*SE(J)
                     D13(2) = SHOWRJ(TEMP)
                     TEMP = B(J) + TNU*SE(J)
                     D13(3) = SHOWRJ(TEMP) 
                     D13(4) = SHOWRJ(SE(J))
                     WRITE (LINE,550) D13(1), D13(2),
     +                                D13(3), D13(4), PVAL, CIPHER
                     WRITE (NF,550) D13(1), D13(2),
     +                              D13(3), D13(4), PVAL, CIPHER
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ELSE
                  J = N0
               ENDIF
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     IF (SE(J).GT.TOL) THEN
                        TVAL = ABS(B(J)/SE(J))
                        IFAIL = N1
                        PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMFIT')
                     ELSE
                        PVAL = ONE
                     ENDIF
                     IF (PVAL.GT.PNT2) THEN
                        CIPHER = ' ***'
                     ELSEIF (PVAL.GT.PNT1) THEN
                        CIPHER = '  **'
                     ELSEIF (PVAL.GT.PNT05) THEN
                        CIPHER = '   *'

                                            ELSE
                        CIPHER = '    '
                     ENDIF
                     IF (PVAL.LT.ZERO) PVAL = ZERO
                     IF (PVAL.GT.ONE) PVAL = ONE
                     IF (E_NUMBERS) THEN  
                        IF (LOGIST .AND. ABS(B(J)).LT.XBIG) THEN
                           WRITE (WORD12,'(1P,E12.5)') EXP(B(J))
                        ELSE
                           WORD12 = BLANK    
                        ENDIF  
                        WRITE (LINE,600) I, B(J), B(J) - TNU*SE(J),
     +                                   B(J) + TNU*SE(J), SE(J), PVAL,
     +                                   CIPHER, WORD12
                        WRITE (NF,600) I, B(J), B(J) - TNU*SE(J),
     +                                 B(J) + TNU*SE(J),
     +                                 SE(J), PVAL, CIPHER, WORD12
                     ELSE
                        IF (LOGIST .AND. ABS(B(J)).LT.XBIG) THEN
                           TEMP = EXP(B(J))
                           WORD13 = SHOWRJ(TEMP) 
                        ELSE
                           WORD13 = BLANK    
                        ENDIF  
                        D13(1) = SHOWRJ(B(J))
                        TEMP = B(J) - TNU*SE(J)
                        D13(2) = SHOWRJ(TEMP)
                        TEMP = B(J) + TNU*SE(J)
                        D13(3) = SHOWRJ(TEMP)
                        D13(4) = SHOWRJ(SE(J))
                        WRITE (LINE,650) I, D13(1), D13(2),
     +                                   D13(3), D13(4), PVAL,
     +                                   CIPHER, WORD13
                        WRITE (NF,650) I, D13(1), D13(2),
     +                                 D13(3), D13(4), PVAL,
     +                                 CIPHER, WORD13 
                     ENDIF
                     CALL TABLE1 (COLOUR, LINE)
                  ENDIF
               ENDDO
C
C Output RSS and DEV
C
               IF (E_NUMBERS) THEN 
                  IF (NTYPE.EQ.N1) THEN
                     WRITE (LINE,1000) RSS, S, A
                  ELSEIF (NTYPE.EQ.N2) THEN
                     WRITE (LINE,1100) DEV
                  ELSEIF (NTYPE.EQ.N3) THEN
                     WRITE (LINE,1200) DEV, A
                  ELSEIF (NTYPE.EQ.N4) THEN
                     WRITE (LINE,1300) DEV, S, A
                  ENDIF
               ELSE
                  IF (NTYPE.EQ.N1) THEN
                     D13(1) = SHOWLJ(RSS)
                     D13(2) = SHOWLJ(S)
                     D13(3) = SHOWLJ(A)
                     WRITE (LINE,1050) TRIM(D13(1)), TRIM(D13(2)),
     +                                 TRIM(D13(3))
                  ELSEIF (NTYPE.EQ.N2) THEN
                     D13(1) = SHOWLJ(DEV)   
                     WRITE (LINE,1150) D13(1)
                  ELSEIF (NTYPE.EQ.N3) THEN
                     D13(1) = SHOWLJ(DEV)
                     D13(2) = SHOWLJ(A)
                     WRITE (LINE,1250) TRIM(D13(1)), D13(2)
                  ELSEIF (NTYPE.EQ.N4) THEN
                     D13(1) = SHOWLJ(DEV)
                     D13(2) = SHOWLJ(S)
                     D13(3) = SHOWLJ(A)
                     WRITE (LINE,1350) TRIM(D13(1)), TRIM(D13(2)),
     +                      D13(3)
                  ENDIF 
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NF,'(A)') LINE
               CALL TABLE1 (COLOUR, 'CLOSE')
               NUMDEC = N1
            ENDIF
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Fitting Generalized Linear Models'
     +/
     +/'Variables (* = suppressed):'
     +/A
     +/'Data:',1X,A
     +/'Title:',1X,A
     +/'Fitting to use weights supplied',1X,A
     +/'Include a constant (mean) term',1X,A
     +/'Total number of x-variables supplied =',I4
     +/'Number of x-variables to be included =',I4
     +/'Number of x-variables to be excluded =',I4
     +/'Number of parameters to be estimated =',I4
     +/
     +/'Fit data with current settings'
     +/'Change status of the constant term'
     +/'Suppress/Restore variables'
     +/'Plot y(i) = f(x(i,j))'
     +/'Examine residuals'
     +/'Compare 2 parameters'
     +/'Compare 2 sets of parameters'
     +/'Evaluate y = f(x) if consistent: x values input from terminal'
     +/'Evaluate y = f(x) if consistent: x values input from a file'
     +/'Results'
     +/'Quit ... Exit these GLM options')
  200 FORMAT ('Number of parameters = ',A,
     +', Rank = ',A,', Number of points = ',A, 
     +', Degrees of freedom = ',A)
  400 FORMAT ('Parameter         Value    Lower95%cl    Upper95%cl',
     +'    Std. error   p',9X,A)
  500 FORMAT (' Constant',   1P,4(1X,E13.5),0P,F7.4,A)
  550 FORMAT (' Constant',      4(1X,A13),F7.4,A)     
  600 FORMAT ('   B(',I3,')',1P,4(1X,E13.5),0P,F7.4,A,1X,A)  
  650 FORMAT ('   B(',I3,')',   4(1X,A13),F7.4,A,1X,A)      
  700 FORMAT (
     + 'Display table of residuals'
     +/'Write to results file'
     +/'Plot against best fit'
     +/'Plot in half normal format'
     +/'Plot in full normal format'
     +/'Quit ... Exit these residuals plotting options')
  800 FORMAT ('Number       Y-value        Theory     Dev-resid',
     +'      Leverage')
  900 FORMAT (I6,1P,4(1X,E13.5))   
  950 FORMAT (I6,1P,4(1X,A13)) 
 1000 FORMAT ('WSSQ =',1P,E12.5,', S =',E12.5,', A =',E12.5)
 1050 FORMAT ('WSSQ = ',A,', S = ',A,', A = ',A)
 1100 FORMAT ('Deviance =',1P,E12.5)
 1150 FORMAT ('Deviance = ',A)
 1200 FORMAT ('Deviance =',1P,E12.5,', A =',E12.5)
 1250 FORMAT ('Deviance = ',A,', A = ',A)
 1300 FORMAT (
     +'Adjusted Deviance =',1P,E12.5,', S =',E12.5,', A =',E12.5)
 1350 FORMAT (
     +'Adjusted Deviance = ',A,', S = ',A,', A = ',A)     
      END
C
C
