C
C
      SUBROUTINE GLMINI (ISX, IWK, MTYPE, NCMAX, NF, NIN, NRMAX,
     +                   A1, A2, B, COV, SE, T, WK, WT, Y)
C
C ACTION: Front end to initialise simfit GLM
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 27/07/2000
C         07/02/2001 added TRIM60 and CHOP60
C         11/06/2002 added GLMSIM
C         10/06/2002 added exponential survival
C         22/07/2002 added Weibull survival
C         02/08/2002 added extreme value survival
C         28/08/2002 added Cox regression, IWK and redimensioned WK
C         16/10/2002 added conditional stratified logistic
C         30/10/2005 added MTYPe to partition options
C         07/01/2006 introduced allocatable arrays
C         14/02/2006 simplified argument list to GLMSIM
C         13/04/2006 introduced LWK and MXN to dimension arguments to GLMCOX
C         21/05/2006 deleted Y from call to GLMDAT
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    MTYPE, NCMAX, NF, NIN, NRMAX
      INTEGER    ISX(NCMAX), IWK(7*NRMAX)
      DOUBLE PRECISION A1(NRMAX,NCMAX), A2(NRMAX,NCMAX),
     +                 B(NCMAX), COV(NCMAX*(NCMAX + 1)/2),
     +                 SE(NCMAX),
     +                 T(NRMAX),
     +                 WK(3*NRMAX),
     +                 WT(NRMAX), Y(NRMAX)
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: V(:,:)
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 15)
      INTEGER    NUMBLD(20), NUMPOS(10)
      INTEGER    I, IPRINT, ISEND, LTYPE, MAXIT, NCOLS, NROWS, NTYPE
      INTEGER    ICOUNT, IERR, JSEND, LWK, MXN
      INTEGER    I1, I2, I3, I4, I5, I6, I7, M, N
      DOUBLE PRECISION AFIX, EPS, SFIX, TOL
      DOUBLE PRECISION ZERO, ONE, EPS1, TOL1
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPS1 = 1.0D-06,
     +           TOL1 = 5.0D-05)
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE1*80, TITLE2*80
      CHARACTER  CHOP60*60, TEXT(30)*100, TRIM60*60
      CHARACTER  CIFER1*40, CIFER2*40, ERROR*40, LINK*40, WORD4(2)*4
      CHARACTER  BLANK*1, NONE*4
      PARAMETER (BLANK = ' ', NONE = 'None')
      CHARACTER (LEN = 80) TRIM80, WORD80_1, WORD80_2
      LOGICAL    ISTOP, OFFVEC, SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      LOGICAL    AGAIN, READY, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   GLMDAT, GLMCON, GLMFIT, GLMADV, PUTFAT, LBOX01, REVPRO,
     +           TRIM60, CHOP60, GLMSIM, GLMWEI, GLMCOX, GLMSTR, TRIM80
      INTRINSIC  ABS
      SAVE       ICOUNT, LTYPE, MAXIT, NTYPE
      SAVE       AFIX, EPS, SFIX, TOL
      DATA       ICOUNT, IPRINT, LTYPE, MAXIT, NTYPE / 0, 0, 2, 20, 1 /
      DATA       AFIX, EPS, SFIX, TOL / ONE, EPS1, ZERO, TOL1 /
      DATA       NUMBLD / 1*1, 19*0 /
      DATA       NUMPOS / 10*1 /
C
C Start of the outer loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C----------------------------------------------------------------------
C
      READY = .FALSE.
      FNAME1 = NONE
      FNAME2 = NONE
      TITLE1 = NONE
      TITLE2 = NONE
C
C Call GLMSIM to set the pattern as follows:
C
C     JSEND = 0: done
C     JSEND = 1: advanced GLM
C     JSEND = 2: simple logistic GLM
C     JSEND = 3: simple binary logistic GLM
C     JSEND = 4: simple polynomial GLM
C     JSEND = 5: simple exponential survival GLM
C     JSEND = 6: Weibull survival GLM
C     JSEND = 7: extreme value survival GLM
C     JSEND = 8: Cox regression
C     JSEND = 9: Conditional stratified logistic
C
      CLOSE (UNIT = NIN)
      CALL GLMSIM (JSEND, MTYPE, NIN, NF)
      CLOSE (UNIT = NIN)
      IF (JSEND.LE.0) RETURN
C
C Allocate the workspaces
C
      IERR = 0
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(V(NRMAX,NCMAX + 8), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      DO I = 1, NRMAX
         T(I) = ZERO
         WT(I) = ONE
         V(I,7) = ZERO
      ENDDO
      DO I = 1, NCMAX
         ISX(I) = 1
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO
      IF (JSEND.EQ.4) THEN
         DO I = 2, 6
            ISX(I) = 0
         ENDDO
      ENDIF
      DO I = 1, NCMAX*(NCMAX + 1)/2
         COV(I) = ZERO
      ENDDO
      AGAIN = .TRUE.
      IF (JSEND.EQ.1) THEN
C
C Advanced GLM procedure ..............................................
C
         WORD4(1) = BLANK
         WORD4(2) = BLANK
         DO WHILE (AGAIN)
           IF (NTYPE.EQ.2) THEN
               CIFER1 = BLANK
            ELSE
               WRITE (CIFER1,100) AFIX
            ENDIF
            CIFER2 = BLANK
            IF (NTYPE.EQ.1) THEN
               ERROR = 'Normal'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Sigma^2 estimated'
               ELSE
                  WRITE (CIFER2,200) SFIX
               ENDIF
            ELSEIF (NTYPE.EQ.2) THEN
               ERROR = 'Binomial'
            ELSEIF (NTYPE.EQ.3) THEN
               ERROR = 'Poisson'
            ELSEIF (NTYPE.EQ.4) THEN
               ERROR = 'Gamma'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Scale factor estimated'
               ELSE
                  WRITE (CIFER2,300) SFIX
               ENDIF
            ENDIF
            IF (NTYPE.EQ.2) THEN
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Logistic'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Probit'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Complementary log-log'
               ENDIF
            ELSE
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Exponent'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Identity'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Log'
               ELSEIF (LTYPE.EQ.4) THEN
                  LINK = 'Square root'
               ELSEIF (LTYPE.EQ.5) THEN
                  LINK = 'Reciprocal'
               ENDIF
            ENDIF
            WRITE (TEXT,400) TRIM60(FNAME1), CHOP60(TITLE1),
     +                       TRIM60(FNAME2), CHOP60(TITLE2),
     +                       ERROR, LINK, MAXIT, EPS, TOL,
     +                       CIFER1, CIFER2, WORD4(1), WORD4(2)
            NUMOPT = 7
            NTEXT = NSTART + NUMOPT - 1
            NUMDEC = NUMOPT - 2
            NUMBLD(7) = 1
            NUMBLD(8) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (NUMDEC.EQ.1) THEN
               CLOSE (UNIT = NIN)
               CALL GLMDAT (JSEND, NCMAX, NCOLS, NIN, NRMAX, NROWS,
     +                      A1, V, T,
     +                      FNAME1, FNAME2, TITLE1, TITLE2,
     +                      ISTOP, OFFVEC, SUPPLY)
               CLOSE (UNIT = NIN)
               IF (ISTOP) THEN
                  FNAME1 = NONE
                  FNAME2 = NONE
                  TITLE1 = NONE
                  TITLE2 = NONE
                  READY = .FALSE.
               ELSE
                  READY = .TRUE.
                  ICOUNT = ICOUNT + 1
                  WORD80_1 = TRIM80(FNAME1)
                  WORD80_2 = TRIM80(FNAME2)
                  WRITE (NF,500) ICOUNT, WORD80_1, TITLE1, WORD80_2,
     +                           TITLE2
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
               ISEND = 1
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.3) THEN
               ISEND = 2
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.4) THEN
               IF (.NOT.READY) THEN
                  CALL PUTFAT ('First input your data file')
               ELSE
                  WRITE (NF,600) ERROR, LINK
                  CALL GLMFIT (IPRINT, ISX, JSEND, LTYPE, MAXIT, NCMAX,
     +                         NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                         AFIX, A1, A2, B, COV, EPS, SE, SFIX, T,
     +                         TOL, V, WK, WT, Y,
     +                         FNAME1, TITLE1,
     +                         OFFVEC)
               ENDIF
            ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
               I = 1
               CALL GLMADV (I)
           ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
               CALL REVPRO (NF)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ELSE
C
C Simple GLM procedures ..............................................
C
         IF (JSEND.EQ.2) THEN
            FNAME2 = 'None'
            TITLE2 = 'Logistic regression'
         ELSEIF (JSEND.EQ.3) THEN
            FNAME2 = 'None'
            TITLE2 = 'Binary logistic regression'
         ELSEIF (JSEND.EQ.4) THEN
            FNAME2 = 'None'
            TITLE2 = 'Polynomial logistic regression'
         ELSEIF (JSEND.EQ.5) THEN
            FNAME2 = 'log(t)'
            TITLE2 = 'Exponential survival'
         ELSEIF (JSEND.EQ.6) THEN
            FNAME2 = 'alpha*log(t)'
            TITLE2 = 'Weibull survival'
         ELSEIF (JSEND.EQ.7) THEN
            FNAME2 = 'alpha*t'
            TITLE2 = 'Extreme value survival'
         ELSEIF (JSEND.EQ.8) THEN
            FNAME2 = 'None'
            TITLE2 = 'Cox regression'
         ELSEIF (JSEND.EQ.9) THEN
            FNAME2 = 'None'
            TITLE2 = 'Binary logistic regression'
         ENDIF
         IF (JSEND.GE.2 .AND. JSEND.LE.4) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ELSEIF (JSEND.GE.5 .AND. JSEND.LT.8) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 3
            NTYPE = 3
         ELSEIF (JSEND.EQ.8) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ELSEIF (JSEND.EQ.9) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ENDIF
         DO WHILE (AGAIN)
           IF (NTYPE.EQ.2) THEN
               CIFER1 = BLANK
            ELSE
               WRITE (CIFER1,100) AFIX
            ENDIF
            CIFER2 = BLANK
            IF (NTYPE.EQ.1) THEN
               ERROR = 'Normal'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Sigma^2 estimated'
               ELSE
                  WRITE (CIFER2,200) SFIX
               ENDIF
            ELSEIF (NTYPE.EQ.2) THEN
               ERROR = 'Binomial'
            ELSEIF (NTYPE.EQ.3) THEN
               ERROR = 'Poisson'
            ELSEIF (NTYPE.EQ.4) THEN
               ERROR = 'Gamma'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Scale factor estimated'
               ELSE
                  WRITE (CIFER2,300) SFIX
               ENDIF
            ENDIF
            IF (NTYPE.EQ.2) THEN
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Logistic'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Probit'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Complementary log-log'
               ENDIF
            ELSE
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Exponent'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Identity'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Log'
               ELSEIF (LTYPE.EQ.4) THEN
                  LINK = 'Square root'
               ELSEIF (LTYPE.EQ.5) THEN
                  LINK = 'Reciprocal'
               ENDIF
            ENDIF
            WRITE (TEXT,400) TRIM60(FNAME1), CHOP60(TITLE1),
     +                       TRIM60(FNAME2), CHOP60(TITLE2),
     +                       ERROR, LINK, MAXIT, EPS, TOL,
     +                       CIFER1, CIFER2, WORD4(1), WORD4(2)
            NUMOPT = 7
            NTEXT = NSTART + NUMOPT - 1
            NUMDEC = NUMOPT - 2
            NUMBLD(7) = 1
            NUMBLD(8) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (NUMDEC.EQ.1) THEN
               CLOSE (UNIT = NIN)
C
C JSEND = 5: Offsets are returned in V(.,7) for exponential survival
C JSEND = 6: Log survival times are returned in T(.) for Weibull survival
C JSEND = 7: Survival times are returned in T(.) for extreme value survival
C
               CALL GLMDAT (JSEND, NCMAX, NCOLS, NIN, NRMAX, NROWS,
     +                      A1, V, T,
     +                      FNAME1, FNAME2, TITLE1, TITLE2,
     +                      ISTOP, OFFVEC, SUPPLY)
               CLOSE (UNIT = NIN)
               IF (ISTOP) THEN
                  FNAME1 = NONE
                  TITLE1 = NONE
                  READY = .FALSE.
               ELSE
                  IF (JSEND.EQ.4) THEN
C
C Suppress x^2, x^3, ..., x^6 for polynomial regression
C
                     ISX(1) = 1
                     DO I = 2, 6
                        ISX(I) = 0
                     ENDDO
                  ENDIF
                  READY = .TRUE.
                  ICOUNT = ICOUNT + 1
                  WORD80_1 = TRIM80(FNAME1)
                  WORD80_2 = TRIM80(FNAME2)
                  WRITE (NF,500) ICOUNT, WORD80_1, TITLE1, WORD80_2,
     +                           TITLE2
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
               CALL PUTFAT ('Not allowed from simple interface')
            ELSEIF (NUMDEC.EQ.3) THEN
               ISEND = 2
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT,
     +                      NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.4) THEN
               IF (.NOT.READY) THEN
                  CALL PUTFAT ('First input your data file')
               ELSE
                  IF (JSEND.GE.2 .AND. JSEND.LE.5) THEN
                     WRITE (NF,600) ERROR, LINK
                     CALL GLMFIT (IPRINT, ISX, JSEND, LTYPE, MAXIT,
     +                            NCMAX, NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                            AFIX, A1, A2, B, COV, EPS, SE, SFIX,
     +                            T, TOL, V, WK, WT, Y,
     +                            FNAME1, TITLE1,
     +                            OFFVEC)
                  ELSEIF (JSEND.EQ.6 .OR. JSEND.EQ.7) THEN
                     IF (JSEND.EQ.6) THEN
                        WRITE (NF,700)
                     ELSE
                        WRITE (NF,800)
                     ENDIF
                     CALL GLMWEI (IPRINT, ISX, JSEND, MAXIT,
     +                            NCMAX, NCOLS, NF, NRMAX, NROWS,
     +                            AFIX, A1, A2, B, COV, EPS, SE,
     +                            T, TOL, V, WK, WT, Y,
     +                            FNAME1, TITLE1)
                  ELSEIF (JSEND.EQ.8) THEN
                     LWK = 3*NRMAX
                     MXN = NRMAX
                     I1 = 1
                     I2 = I1 + NRMAX
                     I3 = I2 + NRMAX
                     I4 = I3 + NRMAX
                     I5 = I4 + NRMAX
                     I6 = I5 + NRMAX
                     I7 = I6 + NRMAX
                     CALL GLMCOX (IWK(I1), IWK(I2), IPRINT, IWK(I3),
     +                            IWK(I4), ISX, IWK(I5), LWK, MAXIT,
     +                            MXN, IWK(I6), NCMAX, IWK(I7), NF, NIN,
     +                            NRMAX, NRMAX,
     +                            A1, A2, B, COV, SE, T, TOL, V, WK, WT,
     +                            FNAME1, TITLE1)
                  ELSEIF (JSEND.EQ.9) THEN
                     M = NCOLS - 3
                     N = NROWS
                     I1 = 1
                     I2 = I1 + NRMAX
                     I3 = I2 + NRMAX
                     I4 = I3 + NRMAX
                     LWK = 3*NRMAX
                     CALL GLMSTR (IWK(I1), IPRINT, IWK(I2),
     +                            ISX, LWK, M, MAXIT, IWK(I3), N,
     +                            IWK(I4), NF, NRMAX, NRMAX,
     +                            A1, B, COV, SE, TOL, WK, WT,
     +                            FNAME1, TITLE1)
                  ENDIF
               ENDIF
            ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
               I = 2
               CALL GLMADV (I)
            ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
               CALL REVPRO (NF)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C----------------------------------------------------------------------
C
      ENDDO
      CLOSE (UNIT = NIN)
C
C End of the outer loop so deallocate
C
      DEALLOCATE(V, STAT = IERR)
  100 FORMAT ('Exponent A =',1P,E9.2)
  200 FORMAT ('Sigma^2 =',1P,E9.2)
  300 FORMAT ('Scale factor =',1P,E9.2)
  400 FORMAT (
     + 'Generalized Linear Models'
     +/
     +/'File:',1X,A
     +/'Title:',1X,A
     +/'Offset:',1X,A
     +/'Detail:',1X,A
     +/'Error type assumed:',1X,A
     +/'Link type selected:',1X,A
     +/'MAXIT (iterations) =',I6
     +/'EPSI (SVD) =',1P,E9.2
     +/'TOL (Convergence) =',1P,E9.2
     +/A
     +/A
     +/
     +/'New data'
     +/'Select error and link types',1X,A
     +/'Configure control parameters',1X,A
     +/'Proceed to GLM fitting'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these GLM options')
  500 FORMAT (
     +/' GLM analysis number',I3
     +/' File:',1X,A
     +/' Title:',1X,A
     +/' Offset:',1X,A
     +/' Details:',1X,A)
  600 FORMAT (
     +/'Error type:',1X,A
     +/'Link type:',1X,A)
  700 FORMAT (/'Fitting the Weibull survival model')
  800 FORMAT (/'Fitting the extreme value survival model')
      END
C
C
