C
C
      SUBROUTINE GLMOFF (NIN, NRMAX, NROWS, X, FNAME, TITLE, OFFVEC)
C
C ACTION: Read in an offset GLM
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 30/07/2000
C         date of this version 07/08/2000
C
      IMPLICIT   NONE
      INTEGER    NIN, NRMAX, NROWS
      INTEGER    NPTS
      INTEGER    ICOLOR, ISEND, IX, IY
      PARAMETER (ICOLOR = 3, ISEND = 2, IX = 4, IY = 4)
      DOUBLE PRECISION X(NRMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      CHARACTER  LINE*100
      LOGICAL    OFFVEC
      LOGICAL    AGAIN, ISTOP
      LOGICAL    FIXROW, LABEL
      PARAMETER (FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   VEC1IN, YESNO2, PUTFAT
C
C Read in an offset vector
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         OFFVEC = .FALSE.
         WRITE (LINE,100) NROWS
         CALL YESNO2 (ICOLOR, IX, IY, LINE, OFFVEC)
         IF (OFFVEC) THEN
C
C Read in and check data
C
            CLOSE (UNIT = NIN)
            CALL VEC1IN (ISEND, NIN, NRMAX, NPTS, X, FNAME,
     +                   TITLE, ISTOP, FIXROW, LABEL)
            CLOSE (UNIT = NIN)
            IF (ISTOP) AGAIN = .TRUE.
            IF (.NOT.ISTOP .AND. NPTS.LT.NROWS) THEN
               CALL PUTFAT ('Insufficient offset values')
               ISTOP = .TRUE.
            ENDIF
            IF (ISTOP) THEN
               AGAIN = .TRUE.
               OFFVEC = .FALSE.
            ELSE
               AGAIN = .FALSE.
               OFFVEC = .TRUE.
            ENDIF
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Install an offset vector with at least',I4,' rows (usually no)')
      END
C
C
