c
c
      subroutine glmp50 (isend, nout, npar, npts,
     +                   bpar, cov, dev, pcent, se,
     +                   link)
c
c action: calculate p50 or other percentiles after g02gbf
c author: w.g.bardsley, university of manchester, u.k., 28/04/2002
c         09/10/2021 added e_numbers and e_formats, etc.
c         isend = 1: short output
c         isend = 2: full output
c
      implicit   none
      integer    isend, nout, npar, npts
      integer    i, icolor, ifail, ndof
      double precision bpar(npar), cov(npar*(npar + 1)/2), dev, pcent,
     +                 se(npar)
      double precision a, b, bsqd, c, cv, da, dasqd, db, dbsqd, dof,
     +                 p50, pah, pal, pbh, pbl, ph, pl, prob, proba,
     +                 probb, ratio, sep50, t, va, vb
      double precision one, two, pnt975, rtol, x100, x99
      parameter (one = 1.0d+00, two = 2.0d+00, pnt975 = 0.975d+00,
     +           rtol = 1.0d-100, x100 = 100.0d+00, x99 = 99.0d+00)
      double precision g01ebf$, g01fbf$, g01faf$
      character (len = 13) d13(13), showlj, showrj
      character (len = 12) i12, form12
      character  link*1
      character  tail*1, text(30)*100, type1*30, word4*4
      logical    e_numbers, e_formats
      external   e_formats, form12, showlj, showrj
      external   putifa, table1, putfat, triml1
      external   g01ebf$, g01fbf$, g01faf$
      intrinsic  log, sqrt, dble, nint, trim
c
c check that calculations are possible and initialise
c
      if (npar.ne.2 .or. npts.lt.3) return
      if (isend.lt.1 .or. isend.gt.2) then
         call putfat ('ISEND out of range in call to GLMP50')
         return
      endif
      if (pcent.lt.one .or. pcent.gt.x99) then
         call putfat ('Percentage out of range in call to GLMP50')
         return
      endif
      e_numbers = e_formats()
      write (word4,'(i3,a1)') nint(pcent), '%'
      call triml1 (word4)
      a = bpar(1)
      b = bpar(2)
      bsqd = b*b
      if (bsqd.le.rtol) then
         call putfat ('Cannot calculate LD50')
         return
      endif
      va = cov(1)
      cv = cov(2)
      vb = cov(3)
c
c temporarily define p50 = proportion required then calculate f(p)
c
      p50 = pcent/x100
      if (link.eq.'G' .or. link.eq.'g') then
         type1 = 'Logistic'
         c = log(p50/(one - p50))
      elseif (link.eq.'P' .or. link.eq.'p') then
         type1 = 'Probit'
         ifail = 1
         tail = 'L'
         c = g01faf$(tail, p50, ifail)
      elseif (link.eq.'C' .or. link.eq.'c') then
         type1 = 'Complementary log-log'
         c = log(- log(one - p50))
      else
         return
      endif
c
c assign p50 and calculate standard error
c
      p50 = (c - a)/b
      da = -one/b
      db = -(c - a)/bsqd
      dasqd = da*da
      dbsqd = db*db
      sep50 = sqrt(dasqd*va + dbsqd*vb + two*da*db*cv)
      if (sep50.le.rtol) then
         call putfat ('Cannot calculate LD50 standard error')
         return
      endif
c
c now the associated t statistics and confidence limits
c
      ndof = npts - 2
      dof = dble(ndof)
      ratio = p50/sep50
      tail = 'S'
      ifail = 1
      prob = g01ebf$(tail, ratio, dof, ifail)
      call putifa (ifail, nout, 'G01EBF/GLMP50')
      tail = 'L'
      ifail = 1
      t = g01fbf$(tail, pnt975, dof, ifail)
      call putifa (ifail, nout, 'G01FBF/GLMP50')
      pl = p50 - t*sep50
      ph = p50 + t*sep50
      icolor = 15
      call table1 (icolor, 'OPEN')
      if (isend.eq.1 .or. se(1).le.rtol .or. se(2).le.rtol) then
c
c short output
c        
         if (e_numbers) then 
            write (text,100) word4, type1, word4, p50, sep50, pl, ph,
     +                       prob
            do i = 1, 7
               if (i.eq.2 .or. i.eq.5) then
                  icolor = 4
               else
                  icolor = 0
               endif
               call table1 (icolor, text(i))
               write (nout,'(a)') text(i)
            enddo
         else
            d13(1) = showrj(p50)
            d13(2) = showrj(sep50)
            d13(3) = showrj(pl)
            d13(4) = showrj(ph)
            write (text,150) word4, type1, word4, d13(1), d13(2),
     +                       d13(3), d13(4), prob
            do i = 1, 7
               if (i.eq.2 .or. i.eq.5) then
                  icolor = 4
               else
                  icolor = 0
               endif
               call table1 (icolor, text(i))
               write (nout,'(a)') text(i)
            enddo
         endif  
      else
c
c long output
c
         ratio = a/se(1)
         tail = 'S'
         ifail = 1
         proba = g01ebf$(tail, ratio, dof, ifail)
         call putifa (ifail, nout, 'G01EBF/GLMP50')
         pal = a - t*se(1)
         pah = a + t*se(1)
         ratio = b/se(2)
         tail = 'S'
         ifail = 1
         probb = g01ebf$(tail, ratio, dof, ifail)
         call putifa (ifail, nout, 'G01EBF/GLMP50')
         pbl = b - t*se(2)
         pbh = b + t*se(2)
         if (e_numbers) then
            write (text,200) word4, type1, npts, dev,
     +                       a, se(1), pal, pah, proba,
     +                       b, se(2), pbl, pbh, probb, word4,
     +                       p50, sep50, pl, ph, prob
            do i = 1, 9
               if (i.eq.2 .or. i.eq.5) then
                  icolor = 4
               else
                  icolor = 0
               endif
               call table1 (icolor, text(i))
               write (nout,'(a)') text(i)
            enddo
         else
            i12 = form12(npts)
            d13(1) = showlj(dev)
            d13(2) = showrj(a)
            d13(3) = showrj(se(1))
            d13(4) = showrj(pal)
            d13(5) = showrj(pah)
            d13(6) = showrj(b)
            d13(7) = showrj(se(2))
            d13(8) = showrj(pbl)
            d13(9) = showrj(pbh)
            d13(10) = showrj(p50)
            d13(11) = showrj(sep50)
            d13(12) = showrj(pl)
            d13(13) = showrj(ph)
            write (text,250) word4, type1, trim(i12), d13(1),
     +                       d13(2), d13(3), d13(4), d13(5), proba,
     +                       d13(6), d13(7), d13(8), d13(9), probb,
     +                       word4,
     +                       d13(10), d13(11), d13(12), d13(13), prob
            do i = 1, 9
               if (i.eq.2 .or. i.eq.5) then
                  icolor = 4
               else
                  icolor = 0
               endif
               call table1 (icolor, text(i))
               write (nout,'(a)') text(i)
            enddo 



         endif
      endif   
      call table1 (icolor, 'CLOSE')
c
c format statements
c      
  100 format (
     + ' '
     +/'Estimation of the ',a,'point'
     +/'Method: GLM with binomial errors, Link: ',a
     +/
     +/5x,a4,'point    Std. error    Lower95%cl    Upper95%cl    p'
     +/1p,4(1x,e13.5),0p,f8.4
     +/' ')
  150 format (
     + ' '
     +/'Estimation of the ',a,'point'
     +/'Method: GLM with binomial errors, Link: ',a
     +/
     +/5x,a4,'point    Std. error    Lower95%cl    Upper95%cl    p'
     +/4(1x,a13),f8.4
     +/' ')     
  200 format (
     + ' '
     +/'Estimation of the ',a,'point'
     +/'Method: GLM with binomial errors, Link: ',a
     +/'N =',i5,', Deviance = ',1p,e13.5
     +/'Parameter            Value    std. error    Lower95%cl',
     + '    Upper95%cl    p'
     +/'Constant    ',1p,4(1x,e13.5),0p,f8.4
     +/'Slope       ',1p,4(1x,e13.5),0p,f8.4
     +/ a4,'point   ',1p,4(1x,e13.5),0p,f8.4
     +/' ')
  250 format (
     + ' '
     +/'Estimation of the ',a,'point'
     +/'Method: GLM with binomial errors, Link: ',a
     +/'N = ',a,', Deviance =',1x,a
     +/'Parameter            Value    std. error    Lower95%cl',
     + '    Upper95%cl    p'
     +/'Constant    ',4(1x,a13),f8.4
     +/'Slope       ',4(1x,a13),f8.4
     +/ a4,'point   ',4(1x,a13),f8.4
     +/' ')                 
       end
c
c
