c
c
      subroutine glmref (ip, jsend, m, ncol, nref, nrmax, nrow, ntype,
     +                   a, b, x, xref, yref,
     +                   link, offset,
     +                   abort)
c
c action: return a reference curve for GLM models with one variable
c author: w.g.bardsley, university of manchester, u.k. 13/07/2015
c 
c
c         NTYPE: 1. Normal 
c                2. Binomial
c                3. Poisson
c                4. Gamma
c         JSEND: 1. Advanced GLM
c                2. Simple logistic
c                3. Binary logistic
c                4. Polynomial
c            IP: number of independent variables in the model including the intercept if present
c             M: number of independent variables    
c
      implicit none
c
c arguments
c          
      integer,             intent (in)  :: ip, jsend, m, ncol, nref,
     +                                     nrmax, nrow, ntype
      double precision,    intent (in)  :: a, b(ip), x(nrmax,ncol)
      double precision,    intent (out) :: xref(nref), yref(nref) 
      character (len = *), intent (in)  :: link, offset
      logical,             intent (out) :: abort  
c
c locals
c      
      integer    i, ifail, k
      double  precision ainv, alpha, beta, delta, eta, etol, rtol, xmax,
     +                  xmin, z
      double precision g01eaf$, x02amf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      external   g01eaf$, x02amf$
      intrinsic  dble, exp, abs, log
      abort = .true.
c
c check input for consistency with just 1 variable
c      
      if (ip.lt.1       .or.
     +    jsend.eq.4    .or.   
     +    m.ne.1        .or. 
     +    ncol.ne.4     .or.
     +    nref.lt.2     .or.
     +    nrmax.lt.2    .or.
     +    nrow.lt.2     .or.
     +    ntype.lt.1    .or.
     +    ntype.gt.4    .or.
     +    offset.eq.'Y' .or.
     +    offset.eq.'y' ) return
c
c define xref
c
      xmax = x(1,1)
      xmin = x(1,1)
      do i = 1, nrow
         if (x(i,1).gt.xmax) xmax = x(i,1)
         if (x(i,1).lt.xmin) xmin = x(i,1)
      enddo
      delta = (xmax - xmin)/dble(nref - 1) 
      xref(1) = xmin
      do i = 2, nref - 1
         xref(i) = xref(i - 1) + delta
      enddo
      xref(nref) = xmax  
c
c identify the type and check the links
c   
      rtol = 1.0d+09*x02amf$()
      if (ntype.ne.2) then
         if (link.eq.'E' .or. link.eq.'e') then
            if (abs(a).le.rtol) return
            k = 1
            ainv = one/a
         elseif (link.eq.'I' .or. link.eq.'i') then
            k = 2
         elseif (link.eq.'L' .or. link.eq.'l') then
            k = 3
         elseif (link.eq.'S' .or. link.eq.'s') then
            k = 4
         elseif (link.eq.'R' .or. link.eq.'r') then
            k = 5
         else
            return
         endif
      else
         if (link.eq.'G' .or. link.eq.'g') then
            k = 1
         elseif (link.eq.'P' .or. link.eq.'p') then
            k = 2
         elseif (link.eq.'C' .or. link.eq.'c') then
            k = 3
         else
            return
         endif  
      endif
c
c calculate yref
c
      if (ip.eq.1) then
         alpha = zero
         beta = b(1)
      else
         alpha = b(1)
         beta = b(2)
      endif  
      etol = log(rtol)  
      do i = 1, nref
         eta = alpha + beta*xref(i)
         if (ntype.ne.2) then
            if (k.eq.1) then
               if (eta.le.zero) return
               yref(i) = eta**(ainv)
            elseif (k.eq.2) then
               yref(i) = eta
            elseif (k.eq.3) then
               if (eta.lt.etol .or. eta.gt.-etol) return
               yref(i) = exp(eta) 
            elseif (k.eq.4) then
               yref(i) = eta**2  
            else
               if (abs(eta).le.rtol) return
               yref(i) = one/eta
            endif
         else
            if (k.eq.1) then
               if (eta.lt.etol .or.eta.gt.-etol) return
               yref(i) = exp(eta)/(one + exp(eta))
            elseif (k.eq.2) then
               ifail = 0
               yref(i) = g01eaf$('L', eta, ifail)
            elseif (k.eq.3) then
               if (eta.lt.etol .or.eta.gt.-etol) return
               z = - exp(eta)
               if (z.lt.etol .or. z.gt.-etol) return
               yref(i) = one - exp(z)
            endif                         
         endif   
      enddo
c
c finally set abort = .false.
c      
      abort = .false.
      end
c
c      