c
c
      subroutine glmsim (isend, mtype, nin, nout)
c
c action: simple interface to GLIM
c author: w.g.bardsley, university of manchester, u.k.,10/06/2002
c         10/07/2002 added exponential survival
c         02/08/2002 extensive revision
c         29/08/2002 added Cox regression
c         10/10/2002 revised interface
c         16/10/2002 edited and added stratified binary logistic
c         30/01/2003 added call to ttest2
c         02/02/2003 added call to pcvtst
c         30/10/2005 added mtype to partition the options
c         14/02/2006 replaced contin and ldlc50 by m_matone
c         24/02/2006 replaced pcvtst by pcvts3 and deleted arrays
c         11/04/2006 added call to glmadv with isend = 4
c         10/06/2010 added call to nklcfg
c
c isend: (input/output)
c         on return isend is as follows:
c         isend = 0: end
c         isend = 1: advanced GLM
c         isend = 2: logistic
c         isend = 3: binary logistic
c         isend = 4: polynomial logistic
c         isend = 5: exponential survival
c         isend = 6: Weibull survival
c         isend = 7: Extreme value survival
c         isend = 8: Cox regression
c         isend = 9: conditional logistic stratified
c mtype: (input/unchanged) type required as follows:
c         mtype = 1: comprehensive
c         mtype = 2: survival analysis
c         mtype = 3: logistic regression
c   nin: (input/unchanged) unconnected unit for data input
c  nout: (input/unchanged) pre-connected unit for results
c
      implicit   none
c
c arguments
c
      integer    isend, mtype, nin, nout
c
c locals
c
      integer    ix, iy, numdec, numopt, numtxt
      parameter (ix = 4, iy = 4)
      integer    n23
      parameter (n23 = 23)
      integer    jsend, ncol8, ncol12, nrow8, nrow12
      integer    i, index2(13), index3(13)
      integer    kval_11, nklcfg
      character  text(30)*100, text2(14)*100, text3(14)*100
      character  fname8*1024, fname12*1024, title8*80, title12*80
      character  blank*1
      parameter (blank = ' ')
      logical    repeet
      logical    first(20), first8, first12
      logical    titles
      parameter (titles = .true.)
      external   lview2, glmadv, putmes, putadv, nklcfg,
     +           revpro, ttest2, pcvts3, putfat, m_matone
      save       ncol8, nrow8, fname8, title8
      save       ncol12, nrow12, fname12, title12
      save       first, first8, first12
      data       first8, first12 / .true., .true. /
      data       first  / 20*.true. /
      data       index2 / 6, 7, 8, 9,
     +                   12, 13, 14, 15, 16, 17, 18, 19, 20 /
      data       index3 / 2, 3, 4, 5,
     =                   12, 13, 14, 15, 16, 17, 18, 19, 20 /
      if (first8) then
         first8 = .false.
         ncol8 = 2
         nrow8 = 2
         fname8 = 'chisqd.tf4'
      endif
      if (first12) then
         first12 = .false.
         ncol12 = 3
         nrow12 = 10
         fname12 = 'ld50.tf1'
      endif
      repeet = .true.
      do while (repeet)
c
c main decisions
c
         if (mtype.eq.1) then
c
c mtype = 1: present all options
c
            numopt = 20
            write (text,100)
            numdec = numopt - 3
            call lview2 (ix, iy, numdec, numopt,
     +                   text, titles)
         elseif (mtype.eq.2) then
c
c mtype = 2: present only survival options
c
            numopt = 13
            write (text,100)
            text2(1) = text(22)
            do i = 1, 13
               text2(i + 1) = text(index2(i) + 1)
            enddo
            numdec = numopt - 3
            call lview2 (ix, iy, numdec, numopt,
     +                   text2, titles)
            numdec = index2(numdec)
            numopt = 20
         elseif (mtype.eq.3) then
c
c mtype = 3: present only logistic regression options
c
            numopt = 13
            write (text,100)
            text3(1) = text(23)
            do i = 1, 13
               text3(i + 1) = text(index3(i) + 1)
            enddo
            numdec = numopt - 3
            call lview2 (ix, iy, numdec, numopt,
     +                   text3, titles)
            numdec = index3(numdec)
            numopt = 20
         else
c
c mtype out of range
c
            call putfat ('MTYPE out of range in call to GLMSIM')
            isend = 0
            return
         endif
         if (numdec.eq.1) then
c
c advanced GLM analysis has been selected so return with isend = 1
c
            isend = 1
            repeet = .false.
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: advanced GLM'
            write (nout,'(a)')
     +     'Models: Error-types and links selected interactively'
            write (nout,'(a)') blank
         elseif (numdec.eq.2) then
c
c ... logistic regression so set isend = 2
c
            repeet = .false.
            isend = 2
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: logistic regression'
         elseif (numdec.eq.3) then
c
c ... binary logistic regression so set isend = 3
c
            repeet = .false.
            isend = 3
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: binary logistic regression'
         elseif (numdec.eq.4) then
c
c ... Stratified logistic so set isend = 9
c
            repeet =.false.
            isend = 9
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: Logistic (strata)'
         elseif (numdec.eq.5) then
c
c ... polynomial logistic regression so set isend = 4
c
            repeet = .false.
            isend = 4
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)')
     +     'Model: polynomial logistic regression'
         elseif (numdec.eq.6) then
c
c ... exponential regression so set isend = 5
c
            repeet =.false.
            isend = 5
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: exponential survival'
         elseif (numdec.eq.7) then
c
c ... Weibull regression so set isend = 6
c
            repeet =.false.
            isend = 6
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: Weibull survival'
         elseif (numdec.eq.8) then
c
c ... Extreme value regression so set isend = 7
c
            repeet =.false.
            isend = 7
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: Extreme value survival'
         elseif (numdec.eq.9) then
c
c ... Cox regression so set isend = 8
c
            repeet =.false.
            isend = 8
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: Cox proportional hazards'
         elseif (numdec.eq.10) then
c
c ... contingency analysis so do it then set isend = 0
c
            isend = 0
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: Log-lin contingency table'
            jsend = 8
            call m_matone (jsend, ncol8, nin, nout, nrow8,
     +                     fname8, title8)
            repeet = .true.
            isend = 0
         elseif (numdec.eq.11) then
c
c ... bioassay so do it then set isend = 0
c
            write (nout,'(a)') blank
            write (nout,'(a)') 'Method: simplified GLM'
            write (nout,'(a)') 'Model: dose-response percentiles'
            jsend = 12
            call m_matone (jsend, ncol12, nin, nout, nrow12,
     +                     fname12, title12)
            repeet = .true.
            isend = 0
         elseif (numdec.eq.12) then
c
c compare two parameters
c
            call ttest2 (nout)

         elseif (numdec.eq.13) then
c
c compare parameter vectors
c
            call pcvts3 (nout)
         elseif (numdec.eq.14) then
            call putadv ('Not available ... get an upgrade')
         elseif (numdec.eq.numopt - 5) then
c
c advanced GLM help has been selected
c
            isend = 1
            call glmadv (isend)
         elseif (numdec.eq.numopt - 4) then
c
c simplified GLM help has been selected
c
            isend = 2
            call glmadv (isend)
         elseif (numdec.eq.numopt - 3) then
c
c help about file formats has been selected
c
            isend = 3
            call glmadv (isend)
         elseif (numdec.eq.numopt - 2) then
c
c view file formats has been selected
c
            isend = 4
            call glmadv (isend)
         elseif (numdec.eq.numopt - 1) then
            call revpro (nout)
         elseif (numdec.eq.numopt) then
c
c ... cancel
c
            repeet = .false.
            isend = 0
         endif
      enddo
      if (isend.gt.1 .and. isend.le.9 .and. first(isend)) then
         kval_11 = nklcfg(n23)
         if (kval_11.eq.1) then
            if (isend.eq.2) then
               write (text,200)
               numtxt = 19
               call putmes (numtxt, text)
            elseif (isend.eq.3) then
               write (text,300)
               numtxt = 19
               call putmes (numtxt, text)
            elseif (isend.eq.4) then
               write (text,400)
               numtxt = 19
               call putmes (numtxt, text)
            elseif (isend.ge.5 .and. isend.le.8) then
               write (text,500)
               numtxt = 21
               call putmes (numtxt, text)
            elseif (isend.eq.9) then
               write (text,600)
               numtxt = 19
               call putmes (numtxt, text)
            endif
            first(isend) = .false.
         endif
      endif
  100 format (
     + 'Generalized Linear Model Options`Data Format'
     +/'Comprehensive GLM options       `x_1,...,x_m,y,(N/t),s'
     +/'Logistic regression             `x_1,...,x_m,y>=0,N>=y,s=1'
     +/'Binary logistic regression (1)  `x_1,...,x_m,y=0/1,N=1,s=1'
     +/'Binary logistic regression (2)  `x_1,...,x_m,y=0/1,N=1,s=strata'
     +/'Polynomial logistic regression  `x,y>=0,N>=y,s=1'
     +/'Exponential survival            `x_1,...,x_m,y=0/1,t>0,s=1'
     +/'Weibull survival                `x_1,...,x_m,y=0/1,t>0,s=1'
     +/'Extreme value survival          `x_1,...,x_m,y=0/1,t>0,s=1'
     +/'Cox proportional hazard survival`x_1,...,x_m,y=0/1,t>0,s=strata'
     +/'Contingency table analysis      `n by m matrix of frequencies'
     +/'Bioassay (percentiles/EC50/LD50)`x,y>=0,N>=y,s=1'
     +/'Compare 2 parameters            `p,se(p),npts,npar'
     +/'Compare 2 sets of parameters    `c_recent.cfg files'
     +/'Install a GLM macro (NA)        `...'
     +/'Help: Overview of GLM options   `...'
     +/'Help: The simple GLM interface  `...'
     +/'Help: Data formats and macros   `...'
     +/'Help: View GLM test files       `...'
     +/'Results                         `...'
     +/'Exit GLM options                `...'
     +/'Survival Analysis (GLM Options) `Data Format'
     +/'Logistic Regression GLM Options `Data Format')
  200 format (
     + 'First time message: format for logistic regression data'
     +/
     +/'The data file must have m + 3 columns in this order'
     +/
     +/'x_1, x_2, x_3,..., x_m, y, N, s'
     +/
     +/'where x_1, x_2, ..., to x_m are the values of the m covariates,'
     +/'and y are the number of successes in N binomial trials, so that'
     +/'0 =< y(i) =< N(i), and all s-values must be set as s(i) = 1.'
     +/'If some of the x_j values are dummy indicator variables for a'
     +/'factor with k levels, you can either supply (k-1) independent'
     +/'indicator values, leaving one out as reference, or supply a'
     +/'full set of k dependent covariates, and suppress the column you'
     +/'select to be the reference covariate. Otherwise aliasing will'
     +/'occur if a constant is fitted, and the parameters will not be'
     +/'uniquely determined. Mixed effects can be modelled by setting'
     +/'up the appropriate product columns.'
     +/
     +/'Study the test file logistic.tf1 (Note: this has all N = 1).')
  300 format (
     + 'First time message: format for binary logistic regression data'
     +/
     +/'The data file must have m + 3 columns in this order'
     +/
     +/'x_1, x_2, x_3,..., x_m, y, N, s'
     +/
     +/'where x_1, x_2, ..., to x_m are the values of the m covariates,'
     +/'y(i) = 1 (success) or 0 (failure) in a trial of size 1, so that'
     +/'all the N values equal 1, and all the s-values equal 1.'
     +/'If some of the x_j values are dummy indicator variables for a'
     +/'factor with k levels, you can either supply (k-1) independent'
     +/'indicator values, leaving one out as reference, or supply a'
     +/'full set of k dependent covariates, and suppress the column you'
     +/'select to be the reference covariate. Otherwise aliasing will'
     +/'occur if a constant is fitted, and the parameters will not be'
     +/'uniquely determined. Mixed effects can be modelled by setting'
     +/'up the appropriate product columns.'
     +/
     +/'Study the test file logistic.tf1.')
  400 format (
     + 'First time message: format for polynomial logistic regression'
     +/
     +/'The data file must have either 3 columns in the order:'
     +/'y, N, x (like ld50.tf1, i.e. analysis of proportions format)'
     +/'or else it must have 4 columns in the order:'
     +/'x, y, N, s (like ld50.tf2, i.e. GLM format)'
     +/'where x are the values of the covariate, y are the number of'
     +/'successes in N binomial trials, so that 0 =< y(i) =< N(i) and'
     +/'all the s-values must be set as s(i) = 1.'
     +/'The program will generate a file with powers of x, that is:'
     +/'x_1 = x, x_2 = x^2, x_3 = x^3, ..., x_6 = x^6, i.e. to fit a'
     +/'polynomial of degree six. However, you should start by just'
     +/'including the linear term (i.e. suppressing x_2 to x_6) and'
     +/'only include successive power terms if deviances, residuals,'
     +/'and plots of y(x) justify a higher degree polynomial. It is'
     +/'very unlikely that degree > 3 will be justified, and you should'
     +/'be parsimonious and avoid such over-fitting.'
     +/
     +/'Study the test files ld50.tf1 and ld50.tf2.')
  500 format (
     + 'First time message: format for survival analysis data'
     +/
     +/'The data file must have m + 3 columns in this order'
     +/
     +/'x_1, x_2, x_3,..., x_m, y, t, s'
     +/
     +/'where x_1, x_2, ..., to x_m are the values of the m covariates,'
     +/'y(i) = 1 (censored) or 0 (failed) for item(i) at time t(i) > 0,'
     +/'and s-values equal 1. With the Cox proportional hazards model'
     +/'s can indicate strata but, if there are k strata, then s must'
     +/'obey 1 =< s =< k and all values of s = 1, 2, ..., k must occur.'
     +/'If some of the x_j values are dummy indicator variables for a'
     +/'factor with k levels, you can either supply (k-1) independent'
     +/'indicator values, leaving one out as reference, or supply a'
     +/'full set of k dependent covariates, and suppress the column you'
     +/'select to be the reference covariate. Otherwise aliasing will'
     +/'occur if a constant is fitted, and the parameters will not be'
     +/'uniquely determined. Mixed effects can be modelled by setting'
     +/'up the appropriate product columns.'
     +/
     +/'Study the test files cox.tf1, cox.tf2, etc.')
  600 format (
     + 'First time message: conditional logistic regression data'
     +/
     +/'The data file must have m + 3 columns in this order'
     +/
     +/'x_1, x_2, x_3,..., x_m, y, N, s'
     +/
     +/'where x_1, x_2, ..., to x_m are the values of the m covariates,'
     +/'y(i) = 1 (control) or 0 (case) in a trial of size 1, so that'
     +/'all the N values equal 1, and s-values are strata = 1,2,3, etc.'
     +/'If some of the x_j values are dummy indicator variables for a'
     +/'factor with k levels, you can either supply (k-1) independent'
     +/'indicator values, leaving one out as reference, or supply a'
     +/'full set of k dependent covariates, and suppress the column you'
     +/'select to be the reference covariate. Otherwise aliasing will'
     +/'occur as a constant is fitted, and the parameters will not be'
     +/'uniquely determined. Mixed effects can be modelled by setting'
     +/'up the appropriate product columns.'
     +/
     +/'Study the test file strata.tf1')
      end
c
c
