C
C
      SUBROUTINE GLMSTR (IC, IPRINT, ISI, ISX, LWK, M, MAXIT, NCA, N,
     +                   NCT, NF, NRMAX, NSMAX,
     +                   A, B, COV, SE, TOL, WK, WT,
     +                   FNAME, TITLE)
C
C
C ACTION : Conditional logistic stratified regression
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          28/07/2002 developed from GLMCOX using the method described in
C                     NAG routine G11CAF
C          16/10/2002 minor editing
C          19/04/2006 added LWK to arguments
C          14/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          IC = 0 (case = failed) or 1 (control = censored)
C          IPRINT = iterations before printing intermediate output
C          ISI = stratum indicator 1,2,3,... or 0 to omit
C          ISX = variables out (0) or in (1)  
C          LWK = workspace dimemsion
C          M = no. variables (= no. rows - 3)
C          MAXIT = max. no. iterations
C          NCA = cases in strata
C          N = no. rows
C          NCT = controls in strata
C          NF = output unit
C          NRMAX = max. no. data
C          NSMAX = max. no. strata
C          A = original data matrix, i.e. x1,...,xm,y=0/1,N=1,s=stratum
C          B = parameters
C          COV = CV matrix
C          SE = std. errors
C          TOL = convergence factor
C          WK = workspace
C          WT = SC in NAG calls
C
      IMPLICIT   NONE
      INTEGER    LWK, M, N, NRMAX, NSMAX
      INTEGER    IC(N), IPRINT, ISI(N),
     +           ISX(M), MAXIT, NCA(NSMAX), NCT(NSMAX), NF
      INTEGER    I, IDF, IFAIL, IP, J, K, L, NS, NTEMP
      INTEGER    COLOUR
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N15 = 15)
      INTEGER    ISEND, ITYPE, NCOLS, NSTRAT
      PARAMETER (ISEND = 2, ITYPE = 1, NCOLS = 1, NSTRAT = 100)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 8,
     +           NSTART = 12)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      DOUBLE PRECISION A(NRMAX,M + 3), B(M), COV(M*(M + 1)/2),
     +                 SE(M), TOL, WK(LWK), WT(NRMAX)
      DOUBLE PRECISION DEV, WTOL
      DOUBLE PRECISION DF, PVAL, TEMP, TNU, TVAL
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT05, PNT1, PNT2
      PARAMETER (PNT025 = 0.025D+00, PNT05 = 0.05D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION G01EBF$, X02AMF$, G01FBF$
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER  FNAME*(*), TITLE*(*)
      CHARACTER  CHOP80*80, TEXT(30)*100, LINE*100, TRIM80*80
      CHARACTER  DETAIL*100, HEADER(3)*100
      CHARACTER  CIPHER*4, WORD6*6
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, READY
      LOGICAL    STRATA(NSTRAT)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AGAIN1, FITNOW, IWARNU
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   PUTIFA, LBOX01, PUTFAT, TABLE1, PUTADV, EDITOR,
     +           REVPRO, TRIM80, CHOP80, PATCH1, TRIML1,
     +           ISXTYP, ISXEDI
      EXTERNAL   G11CAF$, G01FBF$, G01EBF$, X02AMF$
      INTRINSIC  ABS, DBLE, NINT, TRIM
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Part 1: Initialise
C ==================
C
      READY = .FALSE.
C
C Part 2: Check input data
C ========================
C
      IF (M.LT.1) THEN
         CALL PUTFAT ('No. covariates are defined')
         RETURN
      ENDIF
      IF (M.GT.N) THEN
         CALL PUTFAT ('Insufficient data')
         RETURN
      ENDIF
      NS = N0
      J = M + N1
      K = M + N2
      L = M + N3
      ABORT = .FALSE.
      DO I = N1, N
         IF (.NOT.ABORT) THEN
            NTEMP = NINT(A(I,J))
            IF (NTEMP.LT.N0 .OR. NTEMP.GT.N1) THEN
               WRITE (WORD6,'(I6)') I
               CALL TRIML1 (WORD6)
               LINE = 'y(i) must be either 0 or 1 at i = '//WORD6
               ABORT = .TRUE.
            ELSE
               IC(I) = NTEMP
            ENDIF
         ENDIF
         IF (.NOT.ABORT) THEN
            NTEMP = NINT(A(I,K))
            IF (NTEMP.NE.N1) THEN
               WRITE (WORD6,'(I6)') I
               CALL TRIML1 (WORD6)
               LINE = 'N(i) must be 1 at i = '//WORD6
               ABORT = .TRUE.
            ENDIF
         ENDIF
         IF (.NOT.ABORT) THEN
            NTEMP = NINT(A(I,L))
            IF (NTEMP.LT.N0) THEN
               ISI(I) = N0
            ELSE
               ISI(I) = NTEMP
            ENDIF
            IF (ISI(I).GT.NS) NS = ISI(I)
         ENDIF
         IF (ABORT) THEN
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
      ENDDO
      IF (NS.GT.NSMAX) THEN
         CALL PUTFAT ('No. strata > max. allowed')
         RETURN
      ELSEIF (NS.LT.N1) THEN
         CALL PUTFAT ('No. strata < 1, data format is incorrect')
         RETURN
      ELSEIF (NS.EQ.N1) THEN
         CALL PUTFAT ('No strata, use binomial logistic regression (1)')
         RETURN
      ENDIF
      IF (NS.LE.NSTRAT) THEN
         DO I = N1, NS
            STRATA(I) = .FALSE.
         ENDDO
         DO I = N1, N
            STRATA(ISI(I)) = .TRUE.
         ENDDO
         DO I = N1, NS
            IF (.NOT.STRATA(I)) THEN
               WRITE (WORD6,'(I6)') STRATA(I)
               CALL TRIML1 (WORD6)
               LINE = 'Empty stratum number '//WORD6
               CALL PUTFAT (LINE)
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C Part 3: Initialise elements of ISX ... M = total number of variables
C ====================================================================
C
      E_NUMBERS = E_FORMATS()
      DO I = N1, M
         ISX(I) = N1
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO
C
C ======================================================================
C Part 4: Main branch point for repeated analysis
C ======================================================================
C
      AGAIN1 = .TRUE.
      FITNOW = .FALSE.
      DO WHILE (AGAIN1)
C
C First of all define IP then initialise the menu
C         
         CALL ISXTYP (ISX, M, IP, N1, 
     +                DETAIL,
     +                IWARNU)     
         WRITE (TEXT,100) DETAIL, TRIM80(FNAME), CHOP80(TITLE), M,
     +                    M - IP, IP
         HEADER(1) = TEXT(1)
         HEADER(2) = TEXT(3)
         HEADER(3) = TEXT(4)
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(6) = N1
         NUMBLD(8) = N1
         FITNOW = .FALSE.
         NUMDEC = N6
         NTEXT = NSTART + NUMOPT - N1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(6) = N0
         NUMBLD(8) = N0
         IF (NUMDEC.EQ.N1) THEN
C
C Proceed to fitting with B(i) = 0
C
            READY = .FALSE.
            FITNOW = .TRUE.
            DO I = N1, IP
               B(I) = ZERO
            ENDDO
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Proceed to fitting with user defined B(i)
C
            READY = .FALSE.
            FITNOW = .TRUE.
            LINE = 'Starting estimates for logistic regression'
            CALL EDITOR (ISEND, ITYPE, NCOLS, NRMAX, IP,
     +                   B,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Suppress/Restore variables
C           
            CALL ISXEDI (ISX, M, IP, N1) 
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Display strata with LINE = table header (3 x 10)
C
             IF (READY) THEN
                LINE = '    Strata     Cases  Controls'
                COLOUR = N15
                CALL TABLE1 (COLOUR, 'OPEN')
                COLOUR = N4
                CALL TABLE1 (COLOUR, LINE)
                COLOUR = N0
                DO I = N1, NS
                   WRITE (LINE,'(3I10)') I, NCA(I), NCT(I)
                   CALL TABLE1 (COLOUR, LINE)
                ENDDO
                CALL TABLE1 (COLOUR, 'CLOSE')
             ELSE
                CALL PUTFAT ('Not ready  ...  First fit the data')
             ENDIF
             AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
             IF (READY) THEN
C
C File strata with LINE = table header (3 X 10)
C
                WRITE (NF,'(A)') BLANK
                LINE = '    Strata     Cases  Controls'
                WRITE (NF,'(A)') LINE
                DO I = N1, NS
                   WRITE (LINE,'(3I10)') I, NCA(I), NCT(I)
                   WRITE (NF,'(A)') LINE
                ENDDO
                CALL PUTADV ('Strata now written to results file')
            ELSE
               CALL PUTFAT ('Not ready  ...  First fit the data')
            ENDIF
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
            WRITE (TEXT,200)
            NTEXT = 20
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N7) THEN
            CALL REVPRO (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Terminate current data analysis
C
           AGAIN1 = .FALSE.
           FITNOW = .FALSE.
         ENDIF
C
C Part 5: Fitting
C ===============
C
         IF (FITNOW) THEN
            IP = 0
            DO I = 1, M
               IF (ISX(I).GT.0) IP = IP + 1
            ENDDO
            IFAIL = 0
            CALL G11CAF$(N, M, NS, A, NRMAX, ISX, IP, IC, ISI,
     +                   DEV, B, SE, WT, COV, NCA, NCT, TOL, MAXIT,
     +                   IPRINT, WK, LWK, IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G11CAF/GLMSTR')
            IF (IFAIL.EQ.0) THEN
               READY = .TRUE.
            ELSE
               READY = .FALSE.
               IF (IFAIL.EQ.1 .OR. IFAIL.EQ.2) THEN
                  CALL PUTFAT ('Inconsistent dimensions')
               ELSEIF (IFAIL.EQ.3) THEN
                  CALL PUTFAT ('Data set too large')
               ELSE
                  CALL PUTFAT (
     +'Try more-iterations/larger-TOL/new-starting-estimates')
               ENDIF
            ENDIF
            IF (READY) THEN
C
C Output the best-fit parameters
C
               WRITE (NF,'(A)') BLANK  
               IF (IWARNU) THEN
                  DO I = N1, N3
                     WRITE (NF,'(A)') HEADER(I)
                  ENDDO
               ELSE
                  WRITE (NF,'(A)') HEADER(1)
               ENDIF 
               WRITE (NF,'(A)') BLANK     
               COLOUR = N15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
               IDF = N - IP
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) IP, N, IDF
                  WRITE (NF,300) IP, N, IDF
               ELSE
                  I12(1) = FORM12(IP)
                  I12(2) = FORM12(N)
                  I12(3) = FORM12(IDF)
                  WRITE (LINE,350) TRIM(I12(1)), TRIM(I12(2)), 
     +                             TRIM(I12(3))
                  WRITE (NF,350) TRIM(I12(1)), TRIM(I12(2)), 
     +                           TRIM(I12(3))
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,400)
               WRITE (NF,400)
               COLOUR = N4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = N0
C
C Calculate t values and parameter p-values
C
               IFAIL = N1
               TNU = G01FBF$(TAIL, PNT025, DBLE(IDF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01FBF/GLMCOX')
               WTOL = 1.0D+9*X02AMF$()
               DF = DBLE(IDF)
               J = N0
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     IF (SE(J).GT.WTOL) THEN
                        TVAL = ABS(B(J)/SE(J))
                        IFAIL = N1
                        PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMCOX')
                     ELSE
                        PVAL = ONE
                     ENDIF
                     IF (PVAL.GT.PNT2) THEN
                        CIPHER = ' ***'
                     ELSEIF (PVAL.GT.PNT1) THEN
                        CIPHER = '  **'
                     ELSEIF (PVAL.GT.PNT05) THEN
                        CIPHER = '   *'
                     ELSE
                        CIPHER = '    '
                     ENDIF
                     IF (PVAL.LT.ZERO) PVAL = ZERO
                     IF (PVAL.GT.ONE) PVAL = ONE
                     IF (E_NUMBERS) THEN  
                        WRITE (LINE,600) I, B(J), B(J) - TNU*SE(J),
     +                                   B(J) + TNU*SE(J), SE(J), PVAL,
     +                                   CIPHER
                        WRITE (NF,600) I, B(J), B(J) - TNU*SE(J),
     +                                 B(J) + TNU*SE(J),
     +                                 SE(J), PVAL, CIPHER
                     ELSE
                        D13(1) = SHOWRJ(B(J))
                        TEMP = B(J) - TNU*SE(J)
                        D13(2) = SHOWRJ(TEMP)
                        TEMP = B(J) + TNU*SE(J)
                        D13(3) = SHOWRJ(TEMP)
                        D13(4) = SHOWRJ(SE(J))
                        WRITE (LINE,650) I, D13(1), D13(2), D13(3),
     +                                   D13(4), PVAL, CIPHER
                        WRITE (NF,650) I, D13(1), D13(2), D13(3),
     +                                 D13(4), PVAL, CIPHER
                     ENDIF  
                     CALL TABLE1 (COLOUR, LINE)
                  ENDIF
               ENDDO
               IF (E_NUMBERS) THEN
                  WRITE (NF,700) DEV
                  WRITE  (LINE,700) DEV
               ELSE
                  D13(1) = SHOWLJ(DEV)
                  WRITE (NF,750) D13(1)
                  WRITE  (LINE,750) D13(1)
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               CALL TABLE1 (COLOUR, 'CLOSE')
               NUMDEC = N1
            ENDIF
         ENDIF
      ENDDO
c
c format stements
c      
  100 FORMAT (
     + 'Stratified logistic regression'
     +/
     +/'Variables (* = suppressed):'
     +/A
     +/'Data:'
     +/A
     +/'Title:'
     +/A
     +/'Total number of x-variables supplied =',I4
     +/'Number of x-variables to be excluded =',I4
     +/'Number of parameters to be estimated =',I4
     +/'Fit: with starting estimates = 0'
     +/'Fit: with starting estimates input'
     +/'Suppress/Restore variables'
     +/'Strata: display table'
     +/'Strata: write to file'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these logistic regression options')
  200 FORMAT (
     + 'Conditional logistic analysis of stratified data'
     +/
     +/'The data format is as for binary logistic regression (y = 0 for'
     +/'a case, y = 1 for a control, and N = 1) but s must be used as a'
     +/'stratum indicator. If there is only one stratum, all s must be'
     +/'set to 1 and normal binary logistic regression used. With two'
     +/'strata but no covariates, the s values must all be set to 1'
     +/'and the strata treated as dummy indicator variables, as in the'
     +/'test file logistic.tf1. If there are m covariates, i.e. m'
     +/'explanatory variables, these must be in columns 1 to m and s-'
     +/'values in column m + 3 used for strata, as in strata.tf1.'
     +/'There is no formal regression constant with the regression as'
     +/'this is subsumed in the baseline functions, but offsets are'
     +/'actually assumed for each stratum if the s-values are used to'
     +/'define strata.'
     +/'After fitting, the parameters, standard errors and strata can'
     +/'be output as a table.'
     +/'Note that fitting is iterative and, if it does not succeed with'
     +/'default settings, you can decrease the number of covariates,'
     +/'alter the TOL or MAXIT values, or input starting estimates.')
  300 FORMAT (' Number of parameters =',I3,
     +', Number of points =',I6,', Degrees of freedom =',I6)
  350 FORMAT (' Number of parameters = ',A,
     +', Number of points = ',A,', Degrees of freedom = ',A)   
  400 FORMAT (' Parameter         Value    Lower95%cl    Upper95%cl',
     +'     Std.error     p')
  600 FORMAT ('    B(',I3,')',1P,4(1X,E13.5),0P,F9.4,A)   
  650 FORMAT ('    B(',I3,')',4(1X,A13),F9.4,A)     
  700 FORMAT (' Deviance =',1P,E13.5)
  750 FORMAT (' Deviance =',1X,A)
      END
C
C
