C
C
      SUBROUTINE GLMWEI (IPRINT, ISX, JSEND, MAXIT, NCMAX,
     +                   NCOLS, NF, NRMAX, NROWS,
     +                   AFIX, A1, A2, B, COV, EPS, SE, T,
     +                   TOL, V, WK, WT, Y,
     +                   FNAME1, TITLE1)
C
C
C ACTION : Weibull survival by GLIM fitting
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          22/07/2002 developed from GLMFIT using the method described by
C                     Aitken M, Clayton D in Appl. Statist. (1980) 29 no. 2
c                     pp. 156-163
C          08/10/2002 corrected error updating covariance matrix
C          21/11/2002 added HNPLOT
C          14/04/2006 suppressed code for reading V(IP + 1,8) for NPLOT and
C                     introduced ISXEDI and ISXTYP
C          14/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          IPRINT = iterations before printing intermediate output
C          ISX = variables out (0) or in (1)
C          JSEND = fitting type
C          MAXIT = max. no. iterations
C          A1 = original data matrix ... this is never altered
C          A2 = the current active copy of DATA in A1 which is required
C          B = parameters
C          COV = CV matrix
C          EPS = rank factor for SVD
C          RES = deviance residuals
C          SE = std. errors
C          JSEND = 6: T = log(time) returned from GLMDAT
C          JSEND = 7: T = time returned from GLMDAT
C          TOL = convergence factor
C          V = workspace
C          WK = workspace
C          WT = weights (active) calculated on demand
C          Y = original (active) Y-values
C          Each time the data set is altered a new active set is calculated
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NRMAX
      INTEGER    IPRINT, ISX(NCMAX), JSEND, MAXIT, NCOLS, NF, NROWS
      DOUBLE PRECISION AFIX, A1(NRMAX,NCMAX), A2(NRMAX,NCMAX),
     +                 B(NCMAX), COV(NCMAX*(NCMAX + 1)/2), EPS,
     +                 SE(NCMAX), T(NRMAX), TOL,
     +                 V(NRMAX,NCMAX + 8),
     +                 WK((NCMAX*NCMAX + 3*NCMAX + 22)/2), WT(NRMAX),
     +                 Y(NRMAX)
      CHARACTER  FNAME1*(*), TITLE1*(*)
C
C Locals
C
      INTEGER    I, IDF, IFAIL, IP, IRANK, ITEST, J, K, M, N, NCOL1,
     +           NVAR
      INTEGER    ICOUNT, MAXIT2, NEQ1
      INTEGER    COLOUR, NPMAX, NPTS
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N10, N15, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N10 = 10, N15 = 15, N100 = 100)
      INTEGER    NGRAF, NMAX, LPLOT, MPLOT, NPLOT
      PARAMETER (NGRAF = 1000, NMAX = 100)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 16, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION XGRAF1(NGRAF), XGRAF2(NGRAF), XGRAF3(N2),
     +                 XGRAF4(2)
      DOUBLE PRECISION YGRAF1(NGRAF), YGRAF2(NGRAF), YGRAF3(N2),
     +                 YGRAF4(2)
      DOUBLE PRECISION A, ASYMP, DEV, EPS1, TOL1, WTOL
      DOUBLE PRECISION DF, PVAL, TEMP, TNU, TVAL, VALUE
C     DOUBLE PRECISION XDELTA, XMIN
      DOUBLE PRECISION ALFDIF, ALF0, ALF0P, ALF1, DEV1, DEVDIF, DNEQ1
      DOUBLE PRECISION AINV(NMAX,NMAX), BVEC(NMAX), C, DENOM, DUMMY,
     +                 VTEMP(NMAX,NMAX), V00(NMAX + 1, NMAX + 1),
     +                 V11(NMAX,NMAX), V12(NMAX), V22
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT05, PNT1, PNT2
      PARAMETER (PNT025 = 0.025D+00, PNT05 = 0.05D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION FRACN, YMAX, YMIN
      PARAMETER (FRACN = 0.01D+00, YMAX = 1.01D+00, YMIN = 0.99D+00)
      DOUBLE PRECISION X02AJF$, G01EBF$, X02AMF$, G01FBF$
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER  CHOP80*80, TEXT(NTEXT)*100, LINE*100, TRIM80*80
      CHARACTER  DETAIL*100, HEADER(3)*100
      CHARACTER  CIPHER*4, LABELM*5, LABELW*5, METHOD*30
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      CHARACTER  LINK*1, MEAN*1, OFFSET*1, WEIGHT*1
      CHARACTER  PTITLE*17, XTITLE*3, YTITLE*3
      CHARACTER  PNAME*20, XNAME*9, YNAME*9
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    IWARNU, READY
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AGAIN1, AGAIN2, FITNOW
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   PUTIFA, LBOX01, PUTFAT, TABLE1, PUTADV, PUTWAR, LBOX02,
     +           GETIM1, GKST04, REVPRO, GKS004, TRIM80, CHOP80, PUTMES,
     +           HNPLOT, ISXEDI, ISXTYP
      EXTERNAL   X02AJF$, G01EBF$, X02AMF$, G01FBF$
      EXTERNAL   G02GCF$
      INTRINSIC  ABS, DBLE, SQRT, MIN, LOG
      SAVE       MEAN
      DATA       MEAN / 'M' /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Part 1: Initialise
C ==================
C
      IF (JSEND.EQ.N6 .OR. JSEND.EQ.N7) THEN
         MAXIT2 = N2*MAXIT
         IF (MAXIT2.LT.N10) THEN
            MAXIT2 = N10
         ELSEIF (MAXIT2.GT.N100) THEN
            MAXIT2 = N100
         ENDIF
         OFFSET = 'Y'
         LINK = 'L'
         WEIGHT = 'U'
         LABELW = ' (No)'  
         IF (JSEND.EQ.N6) THEN
            METHOD = '(Weibull)'
         ELSE
            METHOD = '(Extreme value)'
         ENDIF      
      ELSE
         CALL PUTFAT ('JSEND not 6 OR 7 in call to GLMWEI')
         RETURN
      ENDIF 
      READY = .FALSE.
C
C Part 2: Check input data
C ========================
C
      IF (NCOLS.GT.NCMAX) THEN
         CALL PUTFAT ('Column dimension exceeded in call to GLMWEI')
         RETURN
      ENDIF
      NCOL1 = N3
      NPMAX = NCMAX - N2
      IF (NCOLS.LT.NCOL1) THEN
         CALL PUTFAT ('Insufficient no. of data columns for analysis')
         RETURN
      ENDIF
      IF (NROWS.GT.NRMAX) THEN
         CALL PUTFAT ('Row dimension exceeded in call to GLMWEI')
         RETURN
      ENDIF
      IF (NROWS.LE.NCOLS - N2) THEN
         CALL PUTFAT ('Must have more y-values than variables')
         RETURN
      ENDIF
C
C Initialise elements of ISX ... M = total number of variables
C
      M = NCOLS - N2
      IF (M.EQ.NPMAX) THEN
         CALL PUTFAT ('Too many variables to include a constant term')
         MEAN = 'Z'
      ENDIF
      DO I = N1, NCMAX
         ISX(I) = N1
      ENDDO
C
C Part 3: Define N and assign data to array A2 then calculate the weights
C =======================================================================
C
      E_NUMBERS = E_FORMATS()
      N = N0
      NEQ1 = N0
      WTOL = 1.0D-20
      DO I = N1, NROWS
         VALUE = A1(I,NCOLS)
         IF (VALUE.GT.WTOL) THEN
            N = N + N1
            WT(N) = ONE
            K = N0
            DO J = N1, M
               K = K + N1
               A2(N,K) = A1(I,K)
            ENDDO
            K = K + N1
            Y(N) = A1(I,K)
            IF (Y(N).GT.YMIN .AND. Y(N).LT.YMAX) NEQ1 = NEQ1 + N1
         ENDIF
      ENDDO
      IF (NEQ1.GT.N0) THEN
         DNEQ1 = DBLE(NEQ1)
      ELSE
         CALL PUTFAT ('No uncensored observations to analyse')
         RETURN
      ENDIF
C
C ======================================================================
C Part 4: Main branch point for repeated analysis
C ======================================================================
C
      AGAIN1 = .TRUE.
      AGAIN2 = .TRUE.
      FITNOW = .FALSE.
      DO WHILE (AGAIN1)
C
C First of all define IP, NVAR and LABELM then initialise the menu
C
         NUMDEC = N1
         IP = N0
         IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
            IP = IP + N1
            LABELM = '[Yes]'
         ELSE
            LABELM = ' [No]'
         ENDIF
         CALL ISXTYP (ISX, M, NVAR, N1,
     +                DETAIL,
     +                IWARNU)
         DO I = N1, M
            IF (ISX(I).GT.N0) IP = IP + N1
         ENDDO
         WRITE (TEXT,100) METHOD, DETAIL, TRIM80(FNAME1),
     +                    CHOP80(TITLE1), LABELW, LABELM, M, NVAR,
     +                    M - NVAR, IP
         HEADER(1) = TEXT(1)
         HEADER(2) = TEXT(3)
         HEADER(3) = TEXT(4)
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(6) = N1
         NUMBLD(8) = N1
         FITNOW = .FALSE.
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Proceed to fitting (after NUMDEC = NUMOPT section)
C
            READY = .FALSE.
            FITNOW = .TRUE.
            CONTINUE
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Change status of MEAN
C
            IF (M.EQ.NPMAX) THEN
               MEAN = 'Z'
               CALL PUTFAT (
     +        'Too many variables to include a constant term')
            ELSEIF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               MEAN = 'Z'
               CALL PUTADV (
     +        'Regression will now have eta(0) = 0')
            ELSE
               MEAN = 'M'
               CALL PUTADV (
     +        'Regression will now have eta(0) = constant')
            ENDIF
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Suppress/Restore variables
C
            CALL ISXEDI (ISX, M, NVAR, N1)
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: Plot
C
             IF (READY) THEN
                IF (M.EQ.N1 .OR. JSEND.EQ.N4) THEN
                   J = N1
                ELSE
                   CALL GETIM1 (N1, J, M,
     +            'Number of x-column for plotting')
                ENDIF
                IF (ISX(J).EQ.N0 .AND. JSEND.NE.N4) THEN
                   CALL PUTFAT (
     +            'This is not in the current regression set')
                ELSE
C
C Copy the data into XGRAF1 and YGRAF1
C
                   NPTS = MIN(N, NGRAF)
                   DO I = N1, NPTS
                      XGRAF1(I) = A2(I,J)
                      YGRAF1(I) = Y(I)
                   ENDDO
C
C See if a best-fit curve has been calculated then assign PTITLE
C
C                  NPLOT = NINT(V(IP + N1,N8))
C                  IF (NPLOT.GT.N2) THEN
C
C If so copy the best-fit curve into XGRAF2, YGRAF2
C
C                     NPLOT = MIN(NPLOT, NGRAF)
C                     XMIN = V(IP + N2,N8)
C                     XDELTA = V(IP + N3,N8)
C                     XGRAF2(1) = XMIN
C                     YGRAF2(1) = V(IP + N4,N8)
C                     DO I = N2, NPLOT
C                        XGRAF2(I) = XGRAF2(I - N1) + XDELTA
C                        YGRAF2(I) = V(IP + N3 + I,N8)
C                     ENDDO
C                     LPLOT = N1
C                     MPLOT = N0
C                     PTITLE = 'Data and Best-Fit'
C                  ELSE
C
C Otherwise copy the best fit points into XGRAF2 and YGRAF2
C
                      LPLOT = N0
                      MPLOT = N4
                      NPLOT = NPTS
                      PTITLE = 'Data with * = Fit'
                      DO I = N1, NPLOT
                         XGRAF2(I) = XGRAF1(I)
                         YGRAF2(I) = V(I,N2)
                      ENDDO
C                  ENDIF
C
C Assign YTITLE and ASYMP
C
                   YTITLE = ' y '
                   ASYMP = - ONE
C
C Initialise the dummy arrays
C
                   DO I = N1, N2
                      XGRAF3(I) = ZERO
                      XGRAF4(I) = ZERO
                      YGRAF3(I) = ZERO
                      YGRAF4(I) = ZERO
                   ENDDO
C
C Assign XTITLE
C
                   IF (J.LT.N10) THEN
                      WRITE (XTITLE,'(A2,I1)') ' x', J
                   ELSE
                      WRITE (XTITLE,'(A1,I2)') 'x', J
                   ENDIF
C
C Plot the data
C
                   CALL GKST04 (N0, LPLOT, N0, N0,
     +                          N5, MPLOT, N0, N0,
     +                          NPTS, NPLOT, N2, N2,
     +                          ASYMP,
     +                          XGRAF1, XGRAF2, XGRAF3, XGRAF4,
     +                          YGRAF1, YGRAF2, YGRAF3, YGRAF4,
     +                          PTITLE, XTITLE, YTITLE,
     +                          AXES, AXES)
                ENDIF
             ELSE
                CALL PUTFAT ('Not ready  ...  First fit the data')
             ENDIF
             AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
             IF (READY) THEN
C
C NUMDEC = 5: Output the residuals, etc.
C
               NUMDEC = N4
               AGAIN2 = .TRUE.
               DO WHILE (AGAIN2)
                  WRITE (TEXT,700)
                  CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, N6, NUMPOS,
     +                         TEXT)
                  IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
                     COLOUR = N15
                     CALL TABLE1 (COLOUR, 'OPEN')
                     WRITE (LINE,800)
                     COLOUR = N4
                     CALL TABLE1 (COLOUR, LINE)
                     COLOUR = N0
                     DO I = N1, N
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,900) I, Y(I), V(I,2), V(I,5),
     +                                      V(I,6)
                        ELSE
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6))
                           WRITE (LINE,950) I, D13(1), D13(2), D13(3),
     +                                      D13(4)
                        ENDIF  
                        CALL TABLE1 (COLOUR, LINE)
                     ENDDO
                     CALL TABLE1 (COLOUR, 'CLOSE')
                     NUMDEC = N2
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C
                     WRITE (NF,'(A)') ' '
                     WRITE (NF,800)
                     DO I = N1, N
                        IF (E_NUMBERS) THEN
                           WRITE (NF,900) I, Y(I), V(I,2), V(I,5),
     +                                  V(I,6)
                        ELSE
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6))
                           WRITE (NF,950) I, D13(1), D13(2), D13(3),
     +                                    D13(4)
                        ENDIF  
                     ENDDO
                     NUMDEC = N3
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot the residuals
C
                      NPTS = MIN(N, NGRAF)
                      DO I = N1, NPTS
                         XGRAF1(I) = V(I,2)
                         YGRAF1(I) = V(I,5)
                      ENDDO
                      DO I = N1, N2
                         XGRAF2(I) = ZERO
                         XGRAF3(I) = ZERO
                         XGRAF4(I) = ZERO
                         YGRAF2(I) = ZERO
                         YGRAF3(I) = ZERO
                         YGRAF4(I) = ZERO
                      ENDDO
                      PNAME = 'Deviance Residuals'
                      XNAME = 'Best-Fit'
                      YNAME = 'Residuals'
C
C Plot the residuals
C
                      CALL GKS004 (N0, N0, N0, N0,
     +                             N4, N0, N0, N0,
     +                             NPTS, N2, N2, N2,
     +                             XGRAF1, XGRAF2, XGRAF3, XGRAF4,
     +                             YGRAF1, YGRAF2, YGRAF3, YGRAF4,
     +                             PNAME, XNAME, YNAME,
     +                             AXES, AXES)
                     NUMDEC = N4
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N4) THEN
C
C Half normal plot
C
                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        YGRAF1(I) = V(I,5)
                     ENDDO
                     IFAIL = N1
                     CALL HNPLOT (IFAIL, NPTS, YGRAF1)
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N5) THEN
C
C Full normal plot
C
                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        YGRAF1(I) = V(I,5)
                     ENDDO
                     IFAIL = N2
                     CALL HNPLOT (IFAIL, NPTS, YGRAF1)
                     AGAIN2 = .TRUE.
                  ELSE
                     AGAIN2 = .FALSE.
                  ENDIF
                  NUMDEC = N6
               ENDDO
            ELSE
               CALL PUTFAT ('Not ready  ...  First fit the data')
            ENDIF
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
            CALL REVPRO (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Terminate current data analysis
C
           AGAIN1 = .FALSE.
           AGAIN2 = .FALSE.
           FITNOW = .FALSE.
         ENDIF
C
C Part 5: Fitting
C ===============
C
         IF (FITNOW) THEN
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            LINE = 'Iterate  IFAIL         alpha      deviance'
            COLOUR = N4
            CALL TABLE1 (COLOUR, LINE)
            WRITE (NF,'(A)') BLANK 
            WRITE (NF,'(A)') LINE
            COLOUR = N0
            IFAIL = N0
            A = AFIX
            EPS1 = EPS
            TOL1 = TOL
            ICOUNT = N0
            ALFDIF = ONE
            ALF0 = ONE
            ALF0P = ONE
            DEVDIF = ONE
            DEV1 = ZERO
            WTOL = 1.0D+09*X02AJF$()
C
C Note that T = log(T) from GLMDAT if JSEND = 6
C       but T = T from GLMDAT if JSEND = 7
C

            DO WHILE (ICOUNT.LT.MAXIT2 .AND. ALFDIF.GT.FRACN .AND.
     +                DEVDIF.GT.FRACN .AND. IFAIL.EQ.N0)
               ICOUNT = ICOUNT + N1
               ALF1 = (ALF0 + ALF0P)/TWO
               DO I = N1, N
                  V(I,N7) = ALF1*T(I)
               ENDDO
               ALF0 = ALF1
               CALL G02GCF$(LINK, MEAN, OFFSET, WEIGHT, N, A2, NRMAX, M,
     +                      ISX, IP, Y, WT, A, DEV, IDF, B, IRANK, SE,
     +                      COV, V, NRMAX, TOL1, MAXIT, IPRINT, EPS1,
     +                      WK,
     +                      IFAIL)
               ALF1 = ZERO
               DO I = N1, N
                  ALF1 = ALF1 + (V(I,N2) - Y(I))*T(I)
               ENDDO
               IF (ABS(ALF1).GT.WTOL) ALF0P = DNEQ1/ALF1
C
C Always do the initialisation for exponential case alpha = 1 and then two
C iterations to estimate alpha before checking for convergence or IFAIL exit
C
               IF (ICOUNT.GT.N3) THEN
                  IF (ABS(ALF0).GT.WTOL)
     +                ALFDIF = ABS((ALF0 - ALF0P)/ALF0)
                  IF (ABS(DEV1).GT.WTOL)
     +                DEVDIF = ABS((DEV1 - DEV)/DEV1)
               ELSE
                  IFAIL = N0
               ENDIF
               DEV1 = DEV
               IF (E_NUMBERS) THEN
                  WRITE (LINE,'(2I7,1P,2(1X,E13.5))') ICOUNT, IFAIL,
     +                                                ALF0P,  DEV
               ELSE
                  D13(1) = SHOWRJ(ALF0P)
                  D13(2) = SHOWRJ(DEV) 
                  WRITE (LINE,'(2I7,2(1X,A13))') ICOUNT, IFAIL, D13(1),
     +                                           D13(2)
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NF,'(A)') LINE
            ENDDO
C
C Adjust the deviance according to McCullagh and Nelder p 186
C
            IF (ALF0P.GT.WTOL) THEN
               DEV1 = DEV - TWO*DBLE(NEQ1)*LOG(ALF0P)
            ELSE
               DEV1 = DEV
            ENDIF
            CALL TABLE1 (COLOUR, 'CLOSE')
            CALL PUTIFA (IFAIL, NF, 'G02GCF/GLMFIT')
            ITEST = IFAIL - N1
            IF (IFAIL.EQ.N0) THEN
               READY = .TRUE.
            ELSE
               IF (ITEST.GE.4 .AND. ITEST.LE.8) THEN
                  READY = .TRUE.
                  TEXT(N1) =
     +'Note: the model fitting procedure has not converged properly'
                  TEXT(N2) = BLANK
                  TEXT(N3) =
     +'Parameter estimates and best fit model may be unreliable since'
                  IF (ITEST.EQ.4) THEN
                     TEXT(N4) =
     +'the fitted model has hit a boundary ... re-formulate the model ?'
                  ELSEIF (ITEST.EQ.5) THEN
                     TEXT(N4) =
     +'the SVD has failed to converge ... selected model may not fit.'
                  ELSEIF (ITEST.EQ.6) THEN
                     TEXT(N4) =
     +'max. iterations used without convergence ... increase MAXIT ?'
                  ELSEIF (ITEST.EQ.7) THEN
                     TEXT(N4) =
     +'rank changed during iteration ... examine the fit carefully.'
                  ELSEIF (ITEST.EQ.8) THEN
                     TEXT(N4) =
     +'NDOF = 0 ... a saturated model has been fitted.'
                  ENDIF
                  TEXT(N5) = BLANK
                  TEXT(N6) =
     +'Advice: new model, adjust data or re-configure GLM parameters.'
                  CALL PUTMES (N6, TEXT)
               ELSE
                  READY = .FALSE.
               ENDIF
            ENDIF
C
C Is the problem of full rank ?
C
            SE(IP + N1) = ZERO
            IF (READY) THEN
               WTOL = 1.0D+09*X02AJF$()
               IF (IRANK.LT.IP) THEN
                  CALL PUTWAR (
     +'Less than full rank (SVD used) ... Ignore parameters/std.errors')
                  DO I = N1, IP
                     SE(I) = ZERO
                  ENDDO
               ELSEIF (NCMAX.LE.NMAX .AND. ABS(ALF0P).GT.WTOL) THEN
C
C Enlarge the covariance matrix: Step 1 ... create AINV
C
                  K = N0
                  DO J = N1, IP
                     DO I = N1, J
                        K = K + N1
                        AINV(I,J) = COV(K)
                        IF (I.LT.J) AINV(J,I) = AINV(I,J)
                     ENDDO
                  ENDDO
C
C Enlarge the covariance matrix: Step 2 ... create BVEC
C
                  IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
                     J = N1
                     BVEC(J) = ZERO
                     DO I = N1, N
                        BVEC(J) = BVEC(J) + V(I,N2)*T(I)
                     ENDDO
                     K = N0
                     DO J = N2, IP
                        K = K + N1
                        DO WHILE (ISX(K).EQ.N0)
                           K = K + N1
                        ENDDO
                        BVEC(J) = ZERO
                        DO I = N1, N
                           BVEC(J) = BVEC(J) + V(I,N2)*A2(I,K)*T(I)
                        ENDDO
                     ENDDO
                  ELSE
                     K = N0
                     DO J = N1, IP
                        K = K + N1
                        DO WHILE (ISX(K).EQ.N0)
                           K = K + N1
                        ENDDO
                        BVEC(J) = ZERO
                        DO I = N1, N
                           BVEC(J) = BVEC(J) + V(I,N2)*A2(I,K)*T(I)
                        ENDDO
                     ENDDO
                  ENDIF
C
C Enlarge the covariance matrix: Step 3 ... create C
C
                  C = ZERO
                  DO I = N1, N
                     C = C + V(I,N2)*T(I)**2
                  ENDDO
                  C = C + DNEQ1/(ALF0P*ALF0P)
C
C Enlarge the covariance matrix: Step 4 ... create DENOM
C
                  DO I = N1, IP
                     WK(I) = ZERO
                     DO J = N1, IP
                        WK(I) = AINV(I,J)*BVEC(J)
                     ENDDO
                  ENDDO
                  DUMMY = ZERO
                  DO I = N1, IP
                     DUMMY = DUMMY + BVEC(I)*WK(I)
                  ENDDO
                  DENOM = C - DUMMY
                  IF (ABS(DENOM).GT.WTOL) THEN
C
C Enlarge the covariance matrix: Step 5 ... create V11 then V00 1 to IP
C
                     DO I = N1, IP
                        WK(I) = ZERO
                        DO J = N1, IP
                           WK(I) = WK(I) + BVEC(J)*AINV(J,I)
                        ENDDO
                     ENDDO
                     DO I = N1, IP
                        DO J = N1, IP
                           VTEMP(I,J) = BVEC(I)*WK(J)/DENOM
                        ENDDO
                     ENDDO
                     DO I = N1, IP
                        DO J = N1, IP
                           V11(I,J) = ZERO
                           DO K = N1, IP
                              V11(I,J) = V11(I,J) + AINV(I,K)*VTEMP(K,J)
                           ENDDO
                           V11(I,J) = V11(I,J) + AINV(I,J)
                        ENDDO
                     ENDDO
                     DO J = N1, IP
                        DO I = N1, IP
                           V00(I,J) = V11(I,J)
                        ENDDO
                     ENDDO
C
C Enlarge the covariance matrix: Step 6 ... create V12 and V22
C
                     DO I = N1, IP
                        V12(I) = ZERO
                        DO J = N1, IP
                           V12(I) = V12(I) - AINV(I,J)*BVEC(J)
                        ENDDO
                        V12(I) = V12(I)/DENOM
                     ENDDO
                     V22 = ONE/DENOM
C
C Enlarge the covariance matrix: Step 7 ... create rest of V00
C
                     K = IP + N1
                     V00(K,K) = V22
                     DO I = N1, IP
                        V00(I,K) = V12(I)
                        V00(K,I) = V00(I,K)
                     ENDDO
C
C Create new SE
C
                     DO I = N1, K
                        SE(I) = SQRT(V00(I,I))
                     ENDDO
                  ELSE
                     CALL PUTFAT (
     +              'c - b^TA^{-1}b too small to estimate alpha SE')
                  ENDIF
               ELSEIF (ABS(ALF0P).LE.WTOL) THEN
                  CALL PUTFAT ('ALPHA too small to calculate alpha SE')
               ELSE
                  CALL PUTFAT ('NMAX too small to calculate alpha SE')
               ENDIF
C
C Output the best-fit parameters
C
               WRITE (NF,'(A)') BLANK
               IF (IWARNU) THEN
                  DO I = N1, N3
                     WRITE (NF,'(A)') HEADER(I)
                  ENDDO
               ELSE
                  WRITE (NF,'(A)') HEADER(1)
               ENDIF
               WRITE (NF,'(A)') BLANK
               COLOUR = N15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
               IF (E_NUMBERS) THEN
                  WRITE (LINE,200) IP, IRANK, N, IDF
                  WRITE (NF,200) IP, IRANK, N, IDF
               ELSE
                  I12(1) = FORM12(IP)
                  I12(2) = FORM12(IRANK)
                  I12(3) = FORM12(N)
                  I12(4) = FORM12(IDF) 
                  WRITE (LINE,250) TRIM(I12(1)), TRIM(I12(2)), 
     +                             TRIM(I12(3)), I12(4)
                  WRITE (NF,250) TRIM(I12(1)), TRIM(I12(2)), 
     +                           TRIM(I12(3)), I12(4)
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,400)
               WRITE (NF,400)
               COLOUR = N4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = N0
C
C Calculate t values and parameter p-values
C
               IFAIL = N1
               TNU = G01FBF$(TAIL, PNT025, DBLE(IDF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01FBF/GLMWEI')
               WTOL = 1.0D+9*X02AMF$()
               DF = DBLE(IDF)
               IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
                  J = N1
                  IF (SE(J).GT.WTOL) THEN
                     TVAL = ABS(B(J)/SE(J))
                     IFAIL = N1
                     PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMWEI')
                  ELSE
                     PVAL = ONE
                  ENDIF
                  IF (PVAL.GT.PNT2) THEN
                     CIPHER = ' ***'
                  ELSEIF (PVAL.GT.PNT1) THEN
                     CIPHER = '  **'
                  ELSEIF (PVAL.GT.PNT05) THEN
                     CIPHER = '   *'
                  ELSE
                     CIPHER = '    '
                  ENDIF
                  IF (PVAL.LT.ZERO) THEN
                     PVAL = ZERO
                  ELSEIF (PVAL.GT.ONE) THEN
                     PVAL = ONE
                  ENDIF
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,500) B(J), B(J) - TNU*SE(J),
     +                                B(J) + TNU*SE(J),
     +                                SE(J), PVAL, CIPHER
                     WRITE (NF,500) B(J), B(J) - TNU*SE(J),
     +                              B(J) + TNU*SE(J),
     +                              SE(J), PVAL, CIPHER
                  ELSE
                     D13(1) = SHOWRJ(B(J))
                     TEMP = B(J) - TNU*SE(J)
                     D13(2) = SHOWRJ(TEMP)
                     TEMP = B(J) + TNU*SE(J)
                     D13(3) = SHOWRJ(TEMP)
                     D13(4) = SHOWRJ(SE(J))
                     WRITE (LINE,550) D13(1), D13(2),
     +                                D13(3), D13(4), PVAL, CIPHER
                     WRITE (NF,550) D13(1), D13(2),
     +                              D13(3), D13(4), PVAL, CIPHER 
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ELSE
                  J = N0
               ENDIF
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     IF (SE(J).GT.TOL) THEN
                        TVAL = ABS(B(J)/SE(J))
                        IFAIL = N1
                        PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMWEI')
                     ELSE
                        PVAL = ONE
                     ENDIF
                     IF (PVAL.GT.PNT2) THEN
                        CIPHER = ' ***'
                     ELSEIF (PVAL.GT.PNT1) THEN
                        CIPHER = '  **'
                     ELSEIF (PVAL.GT.PNT05) THEN
                        CIPHER = '   *'
                     ELSE
                        CIPHER = '    '
                     ENDIF
                     IF (PVAL.LT.ZERO) PVAL = ZERO
                     IF (PVAL.GT.ONE) PVAL = ONE
                     IF (E_NUMBERS) THEN  
                        WRITE (LINE,600) I, B(J), B(J) - TNU*SE(J),
     +                                   B(J) + TNU*SE(J), SE(J), PVAL,
     +                                  CIPHER
                        WRITE (NF,600) I, B(J), B(J) - TNU*SE(J),
     +                                 B(J) + TNU*SE(J),
     +                                 SE(J), PVAL, CIPHER
                     ELSE
                        D13(1) = SHOWRJ(B(J))
                        TEMP = B(J) - TNU*SE(J)
                        D13(2) = SHOWRJ(TEMP)
                        TEMP = B(J) + TNU*SE(J)
                        D13(3) = SHOWRJ(TEMP)
                        D13(4) = SHOWRJ(SE(J))  
                         WRITE (LINE,650) I, D13(1), D13(2), D13(3),
     +                                    D13(4), PVAL, CIPHER
                        WRITE (NF,650) I, D13(1), D13(2), D13(3),
     +                                 D13(4), PVAL, CIPHER
                     ENDIF  
                     CALL TABLE1 (COLOUR, LINE)
                  ENDIF
               ENDDO
C
C Output alpha and DEV
C
               J = IP + N1
               B(J) = ALF0P
               IF (SE(J).GT.TOL) THEN
                  TVAL = ABS(B(J)/SE(J))
                  IFAIL = N1
                  PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                  CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMWEI')
               ELSE
                  PVAL = ONE
               ENDIF
               IF (PVAL.GT.PNT2) THEN
                  CIPHER = ' ***'
               ELSEIF (PVAL.GT.PNT1) THEN
                  CIPHER = '  **'
               ELSEIF (PVAL.GT.PNT05) THEN
                  CIPHER = '   *'
               ELSE
                  CIPHER = '    '
               ENDIF
               IF (PVAL.LT.ZERO) PVAL = ZERO
               IF (PVAL.GT.ONE) PVAL = ONE
               IF (E_NUMBERS) THEN  
                  WRITE (LINE,1000) B(J), B(J) - TNU*SE(J),
     +                              B(J) + TNU*SE(J), SE(J), PVAL,
     +                              CIPHER
                  WRITE (NF,1000) B(J), B(J) - TNU*SE(J),
     +                            B(J) + TNU*SE(J),
     +                            SE(J), PVAL, CIPHER
               ELSE
                   D13(1) = SHOWRJ(B(J))
                   TEMP = B(J) - TNU*SE(J)
                   D13(2) = SHOWRJ(TEMP)
                   TEMP = B(J) + TNU*SE(J)
                   D13(3) = SHOWRJ(TEMP)
                   D13(4) = SHOWRJ(SE(J)) 
                   WRITE (LINE,1050) D13(1), D13(2), D13(3), D13(4),
     +                               PVAL, CIPHER
                  WRITE (NF,1050) D13(1), D13(2), D13(3), D13(4),
     +                            PVAL, CIPHER
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1100) DEV
               ELSE
                  D13(1) = SHOWLJ(DEV)
                  WRITE (LINE,1150) D13(1)   
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               WRITE (NF,'(A)') LINE
               IF (ALF0P.GT.WTOL) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,1200) DEV1
                  ELSE
                     D13(1) = SHOWLJ(DEV1)
                     WRITE (LINE,1250) D13(1)  
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
                  WRITE (NF,'(A)') LINE
               ENDIF
               CALL TABLE1 (COLOUR, 'CLOSE')
               NUMDEC = N1
            ENDIF
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'GLM Survival analysis',1X,A
     +/
     +/'Variables (* = suppressed):'
     +/A
     +/'Data:'
     +/A
     +/'Title:'
     +/A
     +/'Fitting to use weights supplied',1X,A
     +/'Include a constant (mean) term',1X,A
     +/'Total number of x-variables supplied =',I4
     +/'Number of x-variables to be included =',I4
     +/'Number of x-variables to be excluded =',I4
     +/'Number of parameters to be estimated =',I4
     +/
     +/'Fit data with current settings'
     +/'Change status of the constant term'
     +/'Suppress/Restore variables'
     +/'Plot y(i) = f(x(i,j))'
     +/'Examine residuals'
     +/'Results'
     +/'Quit ... Exit GLM survival analysis')
  200 FORMAT (' Number of parameters =',I3,
     +', Rank =',I3,', Number of points =',I6,', Degrees of freedom =',
     +I6)
  250 FORMAT (' Number of parameters = ',A,
     +', Rank = ',A,', Number of points = ',A,', Degrees of freedom = ',
     +A)   
  400 FORMAT (' Parameter         Value    Lower95%cl    Upper95%cl',
     +'     Std.error     p')
  500 FORMAT ('  Constant',   1P,4(1X,E13.5),0P,F9.4,A)  
  550 FORMAT ('  Constant',      4(1X,A13),F9.4,A)   
  600 FORMAT ('    B(',I3,')',1P,4(1X,E13.5),0P,F9.4,A) 
  650 FORMAT ('    B(',I3,')',   4(1X,A13),F9.4,A)    
  700 FORMAT (
     + 'Display table of residuals'
     +/'Write to results file'
     +/'Plot against best fit'
     +/'Plot in half normal format'
     +/'Plot in full normal format'
     +/'Quit ... Exit these residuals plotting options')
  800 FORMAT ('Number       Y-value        Theory     Dev-resid',
     +'      Leverage')
  900 FORMAT (I6,1P,4(1X,E13.5))
  950 FORMAT (I6,4(1X,A13))
 1000 FORMAT ('     alpha',   1P,4(1X,E13.5),0P,F9.4,A)
 1050 FORMAT ('     alpha',      4(1X,A13),F9.4,A)
 1100 FORMAT ('Deviance =',1P,E10.3)
 1150 FORMAT ('Deviance =',1X,A)
 1200 FORMAT ('Deviance - 2n*log[alpha] =',1P,E10.3)
 1250 FORMAT ('Deviance - 2n*log[alpha] =',1X,A)
      END
C
C
