C
C
      SUBROUTINE GOGOGO (NOUT,
     +                   FNAME1, FNAME2, PNAME,
     +                   ABORT, NEW)
C
C ACTION : Declare end and files used then ask if a repeat run is required
C          Derived from GOSTOP by adding facility to save/edit file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 5/3/94
C          04/02/1998 Added call to view data file
C          18/03/1998 Added call to EDITFL
C          18/08/1999 re-arranged the menu to make more logical
C          03/12/1999 replaced start_process@ by winxec
C          04/12/1999 restored start_process@
C          20/12/1999 altered assignment of TEXT(1) to avoid WRITE using
C                     100 FORMAT which is not accepted in /check_mate
C                     Also revised mechanism for creating a file for editfl
C          07/01/2001 removed CONTINUE statement
C          16/01/2002 replaced RENAME@ by RENAME and START_PROCESS@ BY STARTP
C          28/05/2002 added TRIM80
C          15/12/2002 added call to EDFLXX
C          18/12/2002 replaced TRIM80 by TRIM60
C          30/01/2003 added call to TTEST2
C          17/02/2005 added call to FITVAL and ATTRIB
C          04/10/2007 added INTENTS and SIM256 
c          20/04/2014 added final call to ... CLOSE (UNIT = NOUT)
C
C          NOUT: (input/unchanged) unit connected for results
C        FNAME1: (input/output) name of current data file
C        FNAME2: (input/unchanged) name of results file (f any)
C         PNAME: (input/unchanged) name of calling program
C         ABORT: (output) error indicator
C           NEW: (output)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NOUT
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME2, PNAME
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1
      LOGICAL,             INTENT (OUT)   :: ABORT, NEW
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           N0, N1, N2, N3, N4, N5, N7, N8, N9, N12, N30
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1,
     +           N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N7 = 7, N8 = 8, N9 = 9, N12 = 12, N30 = 30)
      INTEGER    ISEND, ITYPE,  NIN1, NOUT1, NSEND, NVAL
      PARAMETER (ISEND = 1, ITYPE = 2)
      INTEGER    ERROR_CODE
      INTEGER    NUMBLD(N30), NUMPOS(N8)
      INTEGER    I, IOS, LEN200, L1, L2, NTEXT
      CHARACTER  LINE*100, TEXT(N30)*100, FILE*1024, TRIM60*60
      CHARACTER  FILEX*1024, FNAME(2)*1024, SIM256*1024, WORD14*14
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    EXIST, READ_ONLY, REPEET
      LOGICAL    BORDER, FLASH, HIGH, SUPPLY, TEMP, THERE
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   LBOX01, LEN200, REVPRO, VIEWER, LCASE1, OFILES,
     +           GETNOU, GETTMP, DELEET, PUTADV, TRIM60, EDFLXX,
     +           RENAME, TTEST2, FITVAL, ATTRIB, PUTFAT, SIM256
C
C Initialise local arrays
C
      NUMBLD(N1) = N4
      DO I = N2, N30
         NUMBLD(I) = N0
      ENDDO
      DO I = N1, N8
         NUMPOS(I) = N1
      ENDDO
      DO I = N1, N2
         FNAME(I) = BLANK
      ENDDO
C
C Main branch point
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Part 1: initialise....................................................
C =======
C
         ABORT = .TRUE.
         NEW = .FALSE.
         SUPPLY = .FALSE.
         TEMP = .FALSE.
         L1 = N1
         L2 = LEN200(PNAME)
         LINE = 'Program '//PNAME(L1:L2)//' has completed the analysis'

         NTEXT = N1
         TEXT(NTEXT) = LINE

         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK
C
C Part 2: check out FNAME1 = name of the data file if present...........
C =======
C
         IF (FNAME1.EQ.BLANK) THEN
C
C Data has not been read in so there is no input file
C
            SUPPLY = .FALSE.
            TEMP = .FALSE.
            NUMOPT = N4
         ELSE
C
C There is a current data file
C
            SUPPLY = .TRUE.
            NUMOPT = N7

            NTEXT = NTEXT + N1
            TEXT(NTEXT) = 'Input data were contained in the file:'

            NTEXT = NTEXT + N1
            LINE = TRIM60(FNAME1)
            TEXT(NTEXT) = LINE
            NUMBLD(NTEXT) = N1

            NTEXT = NTEXT + N1
            TEXT(NTEXT) = BLANK

            FILE = FNAME1
            CALL LCASE1 (FILE)
            IF (FILE(N1:N2).EQ.'f$' .AND. FILE(N9:N12).EQ.'.tmp') THEN
C
C The file is a temporary file F$123456.tmp or similar so increment NUMOPT
C
               NUMOPT = NUMOPT + N1
               TEMP = .TRUE.
            ELSE
C
C The data are in a disk file
C
               TEMP = .FALSE.
            ENDIF
         ENDIF
C
C Part 3: check out the results/log file if created.....................
C =======
C
         IF (FNAME2.NE.BLANK) THEN
C
C There is an output file
C
            NTEXT = NTEXT + N1
            TEXT(NTEXT) = 'Results have been written to the file:'

            NTEXT = NTEXT + N1
            LINE = TRIM60(FNAME2)
            TEXT(NTEXT) = LINE
            NUMBLD(NTEXT) = N1

            NTEXT = NTEXT + N1
            TEXT(NTEXT) = BLANK
         ENDIF
C
C Part 4: start to build up the menu....................................
C =======
C
         NTEXT = NTEXT + N1
         NSTART = NTEXT
         TEXT(NTEXT) = 'Results'

         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Compare two known parameter estimates'
C
C Extra options if data has already been supplied
C
         IF (SUPPLY) THEN
            NTEXT = NTEXT + 1
            TEXT(NTEXT) = 'View the current data'

            NTEXT = NTEXT + N1
            TEXT(NTEXT) = 'Edit the current data then re-run'

            IF (TEMP) THEN
               NTEXT = NTEXT + N1
               TEXT(NTEXT) = 'Save this edited data'
            ENDIF

            NTEXT = NTEXT + N1
            TEXT(NTEXT) = 'Re-fit the current data'
         ENDIF
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Fit a new data set'

         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Quit ... Exit program'//BLANK//PNAME(L1:L2)
C
C Part 5: All data have been assembled so throw up the menu..............
C =======
C
         NUMDEC = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         REPEET = .FALSE.
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Review progress so far then return to the menu
C
            CALL REVPRO (NOUT)
            REPEET = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Compare two parameters
C
            CALL TTEST2 (NOUT)
            REPEET = .TRUE.
         ENDIF
C
C Part 6: special action if SUPPLY......................................
C =======
C
         IF (SUPPLY) THEN
C
C Data are in an input data file
C
            IF (NUMDEC.EQ.N3) THEN
C
C SUPPLY and NUMDEC = 3: View current data then go back to the menu
C
               CALL VIEWER (ISEND,
     +                      FNAME1, BLANK, BLANK)
               REPEET = .TRUE.
            ELSEIF (NUMDEC.EQ.N4) THEN
C
C SUPPLY and NUMDEC = 4: Edit current data
C                        First open a curve fit file for data after editing
C
               FNAME(1) = FNAME1
               NSEND = 1
               CALL FITVAL (NSEND, NVAL,
     +                      ABORT)
               IF (ABORT) THEN
                  CALL GETTMP (IOS,
     +                         FILEX)
                  FNAME(2) = FILEX
               ELSE
                  NSEND = 2
                  CALL FITVAL (NSEND, NVAL,
     +                         ABORT)
                  IF (ABORT) THEN
                     CALL GETTMP (IOS,
     +                            FILEX)
                     FNAME(2) = FILEX
                  ELSE
                     IF (NVAL.LT.10) THEN
                        WRITE (WORD14,100) NVAL
                     ELSEIF (NVAL.LT.100) THEN
                        WRITE (WORD14,200) NVAL
                     ELSE
                        WRITE (WORD14,300) NVAL
                     ENDIF
                     FNAME(2) = SIM256(WORD14)
                     CALL ATTRIB (FNAME(2),
     +                            EXIST, READ_ONLY)
                     IF (EXIST .AND. READ_ONLY) THEN
                        WRITE (LINE,400) WORD14
                        CALL PUTFAT (LINE)
                        CALL GETTMP (IOS, FILEX)
                        FNAME(2) = FILEX
                     ENDIF
                  ENDIF
               ENDIF
               ABORT = .FALSE.
               CALL GETNOU (NOUT1)
               OPEN (UNIT = NOUT1, FILE = FNAME(2))
               WRITE (NOUT1,'(A)') 'Temporary file'
               CALL GETNOU (NIN1)
               CLOSE (NIN1)
               CLOSE (NOUT1)
               CALL EDFLXX (ITYPE, NIN1, NOUT1,
     +                      FNAME)
               CLOSE (NIN1)
               CLOSE (NOUT1)
               FNAME1 = FNAME(2)
               WRITE (LINE,500) TRIM60(FNAME1)
               CALL PUTADV (LINE)
            ENDIF
            IF (TEMP .AND. NUMDEC.EQ.N5) THEN
C
C SUPPLY and TEMP and NUMDEC = 5: Rename edited data
C
               WRITE (LINE,600)
               CALL PUTADV (LINE)
               CALL GETNOU (NOUT1)
               CLOSE (NOUT1)
               CALL OFILES (ISEND, NOUT1,
     +                      FILE,
     +                      ABORT)
               CLOSE (NOUT1)
               IF (.NOT.ABORT) THEN
                  CALL DELEET (FILE,
     +                        ASKIF, THERE)
                  IF (THERE) THEN
                     WRITE (LINE,700)
                     CALL PUTFAT (LINE)
                  ELSE
                     CALL RENAME (FNAME1, FILE,
     +                            ERROR_CODE)
                     FNAME1 = FILE
                  ENDIF
               ENDIF
               REPEET = .TRUE.
            ENDIF
         ENDIF
      ENDDO
C
C Part 7: Final decisions before quitting...............................
C =======
C
      IF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Quit ... NUMOPT has been selected
C
         CLOSE (UNIT = NOUT)
         ABORT = .TRUE.
      ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = NUMOPT - 1: Another run with NEW data
C
         ABORT = .FALSE.
         NEW = .TRUE.
      ELSE
C
C OTHERWISE: Another run with new data for all other options and NEW = .FALSE.
C
         ABORT = .FALSE.
         NEW = .FALSE.
      ENDIF
C
C Format statements
C      
  100 FORMAT ('curfit_',I1,'.tmp')
  200 FORMAT ('curfit_',I2,'.tmp')
  300 FORMAT ('curfit_',I3,'.tmp')
  400 FORMAT ('Read_only file encountered ... Use attrib -r',1x,A)
  500 FORMAT ('Edited data Saved As ...',1X,A)
  600 FORMAT ('Specify a new file name')
  700 FORMAT ('Change read-only status to over-write')
      END
C
C
