c
c
      subroutine grp000 (ing, ncmax, ncsav, nin, nout, nrmax, nrsav,
     +                   a, wk,
     +                   fname, title,
     +                   newdat, supply)
c
c action: inter-group distances
c author: w.g.bardsley, university of manchester, u.k.
c         developed from manova 22/03/2004
c         13/04/2004 added calls to isxtyp, isxedi, and isxvec
c         10/06/2004 added call to grp001 and other related changes
c         12/01/2005 edited and changed argument list for grp001, and
c                    added call to grp002
c         16/01/2006 moved arguments b and d to allocatables
c         09/03/2006 added ncsav, nrsav, fname, title, newdat, and supply
c                    to argument list
c         03/08/2006 repaired code to read extra observations off the file
c         29/10/2006 added calls to eofint and getval
c         11/11/2006 added allpos in call to eofint
c         14/09/2010 added plotting option by call to MANOVG
c         21/06/2012 introduced iag instead of ing in call to grp001 and
c                    added more internal allocations
c         09/02/2017 made l1, l2, nwmax kind = 7         
c
c       ing: workspace to hold group assignment for each row
c     ncmax: (input/unchanged) second dimension of a
c     ncsav: (input/output) current no. of columns
c       nin: (input/unchanged) unconnected unit for file opening
c      nout: (input/unchanged) preconnected unit for writing results
c     nrmax: (input/unchanged) leading dimension of a
c     nrsav: (input/output) current no. of rows
c     a, wk: workspace
c     fname: (input/output) current file
c     title: (input/output) current title
c    newdat: (output) request for new data
c    supply: (input) .true. if data file supplied
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmax, nin, nout, nrmax
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: ing(nrmax)
      double precision,    intent (inout) :: a(nrmax,ncmax),
     +                                       wk(nrmax*(ncmax + 1))
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat
c
c local allocatable arrays
c
      integer,              allocatable :: iag(:), isx(:), iwk(:), 
     +                                     nig(:)
      double precision,     allocatable :: b(:,:), d(:,:), det(:),
     +                                     gc(:), gmean(:,:)
c
c locals
c
      integer (kind = 7) l1, l2, nwmax
      integer    i, ierr, j, k, kcol, krow, ldd, ldx, ntext, m, n, ncol,
     +           ncolp1, ng, ngp1, nobs, nrow, nvar
      integer    icount, ifail
      integer    icolor, ix, iy, lshade, numdec
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    n0, n1, n2, n4, nxmin
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, nxmin = 1)
      integer    nstart, ntype, numopt, numtxt
      parameter (nstart = 11, ntype = 3,
     +           numopt = 14, numtxt = nstart + numopt - n1)
      integer    idtype, ldg, ngmax, nvmax, nvsav 
      parameter (idtype = 2, nvsav = 100) 
      integer    isxsav(nvsav)
      integer    numbld(30), numpos(20)
      double precision df, sig, stat, wt(2)
      double precision dn
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100, symbol*40, text(30)*100
      character  chop80*80, word80*80, trim100*100, word100*100
      character  word12(4)*12, form12*12
      character  banner(2)*100
      character  header*100
      parameter (header = 'Mean vectors: groups then pooled')
      character  equal*1, mode*1
      character  blank*1, weight*1
      parameter (blank = ' ', weight = 'U')
      logical    abort, ok, ready, repeet, showit
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    fileit, frame, next, updown
      parameter (fileit = .true., frame = .false., updown = .true.)
      logical    allpos
      parameter (allpos = .true.)
      external   lbox01, chop80, putfat, isxedi, isxtyp, isxvec,
     +           table1, putifa, tutor1, revpro, manovd, dsplay, plevel,
     +           grp001, grp002, eofint, getval, manovg, form12, trim100
      external   g03daf$, g03dbf$
      intrinsic  dble, nint 
      save       icount, isxsav
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvsav*1 /
      data       icount / 0 /
c
c initialise newdat then check if supply = .true.
c
      newdat = .false.
      if (supply) then
         if (ncsav.lt.2 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(iag)) deallocate(iag, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(nig)) deallocate(nig, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(det)) deallocate(det, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(gc)) deallocate(gc, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(gmean)) deallocate(gmean, stat = ierr)
      if (ierr.ne.0) return  
      allocate(iag(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(nig(nrmax), stat = ierr)
      if (ierr.ne.0) return    
      allocate(b(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      nvmax = ncmax
      do i = n1, ncmax
         if (i.le.nvsav) then
            isx(i) = isxsav(i)
         else
            isx(i) = n1
         endif
      enddo
      if (supply) then
         ready = .false.
         ok = .false.
         
c         nwmax = nrmax*(ncmax + n1)
         l1 = nrmax
         l2 = ncmax
         nwmax = l1*(l2 + 1)
         
         m = ncsav!must be set to the fname column dimension as supply = .true.
         n = nrsav!must be set to the fname row dimension as supply = .true.
         call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                nxmin, nwmax,
     +                a, wk,
     +                fname, title,
     +                abort, supply)
         ncol = m!this is now the number of variables ncsav - 1 as supply = .true.
         nrow = n!this is now the number of cases as supply = .true.
         if (.not.abort .and. ncol.gt.n1 .and. nrow.gt.ncol) then
            abort = .false.
         else
            abort = .true.
         endif
         if (.not.abort .and. ncol.lt.n2) then
            abort = .true.
            call putfat ('Must have at least 2 columns')
         endif
         if (.not.abort .and. nrow.lt.n2) then
            abort = .true.
            call putfat ('Must have at least 2 rows')
         endif
         if (abort) then
            deallocate(iag, stat = ierr)
            deallocate(isx, stat = ierr)
            deallocate(nig, stat = ierr)
            deallocate(b, stat = ierr)
            deallocate(d, stat = ierr)
            deallocate(det, stat = ierr)
            deallocate(gc, stat = ierr)
            deallocate(gmean, stat = ierr)
            return
         else
            ready = .true.
            ngmax = ng
            ldg = ngmax + 1
            ierr = 0
            if (allocated(det)) deallocate(det, stat = ierr)
            if (ierr.ne.0) return  
            if (allocated(gc)) deallocate(det, stat = ierr)
            if (ierr.ne.0) return
            if (allocated(gmean)) deallocate(det, stat = ierr)
            if (ierr.ne.0) return 
            allocate (det(ngmax + 2), stat = ierr)
            if (ierr.ne.0) return 
            i = (ngmax + 2)*nvmax*(nvmax + 1)/2  
            allocate (gc(i), stat = ierr)
            if (ierr.ne.0) return
            allocate (gmean(ldg,nvmax), stat = ierr)
            if (ierr.ne.0) return     
c
c check if isx is initialised from the data file
c
            call eofint (isx, ncol,
     +                   fname,
     +                   abort, allpos)
            call isxvec (isx, ncol, nvar, nxmin)
            nobs = n0
c
c see if extra observations have been appended
c Note the file has ncol + 1 columns but only ncol variables
c
            close (unit = nin)
            kcol = ncol
            ncolp1 = ncol + n1
            call getval (kcol, krow, ncolp1, nin, nrow, nwmax,
     +                   wk,
     +                   fname)
            close (unit = nin)
            if (krow.gt.n0) then
               nobs = krow
               k = n0
               do i = n1, nobs
                  do j = n1, ncol
                     k = k + n1
                     b(i,j) = wk(k)
                  enddo
               enddo
            endif
            icount = icount + 1
            word80 = chop80(title)
            word100 = trim100(fname) 
            write (nout,200) icount, word100, word80
         endif
      else
         n = n0
         nobs = n0
         m = n0
         ncol = n0
         nrow = n0
         ng = n0
         nvar = n0
         title = 'No current data'
         word80 = chop80(title)
         ready = .false.
      endif
      ok = .false.
      showit = .false.
c
c main loop ............................................................
c
      repeet = .true.
      do while (repeet)
         if (ncol.gt.n0) then
c
c create line:  Write numbers/stars for variables included/suppressed
c
            call isxtyp (isx, ncol, nvar, nxmin, line, showit)
         else
            line = blank
            showit = .false.
         endif
c
c set up the main menu
c 
         word12(1) = form12(ng)
         word12(2) = form12(n)
         word12(3) = form12(nobs) 
         write (text,100) word80, line, word12(1), word12(2), word12(3)
         if (showit) then
              banner(1) = text(3)
              banner(2) = text(4)
         endif
         numdec = numopt - n1
         numbld(1) = n4
         numbld(4) = n1
         numbld(6) = n1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = n0
         numbld(4) = n0
         numbld(6) = n0
c
c-----------------------------------------------------------------------
c Special action: Set up the covariance matrices if ready and not ok
c                 and 2 =< numdec =< 8
c                 This must be done every time a new data set is read in
c                 or variables are suppressed/restored
c------------------------------------------------------------------------
c
         if (ready       .and.
     +       .not.ok     .and.
     +       numdec.ge.2 .and.
     +       numdec.le.8) then
     
            ierr = 0
            if (allocated(iwk)) deallocate(iwk, stat = ierr)
            if (ierr.ne.0) return
            allocate (iwk(ng), stat = ierr)
            if (ierr.ne.0) return
              
            ldx = nrmax
            call g03daf$(weight, n, m, a, ldx, isx, nvar, ing, ng,
     +                   wt, nig, gmean, ldg, det, gc, stat, df,
     +                   sig, wk, iwk, ifail)
     
            deallocate (iwk, stat = ierr)
            
            call putifa (ifail, nout, 'G03DAF/MANOVA')
            if (ifail.eq.n0) then
               ok = .true.
               dn = dble(n)
               ngp1 = ng + 1
               do j = n1, nvar
                  gmean(ngp1,j) = zero
               enddo
               do j = n1, nvar
                  do i = n1, ng
                     gmean(ngp1,j) = gmean(ngp1,j) +
     +                               dble(nig(i))*gmean(i,j)
                  enddo
                  gmean(ngp1,j) = gmean(ngp1,j)/dn
               enddo
            endif
         endif
c
c Special action: check current data if analysis has been requested
c
         if (numdec.ge.2 .and. numdec.le.8) then
            if (.not.ready) then
               call putfat ('First read in some data')
               numdec = n0
            else
               call isxvec (isx, ncol, nvar, nxmin)
               if (nvar.lt.nxmin) numdec = n0
            endif
         endif
c
c Special action: inform user if any variables are suppressed
c
         if (showit .and. ready .and. ok .and. numdec.ge.2 .and.
     +       numdec.le.8) then
             write (nout,'(a)') blank
             write (nout,'(a)') banner(1)
             write (nout,'(a)') banner(2)
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data...matrix a will not be changed from now on
c **********
c
            if (supply) then
               newdat = .true.
c
c store isxsav and deallocate workspace
c
               do i = 1, ncmax
                  if (i.le.nvsav) isxsav(i) = isx(i)
               enddo
               deallocate(iag, stat = ierr)
               deallocate(isx, stat = ierr)
               deallocate(nig, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(d, stat = ierr)
               deallocate(det, stat = ierr)
               deallocate(gc, stat = ierr)
               deallocate(gmean, stat = ierr)
               return
            endif
            ready = .false.
            ok = .false.
            
c            nwmax = nrmax*(ncmax + 1)

            l1 = nrmax
            l2 = ncmax
            nwmax = l1*(l2 + 1)
            
            m = n0
            n = n0
            call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                   nxmin, nwmax,
     +                   a, wk,
     +                   fname, title,
     +                   abort, supply)
            ncol = m
            nrow = n
            if (.not.abort .and. ncol.gt.n1 .and. nrow.gt.ncol) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 columns')
            endif
            if (.not.abort .and. nrow.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 rows')
            endif
            if (abort) then
               m = n0
               n = n0
               ncol = n0
               ncsav = n0
               nrow = n0
               nrsav = n0
               nvar = n0
               ready = .false.
               word80 = 'No current data'
               numdec = n1
            else
               ready = .true.
               ngmax = ng
               ldg = ngmax + 1
               ierr = 0
               if (allocated(det)) deallocate(det, stat = ierr)
               if (ierr.ne.0) return  
               if (allocated(gc)) deallocate(det, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(gmean)) deallocate(det, stat = ierr)
               if (ierr.ne.0) return 
               allocate (det(ngmax + 2), stat = ierr)
               if (ierr.ne.0) return 
               i = (ngmax + 2)*nvmax*(nvmax + 1)/2  
               allocate (gc(i), stat = ierr)
               if (ierr.ne.0) return
               allocate (gmean(ldg,nvmax), stat = ierr)
               if (ierr.ne.0) return     
c
c check if isx is initialised from the data file
c
               call eofint (isx, ncol,
     +                      fname,
     +                      abort, allpos)
               call isxvec (isx, ncol, nvar, nxmin)
               nobs = n0
c
c see if extra observations have been appended
c Note: the file has ncol + 1 columns but only ncol variables
c
               close (unit = nin)
               kcol = ncol
               ncolp1 = ncol + n1
               call getval (kcol, krow, ncolp1, nin, nrow, nwmax,
     +                      wk,
     +                      fname)
               close (unit = nin)
               if (krow.gt.n0) then
                  nobs = krow
                  k = n0
                  do i = n1, nobs
                     do j = n1, ncol
                        k = k + n1
                        b(i,j) = wk(k)
                     enddo
                  enddo
               endif
               ncsav = ncolp1
               nrsav = nrow
               icount = icount + 1
               word80 = chop80(title)
               word100 = trim100(fname)
               write (nout,200) icount, word100, word80
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: display means
c **********
c
            call dsplay (nvmax, nvar, nout, ldg, ngp1, ntype,
     +                   gmean, header, fileit)
         elseif (numdec.eq.3) then
c
c numdec = 3: test for all CV equality
c **********
c
            word12(1) = form12(ng)
            word12(2) = form12(n)
            word12(3) = form12(nvar)
            i = nint(df)
            word12(4) = form12(i)
            call plevel (sig, symbol)
            write (text,300) word12(1), word12(2), word12(3), stat,
     +                       word12(4), sig, symbol
            write (nout,'(a)') blank
            j = 15
            call table1 (j, 'OPEN')
            do i = 1, 8
               if (i.eq.1) then
                  j = 4
               else
                  j = 0
               endif
               call table1 (j, text(i))
               write (nout,'(a)') text(i)
            enddo
            call table1 (j,'CLOSE')
         elseif (numdec.eq.4 .or. numdec.eq.5) then
c
c numdec = 4 or 5: group distances for equal/unequal CV
c ****************
c
            mode = 'M'
            if (numdec.eq.4) then
               equal = 'E'
               line = 'D^2 for all groups assuming equal CV'
            else
               equal = 'U'
               line = 'D^2 for all groups assuming unequal CV'
            endif
            
            ldd = ng
            ierr = 0
            allocate (d(ldd,ng), stat = ierr)
            if (ierr.ne.0) return
              
            ifail = n0
            call g03dbf$(equal, mode, nvar, ng, gmean, ldg, gc, nobs,
     +                   m, isx, b, nrmax, d, ldd, wk, ifail)
     
            if (ifail.eq.n0) then
               if (equal.eq.'E') then
                  do i = n1, ng
                     do j = i + n1, ng
                        d(i,j) = d(j,i)
                     enddo
                  enddo
               endif
               do i = n1, ng
                  d(i,i) = zero
               enddo
               call dsplay (ng, ng, nout, ldd, ng, ntype,
     +                      d,
     +                      line,
     +                      fileit)
            else
               call putifa (ifail, nout, 'G02DBF/GRP000')
            endif
            
            deallocate(d, stat = ierr)
            
         elseif (numdec.eq.6 .or. numdec.eq.7) then
c
c numdec = 6 or 7: sample/group distances
c ****************
c
            if (nobs.le.0) then
               call grp002 (nrmax, m, nin, nobs,
     +                      wk, b)
            endif
            if (nobs.le.n0) then
               call putfat ('No current extra sample values')
            else
               mode = 'S'
               if (numdec.eq.6) then
                  equal = 'E'
                  line = 'D^2 for samples/groups assuming equal CV'
               else
                  equal = 'U'
                  line = 'D^2 for samples/groups assuming unequal CV'
               endif
               
               ldd = nobs
               ierr = 0
               allocate (d(ldd,ng), stat = ierr)
               if (ierr.ne.0) return
                 
               ifail = n0
               call g03dbf$(equal, mode, nvar, ng, gmean, ldg, gc, nobs,
     +                      m, isx, b, nrmax, d, ldd, wk, ifail)
     
               if (ifail.eq.n0) then
                  call dsplay (ng, ng, nout, ldd, nobs, ntype,
     +                         d,
     +                         line,
     +                         fileit)
               else
                  call putifa (ifail, nout, 'G02DBF/GRP000')
               endif
               
               deallocate(d, stat = ierr)
               
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: assign sample to groups
c **********
c
            if (nobs.le.0) then
               call grp002 (nrmax, m, nin, nobs,
     +                      wk, b)
            endif
            ldx = nrmax
            call grp001 (iag, isx, ldg, ldx, m, ng, nig, nin, nobs,
     +                   nout, nvar,
     +                   a, det, gc, gmean, wk, b)
         elseif (numdec.eq.9) then
c
c numdec = 9: select to suppress/restore variables
c **********
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
         elseif (numdec.eq.10) then
c
c numdec = 10: input/edit extra observations
c ************
c
            if (m.gt.n0 .and. n.gt.n0) then
               call grp002 (nrmax, m, nin, nobs,
     +                      wk, b)
            else
               call putfat ('First read in some data')
            endif
         elseif (numdec.eq.11) then
c
c numdec = 11: plot
c ************
c
            if (m.gt.n0 .and. n.gt.n0) then
               i = -1
               call manovg (i,
     +                      fname,
     +                      newdat)               
            else
               call putfat ('First read in some data')
            endif            
         elseif (numdec.eq.numopt - n2) then
c
c numdec = numopt - 2: review progress
c *******************
c
            call revpro (nout)            
         elseif (numdec.eq.numopt - n1) then
c
c numdec = numopt - 1: help
c *******************
c
             write (text,1000)
             ntext = 22
             numbld(1) = 1
             numbld(15) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(15) = 0
             write (text,1100)
             ntext = 22
             next = .true.
             numbld(1) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             next = .false.
             write (text,1200)
             ntext = 22
             numbld(1) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numdec = 2

         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ***************
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c store isxsav and deallocate workspace
c
      do i = 1, ncmax
         if (i.le.nvsav) isxsav(i) = isx(i)
      enddo
      deallocate(iag, stat = ierr)
      deallocate(isx, stat = ierr)
      deallocate(nig, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(d, stat = ierr)
      deallocate(det, stat = ierr)
      deallocate(gc, stat = ierr)
      deallocate(gmean, stat = ierr)

c
c format statements
c
  100 format (    
     + 'Discriminant analysis'
     +/
     +/'Title for current group comparison data:'
     +/A
     +/'Variables included:'
     +/A
     +/'Number of groups:',1x,a
     +/'Number of cases:',1x,a
     +/'Number of extra observations:',1x,a
     +/
     +/'Data options: New/Edit/Transform/View'
     +/'All groups: display/file means'
     +/'All groups: test equality of CV matrices'
     +/'All groups: D^2 for equal CV matrices'
     +/'All groups: D^2 for unequal CV matrices'
     +/'Groups/extra observations: D^2 for equal CV matrices'
     +/'Groups/extra observations: D^2 for unequal CV matrices'
     +/'Assign samples to groups'
     +/'Suppress/Restore variables'
     +/'Input/edit extra observations' 
     +/'Plot current training set'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit discrimination analysis')
  200 format (
     +/'Analysis of Group comparison data set number',i4
     +/'================================================'
     +/'File:'
     +/A
     +/'Title:'
     +/A)
  300 format (
     + 'Group comparison H0: all covariance matrices are equal'
     +/
     +/'Number of groups             =',1x,a
     +/'Number of observations       =',1x,a
     +/'Number of variables          =',1x,a
     +/'Test statistic C             =',1p,e10.3
     +/'Number of degrees of freedom =',1x,a
     +/'p = P(chi-squared >= C)      =',0p,f7.4,1x,a)
 1000 format (
     + 'Overview of multivariate group comparison'
     +/
     +/'It is supposed that m variables have been measured for g groups'
     +/'with n_i cases per group, where m > 1, g > 1, n_i >= m, and the'
     +/'data have been formatted as a data file with n rows and m + 1'
     +/'columns, e.g. using Makmat. Note: n = n_1+n_2+...+n_g, column 1'
     +/'must have groups in nondecreasing order, and variables 1 to m'
     +/'must be in columns 2 to m + 1. Test files manova1.tf? show how'
     +/'to format MANOVA data correctly. If possible, all groups should'
     +/'have the same numbers of cases per group.'
     +/'You select variables (columns) to include/exclude then various'
     +/'options are possible to explore the data assuming multivariate'
     +/'normality. Note: these options only work well when n_i >> m.'
     +/
     +/'Assigning extra observations to the training sets'
     +/'This option is used when you have data that have not yet been'
     +/'assigned to groups. The main data file contains data for the'
     +/'known groups, which are regarded as training sets, then any'
     +/'extra observations appended to the file (see manova1.tf2), or'
     +/'supplied independently, can be used to estimate distances from'
     +/'groups or to assign to groups. Extra data assigned in this way'
     +/'can be added to the groups to create new training set files.')
 1100 format (
     + 'Estimating distances between group means and samples'
     +/
     +/'The best estimate of the distance between two vectors x and y'
     +/'is the squared Mahalanobis distance given by the quadratic form'
     +/'         D^2 = (x - y)^T[(CV)^{-1}](x - y)^T'
     +/'where CV is the best estimate for the covariance matrix, i.e.'
     +/'the pooled (S) or individual group (S_j) estimates. Individual'
     +/'estimates should only be used if this is indicated by the test'
     +/'for equality of covariance matrices, and this is only reliable'
     +/'with very large samples, i.e. when n_i >> m for all groups.'
     +/
     +/'The matrix D^2(i,j) calculated by this procedure depends on the'
     +/'assumptions made as follows.'
     +/
     +/'1)`Comparing groups assuming equal CV'
     +/'  `D^2(i,j) is for group means i and j with CV = S'
     +/'2)`Comparing groups assuming unequal CV'
     +/'  `D^2(i,j) is for group means i and j with CV = S_j.'
     +/'3)`Comparing groups and extra observations assuming equal CV'
     +/'  `D^2(i,j) is for sample i and group j with CV = S.'
     +/'4)`Comparing groups and extra observations assuming unequal CV'
     +/'  `D^2(i,j) is for sample i and group j with CV = S_j.')
 1200 format (
     + 'Assigning new observations to groups'
     +/
     +/'In this procedure the groups are regarded as training sets and'
     +/'the aim is to assign new observations to the groups defined by'
     +/'the main data, according to posterior probability estimates as'
     +/'functions of priors and the D^2. There are many possibilities.'
     +/'(1)`Estimative-equal-CV-matrices (Linear discrimination)'
     +/'(2)`Estimative-unequal-CV-matrices (Quadratic discrimination)'
     +/'(3)`Predictive-equal-CV-matrices'
     +/'(4)`Predictive-unequal-CV-matrices'
     +/'(a)`Equal priors'
     +/'(b)`Priors proportional to sample size'
     +/'(c)`Priors supplied (as frequencies to be normalised by Simfit)'
     +/'Posterior probabilities are calculated using the priors, then'
     +/'samples are assigned to the groups with the highest posterior'
     +/'probabilities. Atypicality indices are also calculated to show'
     +/'the closeness of samples to the groups defined by the training'
     +/'sets. Values close to 1 suggest the sample would be atypical if'
     +/'assigned to the group in question. So a row of values near 1'
     +/'would suggest the sample can not be assigned with confidence to'
     +/'any group. If in doubt select method (1) with equal priors (a).'
     +/'See test file manova1.tf2 for the data format required.')
      end
c
c

