c
c
      subroutine grp001 (iag, isx, ldg, ldx, m, ng, nig, nin, nobs,
     +                   nout, nvar,
     +                   a, det, gc, gmean, wk, x)
c
c action: assign observations to groups
c author: w.g.bardsley, university of manchester, u.k., 10/06/2004
c         13/01/2005 added data matrix a to argument list and introduced
c                    calls to grp002 and grp003 to edit/input new extra data
c                    and save new expanded training sets
c         29/10/2006 edited 
c         14/09/2010 added plot option
c         21/06/2012 changed default for E to E = 'E' and iag(ldg) instead of iag(nobs)
c
c advice: This routine must be called, e.g. as from grp000, where there
c         have been previous calls to manovd and g03daf$ to set the
c         input values isx, m, ng, nig, nobs, nvar, det, gc, gmean, x.
c
c         iag:  workspace
c         isx: (input/unchanged) flag for included/excluded variables
c         ldx: (input/unchanged) dimension for sample x
c         ldg: (input/unchanged) dimension for gmean
c           m: (input/unchanged) number of available variables
c          ng: (input/unchanged) number of groups
c         nig: (input/unchanged) number per group
c         nin: (input/unchanged) unconnected unit for reading data
c        nobs: (input/output) number of extra observations
c        nout: (input/unchanged) preconnected unit for results
c        nvar: (input/unchanged) number of included variables
c           a: (input/unchanged) original data set
c         det: (input/unchanged) log of determinants
c          gc: (input/unchanged) R and R_j values
c       gmean: (input/unchanged) group means
c          wk:  workspace
c           x: (input/output) sample of observations
c
      implicit none
c
c arguments
c
      integer,          intent (in)    :: ldx, ldg, m, ng, nout, nvar
      integer,          intent (in)    :: isx(m), nig(ng), nin 
      integer,          intent (inout) :: nobs
      integer,          intent (inout) :: iag(ldx)
      double precision, intent (in)    :: a(ldx,m), det(ng),
     +                                    gc((ng+1)*nvar*(nvar+1)/2),
     +                                    gmean(ldg,nvar)
      double precision, intent (inout) :: wk(2*nvar), x(ldx,m)
c
c allocatables
c      
      double precision, allocatable :: ati(:,:), p(:,:), prior(:)
c
c locals
c
      integer    isend, itype, ncol, ngmax, npsav, nrmax, ntype
      parameter (isend = 2, itype = 1, ncol = 1, 
     +           npsav = 1000, ntype = 2)
      integer    icolor, ierr, ix, iy, lshade, numdec, nstart, ntext,
     +           numopt
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 1, nstart = 8,
     +           numopt = 8, ntext = nstart + numopt - 1)
      integer    numbld(ntext), numpos(numopt)
      integer    i, ifail, j, ldp, n
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
c      double precision ati(nrmax,ngmax), p(nrmax,ngmax), prior(ngmax),
c     +                 psav(npsav), psum
      double precision psav(npsav), psum
      character  equal*1, priors*1, type1*1
      character  line*100, text(ntext)*100, method(3)*40
      character  word12(4)*12, form12*12
      logical    ok, plot, repeet
      logical    atiq, fileit
      parameter (atiq = .true., fileit = .true.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .false., weight = .false.)
      external   putifa, lbox01, table1, editor, putadv, putfat, dsplay,
     +           grp002, grp003, form12
      external   g03dcf$
      save       psav
      save       equal, priors, type1
      data       psav / npsav*one /
      data       equal, priors, type1 / 'E', 'E', 'E' /
      data       numbld / ntext*0 /
      data       numpos / numopt*1 /
c
c check input parameter
c
      ngmax = ng
      nrmax = ldx
      if (nobs.lt.1) then
         call grp002 (ldx, m, nin, nobs,
     +                wk, x)
      endif
      if (nobs.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (nvar.lt.1) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (ng.lt.2) then
         write (line,300)
         call putfat (line)
         return
      endif
      if (nobs.gt.nrmax) then
         word12(1) = form12(nrmax)
         write (line,400) word12(1)
         call putfat (line)
         return
      endif
      if (ng.gt.ngmax) then
         word12(1) = form12(ngmax)
         write (line,500) word12(1)
         call putfat (line)
         return
      endif
c
c allocate
c      
      ierr = 0
      if (allocated(ati)) deallocate(ati, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(p)) deallocate(p, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(prior)) deallocate(prior, stat = ierr)
      if (ierr.ne.0) return 
      allocate (ati(nrmax,ngmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (p(nrmax,ngmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (prior(ngmax), stat = ierr)
      if (ierr.ne.0) return     
c
c  calculate the training set sample size
c
      n = 0
      do i = 1, ng
         n = n + nig(i)
      enddo
      ok = .false.
c
c main loop
c
      repeet = .true.
      do while (repeet)
         if (type1.eq.'E') then
            method(1) = 'Estimative'
         else
            method(1) = 'Predictive'
         endif
         if (equal.eq.'E') then
            method(2) = 'Equal'
         else
            method(2) = 'Unequal'
         endif
         if (priors.eq.'E') then
            method(3) = 'Equal'
         elseif (priors.eq.'P') then
            method(3) = 'Proportional'
         else
            method(3) = 'Supplied'
         endif
         word12(1) = form12(ng)
         word12(2) = form12(nvar)
         word12(3) = form12(n)
         word12(4) = form12(nobs)
         write (text,600) (word12(i), i = 1, 4), (method(i), i = 1, 3)
         if (ok) then
            numdec = numopt
         else
            numdec = 4
         endif
         numbld(1) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         if (nobs.le.0 .and. numdec.eq.4) then
            write (line,100)
            call putfat (line)
            nobs = 0
            numdec = 5
            ok = .false.
         endif
         if (numdec.eq.1) then
c
c toggle estimative/predictive
c
            ok = .false.
            if (type1.eq.'E') then
               type1 = 'P'
            else
               type1 = 'E'
            endif
         elseif (numdec.eq.2) then
c
c togge equal/unequal CV
c
            ok = .false.
            if (equal.eq.'E') then
               equal = 'U'
            else
               equal = 'E'
            endif
         elseif (numdec.eq.3) then
c
c toggle priors
c
             ok = .false.
            if (priors.eq.'E') then
               priors = 'P'
            elseif (priors.eq.'P') then
               priors = 'I'
               write (line,700)
               call putadv (line)
            elseif (priors.eq.'I') then
               priors = 'E'
            endif
         elseif (numdec.eq.4) then
c
c calculate
c
            if (priors.eq.'I') then
               write (line,700)
               call editor (isend, itype, ncol, ngmax, ng,
     +                      psav,
     +                      line,
     +                      curve, fixcol, fixrow, label, order, weight)
               psum = zero
               do i = 1, ng
                  if (psav(i).le.zero) psav(i) = one
                  psum = psum + psav(i)
               enddo
               do i = 1, ng
                  prior(i) = psav(i)/psum
               enddo
            endif
            ldp = nrmax
            ifail = 1
            call g03dcf$(type1, equal, priors, nvar, ng, nig, gmean,
     +                   ldg, gc, det, nobs, m, isx, x, ldx, prior,
     +                   p, ldp, iag, atiq, ati, wk, ifail)
            if (ifail.ne.0) then
c
c failure
c
               call putifa (ifail, nout, 'G03DCF/GRP001')
               ok = .false.
            else
c
c success so output results
c
               ok = .true.
               word12(1) = form12(n)
               word12(2) = form12(ng)
               write (nout,800) (word12(i), i = 1, 2),
     +                          (method(i), i = 1, 3)
               j = 15
               call table1 (j, 'OPEN')
               j = 4
               write (line,900)
               write (nout,900)
               call table1 (j, line)
               j = 0
               do i = 1, nobs
                  write (line,1000) i, iag(i)
                  write (nout,'(a)') line
                  call table1 (j, line)
               enddo
               call table1 (j, 'CLOSE')
               line = 'Posterior probabilities'
               call dsplay (ngmax, ng, nout, nrmax, nobs, ntype,
     +                      p,
     +                      line,
     +                      fileit)
               line = 'Atypicality indices'
               call dsplay (ngmax, ng, nout, nrmax, nobs, ntype,
     +                      ati,
     +                      line,
     +                      fileit)
            endif
         elseif (numdec.eq.5) then
c
c save expanded MANOVA file
c
            plot = .false.
            call grp003 (iag, ldx, m, n, ng, nig, nobs,
     +                   a, x,
     +                   ok, plot)
         elseif (numdec.eq.6) then
c
c plot expanded MANOVA file
c
            plot = .true.
            call grp003 (iag, ldx, m, n, ng, nig, nobs,
     +                   a, x,
     +                   ok, plot)     
         elseif (numdec.eq.7) then
c
c new/edited extra data
c
            ok = .false.
            call grp002 (ldx, m, nin, nobs,
     +                   wk, x)
            if (nobs.gt.nrmax) then
               write (line,400) nrmax
               call putfat (line)
               nobs = 0
            endif
            if (ng.gt.ngmax) then
               write (line,500) ngmax
               call putfat (line)
               nobs = 0
            endif
         else
c
c quit
c
            repeet = .false.
         endif
      enddo     
c
c deallocate
c           
      deallocate(ati, stat = ierr)           
      deallocate(p, stat = ierr)           
      deallocate(prior, stat = ierr)           
c
c format statements
c      
  100 format ('No current extra observations')
  200 format ('Number of current variables < 1')
  300 format ('Number of current groups < 2')
  400 format ('Too many extra observations: max =',1x,a)
  500 format ('Too many groups: max =',1x,a)
  600 format (
     + 'Allocating extra observations to groups'
     +/
     +/'Number of groups:',1x,a
     +/'Number of variables:',1x,a
     +/'Number of training observations:',1x,a
     +/'Number of extra observations:',1x,a
     +/
     +/'Change method: current =',1x,a
     +/'Change CV-mat: current =',1x,a
     +/'Change priors: current =',1x,a
     +/'Assign extra observations to groups'
     +/'Expanded training set: Save As ...'
     +/'Expanded training set: Plot'
     +/'Input/edit extra observations'
     +/'Quit ... Exit these group allocation options')
  700 format (
     +'Set p>0 proportional to priors ... Simfit normalises')
  800 format (
     +/'Allocating observations to groups'
     +/'Size of training set:',1x,a
     +/'Number of groups:',1x,a
     +/'Method:',1x,a
     +/'CV-mat:',1x,a
     +/'Priors:',1x,a)
  900 format ('Observation Group-allocated')
 1000 format (i6,i16)
      end
c
c
