c
c
      subroutine grp002 (ldx, m, nin, nobs,
     +                   w, x)
c
c action: get/edit comparison matrix for grp000 and grp001
c author: w.g.bardsley, university of manchester, u.k., 12/01/2005
c         29/10/2006 edited
c
c         ldx: (input/unchanged) dimension
c           m: (input/unchanged) dimension
c         nin: (input/unchanged) unconnected unit for file opening
c        nobs: (input/ouput) current dimension
c           w: workspace
c           x: (input/output) comparison data
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: ldx, m, nin
      integer,          intent (inout) :: nobs
      double precision, intent (inout) :: w(m), x(ldx,m)
c
c locals
c
      integer    jsend, ntype, numopt, numtxt
      parameter (jsend = 2, ntype = 3, numopt = 5, numtxt = 22)
      integer    numbld(numtxt)
      integer    isend, numdec
      character  line*100, text(30)*100
      character  fname*1024, title*80
      logical    abort, repeet
      logical    fixcol, fixrow, label
      parameter (fixcol = .true., fixrow = .false., label = .false.)
      logical    fileit
      parameter (fileit = .false.)
      external   putfat, listbx, mattin, dsplay, patch2, editd1
      data       numbld / numtxt*0 /
c
c check and initialise title
c
      if (m.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif
      write (title,200)
      if (nobs.lt.1) then
         write (line,300)
         call putfat (line)
      endif
c
c main loop
c
      repeet = .true.
      do while (repeet)
         write (text,400)
         numdec = 4
         call listbx (numdec, numopt, 
     +                text)
         if (nobs.lt.1) then
c
c check that edit/view are consistent
c
            nobs = 0
            if (numdec.eq.2 .or. numdec.eq.3) then
               write (line,300)
               call putfat (line)
               numdec = 0
            endif
         endif
         if (numdec.eq.1) then
c
c new data
c
            isend = 0
            close (unit = nin)
            call mattin (isend, m, m, nin, ldx, nobs,
     +                   x, w,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
             close (unit = nin)
             if (abort) nobs = 0
         elseif (numdec.eq.2) then
c
c edit existing data
c
             call editd1 (jsend, m, ldx, nobs,
     +                    x,
     +                    title)
         elseif (numdec.eq.3) then
c
c view current data
c
             call dsplay (m, m, nin, ldx, nobs, ntype,
     +                    x,
     +                    title,
     +                    fileit)
         elseif (numdec.eq.4) then
c
c help
c
            write (text,500)
            numbld(1) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
         elseif(numdec.eq.numopt) then
c
c apply
c
            repeet = .false.
         endif
      enddo        
c
c format statements
c      
  100 format ('M < 1 in call to GRP003')
  200 format ('Data for allocation to groups')
  300 format ('No data provided to assign to groups')
  400 format (
     + 'Install new extra observations'
     +/'Edit current extra observations'
     +/'View current extra observations'
     +/'Help'
     +/'Quit ... Exit these options')
  500 format (
     + 'Extra observations and existing groups as training sets'
     +/
     +/'Several procedure are available when multivariate data have'
     +/'been assigned to groups, e.g. by experimental design, partial'
     +/'dendrogram construction, or K-means clustering, and it is'
     +/'wished to either:'
     +/'a)`measure distances between extra observations and groups, or'
     +/'b)`assign extra observations to groups based on such distances.'
     +/
     +/'The groups must be provided in Simfit MANOVA format, e.g. as'
     +/'in the test file manova1.tf1, so that the groups can be used'
     +/'as training sets. It is possible to append extra data to be'
     +/'assiged to training sets onto the end of the MANOVA data file,'
     +/'as for the test file manova1.tf2, but there are other ways to'
     +/'provide the extra observations as follows:'
     +/'1)`read in extra data from a data file or the clipboard,'
     +/'2)`type in extra data from the console, or'
     +/'3)`edit the existing extra data set.'
     +/
     +/'New data must have the same number of columns as the training'
     +/'sets (which are not changed) and must have been subjected to'
     +/'the same transformations as the training set data.')
      end
c
c
