c
c
      subroutine grp003 (iag, nrmax, ncol, nrow, ng, nig, nobs,
     +                   a, b,
     +                   ok, plot)
c
c action: create an enlarged manova type file
c author: w.g.bardsley, university of manchester, u.k., 12/01/2005  
c         23/10/2006 edited
c         14/09/2010 added plot to argument list which uses MANOVG to plot 
c
c         nrmax: (input/unchanged) leading dimension
c          ncol: (input/unchanged) column dimension
c            ng: (input/unchanged) no. of groups
c           nig: (input/unchanged) group indices
c          nobs: (input/unchanged) extra observations
c             a: (input/unchanged) original data set
c             b: (input/unchanged) extra data
c            ok: (input/unchanged) ok = .true. if extra data has been assigned
c          plot: (input/unchanged) plot instead of Save As ...
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: nrmax, ncol, ng, nobs
      integer,          intent (in) :: iag(nobs), nrow, nig(ng)
      double precision, intent (in) :: a(nrmax,ncol), b(nrmax,ncol)
      logical,          intent (in) :: ok, plot
c
c allocatable
c
      character (len = 11), allocatable :: label(:)
c
c locals
c
      integer    i, icount, ierr, ios, j, jcount, k, l, n, nout, nrowa, 
     +           nstart, nstop 
      integer    i_label, j_label, k_label, m_format
      integer    isend, nwmax
      parameter (isend = 1, nwmax = 2000)
      double precision divider, temp, ten
      parameter (ten = 10.0d+00) 
      character  fname*1024, line*100, title*80, word32*32
      character  word10*10
      logical    abort, plot_labels, newdat
      logical    askif, there
      parameter (askif = .false.)
      external   putfat, ofiles, getnou, getstr, ymdhms, gettmp,
     +           deleet, manovg, triml1 
      intrinsic  min, dble, mod
      save       jcount
      data       jcount / 0 /
c
c check
c
      if (.not.ok .or. ng.le.0 .or. nobs.le.0) then
         write (line,100)
         call putfat (line)
         return
      endif
      n = 0
      do i = 1, ng
         n = n + nig(i)
      enddo
      if (n.lt.1 .or. n.ne.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c allocate labels if data set is not too large
c      
      if (nrow + nobs.le.nwmax) then
         plot_labels = .true.
         ierr = 0
         if (allocated(label)) deallocate(label, stat = ierr)
         i = nrow + nobs  
         allocate (label(i), stat = ierr)
         if (ierr.ne.0) return 
      else
         plot_labels = .false.
      endif   
         
c
c open a file
c
      call getnou (nout)
      if (plot) then
         call gettmp (i,
     +                fname)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.ne.0) then
            close(unit = nout)
            call deleet (fname,
     +                   askif, there)
            if (allocated(label)) deallocate(label, stat = ierr)
            return
         endif               
      else         
         call ofiles (isend, nout,
     +                fname,
     +                abort)
         if (abort) then
            close (unit = nout)
            if (allocated(label)) deallocate(label, stat = ierr)
            return
         endif
      endif   
c
c write out the header
c
      jcount = jcount + 1 
      call ymdhms (word32)
      
      if (plot) then
         title = 'Temporary MANOVA file'
      else 
         write (title,300) jcount, word32(10:17)
         write (line,400)          
         call getstr (line, title)
      endif   
      
      write (nout,'(a)') title
      write (nout,'(2i6)') n + nobs, ncol + 1
      
      icount = 2
      nrowa = 0
      k_label = 0
      
      do i = 1, ng
c
c i loops over groups, na moves down data matrix a, icount registers new file line
c
         i_label = i
         j_label = 0
         divider = ten
         m_format = 1
         
         do j = 1, nig(i)
c
c j loops over group members
c
            j_label = j_label + 1 
            nrowa = nrowa + 1
            icount = icount + 1
            if (ncol.le.50) then
               write (nout,500,iostat=ios) i, (a(nrowa,k), k = 1, ncol)
            else
               write (nout,500,iostat=ios) i, (a(nrowa,k), k = 1, ncol)
               nstart = 51
               nstop = min(nstart + 49,ncol)
               do k = 1, ncol/50  
                  if (nstart.le.ncol .and. nstop.le.ncol) then
                     if (ios.eq.0) write (nout,600,iostat=ios) 
     +                         (a(nrowa,l), l = nstart, nstop) 
                     nstart = min(nstop + 1, ncol)
                     nstop  = min(nstart + 49,ncol) 
                  endif   
               enddo
            endif
            if (ios.ne.0) then
               close (unit = nout)
               write (line,700) icount
               call putfat (line)
               return
            endif
            
            if (plot_labels) then
c
c define the next plot label from the training set
c              
               if (j_label.ge.10 .and. mod(j_label,10).eq.0) then
                  divider = divider*ten
                  m_format = m_format + 1
               endif   
               k_label = k_label + 1
               temp = dble(i_label) + dble(j_label)/divider
               if (m_format.eq.1) then
                  write (word10,'(f10.1)') temp
               elseif (m_format.eq.2) then
                  write (word10,'(f10.2)') temp 
               elseif (m_format.eq.3) then
                  write (word10,'(f10.3)') temp
               elseif (m_format.eq.4) then
                  write (word10,'(f10.4)') temp
               else   
                  write (word10,'(f10.5)') temp
               endif   
               call triml1 (word10)
               label (k_label) = word10
            endif
            
         enddo
         
         do j = 1, nobs
c
c j now loops over extra data
c
            if (iag(j).eq.i) then
c
c extra observation j belongs to group i
c
               icount = icount + 1
               if (ncol.le.50) then
                  write (nout,500,iostat=ios) i, (b(j,k), k = 1, ncol)
               else
                  write (nout,500,iostat=ios) i, (b(j,k), k = 1, ncol)
                  nstart = 51
                  nstop = min(nstart + 49,ncol) 
                  do k = 1, ncol/50
                     if (nstart.le.ncol .and. nstop.le.ncol) then
                       if (ios.eq.0) write (nout,600,iostat=ios) 
     +                     (b(j,l), l = nstart, nstop)
                        nstart = nstop + 1
                        nstop = min(nstart + 49,ncol) 
                     endif   
                  enddo 
              endif
              if (ios.ne.0) then
                  close (unit = nout)
                  write (line,700) icount
                  call putfat (line)
                  return
               endif
               
               if (plot_labels) then
c
c define the next label from the extra observations allocated to groups
c                 
                  k_label = k_label + 1
                  write (word10,'(i10)') j
                  call triml1 (word10)
                  label(k_label) = 'X'//word10
               endif
               
            endif
         enddo
      enddo
c
c write out the trailer then close the unit
c
      if (plot_labels) then
         i = k_label + 2
         write (nout,'(i6)') i
         write (nout,'(a)') 'begin{labels}'
         do i = 1, k_label
           write (nout,'(a)') label(i)
         enddo
         write (nout,'(a)') 'end{labels}'
      else     
         i = 1
         write (nout,'(i6)') i
         write (nout,'(a)') word32
      endif   
      close (unit = nout)
c
c plotting option
c      
      if (plot) then
         i = -1
         call manovg (i,
     +                fname,
     +                newdat)
         call deleet (fname,
     +                askif, there)
      endif          
      if (allocated(label)) deallocate(label, stat = ierr)
c
c format statements
c      
  100 format ('First assign new data to groups')
  200 format ('Error: N < 1 in call to GRP003')
  300 format ('Enlarged MANOVA file no.',i4,':',a)
  400 format ('Title for enlarged data file')
  500 format (i5,1p,50e15.7)
  600 format (5x,1p,50e15.7)
  700 format ('File creation abandoned at line',i6)
      end
c
c
