c
c
      subroutine helmrt (isend, nrmax, ncol, c, abort)
c
c action: generate an orhonormal helmert type contrast matrix
c author: w.g.bardsley, university of manchester, u.k. 08/10/2003
c
c     isend: input as type required (unchanged)
c            isend = 1: helmert (ncol - 1) by ncol contrasts only
c            isend = 2: helmert ncol by ncol with row 1 equivalent to all 1
c     nrmax, ncol: input as dimensions (unchanged)
c     c: returned as the orthonormal contrast matrix
c
      implicit   none
      integer    isend, nrmax, ncol
      integer    i, j, ncont
      double precision c(nrmax,ncol)
      double precision dncol, rowsum
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  line*100
      logical    abort
      external   putfat
      intrinsic  sqrt, dble
      abort = .true.
      if (isend.lt.1 .or. isend.gt.2 .or. ncol.gt.nrmax .or.
     +    ncol.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c generate a helmert orthonormal contrast matrix
c
      ncont = ncol - 1
      do j = 1, ncol
         do i = 1, ncont
            c(i,j) = zero
         enddo
      enddo
      do i = 1, ncont
         c(i,1) = one
         rowsum = one
         if (i.gt.1) then
            do j = 2, i
               c(i,j) = one
               rowsum = rowsum + one
            enddo
         endif
         c(i,i + 1) = - rowsum
         rowsum = zero
         do j = 1, ncol
            rowsum = rowsum + c(i,j)*c(i,j)
         enddo
         rowsum = sqrt(rowsum)
         do j = 1, ncol
            c(i,j) = c(i,j)/rowsum
         enddo
      enddo
c
c shift the rows and add a row of 1 if a full matrix is required
c
      if (isend.eq.2) then
         do i = ncol, 2, -1
            do j = 1, ncol
               c(i,j) = c(i - 1,j)
            enddo
         enddo
         dncol = dble(ncol)
         rowsum = one/sqrt(dncol)
         do i = 1, ncol
            c(1,i) = rowsum
         enddo
      endif
      abort = .false.
  100 format ('ISEND/NCOL/NRMAX out of range in call to HELMRT')
      end
c
c
