c
c
      subroutine hotel1 (isend, ncol, nout, nrmax, nrow,
     +                   a, b, c, d1, d2, p, s, tsqd, x, y, z,
     +                   abort)
c
c action: hotelling t-squared test
c author: w.g.bardsley, university of manchester, u.k., 09/09/2003
c         08/10/2003 revised
c         08/05/2016 edited format statements
c         06/07/2021 introduced e_formats and e_numbers, etc.
c
c         isend (unchanged) has following meaning:
c         isend = 0: no output, just return results
c         isend = 1: also output the results to display only
c         isend = 2: also output the results to file on nout only
c         isend = 3: also output the results to display and file on nout
c
c         ncol, nrmax, nrow: input dimensions (unchanged)
c         nout: pre-connected unit for error messages (unchanged)
c         a: input data matrix (unchanged)
c         b, c, y, z are workspaces but b is returned as the covariance
c         matrix, y as the mean vector and z as the diference z = y - x
c         x: is the input vector of test i.e. expected means (unchanged)
c         d1, d2: returned as degrees of freedom
c         p: returned as the F-test probability
c         s: returned as the F-test statistic
c         tsqd: Hotelling T-squared statistic
c         abort: returned as .true./.false. error indicator
c
      implicit   none
      integer    isend, ncol, nout, nrmax, nrow
      integer    i, icolor, ifail, ir, issp, ix, j, m, n
      integer    icount
      integer    jsend, nbig
      parameter (jsend = 2, nbig = 50)
      double precision a(nrmax,ncol), b(nrmax,ncol), c(nrmax,ncol),
     +                 d1, d2, p, s, tsqd, x(ncol), y(ncol), z(ncol)
      double precision denom, dncol, dnrow
      double precision sval(nbig), tval(nbig), pval(nbig)
      double precision g01edf$, g01ebf$
      double precision zero, one, pnt01, pnt05
      parameter (zero = 0.0d+00, one = 1.0d+00,
     +           pnt01 = 0.01d+00, pnt05 = 0.05d+00)
      double precision epsi
      parameter (epsi = 1.0d-07)
      character  line*100, resul*30, tail*1, text(10)*100, word4(nbig)*4
      character (len = 12) i12(4), form12 
      character (len = 13) d13(5), showlj, showrj
      logical    abort
      logical    e_formats, e_numbers
      external   e_formats, form12, showlj, showrj
      external   putifa, putfat, plevel, table1, xtrnax
      external   g02baf$, g01edf$, g01ebf$
      intrinsic  dble, nint, sqrt
      save       icount
      data       icount / 0 /
c
c set abort = .true. then initialise and check input parameters
c
      abort = .true.
      d1 = zero
      d2 = zero
      p = zero
      s = zero
      tsqd = zero
c
c is isend in range
c
      if (isend.lt.0 .or. isend.gt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c is n > m >= 2
c
      if (ncol.lt.2 .or. ncol.ge.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
      e_numbers = e_formats()
c
c define dncol and dnrow
c
      dncol = dble(ncol)
      dnrow = dble(nrow)
c
c calculate the cross product matrix and put it in b
c note that g02baf$ does not change the input matrix a
c
      n = nrow
      m = ncol
      ix = nrmax
      issp = nrmax
      ir = nrmax
      ifail = 1
      call g02baf$(n, m, a, ix, y, z, b, issp, c, ir, ifail)
      call putifa (ifail, nout, 'G02BAF/HOTEL1')
      if (ifail.ne.0) return
c
c transform matrix b into the covariance matrix
c
      denom = dnrow - one
      do j = 1, ncol
         do i = 1, ncol
            b(i,j) = b(i,j)/denom
         enddo
      enddo
c
c work out the difference vector of mean(calculated) - expected(supplied)
c
      do i = 1, ncol
         z(i) = y(i) - x(i)
      enddo
c
c make sure b is symmetric before calling xtrnax to calculate T-squared
c
      do i = 2, ncol
         do j = 1, i - 1
            b(i,j) = b(j,i)
         enddo
      enddo
      n = ncol
      call xtrnax (jsend, nout, nrmax, n, b, s, z, abort)
      if (abort) return
c
c calculate the parameters for return
c
      tsqd = dnrow*s
      d1 = dncol
      d2 = dnrow - dncol
      s = d2*tsqd/(d1*(dnrow - one))
      ifail = 1
      tail = 'U'
      p = g01edf$(tail, s, d1, d2, ifail)
      call putifa (ifail, nout, 'G01EDF/HOTEL1')
      if (ifail.eq.0) then
         icount = icount + 1
         if (isend.gt.0) call plevel (p, resul)
      else
         return
      endif
c
c do individual t tests on column means minus expected
c
      if (isend.gt.0 .and. ncol.le.nbig) then
         tail = 'S'
         denom = dnrow - one
         do i = 1, ncol
            sval(i) = sqrt(b(i,i)/dnrow)
            if (sval(i).gt.epsi) then
               tval(i) = z(i)/sval(i)
            else
               tval(i) = one/epsi
            endif
            ifail = 1
            pval(i) = g01ebf$(tail, tval(i), denom, ifail)
            call putifa (ifail, nout, 'G01EBF/HOTEL1')
            if (pval(i).lt.pnt01) then
               word4(i) = ' ***'
            elseif (pval(i).lt.pnt05) then
               word4(i) = '  * '
            else
               word4(i) = '    '
            endif
         enddo
      endif
c
c output to monitor
c
      if (isend.eq.1 .or. isend.eq.3) then
         if (e_numbers) then
            write (text,300) icount, nrow, ncol, tsqd, s, nint(d1),
     +                       nint(d2), p, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol) 
            i = nint(d1)
            i12(3) = form12(i)
            i = nint(d2)
            i12(4) = form12(i)
            d13(1) = showlj(tsqd)
            d13(2) = showlj(s)  
            write (text,350) icount, i12(1), i12(2), d13(1), d13(2), 
     +                       trim(i12(3)), i12(4), p, resul
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1) then
               icolor = 4
            elseif (i.eq.3) then
               icolor = 1
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
c
c individual t test results
c
         if (ncol.le.nbig) then
            write (line,500)
            icolor = 4
            call table1 (icolor, line)
            icolor = 0
            do i = 1, ncol
               if (e_numbers) then
                  write (line,600) i, y(i), sval(i), x(i), z(i),
     +                             tval(i), pval(i), word4(i)
               else
                  d13(1) = showrj(y(i))
                  d13(2) = showrj(sval(i))
                  d13(3) = showrj(x(i))
                  d13(4) = showrj(z(i))
                  d13(5) = showrj(tval(i))
                  write (line,650) i, d13(1), d13(2), d13(3), d13(4),
     +                             d13(5), pval(i), word4(i)
               endif  
               call table1 (icolor, line)
            enddo
         endif
         call table1 (icolor, 'CLOSE')
      endif
c
c output to file connected to nout
c
      if (isend.eq.2 .or. isend.eq.3) then
         if (e_numbers) then
            write (nout,400) icount, nrow, ncol, tsqd, s, nint(d1),
     +                       nint(d2), p, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol) 
            i = nint(d1)
            i12(3) = form12(i)
            i = nint(d2)
            i12(4) = form12(i)
            d13(1) = showlj(tsqd)
            d13(2) = showlj(s)  
            write (nout,450) icount, i12(1), i12(2), d13(1), d13(2), 
     +                       trim(i12(3)), i12(4), p, resul

         endif  
         if (ncol.le.nbig) then
            write (nout,500)
            do i = 1, ncol
               if (e_numbers) then
                  write (nout,600) i, y(i), sval(i), x(i), z(i),
     +                             tval(i), pval(i), word4(i)
            else
               d13(1) = showrj(y(i))
               d13(2) = showrj(sval(i))
               d13(3) = showrj(x(i))
               d13(4) = showrj(z(i))
               d13(5) = showrj(tval(i))
               write (nout,650) i, d13(1), d13(2), d13(3), d13(4),
     +                          d13(5), pval(i), word4(i)
            endif  
            enddo
         endif
      endif
c
c success so set abort = .false.
c
      abort = .false.
c
c format statements
c      
  100 format ('ISEND out of range in call to HOTEL1')
  200 format ('Data matrix must have dimensions n > m and m > 2')
  300 format (
     + 'Hotelling one sample T-square test', i4
     +/
     +/'H0: Column means equal expected values supplied'
     +/'Number of rows         =',i6 
     +/'Number of columns      =',i6
     +/'Hotelling T-square     =',1p,e13.5
     +/'F Statistic (FTS)      =',   e13.5
     +/'Deg. Free. (d1,d2)     =',i6,',',i6
     +/'p = P(F(d1,d2) >= FTS) =',0p,f10.4,2x,a)
  350 format (
     + 'Hotelling one sample T-square test', i4
     +/
     +/'H0: Column means equal expected values supplied'
     +/'Number of rows         =',1x,a
     +/'Number of columns      =',1x,a
     +/'Hotelling T-square     =',1x,a
     +/'F Statistic (FTS)      =',1x,a
     +/'Deg. Free. (d1,d2)     =',1x,a,',',1x,a
     +/'p = P(F(d1,d2) >= FTS) =',f9.4,2x,a)     
  400 format (
     +/1X,'Hotelling one sample T-square test',i4
     +/1X,'--------------------------------------'
     +/1X,'H0: Column means equal expected values supplied'
     +/1X,'Number of rows         =',i6
     +/1X,'Number of columns      =',i6
     +/1X,'Hotelling T-square     =',1p,e13.5
     +/1X,'F Statistic (FTS)      =',   e13.5
     +/1X,'Deg. Free. (d1,d2)     =',i6,',',i6
     +/1X,'p = P(F(d1,d2) >= FTS) =',0p,f10.4,2x,a)
  450 format (
     +/1X,'Hotelling one sample T-square test',i4
     +/1X,'--------------------------------------'
     +/1X,'H0: Column means equal expected values supplied'
     +/1X,'Number of rows         =',1x,a
     +/1X,'Number of columns      =',1x,a
     +/1X,'Hotelling T-square     =',1x,a
     +/1X,'F Statistic (FTS)      =',1x,a
     +/1X,'Deg. Free. (d1,d2)     =',1x,a,',',1x,a
     +/1X,'p = P(F(d1,d2) >= FTS) =',f9.4,2x,a)     
  500 format (
     +'Column',8X,'Mean',9X,'Std.Err.',5X,'Expected',9X,'Delta',
     +9X,'t',8X,'p')
  600 format (i4,2X,1p,5(1x,e13.5),0p,f10.6,a)
  650 format (i4,2x,5(1x,a),f10.6,a) 
      end
c
c
