c
c
      subroutine hotel2 (isend, ncol, nout, nrmax, nrow,
     +                   a, b, c, d1, d2, p, s, tsqd, x, y,
     +                   abort)
c
c action: Hotelling t-squared test on H0: column means are all equal
c author: w.g.bardsley, university of manchester, u.k., 09/09/2003
c         08/10/2003 revised
c         09/05/2016 changed output formats
c         06/07/2021 introduced e_formats and e_numbers, etc.
c
c         isend (unchanged) has following meaning:
c         isend = 0: no output, just return results
c         isend = 1: also output the results to display only
c         isend = 2: also output the results to file on nout only
c         isend = 3: also output the results to display and file on nout
c
c         ncol, nrmax, nrow: input dimensions (unchanged)
c         nout: pre-connected unit for error messages (unchanged)
c         a: input data matrix (unchanged)
c         b, c, y are workspaces but b is returned as the covariance
c         matrix of orthonormal contrasts, y as the mean vector, and
c         x holds the means contrast vector, while c is the helmert
c         orthonormal contrast matrix
c         d1, d2: returned as degrees of freedom
c         p: returned as the F-test probability
c         s: returned as the F-test statistic
c         tsqd: Hotelling T-squared statistic
c         abort: returned as .true./.false. error indicator
c
      implicit   none
      integer    isend, ncol, nout, nrmax, nrow
      integer    i, icolor, ifail, ir, issp, ix, j, k, l, m, n, ncont
      integer    icount
      integer    jsend, ksend
      parameter (jsend = 2, ksend = 1)
      double precision a(nrmax,ncol), b(nrmax,ncol), c(nrmax,ncol),
     +                 d1, d2, p, s, tsqd, x(ncol), y(ncol)
      double precision denom, dncol, dnrow
      double precision g01edf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  line*100, resul*30, tail*1, text(10)*100
      character (len = 12) i12(4), form12
      character (len = 13) d13(2), showlj
      logical    abort
      logical    e_formats, e_numbers
      external   e_formats, form12, showlj
      external   putifa, putfat, plevel, table1, xtrnax, helmrt
      external   g02baf$, g01edf$
      intrinsic  dble, nint
      save       icount
      data       icount / 0 /
c
c set abort = .true. then initialise and check input parameters
c
      abort = .true.
      d1 = zero
      d2 = zero
      p = zero
      s = zero
      tsqd = zero
c
c is isend in range
c
      if (isend.lt.0 .or. isend.gt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c is n > m >= 2
c
      if (ncol.lt.2 .or. ncol.ge.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c define dncol and dnrow
c
      e_numbers = e_formats()
      dncol = dble(ncol)
      dnrow = dble(nrow)
c
c calculate the cross product matrix and put it in b
c note that g02baf$ does not change the input matrix a
c
      n = nrow
      m = ncol
      ix = nrmax
      issp = nrmax
      ir = nrmax
      ifail = 1
      call g02baf$(n, m, a, ix, y, x, b, issp, c, ir, ifail)
      call putifa (ifail, nout, 'G02BAF/HOTEL2')
      if (ifail.ne.0) return
c
c transform matrix b into the covariance matrix
c
      denom = dnrow - one
      do j = 1, ncol
         do i = 1, ncol
            b(i,j) = b(i,j)/denom
         enddo
      enddo
c
c generate a helmert orthonormal contrast matrix
c
      call helmrt (ksend, nrmax, ncol, c, abort)
      ncont = ncol - 1
c
c form c*s and store in c from row ncont + 1 to 2*ncont
c
      do i = 1, ncont
         l = i + ncont
         do j = 1, ncol
            c(l,j) = zero
            do k = 1, ncol
               c(l,j) = c(l,j) + c(i,k)*b(j,k)
            enddo
         enddo
      enddo
c
c form c*s*c^T and store in b
c
      do i = 1, ncont
         l = i + ncont
         do j = 1, ncont
            b(i,j) = zero
            do k = 1, ncol
               b(i,j) = b(i,j) + c(l,k)*(c(j,k))
            enddo
         enddo
      enddo
c
c make sure cv(i,j) = cv(j,i) exactly as xtrnax has to invert
c
      do i = 2, ncont
         do j = 1, i - 1
            b(i,j) = b(j,i)
         enddo
      enddo
c
c work out c*y the means contrast vector
c
      do j = 1, ncont
         x(j) = zero
         do i = 1, ncol
            x(j) = x(j) + c(j,i)*y(i)
         enddo
      enddo
c
c calculate the T-squared value
c
      n = ncont
      call xtrnax (jsend, nout, nrmax, n, b, s, x, abort)
      if (abort) return
c
c calculate the parameters for return
c
      tsqd = dnrow*s
      d1 = dnrow - dncol + one
      d2 = (dnrow - one)*(dncol - one)
      s = d1*tsqd/d2
      d1 = dncol - one
      d2 = dnrow - dncol + one
      ifail = 1
      tail = 'U'
      p = g01edf$(tail, s, d1, d2, ifail)
      call putifa (ifail, nout, 'G01EDF/HOTEL2')
      if (ifail.eq.0) then
         icount = icount + 1
         if (isend.gt.0) call plevel (p, resul)
      else
         return
      endif
c
c output to monitor
c
      if (isend.eq.1 .or. isend.eq.3) then
         if (e_numbers) then
            write (text,300) icount, nrow, ncol, tsqd, s, nint(d1),
     +                       nint(d2), p, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol)
            i = nint(d1)
            i12(3) = form12(i)
            i = nint(d2)
            i12(4) = form12(i)
            d13(1) = showlj(tsqd)
            d13(2) = showlj(s)
            write (text,350) icount, i12(1), i12(2), d13(1), d13(2), 
     +                       trim(i12(3)), i12(4), p, resul            
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1) then
               icolor = 4
            elseif (i.eq.3) then
               icolor = 1
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         call table1 (icolor, 'CLOSE')
      endif
c
c output to file connected to nout
c
      if (isend.eq.2 .or. isend.eq.3) then
         if (e_numbers) then
            write (nout,400) icount, nrow, ncol, tsqd, s, nint(d1),
     +                       nint(d2), p, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol)
            i = nint(d1)
            i12(3) = form12(i)
            i = nint(d2)
            i12(4) = form12(i)
            d13(1) = showlj(tsqd)
            d13(2) = showlj(s)
            write (nout,450) icount, i12(1), i12(2), d13(1), d13(2), 
     +                       trim(i12(3)), i12(4), p, resul   

         endif  
      endif
c
c success so set abort = .false.
c
      abort = .false.
c
c format statements
c      
  100 format ('ISEND out of range in call to HOTEL2')
  200 format ('Data matrix must have dimensions n > m and m > 2')
  300 format (
     + 'Hotelling one sample T-square test', i4
     +/
     +/'H0: Column means equal the same value'
     +/'Number of rows         =',i6
     +/'Number of columns      =',i6
     +/'Hotelling T-square     =',1p,e13.5
     +/'F Statistic (FTS)      =',   e13.5
     +/'Deg. Free. (d1,d2)     =',i6,',',i6
     +/'p = P(F(d1,d2) >= FTS) =',0p,f10.4,2x,a)
  350 format (
     + 'Hotelling one sample T-square test', i4
     +/
     +/'H0: Column means equal the same value'
     +/'Number of rows         =',1x,a
     +/'Number of columns      =',1x,a
     +/'Hotelling T-square     =',1x,a
     +/'F Statistic (FTS)      =',1x,a
     +/'Deg. Free. (d1,d2)     =',1x,a,',',1x,a
     +/'p = P(F(d1,d2) >= FTS) =',f9.4,2x,a)     
  400 format (
     +/1X,'Hotelling one sample T-square test',i4
     +/1X,'--------------------------------------'
     +/1X,'H0: Column means equal the same value'
     +/1X,'Number of rows         =',i6
     +/1X,'Number of columns      =',i6
     +/1X,'Hotelling T-square     =',1p,e13.5
     +/1X,'F Statistic (FTS)      =',   e13.5
     +/1X,'Deg. Free. (d1,d2)     =',i6,',',i6
     +/1X,'p = P(F(d1,d2) >= FTS) =',0p,f10.4,2x,a)
  450 format (
     +/1X,'Hotelling one sample T-square test',i4
     +/1X,'--------------------------------------'
     +/1X,'H0: Column means equal the same value'
     +/1X,'Number of rows         =',1x,a
     +/1X,'Number of columns      =',1x,a
     +/1X,'Hotelling T-square     =',1x,a
     +/1X,'F Statistic (FTS)      =',1x,a
     +/1X,'Deg. Free. (d1,d2)     =',1x,a,',',1x,a
     +/1X,'p = P(F(d1,d2) >= FTS) =',f9.4,2x,a)   
      end
c
c
