
C
C
      SUBROUTINE IAXOUT (I, NBINS, NGRAF, NOUT, NUM, CDF, FACT, X,
     +                   XGRAF, XSTEP, Y, YGRAF, YSTEP, FNAME, PTITLE)
C
C ACTION : Output of data from TESTDC if required
C AUTHOR : W. G. Bardsley, 11/2/91
C          5/7/92 Changed argument list and added graphics
C          DBOS version ... 23/2/94
C          21/4/97 added CDF explicitly to argument list
C          Date of this version 21/4/97
C
      IMPLICIT   NONE
      INTEGER    NBINS, NGRAF, NOUT, NUM
      INTEGER    I(NBINS)
      INTEGER    L0, L1
      PARAMETER (L0 = 0, L1 = 1)
      INTEGER    N0, N1, N2, N4, N6, N7, N9, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N6 = 6, N7 = 7, N9 = 9,
     +           N10 = 10)
      INTEGER    J, JCOLOR, K, NSTART, NSTOP
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 15, IX = 4, IY = 4)
      DOUBLE PRECISION CDF, FACT
      DOUBLE PRECISION X(NUM), XGRAF(NGRAF), XSTEP(2*NUM)
      DOUBLE PRECISION Y(NUM), YGRAF(NGRAF), YSTEP(2*NUM)
      DOUBLE PRECISION DELTA, YVAL1, YVAL2
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      CHARACTER  FNAME*(*), PTITLE*(*)
      CHARACTER  XTITLE*17, YTITLE*29
      CHARACTER  LINE*100
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      LOGICAL    YES
      EXTERNAL   GKS004, TABLE1, YESNO2
      EXTERNAL   CDF
      INTRINSIC  DBLE
      WRITE (LINE,100)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (YES) THEN
         CALL TABLE1 (ICOLOR, 'OPEN')
         JCOLOR = N4
         WRITE (LINE,400)
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = N0
         NSTART = - N6
         NSTOP = N0
         DO K = N1, NUM/N7 + N1
            NSTART = NSTART + N7
            NSTOP = NSTOP + N7
            IF (NSTOP.GT.NUM) NSTOP = NUM
            IF (NSTART.LE.NUM) THEN
               WRITE (LINE,500) (X(J), J = NSTART, NSTOP)
               CALL TABLE1 (JCOLOR, LINE)
            ENDIF
         ENDDO
         JCOLOR = N4
         WRITE (LINE,600)
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = N0
         NSTART = - N6
         NSTOP = N0
         DO K = N1, NUM/N7 + N1
            NSTART = NSTART + N7
            NSTOP = NSTOP + N7
            IF (NSTOP.GT.NUM) NSTOP = NUM
            IF (NSTART.LE.NUM) THEN
               WRITE (LINE,500) (Y(J), J = NSTART, NSTOP)
               CALL TABLE1 (JCOLOR, LINE)
            ENDIF
         ENDDO
         JCOLOR = N4
         WRITE (LINE,700) FACT
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = N0
         NSTART = - N9
         NSTOP = N0
         DO K = N1, NBINS/N10 + N1
            NSTART = NSTART + N10
            NSTOP = NSTOP + N10
            IF (NSTOP.GT.NBINS) NSTOP = NBINS
            IF (NSTART.LE.NBINS) THEN
               WRITE (LINE,800) (I(J), J = NSTART, NSTOP)
               CALL TABLE1 (JCOLOR, LINE)
            ENDIF
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF
      IF (FNAME.NE.' ') THEN
         WRITE (LINE,200)
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
         IF (YES) THEN
            WRITE (NOUT,450)
            WRITE (NOUT,500) (X(J), J = 1, NUM)
            WRITE (NOUT,650)
            WRITE (NOUT,500) (Y(J), J = 1, NUM)
            WRITE (NOUT,750)  FACT
            WRITE (NOUT,800) (I(J), J = 1, NBINS)
         ENDIF
      ENDIF
      WRITE (LINE,300)
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (YES) THEN
         XGRAF(N1) = X(N1)
         YGRAF(N1) = CDF(XGRAF(N1))
         DELTA = (X(NUM) - X(N1))/(DBLE(NGRAF) - ONE)
         DO J = N2, NGRAF - N1
            XGRAF(J) = XGRAF(J - N1) + DELTA
            YGRAF(J) = CDF(XGRAF(J))
         ENDDO
         XGRAF(NGRAF) = X(NUM)
         YGRAF(NGRAF) = CDF(XGRAF(NGRAF))
         K = N0
         DELTA = ONE/DBLE(NUM)
         YVAL1 = ZERO
         DO J = N1, NUM
            K = K + N1
            XSTEP(K) = X(J)
            YSTEP(K) = YVAL1
            K = K + N1
            YVAL2 = YVAL1 + DELTA
            XSTEP(K) = X(J)
            YSTEP(K) = YVAL2
            YVAL1 = YVAL2
         ENDDO
         XTITLE = 'The sample values'
         YTITLE = 'Current cdf and step function'
         CALL GKS004 (L1, L1, L0, L0, L0, L0, L0, L0,
     +                NGRAF, N2*NUM, N2*NUM, N2*NUM,
     +                XGRAF, XSTEP, XSTEP, XSTEP,
     +                YGRAF, YSTEP, YSTEP, YSTEP,
     +                PTITLE, XTITLE, YTITLE, AXES, YES)
      ENDIF
  100 FORMAT ('Display tables of data/transforms ?')
  200 FORMAT ('Tables written to the output file ?')
  300 FORMAT ('Plot current cdf on step function ?')
  400 FORMAT ('Sorted data')
  450 FORMAT (/1X,'Sorted data')
  500 FORMAT (1X,1P,7E11.3)
  600 FORMAT ('Transforms')
  650 FORMAT (/1X,'Transforms')
  700 FORMAT ('Chi-sq. bins (expected =',1P,E10.3,')')
  750 FORMAT (/1X,'Chi-sq. bins (expected =',1P,E10.3,')')
  800 FORMAT (1X,10I7)
      END
C
C
