c
c
      subroutine ijkval (isend, ival, jval, kval, ncol, nrmax, 
     +                   nrow,
     +                   p, q)
      implicit none
c
c action: relate matrix p(i,j) and corresponding vectors ival, jval, kval, q(k) 
c author: w.g.bardsley, university of manchester, u.k., 01/02/2017
c
c isend = 1: input p and output ival, jval, kval, and q
c isend = 2: input kval and output ival and jval
     
c
c arguments
c      
      integer,          intent (in)    :: isend, ncol, nrmax,
     +                                    nrow
      integer,          intent (inout) :: ival(ncol*nrow),
     +                                    jval(ncol*nrow),
     +                                    kval(ncol*nrow)
      double precision, intent (in)    :: p(nrmax,ncol)
      double precision, intent (inout) :: q(ncol*nrow)
c
c locals
c      
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      integer    i, iadd1, j, nwrong
      character (len = 100) line
      external   putadv  
      if (isend.eq.1) then
c
c isend = 1: input matrix p in original order and output ival, jval,kval, and q
c       
         nwrong = 0 
         iadd1 = 0
         do i = 1, nrow
            do j = 1, ncol
               iadd1 = iadd1 + 1
               ival(iadd1) = i
               jval(iadd1) = j
               kval(iadd1) = iadd1
               q(iadd1) = p(i,j)
               if (q(iadd1).lt.zero) then
                  q(iadd1) = zero
                  nwrong = nwrong + 1
               elseif (q(iadd1).gt.one) then
                  q(iadd1) = one
                  nwrong = nwrong + 1
               endif      
            enddo  
         enddo
         if (nwrong.gt.0) then
            write (line,100) nwrong
            call putadv (line)
         endif   
      elseif (isend.eq.2) then
c
c isend = 2: input kval in arbitrary order and return i,j values for corresponding p(i,j)
c      
         do i = 1, ncol*nrow
            jval(i) = mod(kval(i),ncol)
            if (jval(i).eq.0) jval(i) = ncol
            ival(i) = (kval(i) - jval(i))/ncol + 1
         enddo   
      else
         call putadv ('ISEND out of range in call to IJKVAL')    
      endif
c
c format statement
c      
  100 format (i4,' p values < 0 or > 1 have been adjusted')      
      end         
c
c       