c
c
      subroutine indexd (nin, nout, nrmax,
     +                   x)
c
c action: diversity indices (Zar 3rd edition pages 39-42
c author: w.g.bardsley, university of manchester, u.k., 25/06/2004
c         01/12/2021 added E_NUMBERS and E_FORMATS, etc.
c
c         nin: (input/unchanged) unconnected unit for input
c        nout: (input/unchanged) preconnected unit for output
c       nrmax: (input/unchanged) dimension
c           x: workspace
c
      implicit   none
c
c arguments
c
      integer    nin, nout, nrmax
      double precision x(nrmax)
c
c locals
c
      integer    i, icount, ifail, isend, j, k, n, ntext
      parameter (ntext = 13)
      double precision dk, dn, epsi, eto2, eto10,  temp
      double precision hpmax, hprime(3)
      double precision brill(3), brmax, c, d, simp(2)
      double precision zero, one, ten, two
      parameter (zero = 0.0d+00, one = 1.0d+00, ten = 10.0d+00,
     +           two = 2.0d+00)
      double precision x02amf$, s14abf$
      character (len = 13) d13(6), showlj
      character (len = 12) i12(2), form12
      character  fname*1024, line*100, text(ntext)*100, title*80
      character  blank*1, chop80*80, word80*80
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    abort, fixnpt, label
      parameter (fixnpt = .false., label = .true.)
      external   e_formats, form12, showlj
      external   vec1in, putadv, putfat, putifa, table1, chop80
      external   x02amf$, s14abf$
      intrinsic  dble, nint, sqrt, abs, log, log10, mod
      save       icount
      data       icount / 0 /
c
c read in integer frequencies for at least 2 groups
c
      e_numbers = e_formats()
      write (line,100)
      call putadv (line)
      close (unit = nin)
      isend = 3
      call vec1in (isend, nin, nrmax, k,
     +             x,
     +             fname, title,
     +             abort, fixnpt, label)
      close (unit = nin)
      if (abort) return
      if (k.lt.2) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c check for positive integers
c
      epsi = ten*sqrt(x02amf$())
      n = 0
      dn = zero
      do i = 1, k
         if (x(i).le.zero) then
            write (line,300) i
            call putfat (line)
            return
         endif
         j = nint(x(i))
         temp = dble(j)
         if (abs(temp - x(i)).gt.epsi) then
            write (line,400) i
            call putfat (line)
            return
         endif
         n = n + j
         dn = dn + x(i)
      enddo
      if (abs(dble(n) - dn).gt.epsi) then
         write (line,500)
         call putfat (line)
         return
      endif
c
c initialise parameters and conversion factors from e to base 2 and e to base 10
c
      simp(1) = zero
      simp(2) = zero
      do i = 1, 3
        hprime(i) = zero
        brill(i) = zero
      enddo
      eto2 = one/log(two)
      eto10 = one/log(ten)
c
c do the summations as follows: (1) = base 10
c                               (2) = base e
c                               (3) = base 2
c
      do i = 1, k
c
c Simpson just requires proportions anf frequencies
c
         temp = x(i)/dn
         simp(1) = simp(1) + temp*temp
         simp(2) = simp(2) + x(i)*(x(i) - one)
c
c Shannon just requires logs
c
         temp = log(x(i))
         hprime(1) = hprime(1) + x(i)*log10(x(i))
         hprime(2) = hprime(2) + x(i)*temp
         hprime(3) = hprime(3) + x(i)*eto2*temp
         ifail = 1
c
c Brillouin requires log Gamma(x + 1) = log x!
c
         temp = s14abf$(x(i) + one, ifail)
         if (ifail.ne.0) then
            call putifa (ifail, nout, 'S14ABF/INDEXD')
            return
         endif
         brill(1) = brill(1) + eto10*temp
         brill(2) = brill(2) + temp
         brill(3) = brill(3) + eto2*temp
      enddo
c
c conclude for simpson-prime
c
      simp(2) = simp(2)/(dn*(dn - one))
c
c conclude the calculations for Shannon H-prime
c
      temp = log(dn)
      hprime(1) = (dn*log10(dn) - hprime(1))/dn
      hprime(2) = (dn*temp - hprime(2))/dn
      hprime(3) = (dn*eto2*temp - hprime(3))/dn
      dk = dble(k)
      hpmax = log(dk)
c
c conclude the calculations for Brillouin-H
c
      ifail = 1
      temp = s14abf$(dn + one, ifail)
      if (ifail.ne.0) then
         call putifa (ifail, nout, 'S14ABF/INDEXD')
         return
      endif
      brill(1) = (eto10*temp - brill(1))/dn
      brill(2) = (temp - brill(2))/dn
      brill(3) = (eto2*temp - brill(3))/dn
      c = dble(n/k)
      d = dble(mod(n, k))
      brmax = temp
      ifail = 1
      temp = s14abf$(c + one, ifail)
      if (ifail.ne.0) then
         call putifa (ifail, nout, 'S14ABF/INDEXD')
         return
      endif
      brmax = brmax - (dk - d)*temp
      temp = s14abf$(c + two, ifail)
      if (ifail.ne.0) then
         call putifa (ifail, nout, 'S14ABF/INDEXD')
         return
      endif
      brmax = brmax - d*temp
      brmax = brmax/dn
c
c output results
c
      word80 = chop80(title)
      icount = icount + 1
      write (nout,'(a)') blank
      if (e_numbers) then
         write (text,600) icount, word80, k, n,
     +                    hprime(2)/hpmax, one - hprime(2)/hpmax,
     +                    brill(2)/brmax, one - brill(2)/brmax,
     +                   (hprime(i), i = 1, 3),
     +                   (brill(i), i = 1, 3),
     +                    simp(1), one - simp(1),
     +                    simp(2), one - simp(2)
      else
         i12(1) = form12(k)
         i12(2) = form12(n)
         d13(1) = showlj(hprime(1))
         d13(2) = showlj(hprime(2))
         d13(3) = showlj(hprime(3))
         d13(4) = showlj(brill(1))
         d13(5) = showlj(brill(2))
         d13(6) = showlj(brill(3))
         write (text,650) icount, word80, i12(1), i12(2),
     +                    hprime(2)/hpmax, one - hprime(2)/hpmax,
     +                    brill(2)/brmax, one - brill(2)/brmax,
     +                   (trim(d13(i)), i = 1, 3),
     +                   (trim(d13(i)), i = 4, 6),
     +                    simp(1), one - simp(1),
     +                    simp(2), one - simp(2)



      endif  
      j = 15
      call table1 (j, 'OPEN')
      do i = 1, ntext
         if (i.eq.2) then
            j = 4
         elseif (i.eq.5) then
            j = 1
         else
            j = 0
         endif
         write (nout,'(a)') text(i)
         if (i.eq.3) text(i) = blank
         call table1 (j, text(i))
      enddo
      call table1 (j, 'CLOSE')
c
c format statements
c      
  100 format (
     +'Input positive integer frequencies from file or keyboard')
  200 format ('Must have at least two sets of frequencies (groups)')
  300 format ('Frequency =< 0 at data point',i6)
  400 format ('Not an integer at data point',i6)
  500 format ('Data are not positive integers')
  600 format (
     +/' Diversity analysis',i4
     +/' ----------------------'
     +/' Data:'
     +/1x,a
     +/' Number of groups        =',i8
     +/' Total sample size       =',i8
     +/' Pielou J-prime evenness =',f8.4,' [complement =',f7.4,']'
     +/' Brillouin J evenness    =',f8.4,' [complement =',f7.4,']'
     +/' Shannon H-prime         =',1p,e11.3,'(log10)',e11.3,'(ln)',
     +                                 e11.3,'(log2)'
     +/' Brillouin H             =',   e11.3,'(log10)',e11.3,'(ln)',
     +                                e11.3,'(log2)'
     +/' Simpson lambda          =',0p,f8.4,' [complement =',f7.4,']'
     +/' Simpson lambda-prime    =',   f8.4,' [complement =',f7.4,']')
  650 format (
     +/' Diversity analysis',i4
     +/' ----------------------'
     +/' Data:'
     +/1x,a
     +/' Number of groups        =',1x,a
     +/' Total sample size       =',1x,a
     +/' Pielou J-prime evenness =',f7.4,' [complement =',f7.4,']'
     +/' Brillouin J evenness    =',f7.4,' [complement =',f7.4,']'
     +/' Shannon H-prime         =',1x,a,' [log10],',1x,a,' [ln],',
     +                              1x,a,' [log2]'
     +/' Brillouin H             =',1x,a,' [log10],',1x,a,' [ln],',
     +                              1x,a,' [log2]'
     +/' Simpson lambda          =',f7.4,' [complement =',f7.4,']'
     +/' Simpson lambda-prime    =',f7.4,' [complement =',f7.4,']')    
      end
c
c
