c
c
      subroutine inter1 (ncol, nmax, nrow,
     +                   a,
     +                   newdat)
c 
c action: smooth interpolation of a single valued curve using j06caf
c author: w.g.bardsley, university of manchester, u.k., 05/06/2018
c 
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: ncol, nmax, nrow
      double precision,    intent (in)  :: a(nmax,ncol)
      logical,             intent (out) :: newdat  
c
c allocatable 
c      
      double precision, allocatable :: x(:), x2(:), y(:), y2(:)
c
c locals
c     
      integer    i, ios, itolf, meth, n
      integer    isend, jsend
      parameter (isend = 1, jsend = 2)
      integer    nmax1, numdec, numbld(30), numopt, numsta, ntemp, 
     +           numtxt
      parameter (nmax1 = 6000, numopt = 5, numsta = 8)
      integer   l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      parameter (l1 = 1, l2 = 0, l3 = 0, l4 = 0,
     +           m1 = 0, m2 = 5, m3 = 0, m4 = 0,
     +           n3 = 2, n4 = 2)
      double precision x3(n3), x4(n4), y3(n3), y4(n4) 
      character (len = 100) text(30)
      character (len = 30 ) method
      character (len = 12 ) form12, word12(3)
      logical    first, ok, repeet
      external   putfat, j06cfg_1, smooth$, gks004, lstbox, patch2, 
     +           form12 
      save       first
      save       itolf, meth
      save       numbld
      data       first / .true. /
      data       itolf, meth / 2000, 2 /
      data       numbld / 30*0 / 
      newdat = .false. 
      ntemp = 0  
      if (ncol.lt.2 .or. nrow.lt.2 .or. nmax1.lt.2) then
c
c dimension error
c
         call putfat (
     +'ncol < 2, nrow < 2, or nmax1 < 2 in call to INTER1')
         return        
      else
c
c initialise n then allocate
c      
         n = nrow
         allocate(x(nmax1), stat = ios)
         if (ios.ne.0) then
            deallocate(x, stat = ios) 
            return
         endif  
         allocate(x2(n), stat = ios)
         if (ios.ne.0) then
            deallocate(x2, stat = ios) 
            return
         endif      
         allocate(y(nmax1), stat = ios)
         if (ios.ne.0) then
            deallocate(y, stat = ios) 
            return
         endif 
         allocate(y2(n), stat = ios)
         if (ios.ne.0) then
            deallocate(y2, stat = ios) 
            return
         endif       
      endif
c
c initialise x and y
c
      n = nrow
      do i = 1, n
         x(i) = a(i,1)
         y(i) = a(i,2)
         x2(i) = x(i)
         y2(i) = y(i)
      enddo  
      do i = 1, 2
         x3(i) = dble(i)
         x4(i) = x3(i)
         y3(i) = x3(i)
         y4(i) = x3(i)
      enddo   
      ok = .true.
      do i = 2, n
         if (x(i).lt.x(i - 1)) then
            ok = .false.
            exit
         endif
      enddo       
      if (.not.ok) then
         ok = .true.
         do i = 1, n - 1
            if (x(i).gt.x(i + 1)) then
              ok = .false.
              exit
            endif  
         enddo  
      endif      
      if (.not.ok) then
         deallocate(x, stat = ios)
         deallocate(x2, stat = ios)
         deallocate(y, stat = ios)
         deallocate(y2, stat = ios)
         call putfat (
     +'x must be monotonically increasing or monotonically decreasing')
         return
      endif 
      if (first) then
c
c initialise parameters 
c        
         itolf = 2000
         meth = 2
         call j06cfg_1 (isend, itolf, meth)
         first = .false.
      endif   
c
c loop over options 
c      
      repeet = .true.
      do while (repeet)
         if (meth.eq.0) then
            method = 'No interpolation'
         elseif (meth.eq.1) then
            method = 'Piecewise monotonic'
         else
            method = 'Cubic Bessel'
         endif       
         word12(1) = form12(itolf)
         word12(2) = form12(n)
         word12(3) = form12(ntemp)  
         write (text,100) method, word12(1), word12(2), word12(3) 
         numtxt = numsta + numopt - 1
         numdec = 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)     
         if (numdec.eq.1) then
c
c numdec = 1: re-initialise x, x2, y, y2 then smooth and plot
c           
             do i = 1, n
                x(i) = a(i,1)
                x2(i) = x(i)
                y(i) = a(i,2)
                y2(i) = y(i)
            enddo  
            ntemp = n
            call smooth$(ntemp, nmax1,
     +                   x, y)
            n1 = ntemp
            n2 = n
            call gks004 (l1, l2, l3, l4,
     +                   m1, m2, m3, m4,
     +                   n1, n2, n3, n4,       
     +                   x, x2, x3, x4,
     +                   y, y2, y3, y4, 
     +                   method, 'x', 'y',
     +                   .true., .true.) 
         elseif (numdec.eq.2) then
c
c numdec = 2: configure
c         
            call j06cfg_1 (jsend, itolf, meth)
         elseif (numdec.eq.3) then
c
c numdec = 3: help
c
            write (text,200)
            numbld(1) = 1
            numbld(11) = 1
            numbld(14) = 1          
            numbld(17) = 1          
            numbld(20) = 1 
            numbld(23) = 1
            numtxt = 24
            call patch2 (numbld, numtxt,
     +                   text)           
            numbld(1) = 0
            numbld(11) = 0
            numbld(14) = 0          
            numbld(17) = 0          
            numbld(19) = 0  
            numbld(23) = 0    
         elseif (numdec.eq.4) then
c
c numdec = 4: return for new data
c         
            newdat = .true.
            repeet = .false.
         else
c
c numdec = 5: close
c           
            newdat = .false.
            repeet = .false.
         endif                       
      enddo
c
c deallocate
c      
      deallocate(x, stat = ios)
      deallocate(x2, stat = ios)
      deallocate(y, stat = ios) 
      deallocate(y2, stat = ios) 
c
c format statements
c      
  100 format (
     + 'Smooth interpolation of a single valued curve: y = f(x)'
     +/
     +/'Method: ',a
     +/'Tolerance:',a
     +/'Sample size: ',a 
     +/'Smoothed size: ',a 
     +/
     +/'Plot'
     +/'Change method/tolerance'
     +/'Help'
     +/'Data ... New/Edit/Transform/View'
     +/'Quit ... Exit interpolation procedure')
  200 format (
     + 'The smoothing options'
     +/
     +/'The default options should suffice for most applications where'
     +/'polylines are to be replaced by smooth continuous curves, which'
     +/'are single valued. Sometimes, for instance with very sharp and'
     +/'narrow peaks, it may be useful to make temporary changes to'
     +/'the default parameters in order see what is really going on.'
     +/'This is most likely to be required when model equations have'
     +/'been drawn using insufficient points, say < 100.'
     +/
     +/'No smoothing'
     +/'The curve will consist of joined line segments.'
     +/ 
     +/'The Piecwise momotonic method'
     +/'This fits closely but may underestimate local curvature.'
     +/
     +/'The Cubic Bessel method (The default)'
     +/'This fits loosely and may overestimate local curvature.'
     +/
     +/'ITOLF (Default = 2000)'
     +/'Reduce for a rougher curve, or increase for a smoother curve.'
     +/
     +/'Archiving coordinates for the smoothed curve'
     +/'Use Plot then [Advanced] to Save As ... the smoothed curve')     
      end
c
c              