c
c
      subroutine isxdat (isx, ncol, nrmax, nrow,
     +                   a,
     +                   abort)
c
c action: roll columns of matrix a to agree with template in isx
c author: w.g.bardsley, university of manchester, u.k., 10/07/2005
c         06/11/2006 added intents
c
c         isx: (input/unchanged) roll right to left if isx(i) = 0
c        ncol: (input/unchanged) number of columns > = 1
c       nrmax: (input/unchanged) nrmax >= nrow >= 1
c           a: (input/output) output rolled right to left as determined by isx
c              Note: a is returned padded from the right with zero columns
c       abort: (output) error indicator
c
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: ncol, nrmax, nrow
      integer,          intent (in)    :: isx(ncol)
      double precision, intent (inout) :: a(nrmax,ncol)
      logical,          intent (out)   :: abort
c
c locals
c
      integer    i, j, k, l, nvar
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      external   putfat, putwar
c
c check
c
      if (ncol.lt.1 .or. nrow.lt.1 .or. nrow.gt.nrmax .or.
     +    nrmax.lt.1) then
         abort = .true.
         write (line,100)
         call putfat (line)
         return
      else
         abort = .false.
      endif
c
c roll right to left as required by isx
c
      k = 0
      nvar = 0
      do j = 1, ncol
         if (isx(j).eq.0) then
            if (j.lt.ncol) then
               do l = j - k, ncol - k - 1
                  do i = 1, nrow
                     a(i,l) = a(i, l + 1)
                  enddo
               enddo
            endif
            do i = 1, nrow
               a(i,ncol - k) = zero
            enddo
            k = k + 1
         else
            nvar = nvar + 1
         endif
      enddo
      if (nvar.eq.0) then
         write (line,200) ncol
         call putwar (line)
      endif     
c
c format statements
c      
  100 format ('Dimension incorrect in call to ISXDAT')
  200 format ('All',i5,1x,'columns have been suppressed')
      end
c
c
