c
c
      subroutine isxedi (isx, m, nx, nxmin)
c
c action: edit an isx type vector
c author: w.g.bardsley, university of manchester, u.k., 13/04/2004
c         12/05/2004 added call to chkbox
c         07/02/2006 introduced allocatable arrays
c         06/11/2006 expanded and added intents 
c         24/11/2006 allowed nxmin = 0 to allow iszedi to work
c
c         Note: m must be =< ncmax
c
c         isx: (input/output) may be changed by isvec
c              components should be 0 or 1
c           m: (input/unchanged)
c              should be > 0 and =< ncmax
c          nx: (output)
c              number of isx(i) = 1
c       nxmin: (input/unchanged) minimum number of isx(i) > 0
c              this is set by the procedure calling isxedi
c
      implicit none
c
c arguments
c
      integer, intent (in)    :: m, nxmin
      integer, intent (out)   :: nx
      integer, intent (inout) :: isx(m)
c
c local allocatable arrays
c
      character (len = 20), allocatable :: text(:)
      logical, allocatable :: useit(:)
c
c locals
c
      integer    i, ierr
      character  title*100
c
c externals
c
      external   isxvec, chkbox, putfat
c
c check input data
c                 
      if (m.lt.1 .or. nxmin.lt.0 .or. nxmin.gt.m) then 
         write (title,100)
         call putfat (title)
         return
      endif   
c
c first of all scan the input isx
c
      call isxvec (isx, m, nx, nxmin)
      if (nxmin.gt.0 .and. nx.le.0) return
c
c allocate workspaces
c
      ierr = 0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(useit)) deallocate(useit, stat = ierr)
      if (ierr.ne.0) return
      allocate(text(m), stat = ierr)
      if (ierr.ne.0) return
      allocate(useit(m), stat = ierr)
      if (ierr.ne.0) return
c
c prepare the text and logicals for the call to chkbox
c
      write (title,200)
      do i = 1, m
         write (text(i),300) i
         if (isx(i).gt.0) then
            useit(i) = .true.
         else
            useit(i) = .false.
         endif
      enddo
      call chkbox (m,
     +             text, title,
     +             useit)
      
c
c pick up isx from useit and call isxvec to make sure
c
      do i = 1, m
         if (useit(i)) then
            isx(i) = 1
         else
            isx(i) = 0
         endif
      enddo
      call isxvec (isx, m, nx, nxmin)
c
c deallocate workspaces
c
      deallocate(text, stat = ierr)
      deallocate(useit, stat = ierr)
c
c format statements
c          
  100 format ('m < 1, nxmin < 0, or nxmin > m in call to ISXEDI')
  200 format ('Tick variables to be included')
  300 format ('Variable',i4)
      end
c
c
