c
c
      subroutine isxtyp (isx, m, nx, nxmin,
     +                   line,
     +                   iwarnu)
c
c action: create header line according to isx type
c author: w.g.bardsley, university of manchester, u.k., 22/03/2004
c         13/04/2004 added call to isxvec, revised code for n > 10,
c                    increased nmax to 30, added nx and nxmin to
c                    arguments
c         07/02/2006 allowed for unlimited m and increased nmax to 40
c         20/06/2006 corrected value m - nx output to format 100
c         06/11/2006 improved and added intents 
c         24/11/2006 allowed nxmin = 0 so iszedi can work properly
c         03/01/2022 added form12 and editing to take len(line) and m into account
c
c         isx: may be changed by call to isxvec
c           m: (input/unchanged) should be > 0 and >= nxmin
c          nx: (output) number of isx(i) > 0
c       nxmin: (input/unchanged) min. no. of isx(i) > 0
c        line: (output) returned as the header... should have at least 80 ch
c      iwarnu: (output) returned as .true. if any variables are suppressed
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: m, nxmin 
      integer,             intent (out)   :: nx
      integer,             intent (inout) :: isx(m)
      character (len = *), intent (out)   :: line
      logical,             intent (out)   :: iwarnu
c
c locals
c
      integer    i, j, k
      integer    ntop, n0, n1, n2, n3, n4, n10
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n10 = 10)
      integer    nmax 
      character (len = 12) form12, word12(2) 
      character  text*120, word2*2, word3*3
      character  blank*1
      parameter (blank = ' ')
      intrinsic  len, len_trim, min
      external   isxvec, form12, putadv
c
c initialise then check m and len(line), etc.
c
      line = blank
      iwarnu = .false.
      nx = n0
      ntop = len(line)
      if (m.le.n0 .or. nxmin.lt.n0 .or. nxmin.gt.m .or. ntop.lt.n4) then
         write (text,100)
         call putadv (text)
         j = len_trim(text)
         k = min(ntop,j)
         line = text(1:k)
         return 
      endif
c
c analyse isx
c
      call isxvec (isx, m, nx, nxmin)
c
c define iwarnu then nmax and check for m > nmax
c      
      if (m.eq.nx) then
         iwarnu = .false.
      else
         iwarnu = .true.
      endif
      nmax = ntop/n3 
      if (m.gt.nmax) then
         word12(1) = form12(m)
         word12(2) = form12(m - nx)
         write (text,200) trim(word12(1)), word12(2)
         j = len_trim(text)
         k = min(ntop,j)
         line = text(1:k)
         return
      endif
c
c create line: Write numbers/stars for variables included/suppressed
c
     
      if (m.lt.n10) then
c
c the case m < 10
c
         j = - n1
         do i = n1, m
            if (isx(i).eq.n0) then
               word2 = ' *'
            else
              write (word2,'(i2)') i
            endif
            j = j + n2
            k = j + n2
            if (k.le.ntop) line(j:k) = word2
         enddo
      else
c
c the case m >= 10
c
         j = - n2
         do i = n1, m
            if (isx(i).eq.n0) then
               word3 = '  *'
            else
               write (word3,'(i3)') i
            endif
            j = j + n3
            k = j + n3
            if (k.le.ntop) line(j:k) = word3
         enddo
      endif
c
c format statements
c                    
  100 format (
     +'m < 1, nxmin < 0, nxmin > m or len(line) < 4 in call to ISXTYP')
  200 format ('Variables:',1x,a,', Suppressed:',1x,a)
      end
c
c



