c
c
      subroutine isxvec (isx, m, nx, nxmin)
c
c action: analyse an isx type vector
c author: w.g.bardsley, university of manchester, u.k., 13/04/2004
c         06/11/2006 improved and added intents 
c         24/11/2006 allowed nxmin = 0 so iszedi can work properly
c
c         isx: (input)
c              if isx(i) =< 0, isx(i) are re-set to isx(i) = 0
c              if isx(i) > 0,  isx(i) are re-set to isx(i) = 1
c              if too many isx(i) = 0, then re-set so sum{isx(i) = 1} = nxmin
c          m: (input/unchanged)
c         nx: (output)
c             returned as the number of isx(i) = 1
c      nxmin: (input/unchanged) minimum number of isx(i) = 1
c
      implicit none
c
c arguments
c
      integer, intent (in)    :: m, nxmin
      integer, intent (out)   :: nx
      integer, intent (inout) :: isx(m)
c
c locals
c
      integer    i, j
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      character  line*100
c
c externals
c
      external putadv, putfat
c
c initialise nx
c
      nx = n0
c
c analyse isx
c
      if (m.le.n0 .or. nxmin.lt.n0 .or. nxmin.gt.m) then
c
c error exit with warning that m =< 0, etc.
c
         write (line,100)
         call putfat (line)
      else
c
c re-set isx if required and increment nx
c
         do i = n1, m
            if (isx(i).le.n0) then
               isx(i) = n0
            else
               isx(i) = n1
               nx = nx + n1
            endif
         enddo
c
c if nxmin > 0 and insufficient isx(i) = 1 have been set then restore
c                              
         if (nxmin.gt.0) then
            if (nx.lt.nxmin) then
               j = n0
               do i = n1, m
                  if (nx.lt.nxmin) then
                     if (isx(i).eq.n0) then
                        isx(i) = n1
                        nx = nx + n1
                        j = j + n1
                     endif
                  endif
               enddo
               write (line,200) j
               call putadv (line)
              if (nx.lt.nxmin) then
                  write (line,300) nx, nxmin
                  call putfat (line)
               endif
            endif
         endif   
      endif                                  
c
c format statements
c                            
  100 format ('m < 1, nxmin < 0, or nxmin > m in call to ISXVEC')
  200 format ('Number of suppressed variables restored =', i3)
  300 format ('Number of variables =',i3,', minimum required =',i3)
      end
c
c
