c
c
      subroutine iszedi (isz, m)
c
c action: specify isz(i) as -1, 0, or 1
c authot: w.g.bardsley, university of manchester, u.k., 24/11/2006
c         24/11/2010 added call to rboxes and extensive editing
c
      implicit   none
c
c arguments
c          
      integer, intent (in)    :: m
      integer, intent (inout) :: isz(m) 
c
c local allocatable array
c                        
      integer,              allocatable :: isy(:)
      character (len = 20), allocatable :: captions(:)
c
c locals
c                                     
      integer    i, ierr, j, ns, numdec, numtxt, nx, ny
      integer    numopt, numsta, n0, n1, n2, n3
      parameter (numopt = 5, numsta = 7, n0 = 0, n1 = 1, n2 = 2,
     +           n3 = 3)
      integer    numbld(30)
      character  line*100, text(30)*100, t1*1, t2*1, t3*3 
      character  ns12*12, nx12*12, ny12*12
      character  advice(3)*80, form12*12, word20*20 
      logical    iwarnu, repeet
      external   table1, patch2, lstbox, putfat, putadv, rboxes,
     +           form12 
      data       numbld / 30*0 /
c
c check m > 1
c      
      if (m.lt.n2) return
c
c allocate isy and captions and copy isz into isy
c      
      ierr = n0
      if (allocated(isy)) deallocate (isy, stat = ierr)
      if (ierr.ne.n0) return
      allocate (isy(m), stat = ierr)
      if (ierr.ne.n0) return
      if (allocated(captions)) deallocate (captions, stat = ierr)
      if (ierr.ne.n0) return
      allocate (captions(m), stat = ierr)
      if (ierr.ne.n0) return 
      do i = n1, m  
         if (isz(i).lt.n0) then
            isz(i) = -n1
         elseif (isz(i).gt.n0) then
            isz(i) = n1
         else
            isz(i) = n0
         endif         
         isy(i) = isz(i)
         word20 = 'variable '//form12(i)
         captions(i) = word20
      enddo  
      iwarnu = .true.
c
c main loop
c                     
      repeet = .true.
      do while (repeet) 
c
c calculate ns, nx, ny for the isy vector each time round
c      
         nx = n0
         ny = n0
         ns = n0
         do i = n1, m
            if (isy(i).gt.n0) then
               nx = nx + n1
            elseif (isy(i).lt.n0) then
               ny = ny + n1
            else
               ns = ns + n1
            endif 
         enddo        
c
c warn user if no x or no y variables
c                         
         ierr = n0
         if (ns.eq.m) then
            ierr = n1
            write (line,100) 'X or Y' 
         elseif (nx.le.n0) then
            ierr = n2
            write (line,100) 'X'
         elseif (ny.le.n0) then
            ierr = n3
            write (line,100) 'Y'
         endif
         if (iwarnu .and. ierr.ne.n0) call putfat (line)  
         iwarnu = .true.
         ns12 = form12(ns)
         nx12 = form12(nx)
         ny12 = form12(ny)
         write (text,200) nx12, ny12, ns12
         numtxt = numsta + numopt - n1      
         numdec = numopt - n2
         numbld(1) = n1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = n1
         if (numdec.eq.1) then                 
c
c numdec = 1: view original/current  variables
c         
            j = 15  
            call table1 (j, 'OPEN')
            write (line,300)
            j = 4
            call table1 (j, line)
            j = n0
            do i = n1, m  
               if (isz(i).gt.n0) then
                  t1 = 'X'
               elseif (isz(i).lt.n0) then
                  t1 = 'Y'
               else
                  t1 = '0'
               endif  
               if (isy(i).gt.n0) then
                  t2 = 'X'
               elseif (isy(i).lt.n0) then
                  t2 = 'Y'
               else
                  t2 = '0'
               endif
               if (isz(i).eq.isy(i)) then
                  t3 = '   '
               else
                  t3 = '***'
               endif                      
               write (line,400) i, isz(i), t1, isy(i), t2, t3
               call table1 (j, line)         
            enddo
            call table1 (j, 'CLOSE')
         elseif (numdec.eq.2) then            
c
c numdec = 2: define x, y, neither
c 
            do i = 1, m
               isy(i) = isy(i) + n2
            enddo  
            write (advice,500)
            call rboxes (isy, n3, m, n3,
     +                   advice, captions)            
            do i = n1, m
               isy(i) = isy(i) - n2
               if (isy(i).gt.n0) then
                  isy(i) = n1
               elseif (isy(i).lt.n0) then    
                  isy(i) = - n1
               endif   
            enddo
         elseif (numdec.eq.3) then 
c
c numdec = 3: help
c                             
            write (text,600)
            numtxt = 22
            numbld(1) = n1
            call patch2 (numbld, numtxt,
     +                   text) 
            numbld(1) = n0                      
         elseif (numdec.eq.4) then
c
c numdec = 4: accept changes  
c                            
            ierr = n0
            if (ns.eq.m) then
               ierr = n1
               write (line,700) 'x or y' 
            elseif (nx.le.n0) then
               ierr = n2
               write (line,700) 'x'
            elseif (ny.le.n0) then
               ierr = n3
               write (line,700) 'y'
            endif
            if (ierr.ne.n0) then
               iwarnu = .false.
               call putadv (line) 
            else   
               repeet = .false.
               do i = n1, m
                  isz(i) = isy(i)
               enddo       
            endif   
         elseif (numdec.eq.5) then 
c
c numdec = 5: calculate ns, nx, ny for the isz vector and return if OK
c                         
            nx = n0
            ny = n0
            ns = n0
            do i = n1, m
               if (isz(i).gt.n0) then
                  nx = nx + n1
               elseif (isz(i).lt.n0) then
                  ny = ny + n1
               else
                  ns = ns + n1
               endif 
            enddo          
            ierr = n0
            if (ns.eq.m) then
               ierr = n1
               write (line,700) 'x or y' 
            elseif (nx.le.n0) then
               ierr = n2
               write (line,700) 'x'
            elseif (ny.le.0) then
               ierr = n3
               write (line,700) 'y'
            endif
            if (ierr.ne.n0) then
               iwarnu = .false.
               call putadv (line) 
            else   
               repeet = .false.
            endif   
         endif
      enddo          
c
c deallocate
c      
      deallocate (captions, stat = ierr)
      deallocate (isy, stat = ierr)      
c
c format statements
c      
  100 format ('There are no current',1x,a,1x,'variables')     
  200 format (
     + 'Choosing variables as X, Y, or suppressed'
     +/
     +/'Number of X-variables =',1x,a
     +/'Number of Y-variables =',1x,a
     +/'Number of suppressed variables =',1x,a
     +/
     +/'View original/current variables'
     +/'Define variables as X, Y, or suppressed'   
     +/'Help'
     +/'Accept ... install current variables'
     +/'Quit ... restore original variables')
  300 format ('Variable  Original   Type   Current   Type') 
  400 format (i6,4x,i6,7x,a1,3x,i6,7x,a1,4x,a)   
  500 format (
     + 'Tick box 1 for variables you want to be Y'
     +/'Tick box 2 for variables you want to suppress'
     +/'Tick box 3 for variables you want to be X') 
  600 format (
     + 'Defining variables as X, Y, or suppressed.'
     +/
     +/'It is sometimes necessary to specify that some variables in a'
     +/'data matrix are to be regarded as X-variables, some are to be'
     +/'regarded as Y-variables, while some are to be excluded. For'
     +/'this purpose each variable is given an indicator variable as'
     +/'follows` 1: X-variable'
     +/'       `-1: Y-variable'
     +/'       ` 0: suppressed'
     +/
     +/'Such indicators are given original values from the data file.'
     +/'For instance, if a data set has 9 variables, then the data set'
     +/'could have appended some additional text, for instance'
     +/
     +/'begin{indicators}'
     +/' -1 -1  0  1  1  1  1  -1  0'
     +/'end{indicators}'
     +/
     +/'to show that variables 1, 2, and 8 are Y-variables, variables'
     +/'4, 5, 6, 7 are X-variables, while variables 3 and 9 are unused.' 
     +/
     +/'This control lets you to set indicator variables interactively')    
  700 format ('You cannot exit with no current',1x,a,1x,'variables') 
      end
c
c
c                  
            