C
C
      SUBROUTINE IWARNU (ISEND, NPAR, NTEST, 
     +                   ABORT)
C
C ACTION : Warn user to reconsider course of action depending on ISEND
C          Issues a warning if NPAR > NTEST
C ADVICE : ISEND, NPAR, NTEST are unchanged, ABORT is set as required
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 13/02/1992
C          21/02/1994 DBOS version 
C          27/11/2009 added INTENTS
C
C          ISEND: ISEND = 1 then possible warning otherwise silent exit
C           NPAR: number of current parameters
C          NTEST: number of parameters regarded as safe
C               
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND, NPAR, NTEST
      LOGICAL, INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 9, NUMHDR = 6)
      INTEGER    NUMBLD(NUMHDR)
      CHARACTER  HEADER(NUMHDR)*100, OPTION*100
      LOGICAL    YES
      EXTERNAL   ANSWER
      DATA       NUMBLD / 3*0, 3*1 /
      ABORT = .FALSE.
      IF (ISEND.NE.1 .OR. NPAR.LE.NTEST) RETURN
      WRITE (HEADER,100) NTEST
      WRITE (OPTION,200)
      YES = .FALSE.
      CALL ANSWER (ICOLOR, NUMBLD, NUMHDR,
     +             HEADER, OPTION,
     +             YES)
      IF (.NOT.YES) ABORT = .TRUE.
C
C Format statements
C        
  100 FORMAT (
     + 'You should only try to fit models with more than say',I3,
     +/'parameters to be estimated if:'
     +/
     +/'The data and weights used are very extensive and accurate'
     +/'The model to be fitted is correct and not overdetermined'
     +/'You have an excellent set of parameter starting estimates')
  200 FORMAT ('Are you sure you want to fit the model selected ?')
      END
C
C
