C
C
      SUBROUTINE KENCON (NCMAX, NCOL, NF, NIN, NMAX, NROW, NSMALL,
     +                   A, B, C, X,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Kendall coefficient of concordance
C AUTHOR: W. G. Bardsley, University of Manchester
C         03/03/2005 derived from NPCORR
C         20/08/2007 added NEWDAT an SUPPLY
C         20/09/2012 edited to indicate data can be used instead of ranks
C
C   NCMAX: (input/unchanged) dimension
C    NCOL: (input/output) no. of columns
C      NF: (input/unchanged) preconnected unit for results
C    NMAX: (input/unchanged) dimension
C    NROW: (input/output) no. of rows
C  NSMALL: (input/unchanged) dimension
C       A: (input/output) current data matrix
C       B: workspace
C       C: workspace
C       X: workspace
C   FNAME: (input/output) current data file name
C    FSAV: (input/output) library file names
C   TITLE: (input/output) current data title
C    TSAV: (input/output) library titles
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NMAX,
     +                                       NSMALL    
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,NCMAX), B(NMAX),
     +                                       C(NMAX,NCMAX), X(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NSMALL), TITLE,
     +                                       TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: SUPPLY 
      LOGICAL,             INTENT (OUT)   :: NEWDAT       
C
C Locals
C
      INTEGER    I, IFAIL, J, K, N
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 4)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT
      DOUBLE PRECISION W, P
      CHARACTER  CHOP80*80, LINE*80, TEXT(30)*100, SYMBOL*30, WORD80*80
      CHARACTER  AVAIL*4, BLANK*1, CIPHER*4, NOTAV*4
      PARAMETER (AVAIL = '    ', BLANK = ' ', NOTAV = '(NA)')
      CHARACTER (LEN = 12) FORM12, WORD12(3)
      LOGICAL    OK, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT, PUTIFA, LBOX01, STATMT, CHOP80, PATCH1, 
     +           TABLE1, PUTADV, PLEVEL, FORM12
      EXTERNAL   G08DAF$
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
C
C Initialise NEWDAT
C      
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCMAX.LT.2 .OR. NCOL.LT.2 .OR.
     +       NMAX.LT.2 .OR. NROW.LT.2) RETURN
      ENDIF    
      NDEC = NOPT - 1
      WORD80 = CHOP80(TITLE)
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NCOL.GT.1 .AND. NROW.GT.1) THEN
            CIPHER = AVAIL
         ELSE
            CIPHER = NOTAV
         ENDIF
         WORD12(1) = FORM12(NCOL)
         WORD12(2) = FORM12(NROW)
         WRITE (TEXT,100) WORD80, WORD12(1), WORD12(2), CIPHER
         NSTART = 9
         NUMTXT = NSTART + NOPT - 1
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT, TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
C
C Check that DATA are available if 2 is requested
C
         IF (NDEC.EQ.2) THEN
            IF (NCOL.LT.2 .OR. NROW.LT.2) THEN
               OK = .FALSE.
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NDEC = 0
            ELSE
               OK = .TRUE.
            ENDIF
         ENDIF
C
C Read in data if NDEC = 1
C
         IF (NDEC.EQ.1) THEN
C
C Data input
C
            IF (SUPPLY) THEN
                NEWDAT = .TRUE.
                RETURN
            ENDIF    
            IF (ICOUNT.EQ.0) THEN
               WRITE (LINE,300)
               CALL PUTADV (LINE)
            ENDIF
            CALL STATMT (NCMAX, NCOL, NF, NIN, NMAX, NROW, NSMALL,
     +                   A, B, X,
     +                   FNAME, FSAV, TITLE, TSAV)
            WORD80 = CHOP80(TITLE)
            IF (NCOL.LT.1 .OR. NROW.LT.1) THEN
               WORD80 = 'No data'
               NDEC = 1
            ELSE
               NDEC = 2
            ENDIF
         ELSEIF (NDEC.EQ.2 .AND. OK) THEN
C
C Analysis of data
C
            K = NROW
            N = NCOL
            IFAIL = 1
            CALL G08DAF$(A, NMAX, K, N, C, W, P, IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G08DAF/KENCON')
            IF (IFAIL.EQ.0) THEN
               ICOUNT = ICOUNT + 1
               CALL PLEVEL (P, SYMBOL)
               WORD12(3) = FORM12(ICOUNT)
               WRITE (TEXT,400) WORD12(3), WORD80, WORD12(1), WORD12(2),
     +                          W, P, SYMBOL
               NUMTXT = 9
               J = 15
               CALL TABLE1 (J, 'OPEN')
               WRITE (NF,'(A)') BLANK
               DO I = 1, NUMTXT
                  IF (I.EQ.1) THEN
                     J = 4
                  ELSEIF (I.EQ.5) THEN
                     J = 1
                  ELSE
                     J = 0
                  ENDIF
                  CALL TABLE1 (J, TEXT(I))
                  WRITE (NF,'(A)') TEXT(I)
               ENDDO
               CALL TABLE1 (J, 'CLOSE')
            ENDIF
            NDEC = NOPT
         ELSEIF (NDEC.EQ.NOPT - 1) THEN
C
C Help
C
            WRITE (TEXT,600)
            NUMTXT = 21
            NUMBLD(1) = 1
            NUMBLD(6) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = 0
            NUMBLD(6) = 0
            NDEC = 1
         ELSEIF (NDEC.EQ.NOPT) THEN
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Kendall coefficient of concordance'
     +/
     +/'Title of current data:'
     +/A
     +/
     +/'Number of columns (objects)',1x,a
     +/'Number of rows (variables)',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse current data',2X,A
     +/'Help'
     +/'Quit ... Exit Kendall coefficient of concordance')
  200 FORMAT ('Must have at least 2 rows and 2 columns')
  300 FORMAT (
     +'Data files can contain ranks or data, see test file g08daf.tf1')
  400 FORMAT (
     + 1X,'Kendall coefficient of concordance analysis',1X,A
     +/
     +/1X,'H0: no agreement between comparisons'
     +/1X,'Data title'
     +/A
     +/1X,'Number of columns (objects) =',1X,A
     +/1X,'Number of rows (variables)  =',1X,A
     +/1X,'Kendall coefficient W       =',F7.4
     +/1X,'p = P(chi-sq >= W)          =',F7.4,2X,A)
  600 FORMAT (
     + 'The Kendall coefficient of concordance, W'
     +/
     +/'This technique is used with n objects, measurements, or'
     +/'ranks, from k comparisons to test the null hypothesis'
     +/
     +/'H0: there is no agreement between the comparisons.'
     +/
     +/'Data must have n columns for data/objects/ranks (across), and'
     +/'k rows for comparisons/variables (down). The matrix can have'
     +/'original values to be ranked automatically along rows, or else'
     +/'pre-calculated ranks instead of values. Tied ranks are averaged'
     +/'as usual, so a ranked matrix must have these two properties:'
     +/'1) A(i,j) > 0 for i = 1,2,...,k and j = 1,2,...,n'
     +/'2) Sum of A(i,j) for each i and j = 1,2,...,n must = n(n + 1)/2'
     +/'See, for instance, the test file g08daf.tf1. Note that, if data'   
     +/'values are supplied, ranks will be calculated interactively.'
     +/
     +/'The coefficient of concordance W satisfies 0 =< W =< 1 and, for'
     +/'complete agreement W = 1, while W = 0 indicates no agreement.'
     +/
     +/'For n > 7, k(n -1)W is approximately chi-sq.(n - 1)')
      END
C
C
