c
c
      subroutine kernde (n, nin, nout, nrmax,
     +                   fft, smooth, t, u, v, w, w1, x,
     +                   title,
     +                   newdat, supply)
c
c action: kernel density estimation
c author: w.g.bardsley, university of manchester, u.k., 23/08/2005
c         29/02/2006 added newdat and supply to arguments
c         17/08/2006 corrected to ensure nrmax >= nbmax, npmax
c         18/10/2012 edited for the academic version of g10baf and
c                    now uses factor > 3 instead of three for slo, shi
c         12/05/2013 removed cipher
c         19/12/2021 added e_numbers and e_formats, etc.
c
c         n: (input/output) data size (supplied if n = nzsav > 0)
c       nin: (input/unchanged) unopened unit for data input
c      nout: (input/unchanged) preconnected unit for results
c     nrmax: (input/unchanged) dimension
c       fft: workspace
c    smooth: workspace
c         t: workspace
c         u: workspace
c         v: workspace
c         w: workspace
c        w1: workspace
c         x: (input/output) data (supplied if n = nzsav > 0)
c     title: (input/output) data title (supplied if n = nzsav > 0)
c    newdat: (output) .true. if supply = .true. and new data requested
c    supply: (input/unchanged) supply = .true. if data supplied
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: nin, nout, nrmax
      integer,             intent (inout) :: n
      double precision,    intent (inout) :: fft(nrmax), smooth(nrmax),
     +                                       t(nrmax), u(2*nrmax),
     +                                       v(2*nrmax), w(2*nrmax),
     +                                       w1(nrmax), x(nrmax)
      character (len = *), intent (inout) :: title
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat
c
c locals
c
      integer    i, icount, ifail, j, k, nbins, ns, ntemp, ntype
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 11, numsta = 11, numtxt = numsta + numopt - 1)
      integer    numbld(30)
      integer    nbmax, nbmin
      parameter (nbmax = 1000, nbmin = 3)
      double precision slo, shi, window, xmax, xmin
      double precision dn, stdev, xbar, xvar
      double precision zero, factor
      parameter (zero = 0.0d+00, factor = 3.5d+00)
      character  line*100, text(30)*100
      character  ptitle*50, xtitle*40, ytitle*40
      parameter (xtitle = 'values')
      character (len = 1) blank
      parameter (blank = ' ')
      character (len = 10) d10, formgr
      character (len = 12) form12, word12(3)
      character (len = 13) d13(2), showlj, showrj
      character (len = 25) wtype(3)
      character (len = 45) dline
      parameter (dline = 
     +'---------------------------------------------')
      logical    e_numbers, e_formats, first
      logical    abort, ok, ready, repeet, sorted
      logical    fixnpt, usefft
      parameter (fixnpt = .false., usefft = .false.)
      external   e_formats, formgr, revpro, showlj, showrj
      external   vecone, getjm1, lstbox, putadv, putifa, putwar, nxxbar,
     +           table1, pdplot, nxsort, patch2, cdplot, form12, listbx,
     +           getdgt  
      external   g10baf$
      intrinsic  abs, dble, min, sqrt, trim
      save       first, icount, nbins, ns, ntype
      data       first / .true. /
      data       icount, nbins, ns, ntype / 0, 5, 128, 2 /
      data       numbld / 30*0 /
      data       wtype / '[(xmax-xmin)/(nbins-2)]',
     +                   '[1.06*stdev*n^{-1/5}]',
     +                   '[User-selected]' /
c
c initialise
c
      newdat = .false.
      ok = .false.
      sorted = .false.
      stdev = zero
      if (supply) then 
         if (n.le.5) return
         xmax = x(1)
         xmin = x(1)
         do i = 2, n
            if (x(i).lt.xmin) then
               xmin = x(i)
            elseif (x(i).gt.xmax) then
               xmax = x(i)
            endif   
         enddo
         if (xmax.gt.xmin) then
            ready = .true.
         else
            n = 0
            ready = .false.
         endif
      else
         n = 0
         ready = .false.
      endif
c      
c check nbins, ns
c                
      if (nbins.gt.nrmax) then
         nbins = nrmax 
         call putadv ('NBINS > NRMAX in call to KERNDE')
      endif    
      if (ns.gt.nrmax) then
         ns = 128
         call putadv ('NS > NRMAX in call to KERNDE')
      endif   
      e_numbers = e_formats()
      icount = icount + 1
      numdec = numopt - 1
c
c main loop
c
      repeet = .true.
      do while (repeet)
         if (ready) then
            if (ntype.eq.1) then
               window = (xmax - xmin)/dble(nbins - 2)
            elseif (ntype.eq.2) then
               if (stdev.le.zero) then
                  call nxxbar (n,
     +                         x, xbar, xvar)
                  stdev = sqrt(xvar)
                endif
                dn = dble(n)
                dn  = dn**(0.2d+00)
                window = 1.06d+00*stdev/dn                      
            endif
            word12(1) = form12(n)
            word12(2) = form12(nbins)
            word12(3) = form12(ns)
         else
            n = 0
            title = 'No data'
            do i = 1, 3 
               word12(i) = '0'
            enddo
            window = zero   
         endif

         if (e_numbers) then
            write (text,100) icount, title, (word12(i), i = 1, 3),
     +                       window, wtype(ntype)
         else
            d13(1) = showlj(window)
            write (text,150) icount, title, (word12(i), i = 1, 3), 
     +                       trim(d13(1)), wtype(ntype)
         endif 
          
         if (first) then
            first = .false.
            write (nout,'(a)') blank
            write (nout,'(a)') text(1)
            write (nout,'(a)') dline
            do i = 3, 7
               if (i.ne.5) write (nout,'(a)') text(i)
            enddo
         endif      
         
         if (numdec.lt.0) numdec = - numdec
         numbld(1) = 4  
         numbld(4) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
c
c check option selected
c
         if (numdec.ge.2 .and. numdec.le.4 .and. .not.ready) then
            write (line,200)
            call putadv (line)
            numdec = -1
         endif
         if (numdec.ge.3 .and. numdec.le.5 .and. .not.ok) then
            write (line,300)
            call putadv (line)
            numdec = -2
         endif
         if (numdec.eq.1) then
c
c numdec = 1: data
c
            if (supply) then
               newdat = .true.
               return
            endif
            ok = .false.
            ready = .false.
            sorted = .false.
            stdev = zero
            call vecone (nin, nrmax, n,
     +                   x,
     +                   title,
     +                   abort, fixnpt)
            if (.not.abort .and. n.lt.2) abort = .true.
            if (.not.abort) then
               xmax = x(1)
               xmin = x(1)
               do i = 2, n
                  if (x(i).lt.xmin) xmin = x(i)
                  if (x(i).gt.xmax) xmax = x(i)
               enddo
               if (xmax.le.xmin) abort = .true.
            endif
            if (abort) then
               n = 0
               ready = .false.
               numdec = 1
            else
               if (n.le.5) then
                  write (line,400)
                  call putadv (line)
                  n = 0
                  ready = .false.
                  numdec = 1
               else
                  if (n.le.10) then
                     write (line,400)
                     call putwar (line)
                  elseif (n.le.20) then
                     write (line,400)
                     call putadv (line)
                  endif
                  ready = .true.
                  numdec = 2
               endif
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: fit
c           
            slo = xmin - factor*window
            shi = xmax + factor*window
            ifail = 1
            call g10baf$(n, x, window, slo, shi, ns, smooth, t, usefft,
     +                   fft, ifail)
            if (ifail.eq.0) then
               call putadv ('Density estimate has now been calculated')
               numdec = 5
               ok = .true.
            else
               numdec = numopt - 1
               ok = .false.
               call putifa (ifail, nout, 'G10BAF/KERNDE')
            endif
         elseif (numdec.eq.3 .or. numdec.eq.4) then
c
c numdec = 3: table and write to results file if numdec = 4a
c
            if (numdec.eq.4) then
               write (nout,'(a)') blank
               write (nout,'(a)') text(9)
               write (nout,'(a)') blank
            endif  
            j = 15
            call table1 (j, 'OPEN')
            j = 4
            write (line,500) trim(word12(3))
            if (numdec.eq.4) then
               write (nout,550) 
               write (nout,'(2i6)') ns, 2
            endif   
            call table1 (j, line)
            j = 0
            do i = 1, ns
               if (e_numbers) then
                  write (line,600) t(i), smooth(i)
                  if (numdec.eq.4) write (nout,'(a)') line
               else
                  d13(1) = showrj(t(i))
                  d13(2) = showrj(smooth(i))
                  write (line,650) d13(1), d13(2)
                  if (numdec.eq.4) write (nout,'(a)') line
               endif      
               call table1 (j, line)
            enddo
            call table1 (j, 'CLOSE')
            numdec = 5
         elseif (numdec.eq.5) then
c
c numdec = 5: plot
c
            if (.not.sorted) then
               sorted = .true.
               do i = 1, n
                  w1(i) = x(i)
               enddo
               call nxsort (n, w1)
            endif
            ntemp = nbins 
            if (e_numbers) then
               write (ptitle,'(a,1p,e10.3)')
     +               'Kernel Density Estimation: h =', window 
            else
               d10 = formgr(window)
               write (ptitle,'(a,1x,a)')
     +               'Kernel Density Estimation: h =', d10 
            endif  
            ytitle = 'Sample Histogram and pdf'
            call pdplot (ntemp, ns, nrmax, n,
     +                   smooth, w1, t, u, v,
     +                   ptitle, xtitle, ytitle)
            ytitle = 'Sample Distribution and cdf'
            call cdplot (ns, nrmax, n,
     +                   smooth, w1, t, u, v, w,
     +                   ptitle, xtitle, ytitle)
            numdec = 3
         elseif (numdec.eq.6) then
c
c numdec = 6: bins
c
            write (line,700)
            i = min(nbmin,nrmax)
            j = min(nbmax,nrmax)
            ntemp = nbins
            call getjm1 (i, nbins, j,
     +                   line)
            if (nbins.ne.ntemp .and. ntype.eq.1) ok = .false.
            numdec = 5
         elseif (numdec.eq.7) then
c
c numdec = 7: points
c
            write (line,800)
            i = 3
            j = 6
            k = 21
            call getjm1 (i, j, k,
     +                   line)
            if (2**j.lt.nrmax) then
               ns = 2**j
               ok = .false.
            else
               call putadv ('Too large for workspace provided')
            endif      
            numdec = 2
         elseif (numdec.eq.8) then
c
c numdec = 8: window
c           
            write (text,900)
            ntemp = 3
            call listbx (ntype, ntemp,
     +                   text)  
            if (ntype.eq.3) then
               call getdgt (window, zero,
     +'Window width required for Fast Fourier Transform')  
            endif   
            ok = .false.         
            numdec = 2    
         elseif (numdec.eq.numopt - 2) then
c
c Results
c         
            call revpro (nout)   
            numdec = 2  
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,1000)
            ntemp = 22
            numbld(1) = 1
            call patch2 (numbld, ntemp,
     +                   text)
            numbld(1) = 0
            numdec = 1
         elseif (numdec.eq.numopt) then
c
c cancel
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + ' Gaussian Kernel Density Estimation by FFT:',i3
     +/
     +/' Data title:'
     +/1x,a
     +/ 
     +/' Sample size =',1x,a
     +/' Number of histogram bins =',1x,a
     +/' Number of estimated pdf points =',1x,a
     +/' Window for FFT =',1p,e10.3,2x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Table: display'
     +/'Table: display and save to results file'
     +/'Plot'
     +/'Change number of histogram bins'
     +/'Change number of estimated pdf points'
     +/'Change smoothing window for FFT'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit kernel density estimation by FFT')
  150 format (
     + ' Gaussian Kernel Density Estimation by FFT:',i3
     +/
     +/' Data title:'
     +/1x,a
     +/
     +/' Sample size =',1x,a
     +/' Number of histogram bins =',1x,a
     +/' Number of estimated pdf points =',1x,a
     +/' Window for FFT =',1x,a,2x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Table: display'
     +/'Table: display and save to results file'
     +/'Plot' 
     +/'Change number :of histogram bins'
     +/'Change number of estimated pdf points'
     +/'Change smoothing window for FFT'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit kernel density estimation by FFT')     
  200 format ('First read in some data')
  300 format ('First do the calculation')
  400 format ('Sample too small for meaningful analysis')
  500 format ('             x        pdf(x)  (number of values =',
     +1x,a,')')
  550 format ('x-values and pdf estimates in Simfit data file format')    
  600 format (1p,2(1x,e13.5))
  650 format (2(1x,a13))
  700 format ('Number of histogram bins required')
  800 format ('k where the number of pdf values required = 2**k')
  900 format (
     + 'window = (xmax - xmin)/(nbins - 2)'
     +/'window = 1.06*stdev*n^{-1/5}'
     +/'window = value input')
 1000 format (
     + 'Model-free kernel density estimation by Fast Fourier Transform'
     +/
     +/'This procedure takes a sample and creates a density estimate'
     +/'based on a Gaussian kernel. The following are required.'
     +/
     +/'1.`A sample of size n, such as in the test file normal.tf1.'
     +/'  `Note that a meaningful density estimate can be created only'
     +/'  `if the sample size is reasonably large, say n >= 50.'
     +/
     +/'2.`The number of histogram bins. This does not alter the FFT'
     +/'  `and is just provided to to facilitate visualisation of the'
     +/'  `fit of the estimated pdf to the data.' 
     +/
     +/'3.`The FFT window width alters the amount of smoothing, and the'
     +/'  `default value is 1.06*{sample stdev}*n^{-1/5}, as is usually'
     +/'  `recommended for a normal distribution. It can also be set by'
     +/'  `the user, or be coupled to a value slightly larger than the'
     +/'  `histogram bin width.'
     +/
     +/'4.`The number of FFT estimated pdf points.'
     +/'  `For simple profiles values of 64 or 128 should suffice, but'
     +/'  `this can be altered to 2^k, where 3 =< k =< 21.')
      end
c
c
