c
c
      subroutine kmean1 (inc, isx, kmeans, ncol, nic, nin, nrmax, nrow,
     +                   nvar,
     +                   asav, cmeans, wt,
     +                   weight)
c
c action: call smplot to plot the K-means clusters with no labels
c author: w.g.bardsley, university of manchester, u.k., 20/10/2002
c         26/10/2006 edited and improved
c
      implicit   none 
c
c arguments
c      
      integer,          intent (in) :: kmeans, ncol, nin, nrmax, nrow,
     +                                 nvar
      integer,          intent (in) :: inc(nrow), isx(ncol), nic(kmeans)
      double precision, intent (in) :: asav(nrmax,ncol),
     +                                 cmeans(nrmax,nvar), wt(nrow)
      logical,          intent (in) :: weight
c
c locals
c      
      integer    n0, n1, n2, n3, n5
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n5 = 5)
      integer    nmax
      parameter (nmax = 300)
      integer    i, ifail, ios, j, k, ntotal, nx, nxx, ny, nyy
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      double precision x, xx, y, yy
      double precision zero
      parameter (zero = 0.0d+00)
      character  files(nmax)*1024, titles(4)*40, word6*6
      logical    askif, first, there
      parameter (askif = .false.)
      external   gettmp, deleet, triml1, getjm1, smplot, putfat, putadv
      intrinsic  min
      save       first
      data       first / .true. / 
c
c check nvar and kmeans
c 
      if (nvar.lt.n2) then
         call putfat ('insufficient variables to plot')
         return
      endif 
      if (kmeans.le.n1) then
         call putfat ('insufficient clusters to plot')
         return
      endif          
c           
c choose nx and ny, the x and y variables from asav
c
      nx = n0
      ny = n0
      if (nvar.eq.n2) then 
c
c assign nx and ny to the two free consecutive variables
c      
         do i = n1, ncol
            if (nx.eq.n0 .and. isx(i).gt.n0) then
               nx = i
            elseif (ny.eq.n0 .and. isx(i).gt.n0) then
               ny = i
            endif
         enddo
      else
c
c force user to select two non-identical free variables
c      
         do while (nx.eq.n0)
            i = n1
            j = n1
            call getjm1 (i, j, ncol, 'free variable for plotting as x')
            if (isx(j).gt.n0) then
               nx = j
            else
               call putfat ('Variable is suppressed  ...  Try again')
            endif
         enddo
         do while (ny.eq.n0)
            i = n1
            j = n2
            call getjm1 (i, j, ncol, 'free variable for plotting as y')
            if (isx(j).le.n0) then
               j = n0
               call putfat ('Variable is suppressed  ...  Try again')
            endif
            if (nx.eq.j) then
               call putfat ('Variable already chosen  ... Try again')
            else
               ny = j
            endif
         enddo
      endif
c
c first time advice
c
      if (first) then
         first = .false.
         call putadv (
     +'first plot file has data, middle are joins, last has centroids')
      endif
c
c choose nxx and nyy the x and y coordinates from cmeans
c
      if (ncol.eq.nvar) then
c
c no need to correct as no variables are suppressed
c      
         nxx = nx
         nyy = ny
      else   
c
c now map nx and ny into the internal variables nxx and nyy
c      
         nxx = n0
         do i = n1, nx
            if (isx(i).gt.n0) nxx = nxx + n1
         enddo
         nyy = n0
         do i = n1, ny
            if (isx(i).gt.n0) nyy = nyy + n1
         enddo
      endif
c
c now write the actual data centres to the first file
c
      nfiles = n1
      jfiles(nfiles) = n0
      lfiles(nfiles) = n0
      mfiles(nfiles) = n5
      close (unit = nin)
      call gettmp (ifail, 
     +             files(nfiles))
      open (unit = nin, file = files(nfiles),iostat=ios)
      if (ios.eq.n0) then
         write (nin,100,iostat=ios)
         if (weight) then   
c
c write ntotal values to the file if weight = .true.
c         
            ntotal = n0
            do i = n1, nrow
               if (wt(i).gt.zero) ntotal = ntotal + n1
            enddo
            write (nin,200,iostat=ios) ntotal, n2
            do i = n1, nrow
               if (ios.eq.n0 .and. wt(i).gt.zero)
     +         write (nin,300,iostat=ios) asav(i,nx), asav(i,ny)
            enddo
         else  
c
c otherwise write nrow values to the file
c         
            write (nin,200,iostat=ios) nrow, n2
            do i = n1, nrow
               if (ios.eq.n0)
     +         write (nin,300,iostat=ios) asav(i,nx), asav(i,ny)
            enddo
         endif
      endif
      close (unit = nin)
c
c loop over the kmeans clusters to create lines from centroids to data
c point then back to centroid for each of the kmeans groups
c
      do k = n1, min(kmeans, nmax - n2)
c
c define nfiles, jfiles, lfiles, mfiles xx, yy, and files for group k
c
         nfiles = nfiles + n1
         jfiles(nfiles) = n0
         lfiles(nfiles) = n1
         mfiles(nfiles) = n0
         xx = cmeans(k,nxx)
         yy = cmeans(k,nyy)
         close (unit = nin)
         call gettmp (ifail, files(nfiles))
c
c open files and write the headers
c
         open (unit = nin, file = files(nfiles), iostat=ios)
         if (ios.eq.n0) write (nin,100,iostat=ios)
         if (ios.eq.n0) write (nin,200,iostat=ios) n3*nic(k), n2
c
c write the data in groups of three as centroid-to-point-to-centroid
c
         if (ios.eq.n0 .and. weight) then
            do i = n1, nrow
               if (wt(i).gt.zero .and. inc(i).eq.k) then
                  x = asav(i,nx)
                  y = asav(i,ny)
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
                  if (ios.eq.n0) write (nin,300,iostat=ios) x, y
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
               endif
            enddo
         elseif (ios.eq.n0) then
            do i = n1, nrow
               if (inc(i).eq.k) then
                  x = asav(i,nx)
                  y = asav(i,ny)
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
                  if (ios.eq.n0) write (nin,300,iostat=ios) x, y
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
               endif
            enddo
         endif
         close (unit = nin)
      enddo
c
c write the centroids to the last file
c
      nfiles = nfiles + n1
      jfiles(nfiles) = n0
      lfiles(nfiles) = n0
      mfiles(nfiles) = n1
      close (unit = nin)
      call gettmp (ifail, files(nfiles))
      open (unit = nin, file = files(nfiles),iostat=ios)
      if (ios.eq.n0) write (nin,100)
      if (ios.eq.n0) write (nin,200) kmeans, n2
      if (ios.eq.n0) then
         do i = n1, kmeans
            if (ios.eq.n0)
     +      write (nin,300,iostat=ios) cmeans(i,nxx), cmeans(i,nyy)
         enddo
      endif
      close (unit = nin)
c
c assign titles for plotting then call smplot to plot the clusters
c
      write (titles(1),400)
      write (word6,500) nx
      call triml1 (word6)
      write (titles(2),600) word6
      write (word6,500) ny
      call triml1 (word6)
      write (titles(3),600) word6
      titles(4) = ' '
      call smplot (jfiles, lfiles, mfiles, nfiles, 
     +             files, titles)
c
c finally clean up by deleting the temporary files
c
      do i = n1, nfiles
         call deleet (files(i), askif, there)
      enddo
  100 format ('Temporary file')
  200 format (2i6)
  300 format (1p,2e12.4)
  400 format ('K-means clusters')
  500 format (i6)
  600 format ('Variable ',a)
      end
c
c
