c
c
      subroutine kmean2 (inc, isx, kmeans, ncol, nic, nin, nrmax, nrow,
     +                   nvar, nwords,
     +                   asav, cmeans, wt,
     +                   wordx,
     +                   weight)
c
c action: call smplot to plot the K-means clusters with labels
c author: w.g.bardsley, university of manchester, u.k., 20/10/2002  
c         26/10/2006 edited and improved 
c         05/06/2007 added fname and sim256
c         22/12/2007 added nwmax
c         25/12/2007 added f$rotate.tmp
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: kmeans, ncol, nin, nrmax, nrow,
     +                                 nvar, nwords
      integer,          intent (in) :: inc(nrow), isx(ncol), nic(kmeans)
      double precision, intent (in) :: asav(nrmax,ncol),
     +                                 cmeans(nrmax,nvar), wt(nrow)
      character,        intent (in) :: wordx(nwords)*(*)
      logical,          intent (in) :: weight
c
c locals
c
      integer    n0, n1, n2, n3, n5
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n5 = 5)
      integer    nmax, nwmax
      parameter (nmax = 300, nwmax = 2000)
      integer    i, ifail, ios, j, k, ntotal, nx, nxx, ny, nyy
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      double precision x, xx, y, yy
      double precision zero
      parameter (zero = 0.0d+00) 
      character  fname*1024, sim256*1024
      character  files(nmax)*1024, titles(4)*40, word6*6
      character  labfil*12, not_enough*80, rotfil*12, too_many*80
      parameter (
     +    labfil = 'f$labels.tmp',
     +not_enough = 'Insufficient labels supplied for plotting',
     +    rotfil = 'f$rotate.tmp',
     +  too_many = 'Too many labels to plot ... maximum = 2000')
      logical    askif, first, there
      parameter (askif = .false.)
      external   gettmp, deleet, triml1, getjm1, smplot, putfat,
     +           putadv, sim256
      intrinsic  min
      save       first
      data       first / .true. /
c
c check dimensions
c
      if (weight) then
         ntotal = n0
         do i = n1, nrow
            if (wt(i).gt.zero) ntotal = ntotal + n1
         enddo
      else
         ntotal = nrow
      endif
      if (ntotal.lt.n1) return
      if (ntotal.gt.nwords) then
         call putfat (not_enough)
         return
      endif 
      if (ntotal.gt.nwmax) then
         call putfat (too_many)
         return
      endif   
c
c define fname
c             
      fname = sim256(labfil)
      call deleet (fname,
     +             askif, there)
      if (there) then
         call putfat ('You must attrib -r f$labels.tmp then delete')
         return
      else
         close (unit = nin)
         open (unit = nin, file = fname)
         if (weight) then
            do i = n1, nrow
               if (wt(i).gt.zero) write (nin,'(a)') wordx(i)
            enddo
         else
            do i = n1, nrow
               write (nin,'(a)') wordx(i)
            enddo
         endif
         close (unit = nin)
      endif
c
c choose nx and ny, the x and y variables from asav
c
      nx = n0
      ny = n0
      if (nvar.eq.n2) then
         do i = n1, ncol
            if (nx.eq.n0 .and. isx(i).gt.n0) then
               nx = i
            elseif (ny.eq.n0 .and. isx(i).gt.n0) then
               ny = i
            endif
         enddo
      else
         do while (nx.eq.n0)
            i = n1
            j = n1
            call getjm1 (i, j, ncol, 'variable for plotting as x')
            if (isx(j).gt.n0) then
               nx = j
            else
               call putfat ('Variable is suppressed  ...  Try again')
            endif
         enddo
         do while (ny.eq.n0)
            i = n1
            j = n2
            call getjm1 (i, j, ncol, 'variable for plotting as y')
            if (isx(j).le.n0) then
               j = n0
               call putfat ('Variable is suppressed  ...  Try again')
            endif
            if (nx.eq.j) then
               call putfat ('Variable already chosen  ... Try again')
            else
               ny = j
            endif
         enddo
      endif
c
c choose nxx and nyy the x and y coordinates from cmeans
c
      if (ncol.eq.nvar) then
         nxx = nx
         nyy = ny
      else
         nxx = n0
         do i = n1, nx
            if (isx(i).gt.n0) nxx = nxx + n1
         enddo
         nyy = n0
         do i = n1, ny
            if (isx(i).gt.n0) nyy = nyy + n1
         enddo
      endif
c
c first time advice
c
      if (first) then
         first = .false.
         call putadv (
     +'first plot file has data, middle are joins, last has centroids')
      endif
c
c write the actual data centres to the first file
c
      nfiles = n1
      jfiles(nfiles) = n0
      lfiles(nfiles) = n0
      mfiles(nfiles) = n1
      close (unit = nin)
      call gettmp (ifail, files(nfiles))
      open (unit = nin, file = files(nfiles),iostat=ios)
c
c ------------------------------------------------
c format 1000 must NOT be changed on the next line
c ------------------------------------------------
c
      if (ios.eq.n0) write (nin,1000)
      if (ios.eq.n0 .and. weight) then
         write (nin,200,iostat=ios) ntotal, n2
         do i = n1, nrow
            if (ios.eq.n0 .and. wt(i).gt.zero)
     +      write (nin,300,iostat=ios) asav(i,nx), asav(i,ny)
         enddo
      elseif (ios.eq.n0) then
         write (nin,200,iostat=ios) nrow, n2
         do i = n1, nrow
            if (ios.eq.n0)
     +      write (nin,300,iostat=ios) asav(i,nx), asav(i,ny)
         enddo
      endif
      close (unit = nin)

      fname = sim256(rotfil)
      open (unit = nin, file = fname, iostat = ios)
c
c ------------------------------------------------
c format 2000 must NOT be changed on the next line
c ------------------------------------------------
c
      if (ios.eq.n0) write (nin,2000)
      if (ios.eq.n0 .and. weight) then
         write (nin,200,iostat=ios) ntotal, n5
         do i = n1, nrow
            if (ios.eq.n0 .and. wt(i).gt.zero)
     +      write (nin,350,iostat=ios) asav(i,nx), zero, asav(i,ny),
     +                                 zero, zero
         enddo
      elseif (ios.eq.n0) then
         write (nin,200,iostat=ios) nrow, n5
         do i = n1, nrow
            if (ios.eq.n0)
     +      write (nin,350,iostat=ios) asav(i,nx), zero, asav(i,ny),
     +                                 zero, zero  
         enddo
      endif
      close (unit = nin)
c
c loop over the kmeans clusters
c
      do k = n1, min(kmeans, nmax - n2)
c
c define nfiles, jfiles, lfiles, mfiles xx, yy, and files
c
         nfiles = nfiles + n1
         jfiles(nfiles) = n0
         lfiles(nfiles) = n1
         mfiles(nfiles) = n0
         xx = cmeans(k,nxx)
         yy = cmeans(k,nyy)
         close (unit = nin)
         call gettmp (ifail, files(nfiles))
c
c open files and write the headers
c
         open (unit = nin, file = files(nfiles), iostat=ios)
         if (ios.eq.n0) write (nin,100,iostat=ios)
         if (ios.eq.n0) write (nin,200,iostat=ios) n3*nic(k), n2
c
c write the data in groups of three as centroid-to-point-to-centroid
c
         if (ios.eq.n0 .and. weight) then
            do i = n1, nrow
               if (wt(i).gt.zero .and. inc(i).eq.k) then
                  x = asav(i,nx)
                  y = asav(i,ny)
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
                  if (ios.eq.n0) write (nin,300,iostat=ios) x, y
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
               endif
            enddo
         elseif (ios.eq.n0) then
            do i = n1, nrow
               if (inc(i).eq.k) then
                  x = asav(i,nx)
                  y = asav(i,ny)
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
                  if (ios.eq.n0) write (nin,300,iostat=ios) x, y
                  if (ios.eq.n0) write (nin,300,iostat=ios) xx, yy
               endif
            enddo
         endif
         close (unit = nin)
      enddo
c
c write the centroids to the last file
c
      nfiles = nfiles + n1
      jfiles(nfiles) = n0
      lfiles(nfiles) = n0
      mfiles(nfiles) = n1
      close (unit = nin)
      call gettmp (ifail, files(nfiles))
      open (unit = nin, file = files(nfiles),iostat=ios)
      if (ios.eq.n0) write (nin,100)
      if (ios.eq.n0) write (nin,200) kmeans, n2
      if (ios.eq.n0) then
         do i = n1, kmeans
            if (ios.eq.n0)
     +      write (nin,300,iostat=ios) cmeans(i,nxx), cmeans(i,nyy)
         enddo
      endif
      close (unit = nin)
c
c assign titles for plotting then call smplot to plot the clusters
c
      write (titles(1),400)
      write (word6,500) nx
      call triml1 (word6)
      write (titles(2),600) word6
      write (word6,500) ny
      call triml1 (word6)
      write (titles(3),600) word6
      titles(4) = ' '
      call smplot (jfiles, lfiles, mfiles, nfiles, 
     +             files, titles)
c
c finally clean up by deleting the temporary files
c
      do i = n1, nfiles
         call deleet (files(i), askif, there)
      enddo   
c
c format statements
c      
  100 format ('Temporary file')
  200 format (2i6)
  300 format (1p,2e13.5)
  350 format (1p,5e13.5)
  400 format ('K-means clusters')
  500 format (i6)
  600 format ('Variable ',a)
c
c --------------------------------------------------------------------------------
c formats 1000 and 2000 must NOT be translated as they tell simplot to plot labels
c ---------------------------------------------------------------------------------
c
 1000 format ('%simfitplotlabelsfile%')
 2000 format ('%simfitrotatelabelsfile%')
      end
c
c
