c
c
      subroutine kmean3 (inc, isx, kmeans, ldc, ldx, ncol, nic,
     +                   nin, nrow, nvar, nwords,
     +                   cmeans, r, w, x,
     +                   ttype, wordx, wtype,
     +                   weight)
c
c action: write kmeans clusters to a MANOVA type file
c author: w.g.bardsley, university of manchester, u.k., 10/07/2004
c         14/01/2005 changed output formats for more significant figures
c         26/10/2006 revised for large files, added wordx, and other changes
c
c        Note: argument values supplied must be exactly as returned
c              after successful K-means clustering using g03eff
c
c         inc: (input/unchanged) cluster allocation
c         isx: (input/unchanged) variable indicator
c      kmeans: (input/unchanged) number of clusters
c         ldc: (input/unchanged) leading dimension of cmeans
c         ldx: (input/unchanged) leading dimension of x
c        ncol: (input/unchanged) number of potential variables
c         nic: (input/unchanged) number of objects per cluster
c         nin: (input/unchanged) unconnected unit for file saving
c        nrow: (input/unchanged) number of observations
c        nvar: (input/unchanged) number of actual variables
c      nwords: (input/unchanged) number of labels
c      cmeans: (input/unchanged) cluster means
c           r: (input/unchanged) weights
c           w:  workspace
c           x: (input/unchanged) data
c       ttype: (input/unchanged) transformation type
c       wordx: (input/unchanged) labels
c       wtype: (input/unchanged) weighting type
c      weight: (input/unchanged) weighting indicator
c
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: kmeans, ldc, ldx, ncol,
     +                                       nrow, nvar, nwords
      integer,             intent (in)    :: inc(nrow), isx(ncol),
     +                                       nic(kmeans), nin
      double precision,    intent (in)    :: cmeans(ldc,nvar), r(nrow),
     +                                       x(ldx,ncol)
      double precision,    intent (inout) :: w(nrow + nvar)
      character (len = *), intent (in)    :: ttype, wordx(nwords), wtype
      logical,             intent (in)    :: weight 
c
c local allocatable array
c                        
      character (len = 40), allocatable :: wordy(:)
c
c locals
c
      integer    i, icount, ierr, j, jcount, k, l, nstart, nstop, ntotal
      integer    icolor, isend, ix, iy
      parameter (icolor = 4, isend = 1, ix = 4, iy = 4) 
      integer    n0, n1, n2, n19, n49, n50, n51
      parameter (n0 = 0, n1 = 1, n2 = 2, n19 = 19, n49 = 49, n50 = 50,
     +           n51 = 51)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  fname*1024, line*100, title*80, word32*32
      logical    abort  
      external   putfat, ofiles, getstr, yesno2, putadv, ymdhms
c
c check data supplied
c
      if (nrow.lt.n2  .or. nvar.lt.n1 .or. ncol.lt.nvar .or.
     +    ldx.lt.nrow .or. ldc .lt.kmeans) then
         write (line,100)
         call putfat (line)
         return
      endif
      j = n0
      do i = n1, ncol
         if (isx(i).gt.0) j = j + n1
      enddo
      if (j.ne.nvar) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (weight) then
         ntotal = n0
         do i = n1, nrow
            if (r(i).gt.zero) ntotal = ntotal + n1
         enddo
      else
         ntotal = nrow
      endif
      j = n0
      do i = n1, kmeans
         j = j + nic(i)
      enddo
      if (j.ne.ntotal) then
         write (line,300)
         call putfat (line)
         return
      endif
c
c see if all groups have no. observations >= no. variables
c
      icount = n0
      do i = n1, kmeans
         if (nic(i).lt.nvar) icount = icount + n1
      enddo
      if (icount.gt.n0) then
         write (line,400) icount
         abort = .true.
         call yesno2 (icolor, ix, iy, 
     +                line,
     +                abort)
         if (abort) return
      endif
c
c allocate workspace
c                   
      ierr = n0
      if (allocated(wordy)) deallocate(wordy, stat = ierr)
      if (ierr.ne.n0) return
      allocate (wordy(ntotal), stat = ierr)
      if (ierr.ne.n0) return
c
c open a file
c
      close (unit = nin)
      call ofiles (isend, nin,
     +             fname,
     +             abort)
      if (abort) then 
         deallocate(wordy, stat = ierr)
         close (unit = nin)
         return
      endif    
      
c write title and dimensions onto the file
c                      
      call ymdhms (word32)
      write (line,500)
      write (title,600) word32(10:17)
      call getstr (line, title)
      write (nin,'(a)') title
      write (nin,'(2i6)') ntotal, nvar + n1
c
c write groups out sequentially using w(nvar + i) < 0 if already used
c
      if (weight) then
         do i = n1, nrow
            if (r(i).gt.zero) then
               w(nvar + i) = one
            else
               w(nvar + i) = - one
            endif
         enddo
      else
         do i = n1, nrow
            w(nvar + i) = one
         enddo
      endif
c
c loop over the kmeans groups: j = group number
c                
      k = n0
      do j = n1, kmeans
         i = n0
         icount = n0
c
c loop over unassigned data: i = row number
c
         do while (icount.lt.nic(j))
            i = i + n1
            if (w(nvar + i).gt.zero) then
c
c test if observation is in group j
c
               if (inc(i).eq.j) then
                  w(nvar + i) = - one
                  icount = icount + n1
                  jcount = n0
                  k = k + n1
                  wordy(k) = wordx(i)
c
c only write active variables out to the file
c
                  do l = n1, ncol
                     if (isx(l).gt.n0) then
                        jcount = jcount + n1
                        w(jcount) = x(i,l)
                     endif
                  enddo
                  if (nvar.le.n50) then
                     write (nin,700) j, (w(l), l = n1, nvar)
                  else
                     write (nin,700) j, (w(l), l = n1, 50) 
                     nstart = n51
                     nstop = min(nstart + n49, nvar)
                     do k = n1, nvar/n50  
                        if (nstart.le.nvar .and.nstop.le.nvar) then
                           write (nin,800) (w(l), l = nstart, nstop)
                           nstart = min(nstop + n1, nvar)
                           nstop = min(nstart + n49, nvar)
                        endif   
                     enddo 
                  endif
               endif
            endif
         enddo
      enddo
c
c write the file trailer then close the file
c
      write (nin,'(i6)') (kmeans + n1)*(nvar/n50 + n1) + ntotal + n19
      write (nin,900)
      do i = n1, kmeans 
         if (nvar.le.n50) then
            write (nin,800) (cmeans(i,j), j = n1, nvar)
         else
            write (nin,800) (cmeans(i,j), j = n1, n50)  
            nstart = n51
            nstop = min(nstart + n49, nvar)
            do k = n1, nvar/n50  
               if (nstart.le.nvar .and.nstop.le.nvar) then
                  write (nin,800) (cmeans(i,j), j = nstart, nstop)
                  nstart = min(nstop + n1, nvar)
                  nstop = min(nstart + n49, nvar)
               endif   
            enddo 
         endif
      enddo  
      write (nin,1000)
      write (nin,1100)
      do i = n1, ntotal
         write (nin,'(a)') wordy(i)
      enddo
      write (nin,1200)
      write (nin,1300)
      if (nvar.le.n50) then
         write (nin,1400) (n1, j = n1, nvar)
      else
         write (nin,1400) (n1, j = n1, n50)  
         nstart = n51
         nstop = min(nstart + n49, nvar)
         do k = n1, nvar/n50  
            if (nstart.le.nvar .and.nstop.le.nvar) then
               write (nin,1400) (n1, j = nstart, nstop)
               nstart = min(nstop + n1, nvar)
               nstop = min(nstart + n49, nvar)
            endif   
         enddo 
      endif
      write (nin,1500)
      write (nin,1600) ttype, wtype
      write (nin,'(a)') word32
      close (unit = nin)
c
c warn user if any variables have been suppressed then deallocate
c
      if (nvar.lt.ncol) then
         write (line,1700) ncol - nvar
         call putadv (line)
      endif
      if (ntotal.lt.nrow) then
         write (line,1800) nrow - ntotal
         call putadv (line)
      endif                           
      deallocate(wordy, stat = ierr)
c
c format statements
c      
  100 format ('Inconsistent dimensions in call to KMEAN3')
  200 format ('ISX and NVAR inconsistent in call to KMEAN3')
  300 format ('NIC and NROW inconsistent in call to KMEAN3')
  400 format (i4,1x,
     +'Groups with no. observed < no. variables ... Cancel file')
  500 format ('Title for the MANOVA type file')
  600 format ('MANOVA type file:',a)
  700 format (i5,1p,50e13.5)
  800 format (5x,1p,50e13.5)
  900 format ('begin{values}')
 1000 format ('end{values}')
 1100 format ('begin{labels}')
 1200 format ('end{labels}')
 1300 format ('begin{indicators}')
 1400 format (50i3)
 1500 format ('end{indicators}') 
 1600 format (
     + '[TRANSFORMED SPACE] =',1x,a
     +/'Current weighting =',1x,a
     +/'The structure of this MANOVA type file after K-means analysis:'
     +/'Line 1 = title you have chosen'
     +/'Line 2 = no. of non-suppressed data rows and variables'
     +/'Then column 1 = group assigned and data in [TRANSFORMED SPACE]'
     +/'Then the number of extra lines (* see below)'
     +/'Then the cluster centroids in [TRANSFORMED SPACE]'
     +/'This file is ready for MANOVA analysis but you can replace the'
     +/'centroids by new observations in [TRANSFORMED SPACE] to'
     +/'calculate Mahalanobis distances or allocate new observations'
     +/'to groups as training sets (You may have to edit at * above).')
 1700 format (i4,1x,'of the variables are currently suppressed')
 1800 format (i4,1x,'of the observations are currently suppressed')
      end
c
c
