c
c
      subroutine kmean4 (isx, ncol, nrmax, nrow, nvar,
     +                   x)
c
c action: randomise x for K-means starting cluster estimates
c author: w.g.bardsley, university of manchester, u.k., 11/07/2004
c         27/10/2006 introduced isxdat to roll matrix if required
c         06/01/2022 added e_numbers and e_formats, etc.
c
c          isx: (input/unchanged) variable inclusion indicator
c         ncol: (input/unchanged) no. of columns
c        nrmax: (input/unchanged) leading dimension
c         nrow: (input/unchanged) no. of rows
c         nvar: (input/unchanged) no. of variables
c            x: (input/output) as follows:
c                 input: as a COPY of the full current starting matrix 
c                        already transformed but before variable suppression
c                        The original default copy should not be overwritten
c                        by the matrix returned from this routine as this 
c                        would destroy the intention of this routine
c                output: after randomisation and rolling if any variables 
c                        are to be suppressed 
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: ncol, nrmax, nrow, nvar
      integer,          intent (in)    :: isx(ncol)
      double precision, intent (inout) :: x(nrmax,ncol)
c
c locals
c
      integer    i, j, jssed, ktype
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 10,
     +           numtxt = 22)
      integer    isend
      parameter (isend = 0)
      integer    numbld(30), numpos(numopt)
      double precision a, b, c, d, temp
      double precision g05daf$, g05ddf$
      double precision zero, one, varmin
      parameter (zero = 0.0d+00, one = 1.0d+00, varmin = 1.0d-100)
      double precision m_one
      parameter (m_one = - one)
      character (len = 13) d13(4), showlj
      character  line*100, text(30)*100
      logical    e_numbers, e_formats
      logical    abort, first, repeet
      logical    border
      parameter (border = .false.)
      external   e_formats, showlj
      external   lbox02, getd01, getdge, getdg2, patch1, putadv, isxdat
      external   g05daf$, g05ddf$, rseeds
      save       first
      save       a, b, c, d
      data       first / .true. /
      data       a, b, c, d / m_ one, one, zero, one /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c check
c
      if (ncol.lt.1 .or. nrow.lt.1 .or. nrow.gt.nrmax .or.
     +    nvar.lt.1) then
         write (line,100)
         call putadv (line)
         return
      endif
      j = 0
      do i = 1, ncol
        if (isx(i).gt.0) j = j + 1
      enddo
      if (j.ne.nvar) then
         write (line,200)
         call putadv (line)
         return
      endif 
c
c shuffle the columns for missing variables if variables are suppressed
c isxdat cannot now return abort = .true. due to the previous checks on nvar
c                             
      if (nvar.ne.ncol) call isxdat (isx, ncol, nrmax, nrow,
     +                               x,
     +                               abort) 
c
c initialise the random number generator first time round
c
      if (first) then
         first = .false.
         call rseeds (isend, jssed, ktype)
      endif
      e_numbers = e_formats()
      repeet = .true.
c
c main loop
c
      do while (repeet)
         if (e_numbers) then
            write (text,300) a, b, c, d
         else
            d13(1) = showlj(a)
            d13(2) = showlj(b)
            d13(3) = showlj(c)
            d13(4) = showlj(d)
            write (text,350) trim(d13(1)), d13(2), trim(d13(3)), d13(4) 
         endif  
         numdec = 1
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                text)
         if (numdec.lt.8) repeet = .false.
         if (numdec.eq.1) then
            return
         elseif (numdec.eq.2) then
c
c u(a,b)*x
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05daf$(a,b)
                  x(i,j) = temp*x(i,j)
               enddo
            enddo
         elseif (numdec.eq.3) then
c
c u(a,b) + x
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05daf$(a,b)
                  x(i,j) = temp + x(i,j)
               enddo
            enddo
         elseif (numdec.eq.4) then
c
c u(a,b)
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05daf$(a,b)
                  x(i,j) = temp
               enddo
            enddo
         elseif (numdec.eq.5) then
c
c n(c,d^2)*x
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05ddf$(c,d)
                  x(i,j) = temp*x(i,j)
               enddo
            enddo
         elseif (numdec.eq.6) then
c
c n(c,d^2) + x
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05ddf$(c,d)
                  x(i,j) = temp + x(i,j)
               enddo
            enddo
         elseif (numdec.eq.7) then
c
c n(c,d^2)
c
            do j = 1, nvar
               do i = 1, nrow
                  temp = g05ddf$(c,d)
                  x(i,j) = temp
               enddo
            enddo
         elseif (numdec.eq.8) then
c
c new a, b
c
            write (line,400)
            call getdg2 (a, b, 
     +                   line)
         elseif (numdec.eq.9) then
c
c new c,d
c
            write (line,500)
            call getd01 (c,
     +                   line)
            write (line,600)
            call getdge (d, zero,
     +                   line)
            if (d.le.varmin) d = varmin
         elseif (numdec.eq.numopt) then
c
c help
c
            write (text,700)
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
         endif
      enddo
  100 format ('NCOL, NROW or NVAR inconsistent in call to KMEAN4')
  200 format ('ISX and NVAR inconsistent in call to KMEAN4')
  300 format (
     + 'Use x:= x (no randomisation)'
     +/'Use x:= x*U(A,B)'
     +/'Use x:= x + U(A,B)'
     +/'Use x:= U(A,B)'
     +/'Use x:= x*N(C,D^2)'
     +/'Use x:= x + N(C,D^2)'
     +/'Use x:= N(C,D^2)'
     +/'Change U(A,B), A =',1p,e11.3,', B =',e11.3
     +/'Change N(C,D^2), C =',e11.3,', D =',e11.3
     +/'Help')
  350 format (
     + 'Use x:= x (no randomisation)'
     +/'Use x:= x*U(A,B)      (scale)'
     +/'Use x:= x + U(A,B)    (translate)'
     +/'Use x:= U(A,B)        (replace)'
     +/'Use x:= x*N(C,D^2)    (scale)'
     +/'Use x:= x + N(C,D^2)  (translate)'
     +/'Use x:= N(C,D^2)      (replace)'
     +/'Change U(A,B), A =',1x,a,', B =',1x,a
     +/'Change N(C,D^2), C =',1x,a,', D =',1x,a
     +/'Help')   
  400 format ('New A, B for U(A,B), where B > A')
  500 format ('New C for N(C,D^2)')
  600 format ('New D > 0, for N(C,D^2)')
  700 format (
     + 'Randomising a K-means starting cluster matrix'
     +/
     +/'This allows you to take a starting matrix X and either use it'
     +/'unchanged, perturb it by random error, or even replace it by a'
     +/'completely new random matrix. It is useful with K-means cluster'
     +/'analysis as you can explore the effect of alternative sets of'
     +/'starting cluster estimates on final cluster assignments.'
     +/'However, the following points should be noted.'
     +/'1)`If you have selected a transformation, the X above refers to'
     +/'  `the transformed starting estimates. If this is not possible'
     +/'  `(e.g., the square root or log of a nonpositive number) then'
     +/'  `that starting estimate element x(i,j) is not transformed.'
     +/'2)`U(A,B) is a uniform distribution on the range A, B, where'
     +/'  `B > A.'
     +/'3)`N(C,D^2) is a normal distribution with mean C and standard'
     +/'  `deviation D, where D > 0.0.'
     +/'4)`This procedure does not change the starting clusters set in'
     +/'  `the main calling program, e.g., the K-means procedure. It'
     +/'  `just creates a temporary replacement matrix.'
     +/'5)`If starting clusters are such that one or more are empty at'
     +/'  `first pass, the cluster algorithm will fail with a warning'
     +/'  `that too many (or badly assigned) clusters have been used.')
      end
c
c
