c
c
      subroutine kmean5 (ing, isx, ncol, nrmax, nrow,
     +                   asav, wt,
     +                   wordx,
     +                   weight)
c
c action: plot K-mean clusters
c author: w.g.bardsley, university of manchester, u.k., 26/08/2010
c
      implicit none
c
c arguments
c           
      integer,             intent (in) :: ncol, nrmax, nrow
      integer,             intent (in) :: ing(nrow), isx(ncol)
      double precision,    intent (in) :: asav(nrmax,ncol), wt(*) 
      character (len = *), intent (in) :: wordx(*)
      logical,             intent (in) :: weight
c
c locals
c      
      integer    i, ios, j, nout, n
      integer    itype, nwmax
      parameter (itype = - 1, nwmax = 2000) 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 80) title
      character (len = 1024) filex
      parameter (title = 'K-means Clusters')
      logical    askif, newdat, there
      parameter (askif = .false.)
      external   getnou, gettmp, deleet, manovg
c
c initialise n
c      
      if (weight) then
         n = 0
         do i = 1, nrow
            if (wt(i).gt.zero) n = n + 1
         enddo     
      else
         n = nrow
      endif
c
c get a temporary file name, open it, and write in the data
c      
      call gettmp (ios, 
     +             filex)
      if (ios.ne.0) return
      call getnou (nout)
      open (unit = nout, file = filex, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif   
      write (nout,'(a)',iostat=ios) title
      write (nout,'(2i6)',iostat=ios) n, ncol + 1
      if (weight) then
         do i = 1, nrow
            if (wt(i).gt.zero) write (nout,'(i4,1p,50e13.5)',iostat=ios)
     +                         ing(i), (asav(i,j), j = 1, ncol)
         enddo  
      else
         do i = 1, nrow
            write (nout,'(i4,50e13.5)',iostat=ios)
     +             ing(i), (asav(i,j), j = 1, ncol)
         enddo   
      endif 
      write (nout,'(a)',iostat=ios) 'begin{indicators}'
      write (nout,'(50i3)',iostat=ios) (isx(i), i = 1, ncol)
      write (nout,'(a)',iostat=ios) 'end{indicators}'
      if (n.le.nwmax) then 
         write (nout,'(a)',iostat=ios) 'begin{labels}'
         if (weight) then
            do i = 1, nrow
               if (wt(i).gt.zero) write (nout,'(a)',iostat=ios) wordx(i)
            enddo
         else  
            do i = 1, nrow
               write (nout,'(a)',iostat=ios) wordx(i)
            enddo
         endif
         write (nout,'(a)',iostat=ios) 'end{labels}'
      endif 
      close (unit = nout)
c
c call manovg
c      
      call manovg (itype,
     +             filex,
     +             newdat)  
c
c delete the temporary file
c     
      call deleet (filex,
     +             askif, there)
      end
c
c                                                       