C
C
      SUBROUTINE KS1SAM (NGRAF, NIN, NMAX, NOUT, NZ, U, V, W,
     +                   XGRAF, YGRAF, Z, TITLEZ)
C
C ACTION : Kolmogorov-Smirnov one sample test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 1/12/94
C          4/2/97 Edited to remove COMMON and set IFAIL each time
C          12/5/97 win32 version
C          28/8/98 added Lognormal and Weibull, changed the output
C          format and added some standard errors and confidence limits
C          05/04/2000 added t, chi-square, f
C          09/05/2000 used U instead of Z for Poisson calculation and
C                     warned if truncation for binomial/Poisson
C          03/02/2001 displays defaults in edit boxes
C          07/02/2001 added CHOP80
C          12/02/2001 added NUMPAR
C          19/08/2001 added PDFOUT
C          28/02/2002 used G07BAF$ for Poisson con.lim.
C          27/09/2002 replaced patch1 by table1
C          26/03/2003 rearranged output for normal, added HNPLOT and also
C                     NSWMAX to control Shapiro-Wilks call to G01DDF$
C          02/04/2020 increased dimension of PTITLE to 60
C
      IMPLICIT   NONE
      INTEGER    NGRAF, NIN, NMAX, NOUT, NZ
      INTEGER    I, ICOUNT, IFAIL, NCHOP, NDIST, NSAV, NTYPE
      INTEGER    NDOFC, NDOFT, NDOFF1, NDOFF2
      INTEGER    NSWMAX
      PARAMETER (NSWMAX = 2000)
      INTEGER    ICOLOR, IX, IY, NUMTXT
      PARAMETER (IX = 4, IY = 4)
      INTEGER    NUMDEC, NUMOPT, N0, N1, N2, NMIN, NUMPAR
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, NMIN = 3, NUMPAR = 2)
      INTEGER    NUMPOS(20)
      INTEGER    IC(1), ILIM, KX, MAXIT, NGRAF1, NX, NIT
      PARAMETER (ILIM = 95, MAXIT = 500)
      DOUBLE PRECISION U(2*NMAX), V(2*NMAX), W(2*NMAX)
      DOUBLE PRECISION XGRAF(NGRAF), YGRAF(NGRAF)
      DOUBLE PRECISION Z(NMAX)
      DOUBLE PRECISION PAR(NUMPAR), STDERR(NUMPAR)
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      DOUBLE PRECISION BETA, CORR, DEV, GAMMA, SEBETA, SEGAM, TOL
      DOUBLE PRECISION PBOT, PHAT, PTOP, ZBAR, ZCHOP, ZVAR
      DOUBLE PRECISION PL95(2), PU95(2), T95
      DOUBLE PRECISION CHIL95, CHIU95, PSAV, RTOL, XTOL, Y1, Y2
      DOUBLE PRECISION PW, SW
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT001, PNT025, PNT975, PNT95
      PARAMETER (PNT001 = 0.001D+00, PNT025 = 0.025D+00,
     +           PNT975 = 0.975D+00, PNT95 = 0.95D+00)
      DOUBLE PRECISION X02AMF$, G01FCF$, G01FBF$
      CHARACTER  TITLEZ*(*)
      CHARACTER  TITLE*80
      CHARACTER  DIST*2, DNAME*20, EST*1
      CHARACTER  PTYPE*100, PTYPE1*100, PTYPE2*100, PTYPE3*100
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  PTITLE*60
      CHARACTER  ANSWER*40, CHOP80*80, LINE*100, TEXT(30)*100
      CHARACTER  TEMP(3)*100
      CHARACTER  BLANK*1, CENS*1
      PARAMETER (BLANK = ' ', CENS = 'N')
      LOGICAL    ABORT, CALWTS, ESTIM, REPEET
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   PLEVEL, PUTIFA, PUTFAT, TABLE1, YESNO2, LBOX02,
     +           GETDG2, GETD01, GETDGE, GETJGE, GETDL1, PHAT95,
     +           NXXBAR, PUTCAU, CHOP80, NXSORT
      EXTERNAL   VECONE, CDFOUT, PDFOUT, HNPLOT
      EXTERNAL   G08CBF$, X02AMF$, G07BEF$, G01FCF$, G01FBF$,
     +           G07ABF$, G01DDF$
      INTRINSIC  DBLE, NINT, SQRT, EXP, ABS, LOG
      SAVE       ICOUNT
      SAVE       NSAV
      SAVE       NDOFC, NDOFT, NDOFF1, NDOFF2
      SAVE       PSAV
      DATA       ICOUNT, NSAV / 0, 10 /
      DATA       NDOFC, NDOFT, NDOFF1, NDOFF2 / 10, 10, 10, 10 /
      DATA       PSAV / 0.5D+00 /
      DATA       NUMPOS / 20*1 /
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      XTOL = SQRT(RTOL)
      PAR(1) = ONE
      PAR(2) = ONE
C
C Get some data
C
      CALL VECONE (NIN, NMAX, NZ, Z, TITLEZ, ABORT, FIXNPT)
      TITLE = CHOP80(TITLEZ)
      IF (ABORT) RETURN
      IF (NZ.LT.NMIN) THEN
         CALL PUTFAT ('Insufficient data for meaningful test')
         RETURN
      ENDIF
C
C Call NXXBAR for starting estimates and Poisson dispersion
C
      CALL NXXBAR (NZ, Z, ZBAR, ZVAR)
      IF (ZVAR.LE.RTOL) THEN
         CALL PUTFAT ('Singular data (all identical ?)')
         RETURN
      ENDIF
C
C Decide which distribution to use
C
      WRITE (TEXT,100)
      NUMDEC = 2
      NUMOPT = 13
      ICOLOR = 7
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
C
C Estimate parameters or set them by hand
C
      IF (NUMDEC.LE.9) THEN
         ESTIM = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Estimate parameters from the sample ? (usually yes)', ESTIM)
      ELSE
         ESTIM = .FALSE.
      ENDIF
      IF (ESTIM) THEN
         EST = 'E'
         PTYPE = 'Parameters estimated from sample are:'
      ELSE
         PTYPE = 'Parameters fixed by user: are'
         EST = 'S'
      ENDIF
      IF (NUMDEC.EQ.8) THEN
         PTYPE3 = 'Parameters are for y = log(x) [base e]'
      ELSE
         PTYPE3 = BLANK
      ENDIF
      IF (NUMDEC.EQ.1) THEN
         DIST = 'U'
         DNAME = 'Uniform(A,B)'
         IF (.NOT.ESTIM) THEN
            PAR(1) = Z(1)
            PAR(2) = Z(1)
            DO I = 1, NZ
               IF (Z(I).LT.PAR(1)) PAR(1) = Z(I)
               IF (Z(I).GT.PAR(2)) PAR(2) = Z(I)
            ENDDO
            CALL GETDG2 (PAR(1), PAR(2), 'Parameters A, B')
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
         DIST = 'N'
         DNAME = 'Normal(mu,sigma^2)'
         IF (.NOT.ESTIM) THEN
            PAR(1) = ZBAR
            PAR(2) = SQRT(ZVAR)
            CALL GETD01 (PAR(1), 'The mean, mu')
            CALL GETDGE (PAR(2), ZERO,
     +                  'The standard deviation, sigma > 0')
            IF (PAR(2).LT.XTOL) PAR(2) = XTOL
            PAR(2) = PAR(2)**2
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
         DIST = 'G'
         DNAME = 'Gamma(alpha,beta)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(2) = ZVAR/ZBAR
            PAR(1) = ZBAR/PAR(2)
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            CALL GETDGE (PAR(1), RTOL, 'The parameter alpha > 0')
            CALL GETDGE (PAR(2), RTOL, 'The parameter beta > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
         DIST = 'BE'
         DNAME = 'Beta(r,s)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            Y1 = ZBAR**2/ZVAR
            Y2 = ONE/ZBAR - ONE
            PAR(1) = ZBAR*(Y1*Y2 - ONE)
            PAR(2) = PAR(1)*Y2
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            CALL GETDGE (PAR(1), RTOL, 'The parameter r > 0')
            CALL GETDGE (PAR(2), RTOL, 'The parameter s > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.5) THEN
         CALL GETJGE (NSAV, N1, 'The binomial parameter N > 0')
         PAR(1) = DBLE(NSAV)
         DIST = 'BI'
         DNAME = 'Binomial(N,p)'
         IF (.NOT.ESTIM) THEN
            CALL GETDL1 (ZERO, PSAV, ONE, 'The parameter p, 0 < p < 1')
            PAR(2) = PSAV
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
         DIST = 'E'
         DNAME = 'Exponential(lambda)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(1) = ONE/ZBAR
            CALL GETDGE (PAR(1), RTOL,
     +     'The parameter lambda > 0 (Note: mean = 1/lambda')
         ENDIF
         PAR(2) = ZERO
      ELSEIF (NUMDEC.EQ.7) THEN
         DIST = 'P'
         DNAME = 'Poisson(mu)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(1) = ZBAR
            CALL GETDGE (PAR(1), RTOL, 'The parameter mu > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.8) THEN
         DIST = 'L'
         DNAME = 'Lognorm(mu,sigma^2)'
         IF (.NOT.ESTIM) THEN
            DO I = 1, NZ
               IF (Z(I).LE.RTOL) THEN
                  CALL PUTFAT ('Data nonpositive')
                  RETURN
               ENDIF
               U(I) = LOG(Z(I))
            ENDDO
            CALL NXXBAR (NZ, U, PAR(1), PAR(2))
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            PAR(2) = SQRT(PAR(2))
            CALL GETD01 (PAR(1), 'The mean, mu')
            CALL GETDGE (PAR(2), ZERO,
     +                  'The standard deviation, sigma > 0')
            IF (PAR(2).LT.XTOL) PAR(2) = XTOL
            PAR(2) = PAR(2)**2
         ENDIF
      ELSEIF (NUMDEC.EQ.9) THEN
         DIST = 'W'
         DNAME = 'Weibull(A,B)'
         IF (.NOT.ESTIM) THEN
            CALL GETDGE (GAMMA, RTOL,
     +     'The parameter B (Note: B > 0, then A is estimated)')
         ELSE
            GAMMA = - ONE
         ENDIF
C
C Special code for Weibull
C
         EST = 'S'
         TOL = ZERO
         IFAIL = 0
         CALL G07BEF$(CENS, NZ, Z, IC, BETA, GAMMA, TOL, MAXIT, SEBETA,
     +                SEGAM, CORR, DEV, NIT, W, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G07BEF/KS1SAM')
         IF (IFAIL.EQ.2) CALL PUTFAT ('Cannot have values =< 0')
         IF (IFAIL.NE.0) RETURN
         PAR(1) = (EXP(BETA))**(ONE/GAMMA)
         PAR(2) = GAMMA
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t
C
         DIST = 'T'
         DNAME = 't(N)'
         CALL GETJGE (NDOFT, N2, 'The degrees of freedom N > 1')
         PAR(1) = DBLE(NDOFT)
      ELSEIF (NUMDEC.EQ.11) THEN
C
C chi-square
C
         DIST = 'C'
         DNAME = 'chi-square(N)'
         CALL GETJGE (NDOFC, N2, 'The degrees of freedom N > 1')
         PAR(1) = DBLE(NDOFC)
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F
C
         DIST = 'F'
         DNAME = 'F(N,M)'
         CALL GETJGE (NDOFF1, N1, 'Numerator degrees of freedom N > 0')
         PAR(1) = DBLE(NDOFF1)
         CALL GETJGE (NDOFF2, N1,
     +               'Denominator degrees of freedom M > 0')
         PAR(2) = DBLE(NDOFF2)
      ELSE
         RETURN
      ENDIF
C
C Check for truncation if binomial/Poission
C
      IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.7) THEN
         NCHOP = N0
         DO I = N1, NZ
            IFAIL = NINT(Z(I))
            ZCHOP = DBLE(IFAIL)
            IF (ABS(Z(I) - ZCHOP).GE.PNT001) NCHOP = NCHOP + N1
         ENDDO
         IF (NCHOP.GT.N0) THEN
            WRITE (LINE,'(I6,A)') NCHOP, ' values truncated to integers'
            CALL PUTCAU (LINE)
         ENDIF
      ENDIF
C
C The KS tests
C
      IFAIL = 1
      NTYPE = 1
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D1, Z1, P1, U, IFAIL)
      IF (IFAIL.GT.4 .AND. IFAIL.LT.9) THEN
          CALL PUTFAT ('Data inconsistent with distribution selected')
          RETURN
      ENDIF
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      NTYPE = 2
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D2, Z2, P2, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      NTYPE = 3
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D3, Z3, P3, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
C
C Write the parameters to PTYPE1 and PTYPE2
C
C Uniform
C
      IF (NUMDEC.EQ.1) THEN
         IF (ESTIM) THEN
            WRITE (PTYPE1,101) PAR(1)
            WRITE (PTYPE2,102) PAR(2)
         ELSE
            WRITE (PTYPE1,201) PAR(1)
            WRITE (PTYPE2,202) PAR(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Normal
C
         IF (ESTIM) THEN
            STDERR(1) = SQRT(PAR(2)/DBLE(NZ))
            IFAIL = 0
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - 1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/KS1SAM')
            PL95(1) = PAR(1) - T95*STDERR(1)
            PU95(1) = PAR(1) + T95*STDERR(1)
            WRITE (PTYPE1,103) PAR(1), STDERR(1), PL95(1), PU95(1)
            IFAIL = 0
            CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            IFAIL = 0
            CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            PL95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIU95
            PU95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIL95
            WRITE (PTYPE2,104) SQRT(PAR(2)), PAR(2), PL95(2), PU95(2)
         ELSE
            WRITE (PTYPE1,203) PAR(1)
            WRITE (PTYPE2,204) SQRT(PAR(2))
         ENDIF
         IF (NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks if NZ sufficiently small
C
            CALWTS = .TRUE.
            CALL NXSORT (NZ, Z)
            IFAIL = 1
            CALL G01DDF$(Z, NZ, CALWTS, W, SW, PW, IFAIL)
            IF (IFAIL.NE.0) THEN
               CALL PUTIFA (IFAIL, NOUT, 'G01DDF/KS1SAM')
               RETURN
            ENDIF
            IF (PW.LT.0.01D+00) THEN
               ANSWER = 'Reject normality at 1% sig.level'
            ELSEIF (PW.LT.0.05D+00) THEN
               ANSWER = 'Reject normality at 5% sig.level'
            ELSE
               ANSWER = 'Tentatively accept normality'
            ENDIF
         ELSE
            SW = ZERO
            PW = ONE
            ANSWER = 'ERROR: sample size too large'
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Gamma
C
         IF (ESTIM) THEN
            WRITE (PTYPE1,105) PAR(1)
            WRITE (PTYPE2,106) PAR(2)
         ELSE
            WRITE (PTYPE1,205) PAR(1)
            WRITE (PTYPE2,206) PAR(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Beta
C
         IF (ESTIM) THEN
            WRITE (PTYPE1,107) PAR(1)
            WRITE (PTYPE2,108) PAR(2)
         ELSE
            WRITE (PTYPE1,207) PAR(1)
            WRITE (PTYPE2,208) PAR(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Binomial
C
         IF (ESTIM) THEN
            WRITE (PTYPE1,109) NINT(PAR(1))
            STDERR(2) = SQRT(PAR(2)*(ONE - PAR(2))/PAR(1))
            KX = NINT(DBLE(NZ)*PAR(1)*PAR(2))
            NX = NINT(DBLE(NZ)*PAR(1))
            CALL PHAT95 (ILIM, KX, NX, NOUT, PBOT, PHAT, PTOP)
            WRITE (PTYPE2,110) PAR(2), STDERR(2), PBOT, PTOP
         ELSE
            WRITE (PTYPE1,209) NINT(PAR(1))
            WRITE (PTYPE2,210) PAR(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Exponential
C
         IF (ESTIM) THEN
            WRITE (PTYPE1,111) PAR(1)
            WRITE (PTYPE2,112) BLANK
         ELSE
            WRITE (PTYPE1,211) PAR(1)
            WRITE (PTYPE2,212) BLANK
         ENDIF
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Poisson
C
         IF (ESTIM) THEN
            IFAIL = 0
            CALL G07ABF$(NZ, PAR(1), PNT95, PL95(1), PU95(1), IFAIL)
            WRITE (PTYPE1,113) PAR(1), PL95(1), PU95(1), ZVAR
            IF (ZVAR.LT.PL95(1)) THEN
               WRITE (PTYPE2,114)
     +               'Sample variance < mean (Too uniform ?)'
            ELSEIF (ZVAR.GT.PU95(1)) THEN
               WRITE (PTYPE2,114)
     +              'Sample variance > mean (Too clustered ?)'
            ELSE
               WRITE (PTYPE2,114)
     +               'Sample variance consistent with mean'
            ENDIF
         ELSE
            WRITE (PTYPE1,213) PAR(1)
            WRITE (PTYPE2,214) BLANK
         ENDIF
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Lognormal
C
         IF (ESTIM) THEN
            STDERR(1) = SQRT(PAR(2)/DBLE(NZ))
            IFAIL = 0
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/KS1SAM')
            PL95(1) = PAR(1) - T95*STDERR(1)
            PU95(1) = PAR(1) + T95*STDERR(1)
            WRITE (PTYPE1,115) PAR(1), STDERR(1), PL95(1), PU95(1)
            IFAIL = 0
            CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            IFAIL = 0
            CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            PL95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIU95
            PU95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIL95
            WRITE (PTYPE2,116) SQRT(PAR(2)), PL95(2), PAR(2), PU95(2)
         ELSE
            WRITE (PTYPE1,215) PAR(1)
            WRITE (PTYPE2,216) SQRT(PAR(2))
         ENDIF
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Weibull
C
         IF (ESTIM) THEN
            STDERR(1) = (ONE/GAMMA)*((EXP(BETA))**(ONE/GAMMA))*SEBETA
            STDERR(2) = SEGAM
            WRITE (PTYPE1,117) PAR(1), STDERR(1)
            WRITE (PTYPE2,118) PAR(2), STDERR(2)
         ELSE
            WRITE (PTYPE1,217) PAR(1)
            WRITE (PTYPE2,218) PAR(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t
C
         WRITE (PTYPE1,109) NINT(PAR(1))
         WRITE (PTYPE2,112) BLANK
      ELSEIF (NUMDEC.EQ.11) THEN
C
C chi-square
C
         WRITE (PTYPE1,109) NINT(PAR(1))
         WRITE (PTYPE2,112) BLANK
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F
C
         WRITE (PTYPE1,109) NINT(PAR(1))
         WRITE (PTYPE2,219) NINT(PAR(2))
      ELSE
         RETURN
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + N1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      WRITE (NOUT,300) ICOUNT, DNAME, TITLE, PTYPE, PTYPE1, PTYPE2,
     +                 PTYPE3, NZ, D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      WRITE (TEXT,350) ICOUNT, DNAME, CHOP80(TITLE), CHOP80(PTYPE),
     +                 CHOP80(PTYPE1), CHOP80(PTYPE2),
     +                 CHOP80(PTYPE3), NZ, D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      NUMTXT = 22
      IF (NUMDEC.EQ.2 .AND. NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks results if NZ sufficiently small
C
         WRITE (NOUT,325) SW, PW, ANSWER
         WRITE (TEMP,375) SW, PW, ANSWER
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(1)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(2)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(3)
      ENDIF
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.10 .OR. I.EQ.11 .OR.
     +       I.EQ.15 .OR. I.EQ.19 .OR. I.EQ.23) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Prepare for plotting if necessary
C
      IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.7) THEN
C
C Use the extremes of the sorted sample to define IFAIL
C
         IFAIL = NINT(TWO*(U(NZ) - U(1) + ONE))
      ELSE
C
C Plot just IFAIL points for the theoretical CDF
C
         IFAIL = 100
      ENDIF
      IF (IFAIL.GT.NGRAF) THEN
         IFAIL = NGRAF
         CALL PUTCAU ('Sample too large to plot all values')
      ENDIF
      IF (NUMDEC.EQ.1) THEN
         WRITE (PTITLE,400) PAR(1), PAR(2)
      ELSEIF (NUMDEC.EQ.2) THEN
         WRITE (PTITLE,500) PAR(1), SQRT(PAR(2))
      ELSEIF (NUMDEC.EQ.3) THEN
         WRITE (PTITLE,600) PAR(1), PAR(2)
      ELSEIF (NUMDEC.EQ.4) THEN
         WRITE (PTITLE,700) PAR(1), PAR(2)
      ELSEIF (NUMDEC.EQ.5) THEN
         WRITE (PTITLE,800) NINT(PAR(1)), PAR(2)
      ELSEIF (NUMDEC.EQ.6) THEN
         WRITE (PTITLE,900) PAR(1)
      ELSEIF (NUMDEC.EQ.7) THEN
         WRITE (PTITLE,1000) PAR(1)
      ELSEIF (NUMDEC.EQ.8) THEN
         WRITE (PTITLE,1100) PAR(1), SQRT(PAR(2))
      ELSEIF (NUMDEC.EQ.9) THEN
         WRITE (PTITLE,1200) PAR(1), PAR(2)
      ELSEIF (NUMDEC.EQ.10) THEN
         WRITE (PTITLE,1300) NINT(PAR(1))
      ELSEIF (NUMDEC.EQ.11) THEN
         WRITE (PTITLE,1400) NINT(PAR(1))
      ELSEIF (NUMDEC.EQ.12) THEN
         WRITE (PTITLE,1500) NINT(PAR(1)), NINT(PAR(2))
      ENDIF
C
C Set NDIST = NUMDEC and plot if required
C
      IF (NZ.GT.2) THEN
         NDIST = NUMDEC
         REPEET = .TRUE.
         NUMDEC = 1
         NUMOPT = 5
         WRITE (TEXT,1600)
      ELSE
         REPEET = .FALSE.
      ENDIF
      DO WHILE (REPEET)
         ICOLOR = 7
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Plot CDF (IFAIL points) and sample CDF: U must be Z in ascending order
C
            NGRAF1 = IFAIL
            CALL CDFOUT (NGRAF1, NZ, NDIST, NUMPAR, PAR, U, XGRAF, V,
     +                   YGRAF, W, PTITLE)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot PDF (IFAIL points) and sample PDF: U must be Z in ascending order
C
            NGRAF1 = IFAIL
            CALL PDFOUT (NDIST, NGRAF1, NMAX, NUMPAR, NZ, PAR, XGRAF,
     +                   V(1), V(NMAX + 1), YGRAF, W(1), W(NMAX + 1), U)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Half normal plot
C
            IFAIL = N1
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Normal plot
C
            IFAIL = N2
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'Uniform(A,B): range = A to B'
     +/'Normal(mu,sigma^2): mean = mu'
     +/'Gamma(alpha,beta): mean = alpha*beta'
     +/'Beta(r,s): mean = r/(r + s)'
     +/'Binomial(N,p): mean = Np'
     +/'Exponential: cdf = 1 - exp(-lambda*x), mean = 1/lambda'
     +/'Poisson(mu): mean = mu',
     +/'Lognormal(mu,sigma^2): mean = mu',
     +/'Weibull(A,B): cdf = 1 - exp[(A*x)^B]'
     +/'t(N): N = ndof'
     +/'Chi-square(N): N = ndof'
     +/'F(N,M): N = num df, M = denom df'
     +/'Quit ... Exit these options')
  101 FORMAT ('A =',1P,E11.3)
  102 FORMAT ('B =',1P,E11.3)
  103 FORMAT ('mu =',1P,E11.3,', se =',E11.3,', 95%cl = (',
     +E11.3,',',E11.3,')')
  104 FORMAT ('sigma =',1P,E10.3,', sigma^2 =',E10.3,', 95%cl = (',
     +E9.3,',',E9.3,')')
  105 FORMAT ('alpha =',1P,E11.3)
  106 FORMAT ('beta =',1P,E11.3)
  107 FORMAT ('r =',1P,E11.3)
  108 FORMAT ('s =',1P,E11.3)
  109 FORMAT ('N =',I6,' (Fixed)')
  110 FORMAT ('p =',F8.4,', s.e. =',F8.4,', 95% c.l. = (',
     +F8.4,',',F8.4,')')
  111 FORMAT ('lambda =',1P,E11.3)
  112 FORMAT (A)
  113 FORMAT ('mu =',1P,E10.3,
     +', 95% c.l. = (',E10.3,',',E10.3,'), sample variance =',1P,E10.3)
  114 FORMAT (A)
  115 FORMAT ('mu =',1P,E11.3,', s.e. =',E11.3,', 95% c.l. = (',
     +E11.3,',',E11.3,')')
  116 FORMAT ('sigma =',1P,E11.3,', sigma^2 and 95%cl',
     +E11.3,' =<',E11.3,' =<',E11.3)
  117 FORMAT ('A =',1P,E11.3,', s.e. =',E11.3)
  118 FORMAT ('B =',1P,E11.3,', s.e. =',E11.3)
  201 FORMAT ('A =',1P,E11.3)
  202 FORMAT ('B =',1P,E11.3)
  203 FORMAT ('mu =',1P,E11.3)
  204 FORMAT ('sigma =',1P,E11.3)
  205 FORMAT ('alpha =',1P,E11.3)
  206 FORMAT ('beta =',1P,E11.3)
  207 FORMAT ('r =',1P,E11.3)
  208 FORMAT ('s =',1P,E11.3)
  209 FORMAT ('N =',I6,' (Fixed)')
  210 FORMAT ('p =',F8.4)
  211 FORMAT ('lambda =',1P,E11.3)
  212 FORMAT (A)
  213 FORMAT ('mu =',1P,E11.3)
  214 FORMAT (A)
  215 FORMAT ('mu =',1P,E11.3)
  216 FORMAT ('sigma =',1P,E11.3)
  217 FORMAT ('A =',1P,E11.3)
  218 FORMAT ('B =',1P,E11.3)
  219 FORMAT ('N =',I6,' (Fixed)')
  300 FORMAT (
     +/'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/'--------------------------------------'
     +/'Data: ',A
     +/A
     +/A
     +/A
     +/A
     +/'NX =',I6,', i.e. no. of x-values'
     +/'H0 = F(x) equals G(y) (x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and theory not comparable)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A)
  325 FORMAT (
     + 1X,'Shapiro-Wilks normality test:'
     +/1X,'W statistic =',1P,E11.3
     +/1X,'Sign. level =',0P,F8.4,5X,A)
  350 FORMAT (
     + 'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/
     +/'Data:'
     +/A
     +/A
     +/A
     +/A
     +/A
     +/'NX = ',I6,' ,i.e. no. of x-values'
     +/'H0 = F(x) equals G(y)(x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y)(x and theory not comparable)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A)
  375 FORMAT (
     + 'Shapiro-Wilks normality test:'
     +/'W statistic =',1P,E11.3
     +/'Sign. level =',0P,F8.4,5X,A)
  400 FORMAT ('Uniform: A =',1P,E10.2,', B =',E10.2)
  500 FORMAT ('Normal:mu =',1P,E10.2,',sigma =',E9.2)
  600 FORMAT ('Gamma:alpha =',1P,E9.2,',beta =',E9.2)
  700 FORMAT ('  Beta: r =',1P,E9.2,', s =',E9.2)
  800 FORMAT ('  Binomial: N =',I3,', p =',F6.3)
  900 FORMAT ('  Exponential: lambda =',1P,E10.2)
 1000 FORMAT ('  Poisson: mu =',1P,E10.2)
 1100 FORMAT ('Lognorm:mu =',1P,E10.2,',sigma =',E9.2)
 1200 FORMAT ('Weibull:A =',1P,E10.2,',B =',E9.2)
 1300 FORMAT ('    t(N): N =',I4)
 1400 FORMAT ('    Chi-square(N): N =',I4)
 1500 FORMAT ('  F(N,M): N =',I3,', M =',I4)
 1600 FORMAT (
     + 'Plot cdf and sample cumulative'
     +/'Plot pdf and sample histogram'
     +/'Plot normal scores (half)'
     +/'Plot normal scores (full)'
     +/'Quit ... Exit these plotting options')
      END
C
C
