C
C
      SUBROUTINE KS2SAM (NIN, NMAX, NOUT, NX, NY, U, V, X, Y,
     +                   TITLEX, TITLEY)
C
C ACTION : Kolmogorov-Smirnov two sample test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 1/12/94
C          4/2/97 Edited to remove COMMON and set IFAIL each time
C          5/5/97 WIN32 version
C          07/02/2001 added CHOP80
C          27/09/2002 replaced patch1 by table1
C
      IMPLICIT   NONE
      INTEGER    NIN, NMAX, NOUT, NX, NY
      INTEGER    I, ICOUNT, IFAIL, NTYPE
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 21)
      DOUBLE PRECISION U(NMAX), V(NMAX), X(NMAX), Y(NMAX)
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      CHARACTER  TITLEX*(*), TITLEY*(*)
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP80*80, TEXT(30)*100
      LOGICAL    ABORT
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP80, VECTWO
      EXTERNAL   G08CDF$
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      CALL VECTWO (NIN, NMAX, NX, NY, X, Y, TITLEX, TITLEY, ABORT,
     +             FIXNPT)
      IF (ABORT) RETURN
      IFAIL = 1
      NTYPE = 1
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D1, Z1, P1, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IFAIL = 1
      NTYPE = 2
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D2, Z2, P2, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IFAIL = 1
      NTYPE = 3
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D3, Z3, P3, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IF (IFAIL.NE.0) RETURN
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      WRITE (NOUT,100) ICOUNT, TITLEX, TITLEY, NX, NY, D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      WRITE (TEXT,200) ICOUNT, CHOP80(TITLEX), CHOP80(TITLEY), NX, NY,
     +                 D1, Z1, P1,
     +                 P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1 .OR. I.EQ.4  .OR. I.EQ.6 .OR. I.EQ.9 .OR.
     +       I.EQ.10 .OR. I.EQ.14 .OR. I.EQ.18) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
  100 FORMAT (
     +/'Kolmogorov-Smirnov two sample test',I4
     +/'--------------------------------------'
     +/'X-data: ',A
     +/'Y-data: ',A
     +/'NX = ',I6,' Size of X-data'
     +/'NY = ',I6,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A)
  200 FORMAT (
     + 'Kolmogorov-Smirnov two sample test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'NX = ',I6,' Size of X-data'
     +/'NY = ',I6,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1P,E11.3
     +/'z  =',1P,E11.3
     +/'p  =',0P,F8.4,4X,A)
      END
C
C
