C
C
      SUBROUTINE KSHIST (N, X, Y, DBIG, DNEG, DPOS, D1, D5, PGDBIG)
C
C
C AUTHOR : W. G. BARDSLEY, 4/2/91
C          22/3/93 Added D1, D5
C          Date of this version 6/11/97
C ACTION : Kolmogorov-Smirnov test on two histograms with same bins
C SUPPLY : N = Number of bins in histograms
C          X-values X(1), X(2), ..., X(N)
C          Y-values Y(1), Y(2), ..., Y(N)
C          Where X(I), Y(I) = Numbers in successive bins
C          Sums of X and Y must equal total numbers in samples
C RETURN : DNEG :- Largest negative deviation
C          DPOS :- Largest positive deviation
C          DBIG :- MAX(ABS(DNEG),DPOS)
C          D1, D5 :- Critical levesl for large N
C          PGDBIG : P(KS D-value >= DBIG)
C NAG    : X02AME
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    I
      INTEGER    N1, N100
      PARAMETER (N1 = 1, N100 = 100)
      DOUBLE PRECISION X(N), Y(N)
      DOUBLE PRECISION DBIG, DNEG, DPOS, D1, D5, PGDBIG
      DOUBLE PRECISION DELTA, STEPX, STEPY, SUMX, SUMY
      DOUBLE PRECISION ARG, COEFF, ENEG, SERIES, TERM, TWO
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ONE, ZERO, F1P63, F1P36, F2
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00, F1P63 = 1.63D+00,
     +           F1P36 = 1.36D+00, F2 = 2.0D+00)
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT
      EXTERNAL   X02AMF$
      INTRINSIC  ABS, EXP, LOG, MAX, SQRT
C
C Initialise
C
      DBIG = ZERO
      DNEG = ZERO
      DPOS = ZERO
      D1 = ZERO
      D5 = ZERO
      PGDBIG = ZERO
      STEPX = ZERO
      STEPY = ZERO
      SUMX = ZERO
      SUMY = ZERO
C
C Check and calculate SUMX and SUMY
C
      DO I = N1, N
         IF (X(I).LT.ZERO .OR. Y(I).LT.ZERO) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         SUMX = SUMX + X(I)
         SUMY = SUMY + Y(I)
      ENDDO
C
C Find the D values
C
      DO I = N1, N
         STEPX = STEPX + X(I)/SUMX
         STEPY = STEPY + Y(I)/SUMY
         DELTA = STEPX - STEPY
         IF (DELTA.LT.DNEG) THEN
            DNEG = DELTA
         ELSEIF (DELTA.GT.DPOS) THEN
            DPOS = DELTA
         ENDIF
      ENDDO
C
C Evaluate the series
C
      DBIG = MAX(ABS(DNEG), ABS(DPOS))
      COEFF = - F2*((SUMX*SUMY)/(SUMX + SUMY))*(DBIG*DBIG)
      ENEG = LOG(X02AMF$())
      SERIES = ZERO
      TWO = F2
      DO I = N1, N100
         ARG = MAX(ENEG, COEFF*(I**2))
         TERM = TWO*EXP(ARG)
         SERIES = SERIES + TERM
         TWO = - TWO
      ENDDO
      IF (SERIES.LT.ZERO) THEN
          SERIES = ZERO
      ELSEIF (SERIES.GT.ONE) THEN
         SERIES = ONE
      ENDIF
      PGDBIG = SERIES
      DELTA = SQRT((SUMX + SUMY)/(SUMX*SUMY))
      D1 = F1P63*DELTA
      D5 = F1P36*DELTA
  100 FORMAT ('Check point no.',I4,' < 0 in KSHIST')
      END
C
C
