C
C
      SUBROUTINE KSTEST (N,
     +                   Y, DBIG, DNEG, DPOS, D1, D5, PGDBIG)
C
C
C AUTHOR : W. G. Bardsley, 30/06/90
C ACTION : Kolmogorov-Smirnov test
C ADVICE : This version is only for uniform Y and does not use X
C SUPPLY : Number of observations: N
C          Observed values: Y(1) <= Y(2) <=, ..., <= Y(N)
C          Expected distribution: UNIFORM
C RETURN : DNEG  : Largest negative deviation
C          DPOS  : Largest positive deviation
C          DBIG  : MAX(ABS(DNEG),DPOS)
C          PGDBIG: P(KS D-value >= DBIG)
C
C          10/03/1993 Altered call to PROBKS and new arguments D1 and D5
C          04/05/1997 Changed the code to trap replicates correctly
C          06/07/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: Y(N)
      DOUBLE PRECISION, INTENT (OUT) :: DBIG, DNEG, DPOS, D1, D5, PGDBIG
C
C Locals
C      
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I
      DOUBLE PRECISION CDF, CDF0, CDF1, DELTA, DN
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      LOGICAL    OK, STEP, STEP1
      PARAMETER (STEP1 = .FALSE.)
      EXTERNAL   PROBKS, PUTFAT
      INTRINSIC  DBLE, MAX
C
C Initialise the arguments
C
      STEP = STEP1
      DBIG = ZERO
      DNEG = ZERO
      DPOS = ZERO
      D1 = ZERO
      D5 = ZERO
      PGDBIG = ZERO
C
C Check the data supplied
C
      DO I = N1, N
         IF (Y(I).LT.ZERO .OR. Y(I).GT.ONE) THEN
            CALL PUTFAT ('Y < 0 or Y > 1 in KSTEST')
            RETURN
         ENDIF
         IF (I.GT.N1) THEN
            IF (Y(I).LT.Y(I - N1)) THEN
               CALL PUTFAT ('Y(i) <  Y(i - 1) in KSTEST')
               RETURN
            ENDIF
         ENDIF
      ENDDO
C
C Initialise all the counters used to calculate D values
C
      CDF0 = ZERO
      CDF1 = ZERO
      DELTA = ZERO
      DN = DBLE(N)
      IF (STEP) THEN
C
C Special action for discrete distributions since CDF0 not tested
C
         DO I = N1, N
            IF (I.LT.N) THEN
               IF (Y(I + N1).GT.Y(I)) THEN
C
C The next Y increases
C
                  OK = .TRUE.
              ELSE
C
C The next Y is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next Y is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = Y(I)
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPOS) DPOS = DELTA
               IF (DELTA.LT.DNEG) DNEG = DELTA
            ENDIF
         ENDDO
      ELSE
         DO I = N1, N
            IF (I.LT.N) THEN
               IF (Y(I + N1).GT.Y(I)) THEN
C
C The next Y increases
C
                  OK = .TRUE.
              ELSE
C
C The next Y is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next Y is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = Y(I)
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPOS) DPOS = DELTA
               IF (DELTA.LT.DNEG) DNEG = DELTA
               DELTA = CDF0 - CDF
               IF (DELTA.GT.DPOS) DPOS = DELTA
               IF (DELTA.LT.DNEG) DNEG = DELTA
               CDF0 = CDF1
            ENDIF
         ENDDO
      ENDIF
      DBIG = MAX(-DNEG, DPOS)
      CALL PROBKS (N,
     +             DBIG, D1, D5, PGDBIG)
      END
C
C
