C
C
      SUBROUTINE L1NORM (INDX, ISX, NCMAX, NCOLS, NF, NRMAX, NROWS,
     +                   A1, A2, B, RESIDS, THEORY, W, X,
     +                   FNAME, TITLE)
C
C ACTION : Multilinear L1-norm regression
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          18/03/1999 derived from LINEAR
C          16/01/2006 deleted E from call to AXEQB3
C          20/07/2006 extensive editing
C          24/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          The original matrix in A1 is scanned and rows are only
C          included if S > 0. Fitting is always unweighted.
C
C          INDX: (workspace for L1 norm routine)
C           ISX: (workspace) variables out (0) or in (1)
C         NCMAX: (input/unchanged) dimension
C         NCOLS: (input/unchanged) no. columns
C            NF: (input/unchanged) preconnected unit for results
C         NRMAX: (input/unchanged) dimension
C         NROWS: (input/unchanged) no. rows
C            A1: (input/unchanged) original data matrix ... this is never altered
C            A2: (workspace) current active copy of A1 which is made as required
C             B: (workspace) RHS
C        RESIDS: (workspace) residuals
C        THEORY: (workspace) theoretical fit
C             W: (workspace)
C             X: (workspace) solution
C         FNAME: (input/unchanged) data file name
C         TITLE: (input/unchanged) data title
C          Each time the data set is altered a new active set is calculated
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NRMAX
      INTEGER    INDX(NRMAX), ISX(NCMAX), NCOLS, NF, NROWS
      DOUBLE PRECISION A1(NRMAX,NCMAX), A2(NRMAX,NCMAX), B(NRMAX),
     +                 RESIDS(NRMAX), THEORY(NRMAX),
     +                 W(3*NRMAX + 5*NCMAX + NCMAX*NCMAX +
     +                 ((NCMAX + 1)*(NCMAX + 2))/2),
     +                 X(NCMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
C
C Locals
C
      INTEGER    I, IP, ISEND, J, K, M, N, NVAR
      INTEGER    LWORK, NCOL1, NIN, NROW1
      INTEGER    COLOUR
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, NISX, NXMIN
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, NISX = 100, NXMIN = 1)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 5,
     +           NSTART = 14, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(N6)
      INTEGER    ICOUNT, ISXSAV(NISX)
      DOUBLE PRECISION EL1N, VALUE
      DOUBLE PRECISION ONE, ZERO, TOL
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00, TOL = 1.0D-20)
      CHARACTER (LEN = 12) FORM12, I12(5)
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER  TITLE1*80
      CHARACTER  CHOP60*60, TRIM60*60
      CHARACTER  F60*60, T60*60
      CHARACTER  TEXT(NTEXT)*100, LINE*100
      CHARACTER  LABELM*5, MEAN*1
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    DISPLY, FILE1, SUPPLY
      PARAMETER (DISPLY = .FALSE., FILE1 = .FALSE., SUPPLY = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, AGAIN, DONE, FITNOW, IWARNU, REPEET
      INTRINSIC  MIN
      EXTERNAL   E_FORMATS, FORM12,SHOWLJ, SHOWRJ
      EXTERNAL   LBOX01, TABLE1, PUTADV, LBOX02, AXEQB3, REVPRO,
     +           PUTFAT, GETNOU, CHOP60, TRIM60, ISXEDI, ISXTYP,
     +           HNPLOT, GKS001
      SAVE       ICOUNT, ISXSAV
      DATA       ICOUNT / 0 /
      DATA       ISXSAV / NISX*1 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / N6*1 /
C
C Check input data
C
      IF (NCOLS.GT.NCMAX) THEN
         CALL PUTFAT ('Column dimension exceeded in call to L1NORM')
         RETURN
      ENDIF
      IF (NCOLS.LT.N3) THEN
         CALL PUTFAT ('Must have at least 3 columns: e.g. x, y, and s')
         RETURN
      ENDIF
      IF (NROWS.GT.NRMAX) THEN
         CALL PUTFAT ('Row dimension exceeded in call to L1NORM')
         RETURN
      ENDIF
      IF (NROWS.LE.NCOLS - 2) THEN
         CALL PUTFAT ('Must have more y-values than variables')
         RETURN
      ENDIF
C
C Initialise elements of ISX ... M = total number of variables
C
      E_NUMBERS = E_FORMATS()
      M = NCOLS - N2
      DO I = N1, M
         IF (I.LE.NISX) THEN
            ISX(I) = ISXSAV(I)
         ELSE
            ISX(I) = N1
         ENDIF
      ENDDO
      ISX(M + N1) = N0
C
C Define N = no. active equations and B = active RHS
C
      N = N0
      K = NCOLS - N1
      DO I = N1, NROWS
         VALUE = A1(I,NCOLS)
         IF (VALUE.GT.TOL) THEN
            N = N + N1
            B(N) = A1(I,K)
         ENDIF
      ENDDO
      MEAN = 'M'
      F60 = TRIM60(FNAME)
      T60 = CHOP60(TITLE)
C
C Main branch point for repeated analysis
C
      ICOUNT = ICOUNT + N1
      DONE = .TRUE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Initialise the menu
C
         NUMDEC = N1
         IP = N0
         IF (MEAN.EQ.'M') THEN
            IP = IP + N1
            LABELM = '(Yes)'
         ELSE
            LABELM = ' (No)'
         ENDIF
         NVAR = N0
         DO I = N1, M
            IF (ISX(I).NE.N0) THEN
               IP = IP + N1
               NVAR = NVAR + N1
            ENDIF
         ENDDO
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) ICOUNT, F60, T60, LABELM, M,
     +                       NVAR, M - NVAR, IP
         ELSE
            I12(1) = FORM12(ICOUNT)	
            I12(2) = FORM12(M)
            I12(3) = FORM12(NVAR)
            I12(4) = FORM12(M - NVAR)
            I12(5) = FORM12(IP)
            WRITE (TEXT,150) I12(1), F60, T60, LABELM, I12(2),
     +                       I12(3), I12(4), I12(5)  
         ENDIF  
C
C Now refine details of the menu
C
         CALL ISXTYP (ISX, M, NVAR, NXMIN,
     +                LINE,
     +                IWARNU)
         TEXT(N4) = LINE
         IF (IWARNU) TEXT(N5) = '* = suppressed'
         NUMBLD(1) = 1
         NUMBLD(4) = 1
         NUMBLD(6) = 1
         NUMBLD(7) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         FITNOW = .FALSE.
         IF (NUMDEC.EQ.N1) THEN
C
C Proceed to fitting
C
            N = N0
            FITNOW = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Change status of MEAN
C
            IF (MEAN.EQ.'M') THEN
               MEAN = 'Z'
               CALL PUTADV (
     +'Regression will now pass through the origin')
            ELSE
               MEAN = 'M'
               CALL PUTADV (
     +'A mean term, intercept, will be in the model')
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Suppress/restore variables
C
            CALL ISXEDI (ISX, M, NVAR, NXMIN)
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Results
C
            CALL REVPRO (NF)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Terminate current data analysis
C
            REPEET = .FALSE.
         ENDIF
C
C Loop for fitting and output of results
C
         IF (FITNOW) THEN
C
C Define N and assign data to array A2
C Include a first column of 1 for the constant term X = 1 if MEAN
C
            N = N0
            DO I = N1, NROWS
               VALUE = A1(I,NCOLS)
               IF (VALUE.GT.TOL) THEN
                  N = N + N1
                  K = N0
                  IF (MEAN.EQ.'M') THEN
                     K = K + N1
                     A2(N,K) = ONE
                  ENDIF
                  DO J = N1, M
                     IF (ISX(J).NE.N0) THEN
                        K = K + N1
                        A2(N,K) = A1(I,J)
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
C
C Call AXEQB3
C
            NCOL1 = IP
            NROW1 = N
            LWORK = 3*NRMAX + 5*NCMAX + NCMAX*NCMAX +
     +              ((NCMAX + 1)*(NCMAX + 2))/2
            CALL GETNOU (NIN)
            CALL AXEQB3 (INDX, LWORK, NCMAX, NCOL1, NIN, NF, NRMAX,
     +                   NROW1,
     +                   A2, B, EL1N, W, X,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE1, SUPPLY)
            CLOSE (UNIT = NIN)
C
C Calculate RESIDS
C
            IF (MEAN.EQ.'M') THEN
               DO I = N1, N
                  VALUE = X(1)
                  K = N1
                  DO J = N1, IP - N1
                     K = K + N1
                     VALUE = VALUE + A2(I,K)*X(K)
                  ENDDO
                  THEORY(I) = VALUE
                  RESIDS(I) = B(I) - THEORY(I)
               ENDDO
            ELSE
               DO I = N1, N
                  VALUE = ZERO
                  DO J = N1, IP
                     VALUE = VALUE + A2(I,J)*X(J)
                  ENDDO
                  THEORY(I) = VALUE
                  RESIDS(I) = B(I) - THEORY(I)
               ENDDO
            ENDIF
C
C Output the best-fit parameters
C
            WRITE (NF,'(A)') BLANK
            DO I = N1, N7
               IF (I.NE.N2) WRITE (NF,'(A)') TEXT(I)
            ENDDO
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 4
            WRITE (LINE,200)
            WRITE (NF,200)
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
            J = N0
            IF (MEAN.EQ.'M') THEN
               J = J + N1
               IF (E_NUMBERS) THEN
                  WRITE (LINE,300) X(J)
                  WRITE (NF,300) X(J)
               ELSE
                  D13(1) = SHOWLJ(X(J))   
                  WRITE (LINE,350) D13(1)
                  WRITE (NF,350) D13(1)
               ENDIF   
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            DO I = N1, M
               IF (ISX(I).NE.N0) THEN
                  J = J + N1
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,400) I, X(J)
                     WRITE (NF,400) I, X(J)
                  ELSE
                     D13(1) = SHOWLJ(X(J))
                     WRITE (LINE,450) I, D13(1)
                     WRITE (NF,450) I, D13(1)  
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ENDDO
            COLOUR = 4
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) EL1N
               WRITE (NF,500) EL1N
            ELSE
               D13(1) = SHOWLJ(EL1N)
               WRITE (LINE,550) D13(1)
               WRITE (NF,550) D13(1)
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
            CALL TABLE1 (COLOUR, 'CLOSE')
            NUMDEC = N1
C
C Output the residuals, etc.
C
            DONE = .FALSE.
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               WRITE (TEXT,600)
               CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, N6, NUMPOS,
     +                      TEXT)
               IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
                  COLOUR = 15
                  CALL TABLE1 (COLOUR, 'OPEN')
                  WRITE (LINE,700)
                  COLOUR = 4
                  CALL TABLE1 (COLOUR, LINE)
                  COLOUR = 0
                  DO I = N1, N
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,800) I, B(I), THEORY(I), RESIDS(I)
                     ELSE
                        D13(1) = SHOWRJ(B(I))
                        D13(2) = SHOWRJ(THEORY(I))
                        D13(3) = SHOWRJ(RESIDS(I))
                        WRITE (LINE,850) I, D13(1), D13(2), D13(3)  
                     ENDIF  
                     CALL TABLE1 (COLOUR, LINE)
                  ENDDO
                  CALL TABLE1 (COLOUR, 'CLOSE')
                  NUMDEC = N3
               ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C
                  IF (DONE) THEN
                     CALL PUTADV (
     +'Residuals have already been written to the results file')
                  ELSE
                     WRITE (NF,'(A)') BLANK
                     WRITE (NF,700)
                     IF (E_NUMBERS) THEN
                        DO I = N1, N
                           WRITE (NF,800) I, B(I), THEORY(I), RESIDS(I)
                        ENDDO
                     ELSE
                        DO I = N1, N
                           D13(1) = SHOWRJ(B(I))
                           D13(2) = SHOWRJ(THEORY(I))
                           D13(3) = SHOWRJ(RESIDS(I)) 
                           WRITE (NF,850) I, D13(1), D13(2), D13(3)
                        ENDDO 
                     ENDIF  
                     CALL PUTADV (
     +'Residuals have now been written to the results file')
                     DONE = .TRUE.
                  ENDIF
                  NUMDEC = N3
               ELSEIF (NUMDEC.EQ.N3) THEN
C
C Residuals agains theory
C
                  CALL GKS001 (N0, N3, N,
     +                         THEORY, RESIDS,
     +                         'Residuals against Theory',
     +                         'Theory',
     +                         'Residuals')
                  NUMDEC = N6
               ELSEIF (NUMDEC.GE.N4 .AND. NUMDEC.LE.N5) THEN
C
C Half normal or full normal plot
C
                  ISEND = NUMDEC - N3
                  CALL HNPLOT (ISEND, N,
     +                         RESIDS)
                  NUMDEC = N6
               ELSE
C
C Go back for further analysis
C
                  AGAIN = .FALSE.
               ENDIF
            ENDDO
         ENDIF
      ENDDO
C
C Store ISXSAV
C
      DO I = 1, MIN(M,NISX)
         ISXSAV(I) = ISX(I)
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'L1-norm fitting',I4
     +/
     +/'Current status of x-values:'
     +/
     +/
     +/'File:',1X,A
     +/'Title:',1X,A
     +/'Use weights supplied',1X,' (No)'
     +/'Include a constant',1X,A
     +/'Number of variables supplied',I4
     +/'Number of variables included',I4
     +/'Number of variables excluded',I4
     +/'Number of parameter estimates',I4
     +/'L1-norm fit with current settings'
     +/'Change status of constant term'
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Quit ... Exit L1-norm fitting')
  150 FORMAT (
     + 'L1-norm fitting',1X,A
     +/
     +/'Current status of x-values:'
     +/
     +/
     +/'File:',1X,A
     +/'Title:',1X,A
     +/'Use weights supplied',1X,' (No)'
     +/'Include a constant',1X,A
     +/'Number of variables supplied',1X,A
     +/'Number of variables included',1X,A
     +/'Number of variables excluded',1X,A
     +/'Number. of parameter estimates',1X,A
     +/'L1-norm fit with current settings'
     +/'Change status of constant term'
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Quit ... Exit L1-norm fitting')   
  200 FORMAT (' Parameter')
  300 FORMAT (' Constant',   1P,E13.5)
  350 FORMAT (' Constant',   2X,A)
  400 FORMAT ('   B(',I2,')',1P,E13.5)
  450 FORMAT ('   B(',I2,')',2X,A)
  500 FORMAT (' L1-norm objective function =',1P,E13.5)
  550 FORMAT (' L1-norm objective function =',1X,A)
  600 FORMAT (
     + 'Display residuals'
     +/'File residuals'
     +/'Plot residuals against theory'
     +/'Half-normal residuals plot'
     +/'Full-normal residuals plot'
     +/'Quit ... Exit residuals plotting')
  700 FORMAT ('Number       Y-value        Theory      Residual')
  800 FORMAT (I6,1P,3(1X,E13.5))
  850 FORMAT (I6,1P,3(1X,A13))
      END
C
C
