C
C
      SUBROUTINE LDLC50 (NCOL, NIN, NOUT, NRMAX, NROW,
     +                   A, T, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION : calculate LD50, LC50, etc. and other percentiles
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C ADVICE : Developed from ANOVAP 28/04/2002
C          21/05/2002 revised the naming system x, N, t to y, N, x
C          21/11/2002 added HNPLOT
C          02/02/2003 added TTEST2 and PCVTST
C          14/02/2006 added NCOL, NROW, FNAME, TITLE, NEWDAT and SUPPLY
C          20/08/2014 added INTENTS and error bar plots 
C          28/12/2014 added check for IFAIL = 14 on exit from G02GBF
C          09/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          NCOL: (input/output) depending on SUPPLY as for A
C           NIN: (input/unchanged) unconnected unit for reading in data
C          NOUT: (input/unchanged) preconnected unit for output of results
C         NRMAX: (input/unchanged) first dimension of A, second is 4
C          NROW: (input/output) as for A
C             A: (input/output) as follows:
C                SUPPLY = .TRUE. then A is (input/output-rearranged) o/w output
C                If formatted as x, y, N, s then A is reformatted internally into y, N, X 
C                T(NMAX), X(NMAX,1), Y(NMAX) = workspaces
C          FNAME and TITLE as for A
C        NEWDAT: (output)
C        SUPPLY: (input/unchanged)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NOUT, NRMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,4), T(NRMAX),
     +                                       X(NRMAX,1), Y(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT)   :: NEWDAT
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: V(:,:), WT(:), X1(:), X2(:),
     +                                 Y1(:), Y2(:)
C
C Locals
C
      INTEGER    I, IADD1, IERR, ISEND, N, NMAX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ICOUNT, IDF, IFAIL, IRANK, ITEST, JCOLOR, NPTS, NTYPE
      INTEGER    IP, M, MODE, NCMAX, NPAR
      PARAMETER (IP = 2, M = 1, NCMAX = 4, NPAR = 2)
      INTEGER    L1, L2, L3, L4, M1, M2, M3, M4, N0, N1, N2, N3, N4, N5,
     +           N6, N15
      PARAMETER (L1 = 0, L2 = 1, L3 = 2, L4 = 0, M1 = 5, M2 = 0, M3 = 0,
     +           M4 = 0, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N15 = 15)
      INTEGER    ISX(N2)
      INTEGER    IPRINT, LDV, LDX, MAXIT, NGRAF
      PARAMETER (IPRINT = -1, MAXIT = 50,
     +           NGRAF = 100)
      DOUBLE PRECISION DEV, PCENT, VALUE,
     +                 WK((IP*IP + 3*IP + 22)/2), XDELTA
      DOUBLE PRECISION B(IP), COV(IP*(IP + 1)/2), SE(IP)
      DOUBLE PRECISION X3(N2), X4(N2), Y3(N2), Y4(N2)
      DOUBLE PRECISION COVAR(NPAR,NPAR), PAR(NPAR)
      DOUBLE PRECISION COL1, COL2, COL3
      DOUBLE PRECISION ZERO, ONE, X99
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, X99 = 99.0D+00)
      DOUBLE PRECISION EPS, TOL
      PARAMETER (EPS = 1.0D-6, TOL = 5.0D-5)
      DOUBLE PRECISION G01EAF$
      CHARACTER  (LEN = 13) D13(4), SHOWRJ
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, TRIM80*80
      CHARACTER  BLANK*1, TYPE1*50
      PARAMETER (BLANK = ' ')
      CHARACTER  PTITLE*30, XTITLE*30, YTITLE*30
      PARAMETER (XTITLE = 'x (control variable)',
     +           YTITLE = 'p = y/N')
      CHARACTER  PNAME*30, XNAME*20, YNAME*20
      CHARACTER  LINK*1, MEAN*1, OFFSET*1, WEIGHT*1
      PARAMETER (MEAN = 'M', OFFSET = 'N', WEIGHT = 'U')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN2, READY, REPEET, FITTED
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, FIXCOL, FIXROW, LABEL
      PARAMETER (FIXROW = .FALSE., FIXCOL = .FALSE., LABEL = .TRUE.)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWRJ 
      EXTERNAL   LBOX01, MATTIN, PUTFAT, PUTIFA, CHOP80, PATCH1, PUTADV,
     +           GLMP50, TRIM80, GKS004, REVPRO, GETDM1, TABLE1, LSTBOX,
     +           PUTMES, HNPLOT, TTEST2, PCVTST, LDLC50_EBPLOT
      EXTERNAL   G02GBF$, G01EAF$
      INTRINSIC  DBLE, EXP, MIN
      SAVE       ICOUNT, NTYPE, PCENT
      DATA       ICOUNT, NTYPE, PCENT / 0, 2, 50.0D+00 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise
C
      IF (NRMAX.GE.3) THEN
         NMAX = NRMAX
         LDV = NMAX
         LDX = LDV
      ELSE
         RETURN
      ENDIF
      IF (SUPPLY) THEN
C
C Check if matrix has 3 or 4 columns
C
         READY = .TRUE.
         IF (NCOL.LT.N3 .OR. NCOL.GT.N4) THEN
            CALL PUTFAT ('Data table must have 3 or 4 columns')
            RETURN
         ENDIF
C
C Check if matrix too large
C
         IF (NROW.GT.LDV) THEN
            CALL PUTFAT (
     +     'Maximum dimension exceeded in call to LDLC50')
            RETURN
         ENDIF
C
C Check
C
         IF (NCOL.EQ.N4) THEN
            IADD1 = N0
            DO I = N1, NROW
               IF (A(I,N4).GT.ZERO) THEN
                  IADD1 = IADD1 + N1
                  COL1 = A(I,N1)
                  COL2 = A(I,N2)
                  COL3 = A(I,N3)
                  A(IADD1,N1) = COL2
                  A(IADD1,N2) = COL3
                  A(IADD1,N3) = COL1
               ENDIF
            ENDDO
            NROW = IADD1
            IF (NROW.LT.N3) THEN
               CALL PUTFAT (
     +'Insufficient data after checking for s(i) =< 0')
               RETURN
            ENDIF
         ENDIF
         IF (NROW.GT.N2) THEN
            DO I = N1, NROW
               IF (READY) THEN
                  IF (A(I,N1).LT.ZERO) THEN
                     WRITE (LINE,300) I
                     CALL PUTFAT (LINE)
                     READY = .FALSE.
                  ENDIF
                  IF (A(I,N2).LT.A(I,N1)) THEN
                     WRITE (LINE,400) I
                     CALL PUTFAT (LINE)
                     READY = .FALSE.
                  ENDIF
                  IF (I.GT.N1) THEN
                     IF (A(I,N3).LT.A(I - N1,N3)) THEN
                        WRITE (LINE,500) I, I - N1
                        CALL PUTFAT (LINE)
                        READY = .FALSE.
                     ENDIF
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
         IF (.NOT.READY) RETURN
      ENDIF
C
C Allocate
C
      IERR = 0
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WT)) DEALLOCATE(WT, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (V(LDV,IP + 7), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (WT(LDV), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (X1(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (X2(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (Y1(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (Y2(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      NEWDAT = .FALSE.
      N = N0
      DO I = N1, N2
         ISX(I) = N1
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO
      DO I = N1, LDV
         WT(I) = ONE
      ENDDO
      FITTED = .FALSE.
      IF (SUPPLY) THEN
C
C Write data identifier to file and calculate graph points
C
         WRITE (NOUT,'(A,A)') 'File: ', TRIM80(FNAME)
         WRITE (NOUT,'(A,A)') 'Data: ', CHOP80(TITLE)
         X2(N1) = A(N1,N3)
         X2(NGRAF) = A(NROW,N3)
         XDELTA = (X2(NGRAF) - X2(N1))/DBLE(NGRAF - N1)
         DO I = N2, NGRAF - N1
            X2(I) = X2(I - N1) + XDELTA
         ENDDO
      ENDIF
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NTYPE.EQ.N1) THEN
            TYPE1 = '[minimal details and standard-plot]'
         ELSE
            TYPE1 = '[full details plus error-bar-plot]'
         ENDIF
         WRITE (TEXT,100) CHOP80(FNAME), PCENT, TYPE1
         NUMOPT = 12
         NSTART = 16
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = NUMOPT - N1
         NUMBLD(1) = 4
         NUMBLD(3) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(3) = 0
         LINK = 'X'
         IF (NUMDEC.EQ.1) THEN
C
C New data requested
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DEALLOCATE(V, STAT = IERR)
               DEALLOCATE(WT, STAT = IERR)
               DEALLOCATE(X1, STAT = IERR)
               DEALLOCATE(X2, STAT = IERR)
               DEALLOCATE(Y1, STAT = IERR)
               DEALLOCATE(Y2, STAT = IERR)
               RETURN
            ENDIF
            NROW = N0
            FITTED = .FALSE.
            READY = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Logistic link requested
C
            IF (READY) THEN
               LINK = 'G'
            ELSE
               FITTED = .FALSE.
               CALL PUTFAT ('First supply data')
               NUMDEC = N0
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Binomial link requested
C
            IF (READY) THEN
               LINK = 'P'
            ELSE
               FITTED = .FALSE.
               CALL PUTFAT ('First supply data')
               NUMDEC = N0
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C log-log link requested
C
            IF (READY) THEN
               LINK = 'C'
            ELSE
               FITTED = .FALSE.
               CALL PUTFAT ('First supply data')
               NUMDEC = N0
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
             IF (FITTED) THEN
C
C Output the residuals, etc.
C
               DO I = N1, N
                  Y(I) = A(I,N1)
               ENDDO
              
               AGAIN2 = .TRUE.
               DO WHILE (AGAIN2)
                  WRITE (TEXT,700)
                  NUMDEC = 4
                  NUMOPT = 6
                  NSTART = 3
                  NTEXT = NSTART + NUMOPT - 1
                  NUMBLD(1) = 4
                  CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                         TEXT) 
                  NUMBLD(1) = 0                 
                  IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
                     JCOLOR = N15
                     CALL TABLE1 (JCOLOR, 'OPEN')
                     WRITE (LINE,800)
                     JCOLOR = N4
                     CALL TABLE1 (JCOLOR, LINE)
                     JCOLOR = N0
                     IF (E_NUMBERS) THEN
                        DO I = N1, N
                           WRITE (LINE,900) I, Y(I), V(I,2), V(I,5), 
     +                                      V(I,6)
                           CALL TABLE1 (JCOLOR, LINE)
                        ENDDO
                        CALL TABLE1 (JCOLOR, 'CLOSE')
                     ELSE
                        DO I = N1, N   
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6)) 
                           WRITE (LINE,950) I, D13(1), D13(2), D13(3), 
     +                                      D13(4)
                           CALL TABLE1 (JCOLOR, LINE)  
                        ENDDO 
                        CALL TABLE1 (JCOLOR, 'CLOSE')                       ENDDO                         
                     ENDIF   
                     NUMDEC = N2
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C
                     WRITE (NOUT,'(A)') ' '
                     WRITE (NOUT,800)
                     IF (E_NUMBERS) THEN
                        DO I = N1, N
                           WRITE (NOUT,900) I, Y(I), V(I,2), V(I,5),
     +                                      V(I,6)
                        ENDDO
                     ELSE
                         DO I = N1, N
                           D13(1) = SHOWRJ(Y(I))
                           D13(2) = SHOWRJ(V(I,2))
                           D13(3) = SHOWRJ(V(I,5))
                           D13(4) = SHOWRJ(V(I,6)) 
                           WRITE (NOUT,950) I, D13(1), D13(2), D13(3), 
     +                                      D13(4)
                        ENDDO 


                     ENDIF  
                     CALL PUTADV (
     +'Residuals table has now been written to the results file')
                     NUMDEC = N3
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot the residuals
C
                      NPTS = MIN(N, NGRAF)
                      DO I = N1, NPTS
                         X1(I) = V(I,2)
                         Y1(I) = V(I,5)
                      ENDDO
                      DO I = N1, N2
                         X2(I) = ZERO
                         X3(I) = ZERO
                         X4(I) = ZERO
                         Y2(I) = ZERO
                         Y3(I) = ZERO
                         Y4(I) = ZERO
                      ENDDO
                      PNAME = 'Deviance Residuals'
                      XNAME = 'Best-Fit'
                      YNAME = 'Residuals'
C
C Plot the residuals
C
                      CALL GKS004 (N0, N0, N0, N0,
     +                             N4, N0, N0, N0,
     +                             NPTS, N2, N2, N2,
     +                             X1, X2, X3, X4,
     +                             Y1, Y2, Y3, Y4,
     +                             PNAME, XNAME, YNAME,
     +                             AXES, GSAVE)
                     NUMDEC = N4
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N4) THEN
C
C Half normal plot
C

                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        Y1(I) = V(I,5)
                     ENDDO
                     IFAIL = N1
                     CALL HNPLOT (IFAIL, NPTS, Y1)
                     AGAIN2 = .TRUE.
                  ELSEIF (NUMDEC.EQ.N5) THEN
C
C Full normal plot
C

                     NPTS = MIN(N, NGRAF)
                     DO I = N1, NPTS
                        Y1(I) = V(I,5)
                     ENDDO
                     IFAIL = N2
                     CALL HNPLOT (IFAIL, NPTS, Y1)
                     AGAIN2 = .TRUE.
                  ELSE
                     AGAIN2 = .FALSE.
                  ENDIF
                  NUMDEC = N6
               ENDDO
            ELSE
               CALL PUTFAT ('Not ready  ...  First fit the data')
            ENDIF
            NUMDEC = N0
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Set the percentile
C
            NUMDEC = N0
            CALL GETDM1 (ONE, PCENT, X99,
     +      'Percentile required (e.g. 25, 50, 75)')
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Output
C
            NUMDEC = N0
            IF (NTYPE.EQ.N1) THEN
               NTYPE = N2
            ELSE
               NTYPE = N1
            ENDIF
            IF (NTYPE.EQ.1) THEN
               CALL PUTADV (
     +'Only minimal details and a standard plot will be displayed')
            ELSE
               CALL PUTADV (
     +'Full details incuding error bar plots will be displayed')
            ENDIF        
         ELSEIF (NUMDEC.EQ.8) THEN
            CALL TTEST2 (NOUT)
         ELSEIF (NUMDEC.EQ.9) THEN
            IF (FITTED) THEN
               MODE = 2
               NPTS = N
               PAR(1) = B(1)
               PAR(2) = B(2)
               COVAR(1,1) = COV(1)
               COVAR(2,2) = COV(3)
               COVAR(1,2) = COV(2)
               COVAR(2,1) = COV(2)
            ELSE
               MODE = 3
            ENDIF
            CALL PCVTST (MODE, NOUT, NPAR, NPTS, NPAR, COVAR, PAR)
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C Results
C
            NUMDEC = N0
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help requested
C
            NUMDEC = N0
            WRITE (TEXT,200)
            NTEXT = 23
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = 0
         ELSE
C
C Exit
C
            NEWDAT = .FALSE.
            DEALLOCATE(V, STAT = IERR)
            DEALLOCATE(WT, STAT = IERR)
            DEALLOCATE(X1, STAT = IERR)
            DEALLOCATE(X2, STAT = IERR)
            DEALLOCATE(Y1, STAT = IERR)
            DEALLOCATE(Y2, STAT = IERR)
            RETURN
         ENDIF
C
C Get data if NUMDEC = 1
C
         IF (NUMDEC.EQ.1) THEN
            CALL PUTADV (
     +'Input data as y,N,x (e.g. ld50.tf1) or x,y,N,s (e.g. ld50.tf2)')
            ISEND = N3
            FNAME = BLANK
            TITLE = BLANK
            CLOSE (UNIT = NIN)
            CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NMAX, NROW,
     +                   A, T,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)
            CLOSE (UNIT = NIN)
            IF (.NOT.ABORT .AND. NROW.LT.N3) THEN
               ABORT = .TRUE.
               CALL PUTFAT ('Must have at least 3 data points')
            ENDIF
            IF (ABORT) THEN
               READY = .FALSE.
               NROW = N0
            ELSE
               READY = .TRUE.
            ENDIF
C
C Check if matrix has 3 or 4 columns
C
            IF (READY .AND. (NCOL.LT.N3 .OR. NCOL.GT.N4)) THEN
               CALL PUTFAT ('Data table must have 3 or 4 columns')
               READY = .FALSE.
               NROW = N0
            ENDIF
C
C Check if matrix too large
C
            IF (READY .AND. NROW.GT.LDV) THEN
               CALL PUTFAT (
     +        'Maximum dimension exceeded in call to LDLC50')
               READY = .FALSE.
               NROW = N0
            ENDIF
C
C Check
C
            IF (READY .AND. NCOL.EQ.N4) THEN
               IADD1 = N0
               DO I = N1, NROW
                  IF (A(I,N4).GT.ZERO) THEN
                     IADD1 = IADD1 + N1
                     COL1 = A(I,N1)
                     COL2 = A(I,N2)
                     COL3 = A(I,N3)
                     A(IADD1,N1) = COL2
                     A(IADD1,N2) = COL3
                     A(IADD1,N3) = COL1
                  ENDIF
               ENDDO
               NROW = IADD1
               IF (NROW.LT.N3) THEN
                  CALL PUTFAT (
     +'Insufficient data after checking for s(i) =< 0')
                  READY = .FALSE.
                  NROW = N0
               ENDIF
            ENDIF
            IF (READY .AND. NROW.GT.N2) THEN
               DO I = N1, NROW
                  IF (READY) THEN
                     IF (A(I,N1).LT.ZERO) THEN
                        WRITE (LINE,300) I
                        CALL PUTFAT (LINE)
                        READY = .FALSE.
                     ENDIF
                     IF (A(I,N2).LT.A(I,N1)) THEN
                        WRITE (LINE,400) I
                        CALL PUTFAT (LINE)
                        READY = .FALSE.
                     ENDIF
                     IF (I.GT.N1) THEN
                        IF (A(I,N3).LT.A(I - N1,N3)) THEN
                           WRITE (LINE,500) I, I - N1
                           CALL PUTFAT (LINE)
                           READY = .FALSE.
                        ENDIF
                     ENDIF
                  ENDIF
               ENDDO
            ENDIF
            IF (READY) THEN
C
C Write data identifier to file and calculate graph points
C
               WRITE (NOUT,'(A,A)') 'File: ', CHOP80(FNAME)
               WRITE (NOUT,'(A,A)') 'Data: ', TRIM80(TITLE)
               X2(N1) = A(N1,N3)
               X2(NGRAF) = A(NROW,N3)
               XDELTA = (X2(NGRAF) - X2(N1))/DBLE(NGRAF - N1)
               DO I = N2, NGRAF - N1
                  X2(I) = X2(I - N1) + XDELTA
               ENDDO
            ELSE
               NROW = N0
            ENDIF
         ENDIF
         IF (NUMDEC.GT.1 .AND. NUMDEC.LT.5) THEN
            FITTED = .FALSE.
C
C Load X, Y and T
C
            N = NROW
            DO I = N1, N
               X(I,N1) = A(I,N3)
               Y(I) = A(I,N1)
               T(I) = A(I,N2)
            ENDDO
            IFAIL = 1
            CALL G02GBF$(LINK, MEAN, OFFSET, WEIGHT, N, X, LDX,
     +                   M, ISX, IP, Y, T, WT, DEV, IDF, B,
     +                   IRANK, SE, COV, V, LDV, TOL, MAXIT, IPRINT,
     +                   EPS, WK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G02GBF/LDLC50')
            IF (IFAIL.EQ.14) THEN
               ITEST = 11
            ELSE  
               ITEST = IFAIL
            ENDIF    
            IF (IFAIL.EQ.0 .OR. (ITEST.GE.6 .AND. ITEST.LE.11)) THEN
               IF (ITEST.GE.6 .AND. ITEST.LE.10) THEN
                  TEXT(N1) =
     +'Note: the model fitting procedure has not converged properly'
                  TEXT(N2) = BLANK
                  TEXT(N3) =
     +'Parameter estimates and best fit model may be unreliable since'
                  IF (ITEST.EQ.6) THEN
                     TEXT(N4) =
     +'the fitted model has hit a boundary ... re-formulate the model ?'
                  ELSEIF (ITEST.EQ.7) THEN
                     TEXT(N4) =
     +'the SVD has failed to converge ... selected model may not fit.'
                  ELSEIF (ITEST.EQ.8) THEN
                     TEXT(N4) =
     +'max. iterations used without convergence ... increase MAXIT ?'
                  ELSEIF (ITEST.EQ.9) THEN
                     TEXT(N4) =
     +'rank changed during iteration ... examine the fit carefully.'
                  ELSEIF (ITEST.EQ.10) THEN
                     TEXT(N4) =
     +'NDOF = 0 ... a saturated model has been fitted.'
                  ELSEIF (ITEST.EQ.11) THEN
                     TEXT(N4) =
     +'the fitting procedure in subroutine G02GLIM diverged' 
                  ENDIF
                  TEXT(N5) = BLANK
                  TEXT(N6) =
     +'Advice: new model, adjust data or re-configure GLM parameters.'
                  CALL PUTMES (N6, TEXT)
               ENDIF
               FITTED = .TRUE.
               ICOUNT = ICOUNT + N1
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,'(A,I4)') 'Estimation number',ICOUNT
               ISEND = NTYPE
               CALL GLMP50 (ISEND, NOUT, IP, N, B, COV, DEV, PCENT, SE,
     +                      LINK)
                  DO I = N1, N
                     Y(I) = A(I,N1)/A(I,N2)
                     T(I) = A(I,N3)
                  ENDDO
                  IF (LINK.EQ.'G' .OR. LINK.EQ.'g') THEN
                     PTITLE = 'Best Fit Logistic'
                     DO I = N1, NGRAF
                        VALUE = EXP(B(1) + B(2)*X2(I))
                        Y2(I) = VALUE/(ONE + VALUE)
                     ENDDO
                  ELSEIF (LINK.EQ.'P' .OR. LINK.EQ.'p') THEN
                     PTITLE = 'Best Fit Probit'
                     DO I = N1, NGRAF
                        VALUE = B(1) + B(2)*X2(I)
                        IFAIL = N1
                        Y2(I) = G01EAF$('L', VALUE, IFAIL)
                     ENDDO
                  ELSEIF (LINK.EQ.'C' .OR. LINK.EQ.'c') THEN
                     PTITLE = 'Best Fit log-log'
                     DO I = N1, NGRAF
                        VALUE = EXP(B(1) + B(2)*X2(I))
                        Y2(I) = ONE - EXP(- VALUE)
                     ENDDO
                  ENDIF
                  Y3(1) = PCENT/100.0D+00
                  Y3(2) = Y3(1)
                  X3(1) = X2(1)
                  X3(2) = X2(NGRAF)
                  CALL GKS004 (L1, L2, L3, L4,
     +                         M1, M2, M3, M4,
     +                         N, NGRAF, N2, N0,
     +                         T, X2, X3, X4,
     +                         Y, Y2, Y3, Y4,
     +                         PTITLE, XTITLE, YTITLE,
     +                         AXES, GSAVE)
               IF (NTYPE.EQ.N2) CALL LDLC50_EBPLOT (NCOL, NGRAF, NOUT,
     +                                              NRMAX, NROW,
     +                                              A, T, X2, X3, Y, Y2,
     +                                              Y3,
     +                                              PTITLE, XTITLE,
     +                                              YTITLE)
            ENDIF
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Estimating binomial p(x) and percentiles (e.g. LD50)'
     +/
     +/A
     +/
     +/'Analysis of Proportions format: y,N,x (ld50.tf1)'
     +/'Generalized Linear Model format: x,y,N,s (ld50.tf2)'
     +/'y(i) = no. successes at x = x(i)'
     +/'N(i) = no. Bernoulli trials at x = x(i)'
     +/'x(i) = the variable, e.g. time, conc., log(conc), etc.'
     +/'s(i) not used but row(i) is ignored if s(i) =< 0.'
     +/'The GLM models assume k binomial distributions with:'
     +/'0 =< y(i) =< N(i), i = 1, 2, ..., k, and'
     +/'x(i) =< x(i + 1), i = 1, 2, ..., k-1.'
     +/'Use the model giving the smallest deviance.'
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Fit using Logistic link'
     +/'Fit using Probit link'
     +/'Fit using Complementary log-log link'
     +/'Examine residuals'
     +/'Change percentile [',f5.1,'%]'
     +/'Change output',2X,A
     +/'Compare 2 percentile estimates'
     +/'Compare 2 fits, save to c_recent.cfg'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit binomial p(x) and percentiles')
  200 FORMAT (
     + 'Using Generalized Linear Models (GLM) to estimate percentiles'
     +/
     +/'This method to estimate a p(x) dose-response curve is used for'
     +/'dichotomous data where some condition is used to partition data'
     +/'sets into two classes. The criteria could be alive, dead, male,'
     +/'female, staining by antibody, etc. Typically, the number of'
     +/'successes, y(i), would be recorded from sets of size N(i) when'
     +/'some effector, x(i), such as time, temperature, concentration,'
     +/'log(concentration), etc. is varied over a sufficient range such'
     +/'that p-hat(i) = y(i)/N(i) varies from near 0 to close to 1.'
     +/'The reason for constructing such curves is usually to determine'
     +/'the median value for x, i.e. the value of x = x-half, such that'
     +/'half-maximal effect occurs at a dose of x-half.'
     +/
     +/'A good example would be estimating the LD50, i.e. dose causing'
     +/'50% mortality in animals fed with a toxic substance. Here the'
     +/'counts y, per sample of size N, with dose y are binomially'
     +/'distributed, so the maximum likelihood criterion requires a GLM'
     +/'procedure, e.g. logistic regression, probit analysis, etc.'
     +/'You can use the ordinary analysis of proportions procedure to'
     +/'plot error bars, etc. or even make curve-fit files if the GLM'
     +/'models do not fit and you want to try continous models, e.g.'
     +/'using programs polnom, calcurve, mmfit, exfit, gcfit, etc.')
  300 FORMAT ('y < 0 at data item number',I5,' ... Must have y >= 0')
  400 FORMAT ('y > N at data item number',I5,' ... Must have y =< N' )
  500 FORMAT ('x(',I5,') < x(',I5,') ... Must be in increasing order')
  700 FORMAT (
     + 'Options for analysing residuals'
     +/
     +/'Display table of residuals'
     +/'Write to results file'
     +/'Plot against best fit'
     +/'Plot in half normal format'
     +/'Plot in full normal format'
     +/'Quit ... Exit residuals analysis')
  800 FORMAT ('Number       Y-value        Theory      Deviance',
     +'     Leverages')
  900 FORMAT (I6,1P,4(1X,E13.5))
  950 FORMAT (I6,4(1X,A13))
      END
C
C
      SUBROUTINE LDLC50_EBPLOT (NCOL, NGRAF, NOUT, NRMAX, NROW,
     +                          A, T, X2, X4, Y1, Y2, Y4,
     +                          PTITLE, XTITLE, YTITLE)
C
C ACTION: called from LDLC50 to plot error bars 
C AUTHOR: w.g.bardsley, university of manchester, u.k., 20/08/2014
C     
C
C Meaning of the arguments as follows noting several complications.
C  A: data matrix must be formatted y, N, x     ... as in LDLC50 reformatted by now if 4-column x, y, N, s has been input
C  T: original x values                         ... as in LDLC50 
C X2: best fit curve x-coordinates from LDLC50  ... as in LDLC50 
C X4: first and last x-point for percentile     ... X3 in LDLC50 *** NOT X4
C Y1: y/N from matrix A	                        ... as in LDLC50 
C Y2: best-fit curve y-coordinates from LDLC50  ... as in LDLC50
C Y4: y-level for percentile                    ... Y3 in LDLC50 *** NOT Y4
C
      IMPLICIT NONE
C
C Arguments
C   
      INTEGER,             INTENT (IN) :: NCOL, NGRAF, NOUT, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (IN) :: A(NRMAX,NCOL), T(NROW),
     +                                    X2(NGRAF), X4(2), Y1(NROW),
     +                                    Y2(NGRAF), Y4(2) 
      CHARACTER (LEN = *), INTENT (IN) :: PTITLE, XTITLE, YTITLE
C
C Allocatables
C  
      DOUBLE PRECISION, ALLOCATABLE :: YH1(:), YL1(:)
C
C Locals
C    
      INTEGER I, IERR, IFAIL, K, N  
      INTEGER L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4
      PARAMETER (L1 = 0, L2 = 1, L3 = 0, L4 = 2,
     +           M1 = 5, M2 = 0, M3 = 0, M4 = 0,
     +           N3 = 3, N4 = 2)
      DOUBLE PRECISION X3(N3), YL3(N3), YH3(N3), Y3(N3)
      DOUBLE PRECISION PL, PU
      DOUBLE PRECISION CLEVEL
      PARAMETER (CLEVEL = 0.95D+00)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   PUTIFA, GKSEB4
      EXTERNAL   G07AAF$
      INTRINSIC  NINT
      IF (NGRAF.LT.2 .OR. NROW.LT.2 .OR. NCOL.LT.3 .OR.
     +    NROW.GT.NRMAX) RETURN
      N1 = NROW
      N2 = NGRAF
      IERR = 0
      IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(YL1)) DEALLOCATE(YH1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (YH1(N1), STAT = IERR)  
      IF (IERR.NE.0) RETURN
      ALLOCATE (YL1(N1), STAT = IERR)  
      IF (IERR.NE.0) RETURN
        
      DO I = 1, NROW
         K = NINT(A(I,1))
         N = NINT(A(I,2))
         IFAIL = 0
         CALL G07AAF$(N, K, CLEVEL, PL, PU, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G07AAF/LDLC50_EBPLOT') 
         IF (IFAIL.NE.0) RETURN 
         YL1(I) = PL
         YH1(I) = PU
      ENDDO 
      CALL GKSEB4 (L1, L2, L3, L4,
     +             M1, M2, M3, M4, 
     +             N1, N2, N3, N4, 
     +             T, X2, X3, X4,
     +             YH1, YH3, YL1, YL3, Y1, Y2, Y3, Y4,
     +             PTITLE, XTITLE, YTITLE,
     +             AXES, GSAVE)   
      DEALLOCATE(YL1, STAT = IERR) 
      DEALLOCATE(YH1, STAT = IERR)  
      END
C
C          