C
C
      SUBROUTINE LINFIT (NOUT, NPTS, 
     +                   X, Y,
     +                   FILE, PRINT1)
C
C ACTION : Correlation and linear regression using G02CAF
C          Parameter EPSI controls underflow/overflow
C          Parameter NRMAX should be >= NPTS for call to ORTHOG
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 29/5/91
C          DBOS version ... 8/3/94
C          24/05/1995 Graphics and 95% con lims for rho
C          02/08/1995 New algebra for rho confidence limits
C          19/10/1995 changed G01EBF for G01BAF for NAG mark 16
C          14/12/1996 Added regression line for x on y
C          05/05/1997 win32 version
C          08/02/1999 Improved output
C          17/09/1999 added ORTHOG
C          04/05/2004 extensive revision and added ELIPS1 and REVPRO
C          18/05/2004 now exits when Var(x) = 0, Var(y) = 0, r = 1 or -1
C          11/10/2004 added STDERR to results table and PR to plot title
C          06/11/2006 added intents 
C          12/04/2007 made S allocatable 
C          04/10/2014 added calculation for p in ANOVA table
C          25/09/2016 increased number of significant figures
C
C          NOUT: (input/unchanged) preconnected unit for results
C          NPTS: (input/unchanged) number of x,y pairs
C             X: (input/unchanged) X-data
C             Y: (input/unchanged) Y-data
C          FILE: (input/unchanged) write to results file Y/N?
C        PRINT1: (input/unchanged) write to display monitor Y/N?
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: NOUT, NPTS
      DOUBLE PRECISION, INTENT (IN) :: X(NPTS), Y(NPTS)
      LOGICAL,          INTENT (IN) :: FILE, PRINT1  
C
C Local allocatable array
C  
      DOUBLE PRECISION, ALLOCATABLE :: S(:)    
C
C Locals
C
      INTEGER    ICOUNT
      INTEGER    I, IERR, IFAIL, NDOF, NIN, NPTS1, NRMAX, NTYPE
      INTEGER    N0, N1, N2, N3, N4, N5, NGRAF
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           NGRAF = 10)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT,
     +           NTEXT, NUMTXT, NSTART
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 0, NSTART = 3,
     +           NUMTXT = 28, NUMOPT = 7)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      DOUBLE PRECISION HALF, ONE, TWO, THREE, ZERO
      PARAMETER (HALF = 0.5D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION EPSI, PNT1, PNT01, PNT05, RTOL
      PARAMETER (PNT1 = 0.1D+00, PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION EMAX, EMIN
      PARAMETER (EMAX = 127.0D+00, EMIN = - EMAX)
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION R(20)
      DOUBLE PRECISION PA, PB, PR, STAT, Z
      DOUBLE PRECISION PA1, PB1
      DOUBLE PRECISION CONST, DELTA, F1, F2, RBOT, RTOP, X1, X2
      DOUBLE PRECISION G01EBF$, X02AJF$, X02AMF$
      DOUBLE PRECISION XMAX, XMIN, XX(NGRAF), XXX(NGRAF), YMAX, YMIN,
     +                 YY(NGRAF), YYY(NGRAF)
      DOUBLE PRECISION DNDOF, P(2), SE(2), STDERR
      DOUBLE PRECISION DVAL1, DVAL2, FVAL, G01EDF$, PVAL
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 60 ) MSSAGE, PTYPE(3), VERDIC(2)
      CHARACTER (LEN = 50 ) PTITLE
      CHARACTER (LEN = 27 ) BLANK27, DOT27
      PARAMETER (BLANK27 = '                           ',
     +             DOT27 = '       ...           ...   ') 
      CHARACTER (LEN = 13 ) D13(27), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12 ) BLANK12, DOT12, WORD12, FORM12 
      PARAMETER (BLANK12 = '            ',
     +             DOT12 = '      ...   ') 
      CHARACTER (LEN = 8  ) BLANK8, DOT8
      PARAMETER (BLANK8 = '        ',
     +             DOT8 = '   ...  ') 
      CHARACTER (LEN = 2  ) MINUS, PLUS
      PARAMETER (MINUS = ' -', PLUS = ' +')
      CHARACTER (LEN = 2  ) SIGN1, SIGN2
      CHARACTER (LEN = 1  ) BLANK, XTITLE, YTITLE
      PARAMETER (BLANK = ' ', XTITLE = 'X', YTITLE = 'Y')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    FIRST, PLOT
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    ABORT, COVAR, GOFFIT, SUPPLY, TABLE
      PARAMETER (COVAR = .TRUE., GOFFIT = .FALSE., SUPPLY = .TRUE.,
     +           TABLE = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   PUTFAT, PUTIFA, GKS004, MIDDLE, TABLE1, FORM12,
     +           ORTHOG, LBOX01, ELIPS1, PATCH1, REVPRO
      EXTERNAL   G01EBF$, G01EDF$, G02CAF$, X02AJF$, X02AMF$
      INTRINSIC  ABS, LOG, NINT, MIN, SQRT, EXP, MAX, DBLE
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       PTYPE /
     +'is significantly different from zero (p < 0.01)',
     +'is significantly different from zero (p < 0.05)',
     +'is not significantly different from zero (p > 0.05)' /
C
C Check number of points > 3 else crash when calculating 95% limits
C
      IF (NPTS.LT.N4) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF 
      E_NUMBERS = E_FORMATS()  
C
C Allocate
C         
      IERR = N0
      IF (ALLOCATED(S)) DEALLOCATE(S, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      NRMAX = NPTS
      ALLOCATE(S(NRMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN 
C
C Assign constants then linear regression
C
      EPSI = SQRT(X02AJF$())
      RTOL = 1.0D+09*X02AMF$()
      R(3) = ZERO
      R(4) = ZERO
      R(5) = ONE
      MSSAGE = BLANK
      IFAIL = N1
      CALL G02CAF$(NPTS, X, Y, R, IFAIL)
C
C Check for singular data set
C
      IF (R(3).LE.RTOL .OR. R(4).LE.RTOL) THEN
         MSSAGE = 'Variance too small, X and/or Y fixed'
      ELSEIF (R(5).LE.EPSI - ONE) THEN
         MSSAGE = 'r = -1, perfect correlation'
      ELSEIF (R(5).GE.ONE - EPSI) THEN
         MSSAGE = 'r = 1, perfect correlation'
      ENDIF
      IF (MSSAGE.NE.BLANK) THEN
         WRITE (LINE,200) MSSAGE
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      CALL PUTIFA (IFAIL, NOUT, 'G02CAF/LINFIT')
      IF (IFAIL.NE.0) RETURN
C
C Regression of x on y
C
      PB1 = R(6)*(R(3)/R(4))**2
      PA1 = R(1) - PB1*R(2)
C
C Statistics
C
      NDOF = NPTS - N2
      DNDOF = DBLE(NDOF)
      IFAIL = N1
      PA = TWO*(ONE - G01EBF$('Lower-tail', ABS(R(11)), DNDOF,
     +     IFAIL))
      CALL PUTIFA (IFAIL, NOUT, 'G01EBF/LINFIT')
      IF (PA.LE.PNT01) THEN
         VERDIC(2) = PTYPE(1)
      ELSEIF (PA.LE.PNT05) THEN
         VERDIC(2) = PTYPE(2)
      ELSE
         VERDIC(2) = PTYPE(3)
      ENDIF
      IFAIL = N1
      PB = TWO*(ONE - G01EBF$('Lower-tail', ABS(R(10)), DNDOF,
     +     IFAIL))
      CALL PUTIFA (IFAIL, NOUT, 'G01EBF/LINFIT')
      IF (PB.LE.PNT01) THEN
         VERDIC(1) = PTYPE(1)
      ELSEIF (PB.LE.PNT05) THEN
         VERDIC(1) = PTYPE(2)
      ELSE
         VERDIC(1) = PTYPE(3)
      ENDIF
C
C Fishers z transform then define CONST
C
      IF (ONE + R(5).GT.EPSI .AND. ONE - R(5).GT.EPSI) THEN
         Z = HALF*LOG((ONE + R(5))/(ONE - R(5)))
      ELSE
         MSSAGE = 'r-squared = 1, perfect correlation'
         WRITE (LINE,200) MSSAGE
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      CONST = TWO/SQRT(DBLE(NPTS) - THREE)
C
C p for correlation coeff .... must be identical to p (B.ne.0) above
C
      IF (NPTS.GT.N2 .AND. (ONE - R(5)**2).GT.EPSI) THEN
         STDERR = SQRT((ONE - R(5)**2)/DNDOF)
         STAT = R(5)/STDERR
         IFAIL = N1
         PR = G01EBF$('Lower-tail', STAT, DNDOF, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01EBF/LINFIT')
         PR = TWO*MIN(PR, ONE - PR)
      ELSE
         PR = ZERO
      ENDIF
C
C Alternative simpler calculation for limits (see previous versions)
C
      F1 = TWO*Z + TWO*CONST
      F2 = TWO*Z - TWO*CONST
      CALL MIDDLE (EMIN, F1, EMAX)
      CALL MIDDLE (EMIN, F2, EMAX)
      X1 = (EXP(F1) - ONE)/(ONE + EXP(F1))
      X2 = (EXP(F2) - ONE)/(ONE + EXP(F2))
      RBOT = MIN(X1,X2)
      RTOP = MAX(X1,X2)
      IF (RBOT.LT.- ONE) RBOT = - ONE
      IF (RTOP.LT.- ONE) RTOP = - ONE
      IF (RBOT.GT.ONE) RBOT = ONE
      IF (RTOP.GT.ONE) RTOP = ONE
C
C Calculate p value for ANOVA table
C        
      FVAL = R(15)
      DVAL1 = R(13)
      DVAL2 = R(17)
      PVAL = G01EDF$('U', FVAL, DVAL1, DVAL2, IFAIL)  
      IF (R(6).LT.ZERO) THEN
         SIGN1 = MINUS
      ELSE
         SIGN1 = PLUS
      ENDIF  
      IF (PB1.LT.ZERO) THEN
         SIGN2 = MINUS
      ELSE
         SIGN2 = PLUS
      ENDIF       
      WORD12 = FORM12(NPTS)
      ICOUNT = ICOUNT + 1  
C
C Output table of results
C
      IF (.NOT.E_NUMBERS) THEN
         D13(1) = SHOWLJ(R(1))
         D13(2) = SHOWLJ(R(3))
         TEMP = R(3)**2
         D13(3) = SHOWLJ(TEMP)
         D13(4) = SHOWLJ(R(2))
         D13(5) = SHOWLJ(R(4))
         TEMP = R(4)**2
         D13(6) = SHOWLJ(TEMP)
         D13(7) = SHOWRJ(R(6))
         D13(8) = SHOWRJ(R(8))
         D13(9) = SHOWRJ(R(10))
         D13(10) = SHOWRJ(R(7))
         D13(11) = SHOWRJ(R(9))
         D13(12) = SHOWRJ(R(11))
         D13(13) = SHOWRJ(R(5))
         D13(14) = SHOWRJ(STDERR)
         D13(15) = SHOWRJ(STAT)
         TEMP = R(5)**2
         D13(16) = SHOWRJ(TEMP)
         D13(17) = SHOWRJ(Z)
         D13(18) = SHOWRJ(R(12))
         D13(19) = SHOWRJ(R(14))
         D13(20) = SHOWRJ(R(15))
         D13(21) = SHOWRJ(R(16))
         D13(22) = SHOWRJ(R(18))
         D13(23) = SHOWRJ(R(19))
         D13(24) = SHOWLJ(R(7))
         TEMP = ABS(R(6))
         D13(25) = SHOWLJ(TEMP)
         D13(26) = SHOWLJ(PA1)
         TEMP = ABS(PB1)
         D13(27) = SHOWLJ(TEMP)
      ENDIF  

      IF (FILE) THEN
         WRITE (NOUT,'(A)') BLANK
         IF (E_NUMBERS) THEN 
         WRITE (NOUT,300) ICOUNT, WORD12,
     +                    R(1), R(3), R(3)**2, R(2), R(4), R(4)**2,
     +                    R(6), R(8), R(10), PB,
     +                    R(7), R(9), R(11), PA,
     +                    R(5), STDERR, STAT, PR,
     +                    R(5)**2, DOT27, DOT8,
     +                    Z, DOT27, DOT8,
     +                    100.0D+00*R(5)**2,
     +                    RBOT, RTOP,
     +                    R(12), NINT(R(13)), R(14), R(15), PVAL, R(16),
     +                    NINT(R(17)), R(18), DOT12, DOT8,
     +                    R(19), NINT(R(20)), DOT12, DOT12, DOT8,
     +                    VERDIC(1), VERDIC(2),
     +                    R(7), SIGN1, ABS(R(6)), PA1, SIGN2, ABS(PB1)
      ELSE
         WRITE (NOUT,350) ICOUNT, WORD12,
     +                    D13(1), D13(2), D13(3),
     +                    D13(4), D13(5), D13(6),  
     +                    D13(7), D13(8), D13(9), PB,
     +                    D13(10), D13(11), D13(12), PA,
     +                    D13(13), D13(14), D13(15), PR,
     +                    D13(16), BLANK27, BLANK8,
     +                    D13(17), BLANK27, BLANK8,
     +                    100.0D+00*R(5)**2, 
     +                    RBOT, RTOP,
     +                    D13(18), NINT(R(13)), D13(19), D13(20), PVAL,
     +                    D13(21), NINT(R(17)), D13(22), BLANK12,
     +                    BLANK8,
     +                    D13(23), NINT(R(20)), BLANK12, BLANK12,
     +                    BLANK8,
     +                    VERDIC(1), VERDIC(2),
     +                    TRIM(D13(24)), SIGN1, TRIM(D13(25)),
     +                    TRIM(D13(26)), SIGN2, TRIM(D13(27))
         ENDIF
      ENDIF
      IF (PRINT1) THEN
         IF (E_NUMBERS) THEN
         WRITE (TEXT,300) ICOUNT, WORD12,
     +                    R(1), R(3), R(3)**2, R(2), R(4), R(4)**2,
     +                    R(6), R(8), R(10), PB,
     +                    R(7), R(9), R(11), PA,
     +                    R(5), STDERR, STAT, PR,
     +                    R(5)**2, BLANK27, BLANK8,
     +                    Z, BLANK27, BLANK8,
     +                    100.0D+00*R(5)**2, 
     +                    RBOT, RTOP,
     +                    R(12), NINT(R(13)), R(14), R(15), PVAL, 
     +                    R(16), NINT(R(17)), R(18), BLANK12, BLANK8,
     +                    R(19), NINT(R(20)), BLANK12, BLANK12, BLANK8,
     +                    VERDIC(1), VERDIC(2),
     +                    R(7), SIGN1, ABS(R(6)), PA1, SIGN2, ABS(PB1)
         ELSE
           
C-----------------------------------------------------------------------------------------
           
         WRITE (TEXT,350) ICOUNT, WORD12,
     +                    D13(1), D13(2), D13(3),
     +                    D13(4), D13(5), D13(6),  
     +                    D13(7), D13(8), D13(9), PB,
     +                    D13(10), D13(11), D13(12), PA,
     +                    D13(13), D13(14), D13(15), PR,
     +                    D13(16), BLANK27, BLANK8,
     +                    D13(17), BLANK27, BLANK8,
     +                    100.0D+00*R(5)**2, 
     +                    RBOT, RTOP,
     +                    D13(18), NINT(R(13)), D13(19), D13(20), PVAL,
     +                    D13(21), NINT(R(17)), D13(22), BLANK12,
     +                    BLANK8,
     +                    D13(23), NINT(R(20)), BLANK12, BLANK12,
     +                    BLANK8,
     +                    VERDIC(1), VERDIC(2),
     +                    TRIM(D13(24)), SIGN1, TRIM(D13(25)),
     +                    TRIM(D13(26)), SIGN2, TRIM(D13(27))
         ENDIF
C
C---------------------------------------------------------------------------
C         
         TEXT(2) = BLANK
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = N1, NUMTXT
            IF (I.EQ.1 .OR. I.EQ.7 .OR. I.EQ.20 .OR. I.EQ.24 .OR.
     +          I.EQ.25 .OR. I.EQ.27) THEN
               ICOLOR = N4
            ELSE
               ICOLOR = N0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF
C
C Plot the correlation lines or ellipses
C
      PLOT = .TRUE.
      FIRST = .TRUE.
      DO WHILE (PLOT)
         WRITE (TEXT,400)
         ICOLOR = 9
         NTEXT = NUMOPT + NSTART - N1
         NUMDEC = NUMOPT - N1
         NUMBLD(1) = N1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         IF (NUMDEC.EQ.N1) THEN
C
C Both least squares lines
C
            XMIN = X(1)
            XMAX = X(1)
            YMIN = Y(1)
            YMAX = Y(1)
            DO I = N1, NPTS
               IF (X(I).LT.XMIN) XMIN = X(I)
               IF (X(I).GT.XMAX) XMAX = X(I)
               IF (Y(I).LT.YMIN) YMIN = Y(I)
               IF (Y(I).GT.YMAX) YMAX = Y(I)
            ENDDO
            XX(1) = XMIN - PNT1*(XMAX - XMIN)
            YY(1) = R(6)*XX(1) + R(7)
            XX(NGRAF) = XMAX + PNT1*(XMAX - XMIN)
            YY(NGRAF) = R(6)*XX(NGRAF) + R(7)
            DELTA = (XX(NGRAF) - XX(1))/DBLE(NGRAF - 1)
            DO I = N2, NGRAF - N1
               XX(I) = XX(I - N1) + DELTA
               YY(I) = R(6)*XX(I) + R(7)
            ENDDO
            YYY(1) = YMIN - PNT1*(YMAX - YMIN)
            XXX(1) = PB1*YYY(1) + PA1
            YYY(NGRAF) = YMAX + PNT1*(YMAX - YMIN)
            XXX(NGRAF) = PB1*YYY(NGRAF) + PA1
            DELTA = (YYY(NGRAF) - YYY(1))/DBLE(NGRAF - 1)
            DO I = N2, NGRAF - N1
               YYY(I) = YYY(I - N1) + DELTA
               XXX(I) = PB1*YYY(I) + PA1
            ENDDO
            IF (PR.GE.0.0001D+00) THEN
               WRITE (PTITLE,500) R(5), PR
            ELSE
               WRITE (PTITLE,600) R(5)
            ENDIF
            CALL GKS004 (N0, N1, N2, N0,
     +                   N5, N0, N0, N0,
     +                   NPTS, NGRAF, NGRAF, N2,
     +                   X, XX, XXX, XX, Y, YY, YYY, YY,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)

         ELSEIF (NUMDEC.LE.N3) THEN
C
C Reduced and major axis lines
C
            IF (FIRST) THEN
               NPTS1 = MIN(NPTS,NRMAX)
               DO I = N1, NPTS1
                  S(I) = ONE
               ENDDO
               FIRST = .FALSE.
            ENDIF
            NIN = - N1
            NTYPE = NUMDEC
            CALL ORTHOG (IFAIL, NIN, NOUT, NPTS1, NPTS1, NTYPE,
     +                   P, S, SE, X, Y,
     +                   ABORT, COVAR, GOFFIT, PLOT, SUPPLY, TABLE)
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Ellipses
C
            CALL ELIPS1 (NPTS,
     +                   R, X, Y)
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,700)
            NTEXT = 20
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD,
     +                   NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
         
         ELSE
            PLOT = .FALSE.
         ENDIF
      ENDDO 
C
C Deallocate
C  
      DEALLOCATE(S, STAT = IERR)    
C
C Format statements
C      
  100 FORMAT ('You must have at least 4 (x,y) data pairs')
  200 FORMAT ('Calculations terminated:',1X,A)
  300 FORMAT (
     + 'Linear regression: y(x) = A + B*x, x(y) = C + D*y, Sample',I3
     +/'------------------------------------------------------------'
     +/'Sample size =',2X,A
     +/'For X: mean =',1P,E13.5,', std. dev. =',E12.5,', var. =',E12.5
     +/'For Y: mean =',1P,E13.5,', std. dev. =',E12.5,', var. =',E12.5
     +/
     +/'Parameter     Estimate      Std.Err.   Est./Std.Err.     p'
     +/'B(slope) ',1P,1X,E13.5,1X,E13.5,E14.5,0P,F10.4
     +/'A(const) ',1P,1X,E13.5,1X,E13.5,E14.5,0P,F10.4
     +/'r(Ppmcc) ',1P,1X,E13.5,1X,E13.5,E14.5,0P,F10.4
     +/'r-squared',1P,1X,E13.5,A27,2X,A8
     +/'z(Fisher)',1P,1X,E13.5,A27,2X,A8
     +/'y-variation due to x =',0P,F6.2,'%'
     +/'z = (1/2)log[(1+r)/(1-r)]'
     +/'r^2 = B*D'
     +/'t = r*sqrt[(n-2)/(1-r^2))] = Est./Std.Err. for B, D, and r'
     +/'The Pearson product-moment corr. coeff. r estimates rho and'
     +/'95% conf. limits using z are ',0P,F8.4,' =< rho =<',F8.4
     +/
     +/'      Source     Sum-of-squares   NDOF   Mean-square',
     +'     F-value    p'
     +/'Due-to-regression',1X,1P,E12.5,2X,I6,2X,E12.5,E12.5,0P,F8.4
     +/'About-regression ',1X,1P,E12.5,2X,I6,2X,E12.5,A12,A8
     +/'Total            ',1X,1P,E12.5,2X,I6,2X,A12,A12,A8
     +/'Conclusion: B',1X,A
     +/'            A',1X,A
     +/
     +/'The two best-fit unweighted regression lines are:'
     +/'y(x) =',1P,E13.5,A,E13.5,'*x, x(y) =',
     + 1P,E13.5,A,E13.5,'*y')
     
C--------------------------------------------------------------------------------
     
  350 FORMAT (
     + 'Linear regression: y(x) = A + B*x, x(y) = C + D*y, Sample',I3
     +/'------------------------------------------------------------'
     +/'Sample size =',2X,A
     +/'For X: mean =',1X,A13,', std. dev. =',1X,A13,', var. =',1X,A,
     +/'For Y: mean =',1X,A13,', std. dev. =',1X,A13,', var. =',1X,A,
     +/
     +/'Parameter     Estimate      Std.Err.   Est./Std.Err.     p'
     +/'B(slope) ',1X,A13,1X,A13,1X,A13,F10.4
     +/'A(const) ',1X,A13,1X,A13,1X,A13,F10.4
     +/'r(Ppmcc) ',1X,A13,1X,A13,1X,A13,F10.4     
     +/'r-squared',1X,A13,A27,2X,A8
     +/'z(Fisher)',1X,A13,A27,2X,A8
     +/'y-variation due to x =',0P,F6.2,'%'
     +/'z = (1/2)log[(1+r)/(1-r)]'
     +/'r^2 = B*D'
     +/'t = r*sqrt[(n-2)/(1-r^2))] = Est./Std.Err. for B, D, and r'
     +/'The Pearson product-moment corr. coeff. r estimates rho and'
     +/'95% conf. limits using z are ',0P,F8.4,' =< rho =<',F8.4
     +/
     +/'      Source      Sum-of-squares   NDOF     Mean-square',
     +'       F-value    p'
     +/'Due-to-regression',1X,A13,2X,I6,2X,1X,A13,1X,A13,F8.4
     +/'About-regression ',1X,A13,2X,I6,2X,1X,A13,A12,A8
     +/'Total            ',1X,A13,2X,I6,2X,A12,A12,A8
     +/'Conclusion: B',1X,A
     +/'            A',1X,A
     +/
     +/'The two best-fit unweighted regression lines are:'
     +/'y(x) =',1X,A,A,1X,A,'*x, x(y) =',
     + 1X,A,A,1X,A,'*y')
     
C---------------------------------------------------------------------------------------
     
  400 FORMAT (
     + 'Correlation scattergram plotting options'
     +/
     +/'Both unweighted least squares lines'
     +/'Unweighted reduced major axis line'
     +/'Unweighted major axis line'
     +/'XY-Means and Data Confidence ellipses'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit scattergram plotting')
  500 FORMAT ('y=A+Bx, x=C+Dy, r=',0P,F7.4,', p=',F6.4)
  600 FORMAT ('y=A+Bx, x=C+Dy, r=',0P,F7.4,', p < .0001')
  700 FORMAT (
     + 'Scattergrams, correlation plots, and confidence ellipses.'
     +/
     +/'Since correlation data have variation in both x and y variables'
     +/'and choice of x and y is arbitrary there are alternative ways'
     +/'to illustrate scatter about various best fit lines.'
     +/
     +/'You can plot the two best fit unweighted least squares lines,'
     +/'i.e. regression of y on x and regression of x on y. Note that'
     +/'for strong correlation the lines will be close, while distinct'
     +/'lines suggest weak Pearson product-moment correlation.'
     +/'For one best-fit line, as in allometric investigations, choose'
     +/'the reduced major axis line (minimal sum of areas of triangles'
     +/'between data and line) or the major axis line (i.e. orthogonal'
     +/'or minimal sum of distances^2) since these allow for variations'
     +/'in both x and y. However be careful to appreciate the effects'
     +/'of changes in units with these alternative plots.'
     +/
     +/'Another way to check for correlation is to examine confidence'
     +/'regions for means or data, as the axes of these ellipses will'
     +/'not be parallel to the x,y axes with significant correlation.')
      END
C
C
