C
C
C LMFIT1: curve fitting by Levenberg-Marquardt with analytic Jacobian
C =======
C
C calls MINPACK routines as follows:-
C ===================================
C*****INCLUDE 'C:\MINPACK\COVAR.FOR'
C*****INCLUDE 'C:\MINPACK\DPMPAR.FOR'
C*****INCLUDE 'C:\MINPACK\ENORM.FOR'
C*****INCLUDE 'C:\MINPACK\LMDER.FOR'
C*****INCLUDE 'C:\MINPACK\LMDER1.FOR'
C*****INCLUDE 'C:\MINPACK\LMPAR.FOR'
C*****INCLUDE 'C:\MINPACK\QRFAC.FOR'
C*****INCLUDE 'C:\MINPACK\QRSOLV.FOR'
C
C
      SUBROUTINE LMFIT1 (LMFUNC, IFAIL, IPVT, IRANK, LW, M, N, NCMAX,
     +                   NOUT, NRMAX,
     +                   CM, FJAC, FVEC, X, W, WSSQ,
     +                   IWARNU)
C
C ACTION : Levenberg-Marquardt using minpack
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 26/8/97
C          18/09/99 Added call to WAITER
C          27/09/2002 replaced patch1 by table1
C          09/03/2021 minor changes to error reporting, e.g. show if relative error in WSSQ change =< 1% 
C          20/11/2023 added e_formats, e_numbers and form12 
C
C ADVICE : LMFUNC: must be consistent with the argument list required
C                  by LMDER
C          IFAIL : There is no need to test IFAIL on exit or covariance
C                  matrix rank since these are flagged if IWARNU = .TRUE.
C          IPVT  : pivot information
C          IRANK : rank of covariance matrix
C          LW    : dimension at least 5*N + M
C          M     : number of data points/residuals
C          N     : number of parameters
C          NCMAX : maximum number of parameters
C          NOUT  : error message unit
C          NRMAX : first dimension of Jacobian
C          CM    : covariance matrix CM(NCMAX,NCMAX)
C          FJAC  : Jacobian FJAC(NRMAX,NCMAX)
C          FVEC  : functions FVEC(M) (weighted residuals)
C          X     : parameters X(N)
C          W     : workspace W(LW)
C          WSSQ  : weighted sum of squares
C          IWARNU: Display warnings ?
C
      IMPLICIT   NONE
      INTEGER    IFAIL, IRANK, LW, M, N, NCMAX, NOUT, NRMAX
      INTEGER    IPVT(N)
      INTEGER    I, INFO, J
      INTEGER    IFLAG
      PARAMETER (IFLAG = 1)
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 24)
      DOUBLE PRECISION CM(NCMAX,N), FJAC(NRMAX,N), FVEC(M),
     +                 X(N), W(LW), WSSQ
      DOUBLE PRECISION WSSQ1
      DOUBLE PRECISION TOL, TOL1, TOL2, TOL3, TOL4
      PARAMETER (TOL1 = 1.0D-4, TOL2 = 1.0D-9, TOL3 = 1.0D-50,
     +           TOL4 = 1.0D-20)
      DOUBLE PRECISION ZERO, ONE, F1, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, F1 = 1.0D+00,
     +           F100 = 100.0D+00)
      DOUBLE PRECISION FACTOR, PCENT
      CHARACTER  (LEN = 100) TEXT(30), ERROR(0:7)
      CHARACTER  (LEN = 13 ) D13(4), SHOWLJ
      CHARACTER  (LEN = 12 ) I12(3), FORM12  
      CHARACTER  (LEN = 8  ) BLANK8, CIPHER 
      PARAMETER  (BLANK8 = '       ')
      LOGICAL    E_FORMATS, E_NUMBERS 
      LOGICAL    ACTION, IWARNU
      EXTERNAL   COVAR, LMFUNC, LMDER1
      EXTERNAL   TABLE1, WAITER
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      INTRINSIC  ABS, DBLE
      DATA ERROR /
     +'FATAL ERROR: Improper input parameters to LMFIT1/LMDER1',
     +'The relative error in WSSQ is at most TOL_1',
     +'Relative error between parameters and solution at most TOL_1',
     +'OK: Both exit conditions are satisfied for TOL_1 value used',
     +'ERROR: FVEC is orthogonal to the columns of the Jacobian',
     +'ERROR: No. iterations reached current limit of 100*(npar + 1)',
     +'ERROR: TOL too small ... no further reduction in WSSQ possible',
     +'ERROR: TOL too small ... no improvement in parameters possible' /
       E_NUMBERS = E_FORMATS()
C
C call WAITER with ACTION = .TRUE.
C
      ACTION = .TRUE.
      CALL WAITER (ACTION)
C
C initialise IRANK, PCENT, WSSQ and CM in case of fault exit
C
      IFAIL = 0
      INFO = 0
      IRANK = 0
      PCENT = ZERO
      WSSQ = ZERO
      DO J = 1, N
         DO I = 1, N
            CM(I,J) = ONE
         ENDDO
      ENDDO
C
C check input parameters and set IFAIL < 0 if unsatisfactory
C
      IF (N.LT.1) THEN
         IFAIL = - 1
      ENDIF
      IF (M.LT.N) THEN
         IFAIL = - 2
      ENDIF
      IF (LW.LT.5*N + M) THEN
         IFAIL = -3
      ENDIF
      IF (NCMAX.LT.N) THEN
         IFAIL = - 4
      ENDIF
      IF (NRMAX.LT.M) THEN
         IFAIL = - 5
      ENDIF
C
C Proceed if IFAIL >= 0
C
      IF (IFAIL.GE.0) THEN
C
C work out WSSQ before entry
C
         CALL LMFUNC (M, N, X, FVEC, FJAC, NRMAX, IFLAG)
         WSSQ = ZERO
         DO I = 1, M
            WSSQ = WSSQ + FVEC(I)*FVEC(I)
         ENDDO
         WSSQ1 = WSSQ
C
C call lmder1
C
         TOL = TOL1
         CALL LMDER1 (LMFUNC, M, N, X, FVEC, FJAC, NRMAX, TOL, INFO,
     +                IPVT, W, LW)
C
C work out WSSQ and check INFO/IFAIL
C
         WSSQ = ZERO
         DO I = 1, M
            WSSQ = WSSQ + FVEC(I)*FVEC(I)
         ENDDO
         IF (INFO.EQ.0) THEN
            IFAIL = - 5
         ELSEIF (INFO.LT.4) THEN
            IFAIL = 0
         ELSEIF (INFO.EQ.4) THEN
            IFAIL = 1
         ELSEIF (INFO.EQ.5) THEN
            IFAIL = 2
         ELSE
            IFAIL = 3
         ENDIF
C
C Calculate the covariance matrix
C
         TOL = TOL2
         CALL COVAR (N, FJAC, NRMAX, IPVT, TOL, W)
         FACTOR = WSSQ/DBLE(M - N)
         IRANK = 0
         DO J = 1, N
            IF (ABS(FJAC(J,1)).GE.TOL3) IRANK = IRANK + 1
            DO I = 1, N
               CM(I,J) = FACTOR*FJAC(I,J)
            ENDDO
         ENDDO
         PCENT = F100*(WSSQ1 - WSSQ)/(WSSQ1 + TOL4)
      ENDIF
C
C Call WAITER with ACTION = .FALSE.
C
      ACTION = .FALSE.
      CALL WAITER (ACTION)
C
C Check exit conditions, etc.
C     
      IF (PCENT.GT.F1) THEN
         CIPHER = BLANK8
      ELSE
         CIPHER = ' (=< 1%)'   
      ENDIF      
      IF (PCENT.LE.F1 .OR. IRANK.LT.N .OR. IFAIL.NE.0) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) TOL1, WSSQ1, WSSQ, IFAIL, PCENT, CIPHER, M,
     +                       N, IRANK, TOL2
         ELSE
           D13(1) = SHOWLJ(TOL1)
           D13(2) = SHOWLJ(WSSQ1)
           D13(3) = SHOWLJ(WSSQ)
           D13(4) = SHOWLJ(TOL2)
           I12(1) = FORM12(M)
           I12(2) = FORM12(N)
           I12(3) = FORM12(IRANK)  
           WRITE (TEXT,150) TRIM(D13(1)), D13(2), TRIM(D13(3)), IFAIL,
     +                      PCENT, CIPHER, I12(1), I12(2),
     +                      TRIM(I12(3)), TRIM(D13(4)) 
         ENDIF  
         TEXT(19) = ERROR(INFO)
         IF (IRANK.LT.N) THEN
            TEXT(23) = 'ERROR: The covariance matrix is rank deficient'
            TEXT(24) = 'ADVICE: Ignore the parameter standard errors'
         ENDIF
         IF (IWARNU) THEN
            ICOLOR = 15
            CALL TABLE1 (ICOLOR, 'OPEN')
            DO I = 1, NUMTXT
               IF (I.EQ.2 .OR. I.EQ.19 .OR. I.EQ.23 .OR. I.EQ.24) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         DO I = 1, NUMTXT
            WRITE (NOUT, '(A)') TEXT(I)
         ENDDO
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     +/'ADVISORY MESSAGE***********************************************'
     +/'Optimisation Method: Levenberg-Marquardt with analytic Jacobian'
     +/
     +/'LMDER1: Curve fitting may be unsatisfactory due to either:'
     +/
     +/'a) using starting estimates too close to model parameters'
     +/'b) using inappropriate starting estimates for this model'
     +/'c) using the wrong mathematical-model/Jacobian for this data'
     +/'d) using noisy, ill-conditioned, or numerically exact data'
     +/'e) using badly scaled data (i.e. units too large/small)'
     +/'f) using badly chosen data weighting factors'
     +/'g) using insufficient number of iterations (re-enter ?), or'
     +/'h) using incorrect tolerance parameter (TOL_1 =',1P,E10.3,')'
     +/
     +/'WSSQ before fit   =',1P,E10.3
     +/'WSSQ after  fit   =',1P,E10.3,' (IFAIL =',I3,')'
     +/'Percent reduction =',0P,F7.2,'%', A8
     +/
     +/'Number of data points =',I6
     +/'Number of parameters  =',I6
     +/'Rank of CV matrix     =',I6,' (TOL_2 =',1P,E10.3,')'
     +/
     +/)
  150 FORMAT (
     +/'ADVISORY MESSAGE***********************************************'
     +/'Optimisation Method: Levenberg-Marquardt with analytic Jacobian'
     +/
     +/'LMDER1: Curve fitting may be unsatisfactory due to either:'
     +/
     +/'a) using starting estimates too close to model parameters'
     +/'b) using inappropriate starting estimates for this model'
     +/'c) using the wrong mathematical-model/Jacobian for this data'
     +/'d) using noisy, ill-conditioned, or numerically exact data'
     +/'e) using badly scaled data (i.e. units too large/small)'
     +/'f) using badly chosen data weighting factors'
     +/'g) using insufficient number of iterations (re-enter ?), or'
     +/'h) using incorrect tolerance parameter (TOL_1 =',1X,A,')'
     +/
     +/'WSSQ before fit   =',1X,A13
     +/'WSSQ after  fit   =',1X,A13,' (IFAIL =',I3,')'
     +/'Percent reduction =',0P,F7.2,'%', A8
     +/
     +/'Number of data points =',1X,A12
     +/'Number of parameters  =',1X,A12
     +/'Rank of CV matrix     =',1X,A,' (TOL_2 =',1X,A,')'
     +/
     +/)    
      END
C
C
