C
C
      SUBROUTINE LOGIST (N,
     +                   S, X, Y,
     +                   TYPE1,
     +                   ABORT)
C
C ACTION: Logistic and other transformations
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/12/99
C         03/02/2001 improved logical flow
C         29/07/2002 redesigned to allow more transformations
C         09/04/2015 added INTENTS and no longer changes S if x = x, y = y selected
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: N
      DOUBLE PRECISION,    INTENT (INOUT) :: S(N), X(N), Y(N)
      CHARACTER (LEN = *), INTENT (OUT)   :: TYPE1
      LOGICAL,             INTENT (OUT)   :: ABORT      
C
C Locals
C      
      INTEGER    I, LX, LY, NXTRAN, NYTRAN
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 0, NSTART = 5,
     +           NUMOPT = 10)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    LEN200
      DOUBLE PRECISION AX, AY, RTOL, XBOT, XMAX, XTOP, YBOT, YMAX, YTOP
      DOUBLE PRECISION X02AMF$, X02AJF$
      DOUBLE PRECISION ONE, EPSI, F100
      PARAMETER (ONE = 1.0D+00, F100 = 100.0D+00)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  XTRAN*100, YTRAN*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    REPEET
      LOGICAL    LOGIC1, LOGIC2, LOGIC3
      PARAMETER (LOGIC1 = .FALSE., LOGIC2 = .FALSE., LOGIC3 = .FALSE.)
      EXTERNAL   PUTFAT, GETDGE, LBOX01, LEN200, PUTMES, PATCH1
      EXTERNAL   X02AMF$, X02AJF$
      INTRINSIC  LOG, LOG10, ABS
      SAVE       AX, AY, NXTRAN, NYTRAN
      DATA       AX, AY / ONE, ONE /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NXTRAN, NYTRAN / 1, 1 /
C
C Check N
C
      ABORT = .TRUE.
      TYPE1 = BLANK
      IF (N.LT.3) THEN
         CALL PUTFAT ('Insufficient data')
         RETURN
      ENDIF
C
C Find data limits
C
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XBOT = X(1)
      XTOP = X(1)
      YBOT = Y(1)
      YTOP = Y(1)
      DO I = 1, N
         IF (X(I).LT.XBOT) XBOT = X(I)
         IF (X(I).GT.XTOP) XTOP = X(I)
         IF (Y(I).LT.YBOT) YBOT = Y(I)
         IF (Y(I).GT.YTOP) YTOP = Y(I)
      ENDDO
C
C The menu for x
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100)
         NUMDEC = NXTRAN
         NTEXT = 14
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT,
     +                LOGIC1, LOGIC2, LOGIC3)
         IF (NUMDEC.EQ.NUMOPT - 1) THEN
            REPEET = .TRUE.
            WRITE (TEXT,1000)
            NTEXT = 20
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   LOGIC1)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            RETURN
         ELSE
            REPEET = .FALSE.
         ENDIF
C
C Define AX
C
         IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.8) THEN
            XMAX = XTOP + EPSI
            IF (AX.LT.XMAX) THEN
               IF (XMAX.LT.ONE - EPSI) THEN
                  AX = ONE
               ELSEIF (XMAX.LE.(F100 - EPSI)) THEN
                  AX = F100
               ELSE
                  AX = XMAX + ONE
               ENDIF
            ENDIF
            WRITE (LINE,200) XMAX
            CALL GETDGE (AX, XMAX, LINE)
         ENDIF
         IF (XTOP.GT.(ONE - EPSI)) THEN
            IF (NUMDEC.EQ.4 .OR. NUMDEC.EQ.7) THEN
                CALL PUTFAT ('Impossible when x >= 1')
                REPEET = .TRUE.
            ENDIF
         ENDIF
         IF (XBOT.LE.RTOL) THEN
            IF (NUMDEC.GE.3 .AND. NUMDEC.LE.8) THEN
                CALL PUTFAT ('Impossible when x =< 0')
                REPEET = .TRUE.
            ENDIF
          ENDIF
      ENDDO
      NXTRAN = NUMDEC
      XTRAN = TEXT(NSTART + NUMDEC - 1)
C
C The menu for y
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,300)
         NUMDEC = NYTRAN
         NTEXT = 14
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT,
     +                LOGIC1, LOGIC2, LOGIC3)
         IF (NUMDEC.EQ.NUMOPT - 1) THEN
            REPEET = .TRUE.
            WRITE (TEXT,1000)
            NTEXT = 20
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   LOGIC1)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            RETURN
         ELSE
            REPEET = .FALSE.
         ENDIF
C
C Define AY
C
         IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.8) THEN
            YMAX = YTOP + EPSI
            IF (AY.LT.YMAX) THEN
               IF (YMAX.LT.ONE - EPSI) THEN
                  AY = ONE
               ELSEIF (XMAX.LE.(F100 - EPSI)) THEN
                  AY = F100
               ELSE
                  AY = YMAX + ONE
               ENDIF
            ENDIF
            WRITE (LINE,400) YMAX
            CALL GETDGE (AY, YMAX, LINE)
         ENDIF
         IF (YTOP.GT.(ONE - EPSI)) THEN
            IF (NUMDEC.EQ.4 .OR. NUMDEC.EQ.7) THEN
                CALL PUTFAT ('Impossible when y >= 1')
                REPEET = .TRUE.
            ENDIF
         ENDIF
         IF (YBOT.LE.RTOL) THEN
            IF (NUMDEC.GE.3 .AND. NUMDEC.LE.8) THEN
                CALL PUTFAT ('Impossible when y =< 0')
                REPEET = .TRUE.
            ENDIF
          ENDIF
      ENDDO
      NYTRAN = NUMDEC
      YTRAN = TEXT(NSTART + NUMDEC - 1)
C
C Define x = g(x)
C
      IF (NXTRAN.GT.1) THEN
         DO I = 1, N
            IF (NXTRAN.EQ.2) THEN
               IF (ABS(X(I)).GT.RTOL) THEN
                  X(I) = ONE/X(I)
               ELSE
                  WRITE (LINE,500) I
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
            ELSEIF (NXTRAN.EQ.3) THEN
               X(I) = LOG(X(I))
            ELSEIF (NXTRAN.EQ.4) THEN
               X(I) = LOG(X(I)/(ONE - X(I)))
            ELSEIF (NXTRAN.EQ.5) THEN
               X(I) = LOG(X(I)/(AX - X(I)))
            ELSEIF (NXTRAN.EQ.6) THEN
               X(I) = LOG10(X(I))
            ELSEIF (NXTRAN.EQ.7) THEN
               X(I) = LOG10(X(I)/(ONE - X(I)))
            ELSEIF (NXTRAN.EQ.8) THEN
               X(I) = LOG10(X(I)/(AX - X(I)))
            ENDIF
         ENDDO
      ENDIF
C
C Define y = f(y)
C
      IF (NYTRAN.GT.1) THEN
         DO I = 1, N
            IF (NYTRAN.EQ.2) THEN
               IF (ABS(Y(I)).GT.RTOL) THEN
                  Y(I) = ONE/Y(I)
               ELSE
                  WRITE (LINE,600) I
                  CALL PUTFAT (LINE)
                  RETURN
               ENDIF
            ELSEIF (NYTRAN.EQ.3) THEN
               Y(I) = LOG(Y(I))
            ELSEIF (NYTRAN.EQ.4) THEN
               Y(I) = LOG(Y(I)/(ONE - Y(I)))
            ELSEIF (NYTRAN.EQ.5) THEN
               Y(I) = LOG(Y(I)/(AY - Y(I)))
            ELSEIF (NYTRAN.EQ.6) THEN
               Y(I) = LOG10(Y(I))
            ELSEIF (NYTRAN.EQ.7) THEN
               Y(I) = LOG10(Y(I)/(ONE - Y(I)))
            ELSEIF (NYTRAN.EQ.8) THEN
               Y(I) = LOG10(Y(I)/(AY - Y(I)))
            ENDIF
         ENDDO
      ENDIF
C
C Define S = 1
C
      IF (NXTRAN.GT.1 .OR. NYTRAN.GT.1) THEN
         DO I = 1, N
            S(I) = ONE
         ENDDO
      ENDIF
      LX = LEN200(XTRAN)
      LY = LEN200(YTRAN)
      TYPE1 = 'Transformation: '//XTRAN(1:LX)//', '//YTRAN(1:LY)
      ABORT = .FALSE.
      WRITE (TEXT,700) XTRAN, YTRAN
      NTEXT = 4
      IF (NXTRAN.EQ.5 .OR. NXTRAN.EQ.8) THEN
         NTEXT = NTEXT + 1
         WRITE (TEXT(NTEXT),800) AX
         LX = LEN200(TYPE1)
         LY = LEN200(TEXT(NTEXT))
         LINE = TYPE1(1:LX)//', '//TEXT(NTEXT)(1:LY)
         TYPE1 = LINE
      ENDIF
      IF (NYTRAN.EQ.5 .OR. NYTRAN.EQ.8) THEN
         NTEXT = NTEXT + 1
         WRITE (TEXT(NTEXT),900) AY
         LX = LEN200(TYPE1)
         LY = LEN200(TEXT(NTEXT))
         LINE = TYPE1(1:LX)//', '//TEXT(NTEXT)(1:LY)
         TYPE1 = LINE
      ENDIF
      CALL PUTMES (NTEXT, TEXT)
C
C Format statements
C      
  100 FORMAT (
     + 'Select the transformation for x = g(x)'
     +/
     +/'A = 1 for proportions (0 =< x =< 1)'
     +/'A = 100 for percentages (0 =< x =< 100)'
     +/'x = x'
     +/'x = 1/x'
     +/'x = ln[x]'
     +/'x = ln[x/(1 - x)]'
     +/'x = ln[x/(A - x)]'
     +/'x = log10[x]'
     +/'x = log10[x/(1 - x)]'
     +/'x = log10[x/(A - x)]'
     +/'Help'
     +/'Quit ... Exit transformation options')
  200 FORMAT ('A required (A >=',1P,E11.3,')')
  300 FORMAT (
     + 'Select the transformation for y = f(y)'
     +/
     +/'B = 1 for proportions (0 =< y =< 1)'
     +/'B = 100 for percentages (0 =< y =< 100)'
     +/'y = y'
     +/'y = 1/y'
     +/'y = ln[y]'
     +/'y = ln[y/(1 - y)]'
     +/'y = ln[y/(B - y)]'
     +/'y = log10[y]'
     +/'y = log10[y/(1 - y)]'
     +/'y = log10[y/(B - y)]'
     +/'Help'
     +/'Quit ... Exit transformation options')
  400 FORMAT ('B required (B >=',1P,E11.3,')')
  500 FORMAT ('x out of range at datum point',I5)
  600 FORMAT ('y out of range at datum point',I5)
  700 FORMAT (
     + 'For the next fit the x,y variables are:'
     +/
     +/A
     +/A)
  800 FORMAT ('A =',1P,E11.3)
  900 FORMAT ('B =',1P,E11.3)
 1000 FORMAT (
     + 'Transformed polynomial regression and calibration'
     +/
     +/'You input x,y (or x,y,s) data, then this procedure replaces'
     +/'your original x,y variables by functions y = f(y) and x = g(x)'
     +/'before fitting a sequence of polynomials for data smoothing and'
     +/'calibration. Two very important points must be noted.'
     +/
     +/'Even if you input x,y,s data, this routine will always ignore'
     +/'your s values and do unweighted regression, i.e. use s = 1 so'
     +/'that weights w = 1/s^2 will always be equal to one.'
     +/
     +/'After choosing a transformation, the routine uses the letters x'
     +/'and y in all tables and plots to refer to x = g(x) and y = f(y)'
     +/'so you must remember to input f(y) not y for prediction and use'
     +/'g_inverse to recover true_x_predicted from x_predicted. For'
     +/'instance, if you fitted log[y/(1 - y)] as a function of log(x),'
     +/'you would input log([y_p/(1 - y_p)] to predict log(x_p), then'
     +/'use x_predicted = exp(x_p) to recover the predicted value and'
     +/'x_low = exp(x_p_low), x_high = exp(x_p_high) to recover the 95'
     +/'percent confidence limits.')
      END
C
C
