c
c
      subroutine loglin (ncmax, ncol, nout, nrmax, nrow, freq, title)
c
c action: log-linear contingency table analysis
c author: w.g.bardsley, university of manchester, u.k., 28/06/2002
c         07/09/2003 revised and added special cases and extra output
c         28/12/2014 exit from g02gcf only leads to return now if ifail =< 4
c         24/06/2015 corrected 28/12/2014 exit condition to (ifail.gt.0 .and. ifail.le.4)
c         27/07/2021 added E_NUMBERS and E_FORMATS, etc. 
c
      implicit   none
      integer    ncmax, ncol, nout, nrmax, nrow
      integer    iconst, idf, ifail, ip, iprint, irank, ldc, ldv, ldx,
     +           m, maxit, n
      parameter (iconst = 2, iprint = 0, ldc = 250, ldv = ldc,
     +           ldx = ldv, maxit = 20)
      integer    ix, iy, numdec, numopt
      parameter (ix = 4, iy = 4, numopt = 4)
      integer    numpos(numopt)
      integer    isx(ldx), iysav(ldc)
      integer    i, icolor, icount, j, k
      double precision freq(nrmax,ncmax)
      double precision a, b(ldx), c(ldc,iconst), cov(ldx*(ldx - 1)/2),
     +                 dof, dev, eps, p, r, rtol, se(ldx), t, tol,
     +                 v(ldv, ldx + 7), wt(ldx), wk(5*ldx*ldx),
     +                 x(ldx,ldx), y(ldx)
      double precision fv(ldc), resid(ldc), h(ldc), pval, temp
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      double precision g01fbf$, x02amf$, g01ebf$, g01ecf$
      character  title*(80)
      character  chop80*80, line*100, resul*30, text(30)*100, word4*4,
     +           word8*8
      character (len = 13) d13(4), showlj, showrj
      character (len = 12) i12(3), form12
      character  link*1, mean*1, offset*1, weight*1
      parameter (link = 'L', mean = 'M', offset = 'N', weight = 'U')
      character  tail*1
      character  ptitle*50, xtitle*50, ytitle*50
      parameter (ptitle = 'Residuals against Best Fit',
     +           xtitle = 'Log-linear Model Frequencies',
     +           ytitle = 'Deviance Residuals')
      logical    e_formats, e_numbers
      logical    repeet
      external   e_formats, form12, showlj, showrj
      external   chop80, putfat, putifa, table1, triml1, plevel, gks001,
     +           hnplot, lbox02
      external   g02gcf$, g02gkf$, x02amf$, g01fbf$, g01ebf$, g01ecf$
      intrinsic  dble, max, nint, sqrt
      save       icount
      data       icount / 0 /
      data       numpos / numopt*1 /
c
c check ncol and nrow
c
      repeet = .false.
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif

c
c define n, m, ip
c
      n = ncol*nrow
      m = ncol + nrow
      ip = m + 1
      if (m.gt.ldx .or. n.gt.ldx) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c check that freq is ok
c
      do j = 1, ncol
         do i = 1, nrow
            if (freq(i,j).le.zero) then
              write (line,300) i, j
              call putfat (line)
              return
            endif
         enddo
      enddo
c
c fill in x, isx and wt
c
      e_numbers = e_formats()
      do j = 1, m
         do i = 1, n
            x(i,j) = zero
         enddo
      enddo
      k = 0
      do i = 1, nrow
         do j = 1, ncol
            k = k + 1
            y(k) = freq(i,j)
            iysav(k) = nint(y(k))
            x(k,i) = one
            x(k,nrow + j) = one
         enddo
      enddo
      do i = 1, m
         isx(i) = 1
      enddo
      do i = 1, n
        wt(i) = one
      enddo
      ifail = 1
      a = one
      eps = 0.000001d+00
      tol = 0.00005d+00
      if (n.gt.6) then
c
c case 1: n = ncol*nrow > 6 so fit the overdetermined loglinear model
c =======
c
         call g02gcf$(link, mean, offset, weight, n, x, ldx, m, isx, ip,
     +                y, wt, a, dev, idf, b, irank, se, cov, v, ldv,
     +                tol, maxit, iprint, eps, wk, ifail)
         call putifa (ifail, nout, 'G02GCF/LOGLIN')
         if (ifail.gt.0 .and. ifail.le.4) return
         if (ip - irank.ne.iconst) then
            write (line,400)
            call putfat (line)
            return
         endif
c
c save the best fit results
c
         do i = 1, n
            fv(i) = v(i,2)
            resid(i) = v(i,5)
            h(i) = v(i,6)
         enddo
c
c define the constraints vector
c
         k = 1
         c(k,1) = zero
         c(k,2) = zero
         do i = 1, nrow
            k = k + 1
            c(k,1) = one
            c(k,2) = zero
         enddo
         do i = 1, ncol
            k = k + 1
            c(k,1) = zero
            c(k,2) = one
         enddo
c
c fit the constrained model
c
         ifail = 1
         call g02gkf$(ip, iconst, v, ldv, c, ldc, b, a, se, cov, wk,
     +                ifail)
         call putifa (ifail, nout, 'G02GKF/LOGLIN')
         if (ifail.ne.0) return
         icount = icount + 1
         dof = dble(n - ip + iconst)
         ifail = 1
         tail = 'U'
         pval = g01ecf$(tail, dev, dof, ifail)
         call putifa (ifail, nout, 'G01ECF/LOGLIN')
         call plevel (pval, resul)
         ifail = 1
         tail = 'L'
         p = 0.975d+00
         t = g01fbf$(tail, p, dof, ifail)
         call putifa (ifail, nout, 'G01FBF/LOGLIN')
         write (word8,'(i8)') nint(dof)
         call triml1 (word8)
         if (e_numbers) then
            write (text,500) icount, chop80(title), nrow, ncol, dev,
     +        word8, pval, resul
            write (nout,550) icount, title, nrow, ncol, dev, word8,
     +                       pval, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol)
            d13(1) = showlj(dev)
            write (text,505) icount, chop80(title), TRIM(i12(1)),
     +                       i12(2), trim(d13(1)), word8, pval, resul
            write (nout,555) icount, title, TRIM(i12(1)), 
     +                       i12(2), trim(d13(1)), word8, pval, resul
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1 .or. i.eq.4 .or. i.eq.9) then
               icolor = 4
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         icolor = 0
         k = 1
         rtol = 1.0d+09*x02amf$()
         tail = 'S'
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         if (e_numbers) then
            write (nout,600) b(k), se(k), b(k) - t*se(k), 
     +                       b(k) + t*se(k), p, word4
            write (line,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(6)
            d13(4) = showrj(temp)
            write (nout,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4
            write (line,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4
         endif  
         call table1 (icolor, line)
         do i = 1, nrow
            k = k + 1
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (e_numbers) then
               write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)
               write (nout,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
            endif  
            call table1 (icolor, line)
         enddo
         do i = 1, ncol
            k = k + 1
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (e_numbers) then
               write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)  
               write (nout,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
            endif  
            call table1 (icolor, line)
         enddo
         repeet = .true.
      elseif (n.eq.4) then
c
c case 2: ncol = 2 and nrow = 2 so fit the loglinear model directly
c =======
c
         x(1,1) = one
         x(1,2) = zero
         x(2,1) = one
         x(2,2) = one
         x(3,1) = zero
         x(3,2) = zero
         x(4,1) = zero
         x(4,2) = one
         m = 2
         ip = 3
         call g02gcf$(link, mean, offset, weight, n, x, ldx, m, isx, ip,
     +                y, wt, a, dev, idf, b, irank, se, cov, v, ldv,
     +                tol, maxit, iprint, eps, wk, ifail)
         call putifa (ifail, nout, 'G02GCF/LOGLIN')
         if (ifail.gt.0 .and. ifail.le.4) return
c
c save the best fit results
c
         do i = 1, n
            fv(i) = v(i,2)
            resid(i) = v(i,5)
            h(i) = v(i,6)
         enddo
         icount = icount + 1
         dof = dble(n - ip)
         ifail = 1
         tail = 'U'
         pval = g01ecf$(tail, dev, dof, ifail)
         call putifa (ifail, nout, 'G01ECF/LOGLIN')
         call plevel (pval, resul)
         ifail = 1
         tail = 'L'
         p = 0.975d+00
         t = g01fbf$(tail, p, dof, ifail)
         call putifa (ifail, nout, 'G01FBF/LOGLIN')
         write (word8,'(i8)') nint(dof)
         call triml1 (word8)
         if (e_numbers) then
            write (text,500) icount, chop80(title), nrow, ncol, dev, 
     +                       word8, pval, resul
            write (nout,550) icount, title, nrow, ncol, dev, word8,
     +                       pval, resul
         else
            i12(1) = form12(nrow)
            i12(2) = form12(ncol)
            d13(1) = showlj(dev)
            write (text,505) icount, chop80(title), TRIM(i12(1)),
     +                       i12(2), trim(d13(1)), word8, pval, resul
            write (nout,555) icount, title, TRIM(i12(1)), 
     +                       i12(2), trim(d13(1)), word8, pval, resul
         endif  
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1 .or. i.eq.4 .or. i.eq.9) then
               icolor = 4
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         icolor = 0
         k = 1
         rtol = 1.0d+09*x02amf$()
         tail = 'S'
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         if (e_numbers) then
            write (nout,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4
            write (line,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4             
         endif  
         call table1 (icolor, line)
         do i = 1, 2
            k = 2
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (i.eq.2) b(k) = - b(k)
            if (e_numbers) then  
               write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)
               write (nout,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
            endif  
            call table1 (icolor, line)
         enddo
         do i = 1, 2
            k = 3
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (i.eq.2) b(k) = - b(k)
            if (e_numbers) then
               write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)  
               write (nout,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4                            
            endif    
            call table1 (icolor, line)
         enddo
         repeet = .true.
      elseif (nrow.eq.2 .and. ncol.eq.3) then
c
c case 3: ncol = 3 and nrow = 2 so fit the loglinear model directly
c =======
c
         x(1,1) = one
         x(1,2) = one
         x(1,3) = zero
         x(2,1) = one
         x(2,2) = zero
         x(2,3) = one
         x(3,1) = one
         x(3,2) = zero
         x(3,3) = zero
         x(4,1) = zero
         x(4,2) = one
         x(4,3) = zero
         x(5,1) = zero
         x(5,2) = zero
         x(5,3) = one
         x(6,1) = zero
         x(6,2) = zero
         x(6,3) = zero
         m = 3
         ip = 4
         call g02gcf$(link, mean, offset, weight, n, x, ldx, m, isx, ip,
     +                y, wt, a, dev, idf, b, irank, se, cov, v, ldv,
     +                tol, maxit, iprint, eps, wk, ifail)
         call putifa (ifail, nout, 'G02GCF/LOGLIN')
         if (ifail.gt.0 .and. ifail.le.4) return
c
c save the best fit results
c
         do i = 1, n
            fv(i) = v(i,2)
            resid(i) = v(i,5)
            h(i) = v(i,6)
         enddo
         icount = icount + 1
         dof = dble(n - ip)
         ifail = 1
         tail = 'U'
         pval = g01ecf$(tail, dev, dof, ifail)
         call putifa (ifail, nout, 'G01ECF/LOGLIN')
         call plevel (pval, resul)
         ifail = 1
         tail = 'L'
         p = 0.975d+00
         t = g01fbf$(tail, p, dof, ifail)
         call putifa (ifail, nout, 'G01FBF/LOGLIN')
         write (word8,'(i8)') nint(dof)
         call triml1 (word8)
         write (text,500) icount, chop80(title), nrow, ncol, dev, word8,
     +                    pval, resul
         write (nout,550) icount, title, nrow, ncol, dev, word8,
     +                    pval, resul
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1 .or. i.eq.4 .or. i.eq.9) then
               icolor = 4
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         icolor = 0

         k = 1
         rtol = 1.0d+09*x02amf$()
         tail = 'S'
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         if (e_numbers) then
            write (nout,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4
            write (line,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4             
         endif  
         call table1 (icolor, line)

         do i = 1, 2
            k = 2
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (i.eq.2) b(k) = - b(k)
            if (e_numbers) then
               write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)
               write (nout,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
            endif   
            call table1 (icolor, line)
         enddo

         k = 3
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 1
         if (e_numbers) then
            write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)  
            write (nout,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
         endif    
         call table1 (icolor, line)

         k = 4
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 2
         if (e_numbers) then
            write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)  
            write (nout,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
         endif    
         call table1 (icolor, line)

         k = 5
         b(k) = - (b(3) + b(4))
         se(k) = sqrt(se(3)**2 + se(4)**2)
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 3
         if (e_numbers) then
            write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)  
            write (nout,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,805) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
         endif    
         call table1 (icolor, line)
         repeet = .true.
      elseif (nrow.eq.3 .and. ncol.eq.2) then
c
c case 4: ncol = 2 and nrow = 3 so fit the loglinear model directly
c =======
c
         x(1,1) = one
         x(1,2) = zero
         x(1,3) = one
         x(2,1) = one
         x(2,2) = zero
         x(2,3) = zero
         x(3,1) = zero
         x(3,2) = one
         x(3,3) = one
         x(4,1) = zero
         x(4,2) = one
         x(4,3) = zero
         x(5,1) = zero
         x(5,2) = zero
         x(5,3) = one
         x(6,1) = zero
         x(6,2) = zero
         x(6,3) = zero
         m = 3
         ip = 4
         call g02gcf$(link, mean, offset, weight, n, x, ldx, m, isx, ip,
     +                y, wt, a, dev, idf, b, irank, se, cov, v, ldv,
     +                tol, maxit, iprint, eps, wk, ifail)
         call putifa (ifail, nout, 'G02GCF/LOGLIN')
         if (ifail.gt.0 .and. ifail.le.4) return
c
c save the best fit results
c
         do i = 1, n
            fv(i) = v(i,2)
            resid(i) = v(i,5)
            h(i) = v(i,6)
         enddo
         icount = icount + 1
         dof = dble(n - ip)
         ifail = 1
         tail = 'U'
         pval = g01ecf$(tail, dev, dof, ifail)
         call putifa (ifail, nout, 'G01ECF/LOGLIN')
         call plevel (pval, resul)
         tail = 'L'
         p = 0.975d+00
         t = g01fbf$(tail, p, dof, ifail)
         call putifa (ifail, nout, 'G01FBF/LOGLIN')
         write (word8,'(i8)') nint(dof)
         call triml1 (word8)
         write (text,500) icount, chop80(title), nrow, ncol, dev, word8,
     +                    pval, resul
         write (nout,550) icount, title, nrow, ncol, dev, word8,
     +                    pval, resul
         icolor = 15
         call table1 (icolor, 'OPEN')
         do i = 1, 9
            if (i.eq.1 .or. i.eq.4 .or. i.eq.9) then
               icolor = 4
            else
               icolor = 0
            endif
            call table1 (icolor, text(i))
         enddo
         icolor = 0

         k = 1
         rtol = 1.0d+09*x02amf$()
         tail = 'S'
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         if (e_numbers) then
            write (nout,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,600) b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4
            write (line,605) d13(1), d13(2), d13(3), 
     +                       d13(4), p, word4             
         endif  
         call table1 (icolor, line)
         k = 2
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 1
         if (e_numbers) then
            write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,705) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
         endif   
         call table1 (icolor, line)

         k = 3
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 2
         if (e_numbers) then
            write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,705) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
         endif   
         call table1 (icolor, line)

         k = 5
         b(k) = - (b(2) + b(3))
         se(k) = sqrt(se(2)**2 + se(3)**2)
         r = b(k)/max(se(k),rtol)
         p = g01ebf$(tail, r, dof, ifail)
         if (p.gt.0.10d+00) then
            word4 = ' ***'
         elseif (p.gt.0.05d+00) then
            word4 = '  **'
         elseif (p.gt.0.01d+00) then
            word4 = '   *'
         else
            word4 = '    '
         endif
         i = 3
         if (e_numbers) then
            write (nout,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
            write (line,700) i, b(k), se(k), b(k) - t*se(k),
     +                       b(k) + t*se(k), p, word4
         else
            d13(1) = showrj(b(k))
            d13(2) = showrj(se(k))
            temp = b(k) - t*se(k)
            d13(3) = showrj(temp)
            temp = b(k) + t*se(k)
            d13(4) = showrj(temp)
            write (nout,705) i, d13(1), d13(2), d13(3),
     +                       d13(4), p, word4
            write (line,705) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
         endif   
         call table1 (icolor, line)

         do i = 1, 2
            k = 4
            r = b(k)/max(se(k),rtol)
            p = g01ebf$(tail, r, dof, ifail)
            if (p.gt.0.10d+00) then
               word4 = ' ***'
            elseif (p.gt.0.05d+00) then
               word4 = '  **'
            elseif (p.gt.0.01d+00) then
               word4 = '   *'
            else
               word4 = '    '
            endif
            if (i.eq.2) b(k) = - b(k)
            if (e_numbers) then
               write (nout,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
               write (line,800) i, b(k), se(k), b(k) - t*se(k),
     +                          b(k) + t*se(k), p, word4
            else
               d13(1) = showrj(b(k))
               d13(2) = showrj(se(k))
               temp = b(k) - t*se(k)
               d13(3) = showrj(temp)
               temp = b(k) + t*se(k)
               d13(4) = showrj(temp)  
               write (nout,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
               write (line,805) i, d13(1), d13(2), d13(3),
     +                          d13(4), p, word4
         endif               
            call table1 (icolor, line)
         enddo
         repeet = .true.
         write (nout,900)
      endif
      if (repeet) then
c
c output data, best-fit, residuals, leverages
c
         write (nout,900)
         write (line,900)
         icolor = 4
         call table1 (icolor, line)
         icolor = 0
         do i = 1, n
            write (nout,1000) iysav(i), fv(i), dble(iysav(i)) - fv(i),
     +                        resid(i), h(i)
            write (line,1000) iysav(i), fv(i), dble(iysav(i)) - fv(i),
     +                        resid(i), h(i)
            call table1 (icolor, line)
         enddo
         call table1 (icolor, 'CLOSE')
      endif
      numdec = numopt
      icolor = 7
      do while (repeet)
         write (text,1100)
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos, text)
         if (numdec.eq.1) then
            i = 0
            j = 4
            call gks001 (i, j, n,
     +                   fv, resid,
     +                   ptitle, xtitle, ytitle)
         elseif (numdec.eq.2) then
            i = 1
            call hnplot (i, n, resid)
         elseif (numdec.eq.3) then
            i = 2
            call hnplot (i, n, resid)
         else
            repeet = .false.
         endif
      enddo
  100 format ('Must have no. rows >= 2, no. columns >= 2')
  200 format ('Contingency table is too large to analyse')
  300 format (
     +'frequency(i,j) =< 0 at row i =',i4,', column j =',i4)
  400 format ('Contingency table singular or too sparse to analyse')
  500 format (
     +'Log-linear contingency table analysis',i4
     +/
     +/'Data:'
     +/A
     +/'number of rows =',i3,', number of columns =',i3
     +/'Deviance ( D ) =',1p,e12.5,', deg.free. = ',a
     +/'p = P(chi-sq >= D)  =',0p,f7.4,2x,a
     +/
     +/'Parameter     Estimate     Std. error   Lower 95%cl',
     +'    Upper95%cl',5x,'p')
  505 format (
     +'Log-linear contingency table analysis',i4
     +/
     +/'Data:'
     +/A
     +/'nmber of rows =',1x,a,', number of columns =',1x,a
     +/'Deviance ( D ) =',1x,a,', degrees of freedom = ',a
     +/'p = P(chi-sq >= D)  =',f7.4,2x,a
     +/
     +/'Parameter     Estimate     Std. error   Lower 95%cl',
     +'    Upper95%cl',5x,'p')     
  550 format (
     +/'Log-linear contingency table analysis', i4
     +/'========================================='
     +/'Data: ',A
     +/'number of rows =',i3,', number of columns =',i3
     +/'Deviance ( D ) =',1p,e12.5,', deg.free. = ',a
     +/'p = P(chi-sq >= D) =',0p,f7.4,2x,a
     +/
     +/'Parameter     Estimate     Std.Error    Lower95%cl'
     +'    Upper95%cl',5x,'p')
  555 format (
     +/'Log-linear contingency table analysis', i4
     +/'========================================='
     +/'Data: ',A
     +/'number of rows =',1x,a,', number of columns =',1x,a
     +/'Deviance ( D ) =',1x,a,', degrees of freedom = ',a
     +/'p = P(chi-sq >= D) =',f7.4,2x,a
     +/
     +/'Parameter     Estimate     Std.Error    Lower95%cl'
     +'    Upper95%cl',5x,'p')     
  600 format (
     +'Constant ',1p,4(1x,e13.5),0p,f8.4,a)
  605 format (
     +'Constant ',4(1x,a),f8.4,a)     
  700 format (
     +'Row',i3,'   ',1p,4(1x,e13.5),0p,f8.4,a)
  705 format (
     +'Row',i3,'   ',4(1x,a),f8.4,a)     
  800 format (
     +'Col',i3,'   ',1p,4(1x,e13.5),0p,f8.4,a)  
  805 format (
     +'Col',i3,'   ',4(1x,a),f8.4,a)       
  900 format ('     Data        Model       Delta  Dev-resid  Leverage')
 1000 format (i9,f13.4,f12.4,1x,2f10.4)
 1100 format (
     + 'Deviance residuals theory plot'
     +/'Deviance residuals half-normal plot'
     +/'Deviance residuals normal plot'
     +/'Quit ... Exit residuals plotting')
      end
c
c






