C
C
      SUBROUTINE LUFACT (NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK,
     +                   A, W,
     +                   TITLE,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : LU factorisation of a matrix and condition number
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 08/12/2003
C          Derived from CHFACT 08/12/2003
C          01/03/2005 replaced DGETRF, DGECON by F07ADF$, F07AGF$
C          16/01/2006 made Q and R allocatable
C          15/10/2006 extensive editing
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ
C          02/11/2021 added E_NUMBERS and E_FORMATS, etc. 
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C          A is then returned as the matrix
C          Q and R internally are L and U
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C
C          NCMAX: (input/unchanged) max. column dimension 
C           NCOL: (input/output) actual no. columns (depending on SUPPLY)
C            NIN: (input/unchanged) unconnected data input unit 
C             NF: (input/unchanged) preconnected output results unit 
C          NRMAX: (input/unchanged) max. row dimension 
C           NROW: (input/output) actual no. rows (depending on SUPPLY)
C          NWORK: (output) returned as pivot indices 
C              A: (input/output) matrix (depending on SUPPLY)
C              W: (output) norm/condition-no. pairs in positions 1 to 4
C          TITLE: (input/output) title  (depending on SUPPLY)
C          ABORT: (output) failure ?
C         DISPLY: (input/unchanged) table to screen ?
C           FILE: (input/unchanged) output to file ?
C         SUPPLY: (input/unchanged) provide data ? as follows:
C                  SUPPLY = .TRUE. then supply A, NCOL, NROW, TITLE
C                  SUPPLY = .FALSE. A, NCOL, NROW, and TITLE are read in 
C
C          Note the minimum dimensions of W(4*NRMAX) and NWORK(2*NRMAX)    
C          will cover all cases as follows for A(M,N):
C          F07ADF ... IPIV = NWORK(min(M,N))using positions 1 to min(M,N)
C          F06RAF ... W(M)
C          F07AGF ... W(4*N), IWORK = NWORK(N) but when M = N using positions
C                     NMAX + 1 to NMAX + 1 + N    
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)                :: NCMAX, NIN, NF, NRMAX
      INTEGER, INTENT (INOUT)             :: NCOL, NROW, NWORK(2*NRMAX)
      DOUBLE PRECISION, INTENT (INOUT)    :: A(NRMAX,NCMAX), W(4*NRMAX) 
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL, INTENT (OUT)               :: ABORT 
      LOGICAL, INTENT (IN)                :: DISPLY, FILE, SUPPLY
C
C Local allocatable arrays
C
       DOUBLE PRECISION, ALLOCATABLE :: Q(:,:), R(:,:)
C
C Locals
C
      INTEGER    I, ICOUNT, IERR, INFO, J
      INTEGER    KVAL9, NKLCFG
      INTEGER    N0, N1, N2, N3, N4, N5, N15, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N15 = 15, N21 = 21)
      INTEGER    NTEXT1, NTYPE
      PARAMETER (NTEXT1 = 1, NTYPE = 3)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 8)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ANORM1, ANORMI, RCOND1, RCONDI, RTOL, TEMP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION F06RAF$, X02AJF$
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, WORD80*80
      CHARACTER  FNAME1*1024, TEXT(NUMOPT)*100, TEXT1(NTEXT1)*100,
     +           TITLE1*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT1, FILE1, FILE2, FILE3, FILE4, REPEET
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   MATTIN, PUTFAT, DSPLAY, CHOP80, LBOX02,
     +           MATOUT, F07ADF$, F07AGF$, TABLE1, REVPRO
      EXTERNAL   NKLCFG, TFILEQ
      EXTERNAL   F06RAF$, X02AJF$
      INTRINSIC  MIN, TRIM
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Read in the matrix if .NOT.SUPPLY
C
      IF (.NOT.SUPPLY) THEN
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) THEN
            WRITE (LINE,100)
            CALL TFILEQ (LINE)
         ENDIF   
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, W,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Initialise ABORT = .TRUE.
C
      ABORT = .TRUE.
C
C Check the dimensions
C
      IF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
          IF (DISPLY) THEN
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
          ENDIF
          RETURN
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(Q)) DEALLOCATE(Q, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Q(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(R(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Copy A into Q
C
      DO J = N1, NCOL
         DO I = N1, NROW
           Q(I,J) = A(I,J)
         ENDDO
      ENDDO
C
C Factorise
C
      CALL F07ADF$(NROW, NCOL, Q, NRMAX, NWORK, INFO)
      IF (INFO.NE.N0) THEN
         ABORT = .TRUE.
         IF (DISPLY) THEN
            WRITE (LINE,300) INFO
            CALL PUTFAT (LINE)
         ENDIF
         DEALLOCATE(Q, STAT = IERR)
         DEALLOCATE(R, STAT = IERR)
         RETURN
      ENDIF
C
C Copy A into R then estimate the norms
C
      E_NUMBERS = E_FORMATS()
      DO J = N1, NCOL
         DO I = N1, NROW
           R(I,J) = A(I,J)
         ENDDO
      ENDDO
      ANORM1 = F06RAF$('1', NROW, NCOL, R, NRMAX, W)
      DO J = N1, NCOL
         DO I = N1, NROW
           R(I,J) = A(I,J)
         ENDDO
      ENDDO
      ANORMI = F06RAF$('I', NROW, NCOL, R, NRMAX, W)
      IF (NROW.EQ.NCOL) THEN
C
C If A is square estimate the condition numbers
C
         DO J = N1, NCOL
            DO I = N1, NROW
               R(I,J) = Q(I,J)
            ENDDO
         ENDDO
         CALL F07AGF$('1', NCOL, R, NRMAX, ANORM1, RCOND1, W,
     +                NWORK(NRMAX + 1), INFO)
         IF (INFO.EQ.N0) THEN
            DO J = N1, NCOL
               DO I = N1, NROW
                  R(I,J) = Q(I,J)
               ENDDO
            ENDDO
            CALL F07AGF$('I', NCOL, R, NRMAX, ANORMI, RCONDI, W,
     +                   NWORK(NRMAX + 1), INFO)
            IF (INFO.NE.N0) RCONDI = ZERO
         ELSE
            RCOND1 = ZERO
            RCONDI = ZERO
         ENDIF
      ELSE
         RCOND1 = ZERO
         RCONDI = ZERO
      ENDIF
C
C Copy result into R
C
      DO J = N1, NCOL
         DO I = N1, NROW
            IF (J.LT.I) THEN
               R(I,J) = ZERO
            ELSE
               R(I,J) = Q(I,J)
            ENDIF
         ENDDO
      ENDDO
C
C Trim Q
C
      DO J = N1, NCOL
         DO I = N1, NROW
            IF (I.EQ.J) THEN
               Q(I,J) = ONE
            ELSEIF (J.GT.I) THEN
               Q(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
C
C Copy norms and condition numbers into W
C
      W(N1) = ANORM1
      W(N2) = RCOND1
      W(N3) = ANORMI
      W(N4) = RCONDI
      WORD80 = CHOP80(TITLE)
      ICOUNT = ICOUNT + N1
      IF (FILE) THEN
         RTOL = 1.0D+00*X02AJF$()
         WRITE (NF,'(A)') BLANK
         WRITE (NF,400) ICOUNT, WORD80
         IF (RCOND1.GT.RTOL) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,500) ANORM1, ONE/RCOND1
            ELSE
               D13(1) = SHOWLJ(ANORM1)
               TEMP = ONE/RCOND1
               D13(2) = SHOWLJ(TEMP)
               WRITE (NF,525) TRIM(D13(1)), D13(2)
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (NF,550) ANORM1
             ELSE
                D13(1) = SHOWLJ(ANORM1)
                WRITE (NF,575) D13(1) 
             ENDIF  
         ENDIF
         IF (RCONDI.GT.RTOL) THEN
            IF (E_NUMBERS) THEN
               WRITE (NF,600) ANORMI, ONE/RCONDI
            ELSE
               D13(1) = SHOWLJ(ANORMI)
               TEMP = ONE/RCONDI
               D13(2) = SHOWLJ(TEMP)
               WRITE (NF,625) TRIM(D13(1)), D13(2) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (NF,650) ANORMI
            ELSE
               D13(1) = SHOWLJ(ANORMI)
               WRITE (NF,675) D13(1)
            ENDIF  
         ENDIF
      ENDIF
      IF (DISPLY) THEN
C
C Output
C
         RTOL = 1.0D+00*X02AJF$()
         WRITE (TEXT,400) ICOUNT, WORD80
         IF (RCOND1.GT.RTOL) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT(N4),500) ANORM1, ONE/RCOND1
            ELSE
               D13(1) = SHOWLJ(ANORM1)
               TEMP = ONE/RCOND1
               D13(2) = SHOWLJ(TEMP) 
               WRITE (TEXT(N4),525) TRIM(D13(1)), D13(2) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (TEXT(N4),550) ANORM1
            ELSE
               D13(1) = SHOWLJ(ANORM1)
               WRITE (TEXT(N4),575) D13(1)
            ENDIF  
         ENDIF
         IF (RCONDI.GT.RTOL) THEN
            IF (E_NUMBERS) THEN
               WRITE (TEXT(N5),600) ANORMI, ONE/RCONDI
            ELSE
               D13(1) = SHOWLJ(ANORMI)
               TEMP = ONE/RCONDI
               D13(2) = SHOWLJ(TEMP)
               WRITE (TEXT(N5),625) TRIM(D13(1)), D13(2) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (TEXT(N5),650) ANORMI
            ELSE
               D13(1) = SHOWLJ(ANORMI)
               WRITE (TEXT(N5),675) D13(1) 
            ENDIF  
         ENDIF
         J = N15
         CALL TABLE1 (J, 'OPEN')
         DO I = N1, N5
            IF (I.EQ.N1) THEN
               J = N4
            ELSEIF (I.EQ.N3) THEN
               J = N1
            ELSE
               J = N0
            ENDIF
            CALL TABLE1 (J, TEXT(I))
         ENDDO
         CALL TABLE1 (J, 'CLOSE')
         IF (NROW.LE.100 .AND. NCOL.LE.30) THEN
            FILE1 = FILE
            FILE2 = FILE
            FILE3 = FILE
            FILE4 = FILE
         ELSE
            FILE1 = .FALSE.
            FILE2 = .FALSE.
            FILE3 = .FALSE.
            FILE4 = .FALSE.
         ENDIF
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (TEXT,700)
            NUMDEC = NUMOPT
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
C
C Display A
C
            IF (NUMDEC.EQ.1) THEN
               WRITE (LINE,800)
               CALL DSPLAY (NCMAX, NCOL, NF, NRMAX, NROW, NTYPE,
     +                      A,
     +                      LINE,
     +                      FILE1)
               FILE1 = .FALSE.
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Display Q = lower triangle
C
               WRITE (LINE,900)
               CALL DSPLAY (NCMAX, NCOL, NF, NRMAX, NROW, NTYPE,
     +                      Q,
     +                      LINE,
     +                      FILE2)
               FILE2 = .FALSE.
C
C Display R = upper triangle
C
            ELSEIF (NUMDEC.EQ.3) THEN
               WRITE (LINE,1000)
               CALL DSPLAY (NCMAX, NCOL, NF, NRMAX, NROW, NTYPE,
     +                      R,
     +                      LINE,
     +                      FILE3)
               FILE3 = .FALSE.
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Display pivots
C
               J = N15
               CALL TABLE1 (J, 'OPEN')
               WRITE (LINE,1100)
               IF (FILE4) THEN
                  WRITE (NF,'(A)') BLANK
                  WRITE (NF,1100)
                  WRITE (NF,'(A)') BLANK
               ENDIF   
               J = N4
               CALL TABLE1 (J, LINE)
               J = N0
               DO I = N1, MIN(NCOL,NROW)
                  WRITE (LINE,'(I6)') NWORK(I)
                  IF (FILE4) WRITE (NF,'(I6)') NWORK(I)
                  CALL TABLE1 (J, LINE)
               ENDDO
               CALL TABLE1 (J, 'CLOSE')
               FILE4 = .FALSE.
            ELSEIF (NUMDEC.EQ.5) THEN
C
C Save Q As ...
C
               TITLE1 = 'L-matrix'
               TEXT1(1) = BLANK
               CLOSE (UNIT = NIN)
               I = N1
               CALL MATOUT (I, NCOL, NIN, NRMAX, NROW,
     +                      NTEXT1,
     +                      Q,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.6) THEN
C
C Save R As ...
C
               TITLE1 = 'U-matrix'
               TEXT1(1) = BLANK
               CLOSE (UNIT = NIN)
               I = N1
               CALL MATOUT (I, NCOL, NIN, NRMAX, NROW,
     +                      NTEXT1,
     +                      R,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.7) THEN
               CALL REVPRO (NF)  
            ELSE
               REPEET = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C OK so set ABORT = .FALSE.
C
      ABORT = .FALSE.
C
C Deallocate workspace
C
      DEALLOCATE(Q, STAT = IERR)
      DEALLOCATE(R, STAT = IERR)

C
C Format statements
C
  100 FORMAT (
     +'Now input a matrix formatted like matrix.tf1')
  200 FORMAT ('Not a matrix ... Must have m, n > 1')
  300 FORMAT ('On exit from DGETRF/LUFACT, INFO =',I4)
  400 FORMAT (
     + 'The LU factorisation of matrix',I3
     +/'================================='
     +/
     +/'Title of data:'
     +/A
     +/)
  500 FORMAT (
     +'Matrix 1-norm =',1P,E14.7,', Condition number =',E14.7)
  525 FORMAT (
     +'Matrix 1-norm =',1X,A,', Condition number =',1X,A)   
  550 FORMAT (
     +'Matrix 1-norm =',1P,E14.7)
  575 FORMAT (
     +'Matrix 1-norm =',1X,A)   
  600 FORMAT (
     +'Matrix I-norm =',1P,E14.7,', Condition number =',E14.7)
  625 FORMAT (
     +'Matrix I-norm =',1X,A,', Condition number =',1X,A)     
  650 FORMAT (
     +'Matrix I-norm =',1P,E14.7)
  675 FORMAT (
     +'Matrix I-norm =',1X,A)     
  700 FORMAT (
     + 'Display current matrix'
     +/'Display L'
     +/'Display U'
     +/'Display row pivot indices'
     +/'File: Save L As ...'
     +/'File: Save U As ...'
     +/'Results'
     +/'Quit ... Exit Matrix LU options')
  800 FORMAT ('Current matrix A = PLU')
  900 FORMAT ('Lower triangular/trapezoidal L where A = PLU')
 1000 FORMAT ('Upper triangular/trapezoidal U where A = PLU')
 1100 FORMAT ('Row pivot indices equivalent to P where A = PLU')
      END
C
C
