C
C
      SUBROUTINE M_ANOVA1 (JSEND, NF, NIN,
     +                     SUPPLY)
C
C ACTION: One way ANOVA...subroutine to allocate workspace then use ANOVA1
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         28/03/2006 derived from ANOVA1
C         31/01/2008 introduced showit to limit repeat advice about test file types  
C         10/05/2010 introduced NKLCFG to switch on/off the test file advice
C         30/04/2011 introduced call to TFILEQ    
C
C         JSEND: (input/unchanged) NTYPE = JSEND as follows
C                 NTYPE = 1: Parametric and Nonparametric
C                 NTYPE = 2: Parametric
C                 NTYPE = 3: Nonparametric
C            NF: (input/unchanged) preconnected unit for results
C           NIN: (input/unchanged) unconnected unit for data input
C        SUPPLY: (input/unchanged) as follows:
C                SUPPLY = .TRUE. then precise allocations and data selected
C                                from this subroutine
C                SUPPLY = .FALSE. then default allocations and data selected
C                                 from subroutine ANOVA1
C
C Note: if SUPPLY = .TRUE. then matrices of any size can be analysed but
C       otherwise the maximum number of files is set by NBIG and the maximum
C       size for individual vectors is NVBIG
C 
C       FORMAT 200 is not required in this version but is left in for future use
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    JSEND, NF, NIN
      LOGICAL    SUPPLY
C
C Local allocatable arrays
C
      INTEGER,                ALLOCATABLE :: NOBS(:)
      DOUBLE PRECISION,       ALLOCATABLE :: A(:,:), B(:), GBAR(:),
     +                                       X(:), Y(:)
      CHARACTER (LEN = 1024), ALLOCATABLE :: FSAV(:)
      CHARACTER (LEN = 80),   ALLOCATABLE :: TSAV(:)
      LOGICAL,                ALLOCATABLE :: USE1(:)
C
C Locals
C
      INTEGER    NBIG, NVBIG
      PARAMETER (NBIG = 1000,    !default upper limit for NSMALL vectors
     +           NVBIG = 100000) !default upper limit for X vectors
      INTEGER    NCMAX, NMAX, NOMAX, NRMAX, NSMALL
      INTEGER    NCSAV, NRSAV
      INTEGER    NTEMP(1)
      INTEGER    NFILES
      INTEGER    KVAL9, NKLCFG 
      INTEGER    I, IERR, ISEND, J
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0, NOPT = 7,
     +           NSTART = 15, NUMTXT = NOPT + NSTART - 1)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(20)
      INTEGER    IPREV, ITYPE, NOUT1
      PARAMETER (ITYPE = 2)
      INTEGER    N0, N1, N2, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N21 = 21)
      DOUBLE PRECISION XTEMP(N1), YTEMP(N1)
      CHARACTER  TEXT(30)*100, LINE*100
      CHARACTER  FNAMEA*1024, TITLEA*80
      CHARACTER (LEN = 1) FTEMP(1), TTEMP(1)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    NEWDAT, SHOWIT(4)
      LOGICAL    REPEET
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    ABORT, AGAIN, LIBFIL, MATRIX, INCOMPLETE, PROJ, READY
      EXTERNAL   M_ANOVAM, TBOX01, ANOVA1, VECFIL, PFILES, GETNOU
      EXTERNAL   NKLCFG, TFILEQ, INCOMP
      SAVE       NCSAV, NRSAV, FNAMEA, TITLEA, SHOWIT
      DATA       SHOWIT / 4*.TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      DATA       NCSAV, NRSAV / 0, 0 /
      DATA       FNAMEA, TITLEA / BLANK, BLANK /
C
C Check value of JSEND, NF, and NIN
C
      IF (JSEND.LT.1 .OR. JSEND.GT.3 .OR. NF.LT.1 .OR. NIN.LT.1) RETURN
C
C Initialise NEWDAT and SUPPLY
C
       NEWDAT = .TRUE.
C
C Deallocate
C
      J = N0
      IERR = J!to silence NAGfor
      IF (ALLOCATED(NOBS)) DEALLOCATE(NOBS, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(GBAR)) DEALLOCATE(GBAR, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(FSAV)) DEALLOCATE(FSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(TSAV)) DEALLOCATE(TSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(USE1)) DEALLOCATE(USE1, STAT = IERR)
      IF (IERR.NE.N0) RETURN
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         NCMAX = N0
         NMAX = N0
         NOMAX = N0
         NRMAX = N0
         NSMALL = N0
         READY = .FALSE.
         IF (SUPPLY) THEN
C
C Data input from this subroutine ... First get input type required
C
            REPEET = .TRUE.
            DO WHILE (REPEET)
               NDEC = N1
               WRITE (TEXT,100)
               NUMBLD(1) = 4
               CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, 
     +                      NOPT, NUMPOS, NSTART, NUMTXT,
     +                      TEXT,
     +                      TAB_TOP, TAB_MID, TAB_BOT)
               NUMBLD(1) = 0
               REPEET = .FALSE.
               INCOMPLETE = .FALSE.
               IF (NDEC.EQ.1) THEN
                  WRITE (LINE,200)
                  MATRIX = .TRUE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.2) THEN
                  WRITE (LINE,300)
                  MATRIX = .FALSE.
                  LIBFIL = .TRUE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.3) THEN
                  WRITE (LINE,400)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
               ELSEIF (NDEC.EQ.4) THEN
                  WRITE (LINE,500)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .TRUE.
               ELSEIF (NDEC.EQ.5) THEN
                  WRITE (LINE,600)
                  MATRIX = .FALSE.
                  LIBFIL = .FALSE.
                  PROJ = .FALSE.
                  INCOMPLETE = .TRUE.
               ELSEIF (NDEC.EQ.6) THEN
                  REPEET = .TRUE.
                  CALL INCOMP (N0, N1, NFILES, NTEMP, N1,
     +                         XTEMP, YTEMP, 
     +                         FNAMEA, FTEMP, TTEMP,
     +                         ABORT)                   
               ELSE
                  RETURN
               ENDIF
            ENDDO
            IF (MATRIX) THEN
C
C Method 1: Read in and analyse data matrices
C
               ISEND = 1
               CALL M_ANOVAM (ISEND, JSEND, NCSAV, NF, NIN, NRSAV,
     +                        FNAMEA, TITLEA)
               READY = .FALSE.
               NEWDAT = .FALSE.
            ELSEIF (.NOT.PROJ .AND. .NOT.INCOMPLETE) THEN
C
C Methods 2 and 3: Read in files individually or from a libary file
C
               IF (SHOWIT(NDEC)) THEN
                  KVAL9 = NKLCFG(N21)
                  IF (KVAL9.EQ.N1) THEN
                     CALL TFILEQ (LINE)
                     SHOWIT(NDEC) = .FALSE.
                  ENDIF   
               ENDIF   
               ALLOCATE(X(NVBIG), STAT = IERR)
               ALLOCATE(FSAV(NBIG), STAT = IERR)
               ALLOCATE(TSAV(NBIG), STAT = IERR)
               CALL VECFIL (NFILES, NIN, NVBIG, NBIG,
     +                      X,
     +                      FSAV, TSAV,
     +                      ABORT, LIBFIL)
               IF (NFILES.LT.N2) NFILES = N0
               IF (.NOT.ABORT .AND. NFILES.GT.N1) THEN
                  NSMALL = NFILES
                  NOMAX = NFILES
                  ALLOCATE(NOBS(NOMAX), STAT = IERR)
                  ALLOCATE(GBAR(NOMAX), STAT = IERR)
                  ALLOCATE(USE1(NOMAX), STAT = IERR)
                  NMAX = N0
                  DO I = N1, NFILES
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TSAV(I)
                     READ (NIN,*) NOBS(I), J
                     CLOSE (UNIT = NIN)
                     NMAX = NMAX + NOBS(I)
                  ENDDO
                  ALLOCATE(B(NMAX), STAT = IERR)
                  DEALLOCATE(X, STAT = IERR)
                  ALLOCATE(X(NMAX), STAT = IERR)
                  ALLOCATE(Y(NMAX), STAT = IERR)
                  NCMAX = 1
                  NRMAX = 1
                  ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                  READY = .TRUE.
               ENDIF
            ELSEIF (PROJ .AND. .NOT.INCOMPLETE) THEN
C
C Method 4: Read in from the vector project archive
C
               IF (SHOWIT(NDEC)) THEN
                  KVAL9 = NKLCFG(N21) 
                  IF (KVAL9.EQ.N1) THEN
                     CALL TFILEQ (LINE)
                     SHOWIT(NDEC) = .FALSE.
                  ENDIF   
               ENDIF   
               ALLOCATE(FSAV(NBIG), STAT = IERR)
               ALLOCATE(USE1(NBIG), STAT = IERR)
               IPREV = N0
               NFILES = N0
               CALL GETNOU (NOUT1)
               CLOSE (UNIT = NOUT1)
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NBIG, NOUT1,
     +                      FSAV,
     +                      USE1)
               CLOSE (UNIT = NOUT1)
               IF (NFILES.GT.N1) THEN
                  NSMALL = NFILES
                  NOMAX = NSMALL
                  ALLOCATE(NOBS(NOMAX), STAT = IERR)
                  ALLOCATE(TSAV(NSMALL), STAT = IERR)
                  NCMAX = 1
                  NRMAX = 1
                  ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                  NMAX = N0
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TSAV(I)
                     READ (NIN,*) NOBS(I), J
                     CLOSE (UNIT = NIN)
                     NMAX = NMAX + NOBS(I)
                  ENDDO
                  ALLOCATE(B(NMAX), STAT = IERR)
                  ALLOCATE(GBAR(NSMALL), STAT = IERR)
                  ALLOCATE(X(NMAX), STAT = IERR)
                  ALLOCATE(Y(NMAX), STAT = IERR)
                  READY = .TRUE.
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF
            ELSEIF (INCOMPLETE) THEN
C
C Method 5: Read in from an incomplete matrix file
C

C               IF (SHOWIT(NDEC)) THEN
C                  KVAL9 = NKLCFG(N21) 
C                  IF (KVAL9.EQ.N1) THEN
C                     CALL TFILEQ (LINE)
C                     SHOWIT(NDEC) = .FALSE.
C                  ENDIF   
C              ENDIF   

               NCMAX = NBIG
               NMAX = NVBIG
               ALLOCATE(X(NMAX), STAT = IERR)
               ALLOCATE(Y(NMAX), STAT = IERR) 
               ALLOCATE(NOBS(NCMAX), STAT = IERR)
               ALLOCATE(FSAV(NCMAX), STAT = IERR)
               ALLOCATE(TSAV(NCMAX), STAT = IERR)
               IPREV = N0
               NFILES = N0
               CALL INCOMP (N1, NCMAX, NFILES, NOBS, NMAX,
     +                      X, Y,           
     +                      FNAMEA, FSAV, TSAV,
     +                      ABORT) 
               IF (NFILES.GT.N1) THEN
                  NCMAX = 1
                  NRMAX = 1
                  ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
                  NSMALL = NFILES
                  NOMAX = NSMALL
                  ALLOCATE(USE1(NSMALL), STAT = IERR)
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                  ENDDO
                  ALLOCATE(B(NMAX), STAT = IERR)
                  ALLOCATE(GBAR(NSMALL), STAT = IERR)
                  READY = .TRUE.
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF   
            ENDIF
         ELSE
C
C Allocate default spaces with no data assigned
C
            NCMAX = 50
            NRMAX = 5000
            NSMALL = NCMAX
            NOMAX = MAX(NCMAX,NSMALL)
            NMAX = NCMAX*NRMAX
            ALLOCATE(NOBS(NOMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(B(NMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(GBAR(NSMALL), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(X(NMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(Y(NMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(FSAV(NSMALL), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(TSAV(NSMALL), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            ALLOCATE(USE1(NOMAX), STAT = IERR)
            IF (IERR.NE.N0) RETURN
            READY = .TRUE.
         ENDIF
         IF (READY) THEN
C
C 1-way ANOVA
C
            DO I = N1, NOMAX
               USE1(I) = .TRUE.
            ENDDO
            CALL ANOVA1 (JSEND, NCMAX, NF, NIN, NMAX, NOBS, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A, B, GBAR, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
         ENDIF
C
C Deallocate workspaces
C
         IF (ALLOCATED(NOBS)) DEALLOCATE(NOBS, STAT = IERR)
         IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
         IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
         IF (ALLOCATED(GBAR)) DEALLOCATE(GBAR, STAT = IERR)
         IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
         IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
         IF (ALLOCATED(FSAV)) DEALLOCATE(FSAV, STAT = IERR)
         IF (ALLOCATED(TSAV)) DEALLOCATE(TSAV, STAT = IERR)
         IF (ALLOCATED(USE1)) DEALLOCATE(USE1, STAT = IERR)
         IF (NEWDAT) THEN
C
C Another go
C
            AGAIN = .TRUE.
         ELSE
C
C Quit the loop
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO

C
C Format statements
C
  100 format (
     + 'Data input options for this procedure'
     +/  
     +/'There are different options depending on missing values'    
     +/
     +/'For rectangular data with no missing values you can input'  
     +/'a standard Simfit data file or paste from the clipboard.'
     +/  
     +/'Where columns of the data matrix may not all be of the '
     +/'same length (due to missing values) you can use either:'
     +/'a)`A library file of vectors;'
     +/'b)`individual column vectors;'
     +/'c)`vectors from a project archive; or'
     +/'d)`an incomplete matrix.'  
     +/
     +/'Input a complete data matrix (no missing values)'
     +/'Input a library file of vectors'
     +/'Input individual column vectors'
     +/'Input vectors from a project archive'
     +/'Input an incomplete data matrix (missing values)'
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  200 FORMAT (
     +'Now input a n by m matrix file formatted like matrix.tf1')
  300 FORMAT (
     +'Now input n vector files formatted like column1.tf1')
  400 FORMAT (
     +'Now input a library file of vectors formatted like anova1.tfl')
  500 FORMAT (
     +'Now select n vector files from your project archive')
  600 FORMAT (
     +'Now select a missing data file like incomplete.tf1')   
      END
C
C
