c
c
      subroutine m_anovam (isend, itype, ncol, nf, nin, nrow,
     +                     fnamea, titlea)
c
c action: install a matrix then call the ANOVA program indicated by isend
c author: w.g.bardsley, university of manchester, u.k.
c         derived from m_matone 31/03/2006
c         23/11/2006 introduced simdir, and itype1, and added intents
c         25/01/2007 introduced sim256
c         12/10/2007 now allows mat4in to change fnamea and titlea 
c         31/01/2008 introduced showit to limit repeat advice about test files 
c         10/05/2010 introduced NKLCFG to switch on/off the test file advice
c         30/04/2011 introduced call to TFILEQ
C         15/10/2016 changed matrix = .true. as a parameter to matrix = .true. in a data statement
c
c   isend: (input/unchanged) as follows:
c           isend =  1: 1-way ANOVA
c           isend =  2: 2-way ANOVA
c           isend =  3: Repeated measures 
c           isend =  4: Latin Square
c           isend =  5: Groups and subgroups
c           isend =  6: Factorial ANOVA: 0 blocks, 2 factors
c           isend =  7: Factorial ANOVA: k blocks, 2 factors
c           isend =  8: Factorial ANOVA: 0 blocks, 3factors 
c           isend =  9: Factorial ANOVA: k blocks, 3 factors
c           isend = 10: variance homogeneity
c   itype: (input/unchanged) type for 1,2-way ANOVA1 = 1, 2, or 3
c    ncol: (input/output) column size  
c      nf: (input/unchanged) preconnected unit for results 
c     nin: (input/unchanged) unconnected unit for data input
c    nrow: (input/output) row size
c  fnamea: (input/output) data file name
c  titlea: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, itype, nf, nin
      integer,             intent (inout) :: ncol, nrow
      character (len = *), intent (inout) :: fnamea, titlea
c
c Local allocatable array
c
      integer,                allocatable :: lcode(:,:), nobs(:)
      double precision,       allocatable :: a(:,:), b(:), gbar(:),
     +                                       x(:), y(:), z(:)
      character (len = 1024), allocatable :: fsav(:)
      character (len = 80),   allocatable :: tsav(:)
      logical,                allocatable :: use1(:)
c
c locals
c
      integer    i, ierr, jsend, ncmax,  ncol1, nrmax, nrow1
      integer    i1, i2, i3, i4, i5, nfac, nomax, nmax
      integer    itype1, ncadd, nradd
      integer    nitems, nsmall, n1, n21
      parameter (nitems = 10, nsmall = 1, n1 = 1, n21 = 21)
      integer    ncsav(nitems), nrsav(nitems)
      integer    kval9, nklcfg
      character  no_data*30, no_file*30
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, line*100, tfiles(nitems)*15,
     +           word15*15   
      character  sim256*1024 
      logical    showit(nitems)
      logical    abort, fixcol, fixrow, label, newdat, repeet
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    matrix, supply
      parameter (supply = .true.)
      external   isitmf, mat2in, mat3in, mat4in, putfat, sim256
      external   anova1, anova2, anova3, anova4, anova5, vareq1
      external   nklcfg, tfileq
      save       matrix
      save       ncsav, nrsav, header, tfiles, showit
      data       matrix / .true. /
      data       showit / nitems*.true. /
      data       ncsav /  5, 4,  4,  5,  3,  4,  4,  5,   5,  5 /
      data       nrsav /  6, 8,  5, 10, 27, 20, 54, 72, 144,  6 /
      data       header /
     +'1-way ANOVA',                            !1
     +'2-way ANOVA',                            !2
     +'Repeated measurements ANOVA',            !3
     +'Latin Square ANOVA',                     !4
     +'Groups and subgroups ANOVA',             !5
     +'Factorial ANOVA: 0 blocks, 2 factors',   !6 
     +'Factorial ANOVA: k blocks, 2 factors',   !7
     +'Factorial ANOVA: 0 blocks, 3 factors',   !8 
     +'Factorial ANOVA: k blocks, 3 factors',   !9
     +'Variance homogeneity' /                  !10
       data      tfiles /
     +'anova1.tf1',    !1  
     +'anova2.tf2',    !2
     +'anova6.tf1',    !3
     +'anova3.tf1',    !4
     +'anova4.tf1',    !5
     +'anova5.tf1',    !6
     +'anova5.tf2',    !7
     +'anova5.tf3',    !8
     +'anova5.tf4',    !9 
     +'anova1.tf1' /   !10
c
c check isend then initialise ncadd and nradd
c 
      if (isend.lt.1 .or. isend.gt.10) return
      itype1 = itype
      ncadd = 0
      nradd = 0
c
c deallocate
c         
      ierr = 0
      if (allocated(lcode)) deallocate(lcode, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(nobs)) deallocate(nobs, stat = ierr)
      if (ierr.ne.0) return    
      if (allocated(a))    deallocate(a, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b))    deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(gbar)) deallocate(gbar, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x))    deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y))    deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(z))    deallocate(y, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(fsav)) deallocate(fsav, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(tsav)) deallocate(tsav, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(use1)) deallocate(use1, stat = ierr)
      if (ierr.ne.0) return         
c
c------------------------------------------------------------
c Start of code to access a matrix
c------------------------------------------------------------
c  
        
      if (ncol.le.0 .or. nrow.le.0) then 
         fnamea = sim256(tfiles(isend))
         ncol = ncsav(isend)
         nrow = nrsav(isend)
      endif   
      repeet = .true.
      do while (repeet)
c
c Step 1: if ncol > 0 and nrow > 0 check if fname supplied is a current vector file
c ======= isitmf returns ncol1 > 0 and nrow1 > 0 if fnamea is a vector file
c
     
         ncol1 = 0
         nrow1 = 0
         if (ncol.gt.0 .and. nrow.gt.0) call isitmf (ncol1, nrow1,
     +                                               fnamea)
c
c Step 2: if fnamea is not a matrix file of correct size try to open a file
c ======= mat3in selects a matrix file of size nrow1 > 0 by ncol1 > 0 if successful
c
         if (ncol1.le.0 .or. nrow1.le.0 .or.
     +       ncol1.ne.ncol .or. nrow1.ne.nrow) then
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            jsend = 3
            close (unit = nin)
            if (showit(isend)) then
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then
                  word15 = tfiles(isend)(1:15)
                  write (line,100) word15
                  call tfileq (line)
                  showit(isend) = .false.
               endif   
            endif   
            call mat3in (jsend, ncol1, nin, nrow1,
     +                   fnamea, titlea,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncol = 0
               nrow = 0
               fnamea = no_file
               titlea = no_data
               return
            endif
         endif
         if (ncol1.le.0 .or. nrow1.le.0) return
c
c Step 3: we now have a matrix file of size nrow > 0 by ncol > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         ncol = ncol1
         nrow = nrow1
         ierr = 0
         if (allocated(a)) deallocate(a, stat = ierr)
         if (ierr.ne.0) return
         ncmax = ncol + ncadd
         nrmax = nrow + nradd
         allocate(a(nrmax,ncmax), stat = ierr)
         if (ierr.ne.0) return

c
c Step 4: read in the data consisting of nrow by ncol points from file fnamea
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fnamea and titlea are not changed from now on
c
         close (unit = nin)
         call mat2in (nin, ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, titlea,
     +                abort)
         close (unit = nin)
         if (abort) then
            deallocate (a, stat = ierr)
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... fnamea and titlea may change in mat4in
c ======= mat4in is the equivalent of vecone offering as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .true. on return: try for a new data set
c         newdat = .false. on return: proceed with original or edited data
c         If the data are edited fnamea and titlea are changed
c
         call mat4in (ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, header(isend), titlea,
     +                abort, newdat)
         if (abort) then
c
c Option 1 on return from mat4in: Deallaocate then exit
c --------
c
            deallocate (a, stat = ierr)
            return
         elseif (newdat) then
c
c Option 2 on return from from mat4in: New data
c --------
c
            fnamea = no_file
            titlea = no_data
            ncol = 0
            nrow = 0
         else
c
c Option 3 on return from from mat4in: Proceed to analysis
c --------
c  
            newdat = .false.
            if (ncol.lt.2 .or. nrow.lt.2) then
c
c Test 1: make sure ncol >= 2 and nrow >= 2
c              
               write (line,200)
               call putfat (line)
               ncol = 0
               nrow = 0 
            elseif (isend.eq.4 .and. nrow.ne.2*ncol) then
c
c Test 2: make sure Latin square has nrow = 2*ncol
c            
               write (line,300)
               call putfat (line)
               ncol = 0
               nrow = 0   
            elseif (isend.eq.5 .and. ncol.ne.3) then
c
c Test 3: make sure Groups and subgroups has ncol = 3
c            
               write (line,400)
               call putfat (line)
               ncol = 0
               nrow = 0    
            elseif (isend.eq.1) then
c
c isend = 1: 1-way ANOVA (itype = 1, 2, or 3)
c ==========
c              
               nomax = ncol
               nmax = ncol*nrow
               allocate(nobs(nomax), stat = ierr)
               if (ierr.ne.0) return
               allocate(b(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(gbar(nomax), stat = ierr)
               if (ierr.ne.0) return
               allocate(x(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(fsav(nsmall), stat = ierr)
               if (ierr.ne.0) return
               allocate(tsav(nsmall), stat = ierr)
               if (ierr.ne.0) return
               allocate(use1(nomax), stat = ierr)
               if (ierr.ne.0) return
               do i = 1, nomax
                  nobs(i) = nrow
               enddo   
               fsav(1) = fnamea 
               tsav(1) = titlea
               call anova1 (itype1, ncmax, nf, nin, nmax, nobs,
     +                      nomax, nrmax, nsmall,
     +                      a, b, gbar, x, y,
     +                      fsav, tsav,
     +                      matrix, newdat, supply, use1)
               deallocate(nobs, stat = ierr)
               deallocate(a, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(gbar, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(fsav, stat = ierr)
               deallocate(tsav, stat = ierr)
               deallocate(use1, stat = ierr)
            elseif (isend.ge.2 .and. isend.le.3) then   
c
c 2 =< isend =< 3: 2-way ANOVA or Repeated measures (itype = 1, 2, or 3)
c ================
c              
               nmax = ncol*nrow
               allocate(b(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(x(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(use1(ncol), stat = ierr)
               if (ierr.ne.0) return
               jsend = isend - 1  
               call anova2 (jsend, itype1, ncmax, nf, nin, nmax, nrmax,
     +                      a, b, x, y,
     +                      fnamea, titlea,
     +                      newdat, supply, use1)
               deallocate(a, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(use1, stat = ierr)    
            elseif (isend.eq.4) then
c
c Latin Square ANOVA
c               
               allocate(lcode(ncol,ncol), stat = ierr)
               if (ierr.ne.0) return
               i1 = 1
               i2 = i1 + ncol
               i3 = i2 + ncol
               i4 = i3 + ncol
               i5 = i4 + ncol
               nmax = i5 + ncol**2
               allocate(b(nmax), stat = ierr)
               if (ierr.ne.0) return
               call anova3 (ncol, lcode, nf, nin, nrmax, 
     +                      a, b(i1), b(i2), b(i3), b(i4), b(i5),
     +                      fnamea, titlea,
     +                      newdat, supply)
               deallocate(lcode, stat = ierr)
               deallocate(a, stat = ierr)
               deallocate(b, stat = ierr) 
            elseif (isend.eq.5) then
c
c Groups and subgroups ANOVA
c                           
               allocate(b(nrmax), stat = ierr)
               if (ierr.ne.0) return 
               allocate(x(nrmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nrmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(z(nrmax), stat = ierr)
               if (ierr.ne.0) return
               call anova4 (ncmax, nf, nin, nrmax,
     +                      a, b, x, y, z,
     +                      fnamea, titlea,
     +                      newdat, supply)
               deallocate(a, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(z, stat = ierr)
            elseif (isend.ge.6 .and. isend.le.9) then
c
c Factorial ANOVA
c              
               if (itype1.ne.isend - 5) itype1 = isend - 5 
               if (itype1.le.2) then
                  nfac = 2
               else
                  nfac = 3
               endif
               if (ncol.ne.nfac + 2) then
                  write (line,500)
                  call putfat (line)
                  ncol = 0
                  nrow = 0
                  fnamea = no_file
                  titlea = no_data
                  newdat = .true.
               else                       
                  allocate(nobs(3*nrmax), stat = ierr)
                  if (ierr.ne.0) return 
                  allocate(b(nrmax), stat = ierr)
                  if (ierr.ne.0) return   
                  allocate(x(nrmax), stat = ierr)
                 if (ierr.ne.0) return
                    allocate(y(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  allocate(z(nrmax), stat = ierr)
                  if (ierr.ne.0) return
                  call anova5 (itype1, nobs, ncmax, nf, nin, nrmax,
     +                         a, b, x, y, z,
     +                         fnamea, titlea,
     +                         newdat, supply)
                  deallocate(nobs, stat = ierr)
                  deallocate(a, stat = ierr)
                  deallocate(b, stat = ierr)
                  deallocate(x, stat = ierr)
                  deallocate(y, stat = ierr)
                  deallocate(z, stat = ierr)               
               endif  
            elseif (isend.eq.10) then
c
c isend = 1: 1-way ANOVA (itype = 1, 2, or 3)
c ==========
c              
               nomax = ncol
               nmax = ncol*nrow
               allocate(nobs(nomax), stat = ierr)
               if (ierr.ne.0) return
               allocate(b(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(x(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(fsav(nsmall), stat = ierr)
               if (ierr.ne.0) return
               allocate(tsav(nsmall), stat = ierr)
               if (ierr.ne.0) return
               allocate(use1(nomax), stat = ierr)
               if (ierr.ne.0) return
               do i = 1, nomax
                  nobs(i) = nrow
               enddo   
               fsav(1) = fnamea 
               tsav(1) = titlea
               call vareq1 (itype1, ncmax, nf, nin, nmax, nobs,
     +                      nomax, nrmax, nsmall,
     +                      a, b, x, y,
     +                      fsav, tsav,
     +                      matrix, newdat, supply, use1)
               deallocate(nobs, stat = ierr)
               deallocate(a, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(fsav, stat = ierr)
               deallocate(tsav, stat = ierr)
               deallocate(use1, stat = ierr)                
            endif   
            if (.not.newdat) then
               deallocate(a, stat = ierr)
               return
            endif  
         endif
 
      enddo
c------------------------------------------------------------
c End of code to access a matrix
c------------------------------------------------------------
c
  100 format ('Now input a file formatted like',1x,a)
  200 format ('Insufficient data: must have columns >= 2, rows >= 2')
  300 format ('Latin square must have no. rows = twice no. of columns')
  400 format ('Groups and subgroups must have 3 columns')
  500 format ('Must have no. columns = no. factors + 2')
      end
c
c
