c
c
      subroutine m_biplot (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fname, title,
     +                     newdat)
c
c action: front end to biplot
c author: w.g.bardsley, university of manchester, u.k., 28/08/2006
c         19/03/2010 added ncadd and nradd to make sure lwork is large enough for SVD
c
      implicit   none
c
c arguments
c          
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fname*(*), title*(*)   
      logical    newdat
c
c local allocatable arrays
c       
                    
      double precision, allocatable :: d(:), r(:,:), work(:)    
c
c locals
c       
      integer    ierr, lwork, ndmax, nin
      integer    ncadd, nradd
      parameter (ncadd = 2, nradd = 2)
      logical    supply
      parameter (supply = .true.)
      external   getnou, biplot, putfat
      intrinsic  max
      if (ncol.lt.2 .or. nrow.lt.2) then
         call putfat ('Must have n >= 2 and m >= 2')
         return
      endif
      ndmax = max(ncmax,nrmax)
      lwork = 64*(ncmax + nrmax + ncadd + nradd)
      ierr = 0
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return    
      if (allocated(work)) deallocate(work, stat = ierr)
      if (ierr.ne.0) return  
      allocate(d(ndmax), stat = ierr)
      if (ierr.ne.0) return   
      allocate(r(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(work(lwork), stat = ierr)
      if (ierr.ne.0) return 
      call getnou (nin)
      call biplot (lwork, ncmax, ncol, ndmax, nin, nout, nrmax, nrow,
     +             d, r, work, a,
     +             fname, title,
     +             newdat, supply)
      close (unit = nin)
      deallocate(d, stat = ierr)
      deallocate(r, stat = ierr)        
      deallocate(work, stat = ierr)    
      end
c
c      
      
      