c
c
      subroutine m_chfact (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: Cholesky factors
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      double precision, allocatable :: w(:)
c
c locals
c
      integer    ierr, nin, nwork
      parameter (nin = 3)
      character  line*100
      logical    abort, disply, fileit, supply
      parameter (disply = .true., fileit = .true., supply = .true.)
      external   chfact, putfat
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (ncol.ne.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      nwork = ncmax*(ncmax + 1)/2
      allocate(w(nwork), stat = ierr)
      if (ierr.ne.0) return
c
c call chfact for calculations
c
      call chfact (ncmax, ncol, nin, nout, nrmax, nrow, nwork,
     +             a, w,
     +             titlea,
     +             abort, disply, fileit, supply)
c
c deallocate workspaces
c
      deallocate(w, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
  200 format ('Must have no. rows = no. columns')
      end
c
c
