c
c
      subroutine m_cochrq (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: Cochran Q test
c author: w.g.bardsley, university of manchester, u.k.
c         10/02/2006 derived from m_mcnmar
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: lwork(:,:)
      double precision, allocatable :: x(:)
c
c locals
c
      integer    ierr, nin
      parameter (nin = 3)
      character  line*100
      logical    supply
      parameter (supply = .true.)
      external   cochrq, putfat
c
c check
c
      if (ncol.lt.3 .or. nrow.lt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(lwork)) deallocate(lwork, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate(lwork(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call mcnmar for calculations
c
      call cochrq (lwork, ncmax, ncol, nin, nout, nrmax, nrow,
     +             a, x,
     +             titlea,
     +             supply)
c
c deallocate workspaces
c
      deallocate(lwork, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 3 and no. columns >= 3')
      end
c
c
